;
                DOSSEG
                IDEAL
                P386
                MODEL   SMALL
                STACK   512
                ASSUME  CS:_TEXT,DS:_DATA
;
_BACKGROUND     EQU     1
_FOREGROUND     EQU     7

_SCROLLSTART    EQU     96
_SCROLLHEIGHT   EQU     8

_SCREENWIDTH    EQU     320
;
        CODESEG
PROC            Main

                MOV     AX,013h                 ;; Set 320x200x256 VideoMode
                INT     010h

                MOV     [Counter],0
                MOV     [ScrollerPixPos],0
                MOV     [ScrollerPos],0

                CLI
@@VBLFirst:     CALL    Retrace                 ;; Wait for Vertical Retrace
                MOV     DX,_BACKGROUND
                CALL    FillScreen
                CALL    FillScreen
                CALL    FillScreen
                CALL    FillScreen
                CMP     [Counter],199
                JB      @@VBLFirst

@@VBLMiddle:    CALL    Retrace                 ;; Wait for Vertical Retrace
                CALL    Scroller
                MOV     AH,01h                  ;; Check For KeyPress
                INT     016h
                JZ      @@VBLMiddle

                MOV     [Counter],0
@@VBLEnd:       CALL    Retrace                 ;; Wait for Vertical Retrace
                MOV     DX,0
                CALL    FillScreen
                CALL    FillScreen
                CALL    FillScreen
                CALL    FillScreen
                CMP     [Counter],199
                JB      @@VBLEnd

                STI
                MOV     AX,03h                  ;; TextMode
                INT     010H
                MOV     AH,00h                  ;; Read Pressed Key
                INT     016h
                MOV     AX,04C00h               ;; Return To DOS
                INT     021h
                RET
ENDP
;
PROC            Retrace

                PUSH    DX
                PUSH    AX

                MOV     DX,03DAh                ;; Wait For End of Retrace
@@LPWaitStart:  IN      AL,DX
                AND     AL,08h
                JNZ     @@LPWaitStart

                MOV     DX,03DAh                ;; Wait For Start of Retrace
@@LPWaitEnd:    IN      AL,DX
                AND     AL,08h
                JZ      @@LPWaitEnd

                POP     AX
                POP     DX
                RET
ENDP
;
PROC            FillScreen

                PUSH    AX                      ;; Save Registers
                PUSH    ES
                PUSH    CX
                PUSH    BX
                PUSH    DX

                MOV     AX,0A000h               ;; Init Line to Draw
                MOV     ES,AX
                MOV     AX,[Counter]
                MOV     BX,320
                MUL     BX
                MOV     BX,AX
                POP     AX
                PUSH    AX

                MOV     CX,320                  ;; Draw One Line
@@Vul:          MOV     [ES:BX],AX
                INC     BX
                LOOP    @@Vul

                CMP     [Counter],199           ;; Handle Counter
                JAE     @@NoVul
                INC     [Counter]

@@NoVul:        POP     DX
                POP     BX                      ;; Restore Registers
                POP     CX
                POP     ES
                POP     AX
                RET
ENDP
;
PROC            Scroller

                PUSH    AX                      ;; Save Registers
                PUSH    ES
                PUSH    CX
                PUSH    BX
                PUSH    DX

                MOV     AX,0A000h               ;; Init Line To Draw
                MOV     ES,AX
                MOV     AX,_SCROLLSTART
                MOV     CX,_SCREENWIDTH
                MUL     CX
                MOV     DI,AX
                MOV     AX,ES
                MOV     DS,AX
                MOV     SI,DI
                ADD     SI,1
                MOV     CX,((_SCREENWIDTH*_SCROLLHEIGHT-1)+318)/4
                CLD
                REP     MOVSD

                MOV     DX,SEG Font             ;; Init Data Segment
                MOV     DS,DX
                MOV     [LineCount],0           ;; Init Font Offset
                
                MOV     AX,_SCROLLSTART+1       ;; Init Screen Address
                MOV     CX,_SCREENWIDTH
                MUL     CX
                MOV     DI,AX
                DEC     DI
                
                INC     [ScrollerPixPos]        ;; Look for New Char
                CMP     [ScrollerPixPos],8
                JNE     @@NoNewChar
                MOV     [ScrollerPixPos],0
                INC     [ScrollerPos]
                
@@NoNewChar:    MOV     CX,_SCROLLHEIGHT
@@NextLineScrl: PUSH    CX
                
@@ReadAgain:    MOV     BX,OFFSET ScrollerText  ;; Get Character
                ADD     BX,[ScrollerPos]
                XOR     AX,AX
                MOV     AL,[DS:BX]
                CMP     AL,0
                JNE     @@NotEndScroll
                MOV     [ScrollerPos],0
                MOV     [ScrollerPixPos],0
                JMP     @@ReadAgain
                
@@NotEndScroll: SUB     AL,020h
                MOV     BX,OFFSET Font
                ADD     BX,[LineCount]
                ADD     BX,AX
                MOV     AL,[DS:BX]
                MOV     CX,[ScrollerPixPos]
                SHL     AX,CL

                TEST    AL,080h
                JE      @@NoPixel
                MOV     AL,_FOREGROUND
                MOV     [ES:DI],AL
                JMP     @@NextLine
@@NoPixel:      MOV     AL,_BACKGROUND
                MOV     [ES:DI],AL

@@NextLine:     ADD     [LineCount],96
                ADD     DI,_SCREENWIDTH
                POP     CX
                LOOP    @@NextLineScrl

                POP     DX
                POP     BX                      ;; Restore Registers
                POP     CX
                POP     ES
                POP     AX
                RET
ENDP
        ENDS
;
        DATASEG

Counter         DW      0

LineCount       DW      0
ScrollerPixPos  DW      0
ScrollerPos     DW      0
ScrollerText    DB      "  Blue Nose Productions...   ",0

LABEL           Font
INCLUDE         "768_8_HI.INC"
        ENDS
;
END
