
;
; small example for offsetting a sinus-wave trough a picture
; code by ash/OZN/BD, gfx by ??.. grabbed out of a intro of TRSI..
; big credits goto diz dude..
;

code segment
assume cs:code
p386
org 100h

start:          cli                             ; clear interrupts
                             
                mov     ax,13h                  ; goto 320x200x256 mode
                int     10h                     ; standart BIOS-mode
                push    0a000h                  ; make destenation vgasegment
                pop     es

                mov     si,offset pal           ; offset palette
                mov     dx,3c8h
                xor     al,al
                mov     cx,256*3
                out     dx,al
                inc     dx
                repz    outsb

		xor	ax,ax			; make ax zero

mainloopz:      mov     bx,ax                   ; ax is startpos. in bx
                mov     cx,91                   ; 91 = picture height

                mov     si,offset pic           ; offset picture
                mov     di,320*50               ; mov 50*320 into di

vsineloop:      push    cx                      ; push cx
                mov     bp,sine+bx              ; make bp the sinechar
                add     di,bp                   ; add bp to di

                mov     cx,80                   ; make cx 320/4 (=80)
                repz    movsd                   ; move string double word

                sub     di,bp                   ; di - bp
                add     bx,2                    ; bx + 2
                pop     cx                      ; pop cx
                loop    vsineloop               ; loop

                add     ax,4                    ; ax + 4
                cmp     ax,256                  ; compare ax with 256
                jne     no256                   ; jump if not equal
                mov     ax,0                    ; make ax 0

no256:          push	ax			; push ax
		mov     dx,3dah                 ; vertical retrace
                in      al,dx
                test    al,8
                je      $-3

                in      al,60h                  ; check for escape
                cmp     al,1
		pop	ax			; pop ax
                je      outnow
		jmp	mainloopz

outnow:         mov     ax,3                    ; goto 25x80x16 mode
                int     10h
                mov     ax,4c00h                ; goto OS
                int     21h


include         pal.db
include         pic.db
include         sine.db

code ends
end start

