DOSSEG
.MODEL  SMALL
.CODE
.286

jmp     main
INCLUDE rnd.dw

palette LABEL   BYTE
        DB      63,63,63
        DB      63,63,63
        DB      55,55,55
        DB      48,48,48
        DB      40,40,40
        DB      30,30,30
        DB      20,20,20
        DB      10,10,10
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00
        DB      00,00,00

X               DW      0
Y               DW      0
Z               DW      0
adder           DB      0
pointer         DW      0
screendist      EQU     256
old_di          DW      1200 dup(0)

setmcga PROC    NEAR
        mov     ax,13h
        int     10h
        ret
setmcga ENDP

makeplt PROC    NEAR
        mov     dx,SEG palette
        mov     ds,dx
        mov     si,OFFSET palette
        mov     dx,3c8h
        mov     ax,1
        cli
        out     dx,al
        inc     dx
        mov     cx,17*3
        rep     outsb
        sti
        ret
makeplt ENDP

getp    PROC    NEAR
        mov     bx,cs:pointer
        mov     ax,cs:coordinates[bx]
        mov     cs:x,ax
        add     bx,2
        mov     ax,cs:coordinates[bx]
        mov     cs:y,ax
        add     bx,2
        mov     ax,cs:coordinates[bx]
        dec     ax
        mov     cs:coordinates[bx],ax
        mov     cs:z,ax
        add     bx,2
        mov     cs:pointer,bx                   ;Pointer is pointing to next X..
        ret
getp    ENDP

calc    PROC    NEAR
oargh:
        mov     ax,cs:x
        mov     bx,screendist
        imul    bx
        mov     bx,cs:z
        idiv    bx
        mov     cs:x,ax
        mov     ax,cs:y
        mov     bx,screendist
        imul    bx
        mov     bx,cs:z
        idiv    bx
        mov     cs:y,ax

        cmp     ax,100
        jge     reset
        mov     ax,cs:y
        cmp     ax,-100
        jle     reset
        mov     ax,cs:x
        cmp     ax,160
        jge     reset
        mov     ax,cs:x
        cmp     ax,-160
        jle     reset
        ret
reset:
        mov     bx,cs:pointer
        sub     bx,2
        mov     ax,cs:coordinates[bx]
        add     ax,4000
        mov     cs:coordinates[bx],ax
        ret
        jmp     oargh
calc    ENDP

point   PROC    NEAR
        mov     ax,100
        sub     ax,cs:y
        mov     bx,320
        mul     bx
        add     ax,160
        add     ax,cs:x
        mov     bx,cs:pointer
        mov     di,cs:old_di[bx]
        mov     byte PTR es:[di],0
        mov     di,ax
        mov     dx,cs:z
        add     dh,4
        mov     byte PTR es:[di],dh
        mov     cs:old_di[bx],di
        ret
point   ENDP

main    PROC    NEAR
        call    setmcga                 ;Set 320x200x256 MCGA mode
        call    makeplt                 ;Set the color palette

        mov     ax,0a000h               ;VGA buffer starts at A000h
        mov     es,ax                   ;Point ES to the video buffer
bolle:
        mov     cx,400
plot:
        call    getp
        call    calc
        call    point
        loop    plot

        mov     cs:pointer,0            ;Set cs:pointer to zero

        mov     ah,1                    ;Functin call 01h
        int     16h                     ;Get keyboard status
        cmp     al,1bh
        jnz     bolle                   ;No key, then jump to bolle

        mov     ax,03h                  ;Function call 03h
        int     10h                     ;Set 80x25x16 textmode

        mov     ax,4c00h                ;DOS function call 4C00h
        int     21h                     ;Return control to DOS
main    ENDP

        END
