        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include grfx.inc

public  _sc_tobuf

;
; DATA
;
align 4
sctbltbl        label   dword
temp0=offset sctbl
temp1=1
rept 128
                dd      temp0
  temp0=temp0+temp1
  temp1=temp1+1
endm

sctbl           label   byte
include sctbl.m

;
; CODE
;

;
; Scale a 32x32 tile into 256x256 virtual screen buffer (with zero checking)
; In:
;   BL - X scale (0-127 = 1-128)
;   BH - Y scale (0-127 = 1-128)
;   EDX -> 32x32 tile
;   EDI - Y*256+X loc in virtual screen buffer
;   FS - _bufsel
;
_sc_tobuf:
        pushad
        xor dl,dl
        mov ecx,edi
        mov eax,7fh
        sub al,bl
        imul eax,tobufl0ae1
        add eax,offset tobufl0a
        push eax
        movzx eax,bl
        mov ebp,sctbltbl[eax*4]
        mov al,bh
        mov esi,sctbltbl[eax*4]
tobufl0:
        mov edi,ecx
        lodsb
        shl al,2
        lea edx,[edx+eax*8]
        push edx ebp
        jmp [esp+8]
tobufl0a:
rept 80h
tobufl0ae0=$
        add dl,[ebp]
        mov al,[edx]
        inc ebp
        or al,al
        jz short $+5
        db 64h,88h,7            ; mov fs:[edi],al
        inc di
tobufl0ae1=$-tobufl0ae0
endm
        pop ebp edx
        inc ch
        sub bh,1
        jnc tobufl0
        add esp,4
        popad
        ret

code32  ends
        end

