;My polygon routines.

        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
public _ScanEdge, _DrawLineList
ideal
;scan edge - scan converts a poly using a 16.16 fixed point line thing.
;entry - ax = x1, bx = y1, cx = x2, dx = y2, bp = ymin, edi -> list
proc _ScanEdge
    cmp dx,bx             
    jz endscan
    jg noswap             
    
    xchg dx,bx            ;make sure we're going downwards.
    xchg ax,cx            

noswap:
    neg bp                ;since bx is our starty, we calc address by
    add bp,bx             ;4*y's to skip (i.e., our y - min y).
    and ebp,0ffffh
    shl ebp,2
    add edi,ebp
fillfirst:
    push ax dx
    sub cx,ax             
    movzx eax,cx          ;ax = x2-x1
    shl eax,16            ;get it to 16.16

    movzx ecx,dx          ;get y2
    sub cx,bx             ;cx = y2-y1
    cdq
    idiv ecx              ;divide it.
    mov ecx,eax           ;cx is the x step value (fractional).
    pop dx ax

    and ax,0ffffh
    shl eax,16            ;get x in fixed point too.

    add eax,ecx           ;skip first point.

nextpoint:
    push edi
    rol eax,16
    cmp [word edi],-1
    jz thisok
    add edi,2       
thisok:
    mov [edi],ax          ;store integer part.
    rol eax,16
    add eax,ecx           
    inc bx
    pop edi
    add edi,4
    cmp bx,dx
    jnz nextpoint
endscan:
    ret
endp       


;Drawlinelist - draws every line in the list passed to it.
;Must be in increasing Y order, but order of endpoints doesn't matter.
;BP=YMin, ESI->list, CX = length, DL=Color, DI = video offset.

linecolor db 0

proc _DrawLineList

    mov [linecolor],dl
    push di
    movzx edi,bp
    lea edi,[edi*2]
    lea edi,[edi*8]
    lea edi,[edi+edi*4]               ;80 * y
    pop bp
    and ebp,0ffffh
    add edi,0a0000h
    sub edi,[_code32a]
    add edi,ebp
    xor eax,eax
drawall:    
    push cx edi
    lodsw                             ;get endpoints
    mov bx,ax
    lodsw   

    or ax,ax
    js dontdraw

    cmp ax,bx
    jl KeepOrder
    
ChangeOrder:
    xchg ax,bx                        ;force ax<bx
KeepOrder:  

    movzx ebp,ax
    shr bp,2                          ;X Mod 4
    add edi,ebp

    push bx                           ;ebp = length of line
    neg bp
    shr bx,2
    add bp,bx
    pop bx

    mov cl,al                         ;draw first byte
    and cl,3
    mov ax,0f02h
    shl ah,cl
    and ah,0fh
    mov dx,3c4h

    dec ebp                           ;draw 1st, take it out.
    js OneByte                        ;Is it < 4 pixels??

    out dx,ax                         ;set reg

    mov al,[linecolor]                ;write it.
    stosb

    mov ax,0f02h                      ;middle bytes
    out dx,ax
    mov al,[linecolor]                ;setup for word writes.
    mov ah,al
_h1:
    mov ecx,ebp                       ;This *might* be faster than
    shr ecx,1                         ;a single rep stosb; I can't tell 
    rep stosw                         ;on my machine (I get .008 ms dif)
    adc cx,cx
    rep stosb                         ;draw any remaining byte
_h2:
    mov cl,bl                         ;do the other stuff.
    not cl
    and cl,3
    mov ax,0f02h
    shr ah,cl                         ;get the mask.
    out dx,ax
    mov al,[linecolor]                ;draw it
    stosb
dontdraw:
    pop edi cx
    add edi,80
    dec cx
    jnz drawall
    ret

OneByte:
    mov cl,bl
    not cl
    and cl,3
    mov bh,0fh
    shr bh,cl
    and ah,bh
    out dx,ax
    mov al,[linecolor]              
    stosb
    pop edi cx
    add edi,80
    dec cx
    jnz drawall
    ret
endp

ends 
end

