;The main code stuff.
;Following is a simple bit of stuff you can do with these lil
;routines.  The object (cube or 24-gon) moves closer to the eye,
;and rotates. 
;While this example is not entirely impressive, it does show you
;a few possibilities, and how to call everything.

        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc                     ;Pmode header
include modex.inc                     ;ModeX code 
include vec.inc                       ;Vector stuff.
include vrt.inc                       ;tran's retrace stuff.
include poly.inc                      ;polygon stuff.

ideal
;include 'cube.inc'                   ;pick 1 or the other. :)
include '24gon.inc'

align 4                               ;keep it fast
Matrix dd 10000h,0,0,0                ;Rotation Matrix
       dd 0,10000h,0,0
       dd 0,0,10000h,0
       dd 0,0,0,10000h

XYPointList dw NUM_PTS*2 dup (0)      ;List of screen coords.

label NormalIndex word                ;indexes to normals for sort 
i=0
REPT NUM_PLANES
    dw i
    i=i+1
ENDM

Theta dw 0                            ;XY rotate angle
Phi dw 0                              ;Z  rotate angle
Rho dd 2300000h                       ;Z Xlate
EndPtList dw 200 dup (0,0)

ViewPoint dd 0h,0h,-10000h            ;Spot is towards increasing Z.

Normals dd NUM_PLANES*3 dup (0)       ;Rotated normals

VOffs dw 0                            ;video offset.
YMin dw 0                             ;used for determining the
DeltaY dw 0                           ;amount of buffer we actually need.

PlaneCol db 0

pal db 9,4,9                          ;red palette (purple bkg ! :))
    i=16
REPT 16
        db i,0,0
    i=i+3
ENDM 
        db 63,0,0
            
public _main
_main:
    sti                               ;enable interrupts.
    
    call _setmodex


    call _vrt_init

    mov [dword _vrt_palptr],offset pal
    mov [byte _vrt_palindex],0
    mov [word _vrt_pallen],18        ;set pallette in retrace

framez:
    mov esi,offset Matrix
    mov ax,[Theta]
    mov bx,[Phi]
    mov ecx,[Rho]
    call _CreateRotateMatrix          ;make new matrix

    mov ebx,offset Matrix
    mov esi,offset XYZPointList
    mov edi,offset XYPointList
    mov cx,NUM_PTS
    call _XformPts                    ;multiply and project

    mov ebx,offset Matrix
    mov esi,offset NormalList
    mov edi,offset Normals
    mov cx,NUM_PLANES
    call RotateNormals


    mov esi,offset XYPointList+2      ;get the ymin thing.
    mov cx,NUM_PTS
    call GetYMin

    mov cx,NUM_PLANES
    mov esi,offset Normals
    mov ebx,offset NormalIndex
    call Sort                         ;depth sort them.

    mov cx,NUM_PLANES
    mov ebx,offset NormalIndex
    
allplanes:
    push cx ebx
    movzx ebx,[word ebx]              ;next normal
    push bx                           ;save it for plane index 
    lea ebx,[ebx+ebx*2]
    lea ebx,[ebx*4+offset Normals]    ;12*Index+normals
    cmp [dword ebx+2*4],0             ;is it visible?
    jge nodraw
    mov esi,offset ViewPoint
    mov [PlaneCol],1
    call _DotProduct                  ;get a color
    js noadd                          ;make sure it's at least red.
    shr ecx,12
    add [PlaneCol],cl
noadd:
    
    mov ecx,200*2                     ;clear linelist
    or ax,-1
    mov edi,offset EndPtList
    rep stosw

    pop bx
    sub sp,2                          ;for the early out..
    mov ax,PLANE_LENGTH
    mul bx
    movzx esi,ax
    add esi,offset plane1
    call DrawPoly
nodraw:
    add sp,2                          ;leftover pop
    pop ebx cx
    add ebx,2
    dec cx
    jnz allplanes

    mov di,[Voffs]                    ;change and prep for erase old
    call setpage                      ;page

    xor di,16000                      
    mov [Voffs],di    

    and edi,0ffffh                    ;blank the old screen.
    add edi,0a0000h
    sub edi,[_code32a]
    
    mov dx,3c4h
    mov ax,0f02h
    out dx,ax    

    mov ecx,16000/2
    xor ax,ax
    rep stosw

    mov eax,[_vrt_timer]              ;make this the same speed on
    mov [_vrt_timer],0                ;those new-fangled 386dx+'s :)
    mov cx,ax
    shl ax,2
    add [word Theta],ax               ;~12 degrees XY on my 386sx16
    shl cx,1                          
    add [word Phi],cx                 ;6 degrees Z

    cmp [dword Rho],250000h
;   cmp [dword Rho],190000h           ;for closer-ups, uncomment! :)
    jbe hitmax
    sub [dword Rho],50000h
hitmax:
    mov bx,[gs:041ah]                 ;check keyboard buffer
    cmp bx,[gs:041ch]
    jz framez
    mov [gs:041ch],bx                 ;clear buffer
    call _vrt_uninit
    mov [v86r_ax],3                   ;back 2 dos.
    mov al,10h
    int 33h
    jmp _exit   

;Draw the 4 pt plane.
proc DrawPoly
    mov bp,[YMin]                     ;setup miny for scan convert.
    mov cx,PTS_PER_PLANE
first3:
    push cx
    push esi
    movzx esi,[word esi]
    lea esi,[offset XYPointList+esi*4]
    mov ax,[esi]
    mov bx,[esi+2]
    pop esi
    push esi
    movzx esi,[word esi+2]
    lea esi,[offset XYPointList+esi*4]
    mov cx,[esi]
    mov dx,[esi+2]
    mov edi,offset EndPtList
    push bp
    call _ScanEdge                    ;scan convert the dealy.
    pop bp
    pop esi
    add esi,2
    pop cx
    dec cx
    jnz first3
    mov cx,200
    mov dl,[PlaneCol]
    mov esi,offset EndPtList
    mov di,[Voffs]
    call _DrawLineList
    ret
endp

proc setpage
    mov bx,di                         ;flip page
    mov dx,3d4h
    mov al,0ch
    mov ah,bh
    out dx,ax
    inc al
    mov ah,bl
    out dx,ax
    mov eax,[_vrt_timer]              ;wait for retrace
waitvr:
    cmp eax,[_vrt_timer]
    jz waitvr
    ret
endp

proc Sort
;depth sorts normals so we can draw em in order.
;entry: Esi = normal list.
;       Ebx = table of indexes to change.
;        cx = length.
    add esi,8                         ;offset for Z-normal
nextpass:
    movzx edi,[word ebx]              ;get the first z normal val.
    lea edi,[edi+edi*2]                 
    mov eax,[edi*4+esi]                 
    
    xor ebp,ebp
    push cx
    dec cx
    push ebx
    add ebx,2                         ;prep for next index
findmin:
    movzx edi,[word ebx]              ;get the index
    lea edi,[edi+edi*2]               ;edi*3
    cmp eax,[edi*4+esi]               ;edi*12+esi
    jge notless
    mov ebp,ebx                       ;save the offset of the index
    mov eax,[edi*4+esi]               ;get the value.
notless:
    add ebx,2                         ;next index
    dec cx
    jnz findmin
    or ebp,ebp                        ;did we swap anything?
    pop ebx 
    jz noswap
    mov ax,[word ebx]                 ;get old index
    xchg ax,[word ebp]                ;switch it
    mov [word ebx],ax
noswap:
    add ebx,2
    pop cx
    dec cx
    cmp cx,1
    jnz nextpass
    ret 
endp    

;Get minimum Y value
proc GetYMin
    mov ax,[esi]
    mov bx,[esi]
    add esi,4
    dec cx
ym0:    
    cmp ax,[esi]
    jb notamin                        ;these should all be positive
    mov ax,[esi]                      ;so screw the signed jmp
notmax: 
    add esi,4
    dec cx
    jnz ym0
    sub bx,ax
    mov [Ymin],ax
    mov [DeltaY],bx
    ret
notamin:
    cmp bx,[esi]
    ja notmax
    mov bx,[esi]
    jmp notmax
endp


XTemp dd ?
YTemp dd ?
ZTemp dd ?

RotateNormals:
;ripped straight from the same code in vec.asm.  I didn't
;feel like writing any self-modifying code. :)
    push cx
    lodsd                             
    mov [XTemp],eax                    
    imul [dword ebx]                  
    shrd eax,edx,16
    mov ecx,eax                       
    lodsd
    mov [YTemp],eax
    imul [dword ebx+4*4]
    shrd eax,edx,16
    add ecx,eax
    lodsd
    mov [ZTemp],eax
    imul [dword ebx+8*4]
    shrd eax,edx,16
    add ecx,eax
    mov [edi],ecx
    add edi,4    

    mov eax,[XTemp]                   ;calc NewY
    imul [dword ebx+1*4]                          
    shrd eax,edx,16
    mov ecx,eax                       
    mov eax,[YTemp]
    imul [dword ebx+5*4]
    shrd eax,edx,16
    add ecx,eax
    mov eax,[ZTemp]
    imul [dword ebx+9*4]
    shrd eax,edx,16
    add ecx,eax
    mov [edi],ecx
    add edi,4
    
    mov eax,[XTemp]                   ;calc NewZ
    imul [dword ebx+2*4]                          
    shrd eax,edx,16
    mov ecx,eax                       
    mov eax,[YTemp]
    imul [dword ebx+6*4]
    shrd eax,edx,16
    add ecx,eax
    mov eax,[ZTemp]
    imul [dword ebx+10*4]
    shrd eax,edx,16
    add ecx,eax
    mov [edi],ecx
    add edi,4
    pop cx
    dec cx
    jnz RotateNormals
    ret

ends
end
