;----------------------------------------------------------------------
; WormLenz:     Written by              : Carlos Hasan aka PELUSA
;
;               Ripped and merged by    : BYTE KNiGHT
;
;
; Hope I'm forgiven for this lame rip-off..
;-----------------------------------------------------------------------

                jumps
                .model  small,pascal
                .286

                dosseg                          ; used to link like
                .stack  1024                    ; an standalone program.

                global  LenzDemo:proc
                global  wormPic:byte            ; in LENZRAW.OBJ file.
;=============================================================================
RADIUS          equ     52                      ; Lenz Radius in pixels.
RADIUSI         equ     (15*RADIUS)/20          ; Internal Lenz Radius.
STRENGH         equ     155                     ; Lenz Amplify (fixed 8.8).
MAXWIDTH        equ     320                     ; VGA 320x200x256 dimensions.
MAXHEIGHT       equ     200
SEED            equ     286Ah                   ; Random seed for movement.
;======================== Demo data ==========================================

                .data

LenzTable       dw      4*RADIUS*RADIUS dup(?)  ; Holds the transformation.
LenzWidth       dw      2*RADIUS dup(?)         ; Scanline widths.
RandSeed        dw      ?                       ; Random Seed.

palette         db      768 DUP (0)
fadepalette     db      768 DUP (0)
fad             dw      0
;======================== Demo Routines ======================================

                .code
;-----------------------------------------------------------------------------
; Random - Returns a random number of 16 bits, modified version of the
;  ripped System unit random routine of the Borland Pascal 7.0.
; Out:
;  AX - random value.
; Modified:
;  AX, DX, Flags.
;-----------------------------------------------------------------------------

Random          proc near

                mov     ax,[RandSeed]
                mov     dx,8405h
                mul     dx
                inc     ax
                mov     [RandSeed],ax
                ret

Random          endp



;-----------------------------------------------------------------------------
; SetPalette - set the 256 entries of the VGA color palette.
; In:
;   DS:SI - Palette structure address.
;-----------------------------------------------------------------------------

SetPalette      proc near
                mov     cx,768
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                mov     dx,3DAh
WaitVRT1:       in      al,dx                   ; wait the start of
                test    al,8                    ; vertical retrace.
                jz      WaitVRT1
WaitVRT2:       in      al,dx                   ; wait the end of
                test    al,8                    ; vertical retrace.
                jnz     WaitVRT2
                mov     dx,3C9h
                rep     outsb
                ret

SetPalette      endp

RotPalette      proc near Fade:word

                push    ds
                push    es
                mov     ax,@data
                mov     es,ax
                mov     ds,ax

                lea     di,[FadePalette]
                mov     cx,16*3
                xor     ax,ax
                cld
                rep     stosb
                lea     si,[Palette+32*3]
                mov     cx,224*3
                cld
                rep     movsb
                lea     si,[Palette+16*3]
                mov     cx,16*3
                rep     movsb

                lea     bx,[FadePalette]
                mov     cx,16
RotLoop:        push    cx
                mov     si,bx
                mov     di,bx
                lodsb
                mov     ah,al
                lodsb
                mov     dl,al
                lodsb
                mov     dh,al
                mov     cx,15*3
                rep     movsb
                mov     al,ah
                stosb
                mov     al,dl
                stosb
                mov     al,dh
                stosb
                add     bx,16*3
                pop     cx
                loop    RotLoop

                lea     si,[FadePalette]
                lea     di,[Palette]
                mov     cx,768
                rep     movsb

                lea     si,[FadePalette]
                mov     cx,768
                mov     dx,[Fade]
FadeLoop:       mov     al,[si]
                mul     dl
                shr     ax,7
                mov     [si],al
                inc     si
                loop    FadeLoop

                lea     si,[FadePalette]
                call    SetPalette
                pop     es
                pop     ds
                ret

RotPalette      endp

;-----------------------------------------------------------------------------
; WaitVRT - Waits the next VGA Vertical Retrace Period.
;-----------------------------------------------------------------------------
comment|
WaitVRT         proc near

                mov     dx,3DAh
WaitVR1:        in      al,dx
                test    al,8
                jne     WaitVR1
WaitVR2:        in      al,dx
                test    al,8
                je      WaitVR2
                ret

WaitVRT         endp
       |
;-----------------------------------------------------------------------------
; GenLenz - Renders the Transformation matrix used during animation.
;
; Note: The square root is calculated using the Newton iteration
;       aproximation algorithm:
;                                        y + (r - x)
;               y  r - x     y  
;                                             2y
;
;       We performs only one iteration using a initial y value
;       near to the real square root wanted.
;-----------------------------------------------------------------------------

GenLenz         proc near
                local    X:word,Y:word,R:word,Dist:Word,AddX:word,AddY:word

                mov      ax,ds
                mov      es,ax
                cld

                xor      ax,ax                  ; Fills the whole rectangle
                lea      di,[LenzTable]         ; matrix with a linear
                mov      cx,2*RADIUS            ; transformation.
MakLinLoop:     push     ax
                push     cx
                mov      cx,2*RADIUS
MakLinRow:      stosw
                inc      ax
                loop     MakLinRow
                pop      cx
                pop      ax
                add      ax,MAXWIDTH
                loop     MakLinLoop

                mov      [X],RADIUS             ; makes the scanlines
                mov      [Y],0                  ; widths of the lenz
MakWidth:       cmp      [Y],RADIUS             ; with radius RADIUS.
                jge      MakXWidth
                mov      ax,[X]
                mov      bx,RADIUS              ; LenzWidth[Radius+Y] = X
                add      bx,[Y]
                shl      bx,1
                mov      [LenzWidth+bx],ax
                mov      bx,RADIUS              ; LenzWidth[Radius-Y-1] = X
                sub      bx,[Y]
                dec      bx
                shl      bx,1
                mov      [LenzWidth+bx],ax
                mov      ax,[Y]                 ; X = Radius - Y
                imul     ax
                mov      bx,ax
                mov      ax,[X]
                imul     ax
                sub      ax,bx
                add      ax,RADIUS*RADIUS
                sar      ax,1
                cwd
                mov      bx,[X]
                idiv     bx
                mov      [X],ax
                inc      [Y]                    ; Y = Y+1
                jmp      MakWidth
MakXWidth:


                mov     [X],RADIUSI             ; Makes the transformation
                mov     [Y],0                   ; for the Lenz of radius
MakLoop:        cmp     [Y],RADIUSI             ; RADIUSY. Notice that
                jge     MakExit                 ; this lets a border
                                                ; used for restoring the
                                                ; background while moving
                                                ; the lenz into the screen.

                mov     ax,[X]                  ; compute the scanline
                mov     dx,6                    ; width adjusting with
                imul    dx                      ; an aspect ratio of 6/5.
                mov     bx,5
                idiv    bx
                mov     [R],ax

                mov     [Dist],0
                mov     [AddX],0
                mov     [AddY],ax

MakLine:        mov     ax,[R]
                cmp     [AddX],ax
                jge     MakLineBreak

                ; si = @LenzTable[0,RADIUS-Y-1]

                lea     si,[LenzTable]
                mov     ax,RADIUS
                sub     ax,[Y]
                dec     ax
                imul    ax,2*RADIUS
                add     si,ax
                shl     si,1

                ; di = @LenzTable[0,RADIUS+Y]

                lea     di,[LenzTable]
                mov     ax,RADIUS
                add     ax,[Y]
                imul    ax,2*RADIUS
                add     di,ax
                shl     di,1

                ; Lenz[RADIUS+AddX,RADIUS-Y-1] = RADIUS+Hi(Dist) +
                ;     MAXWIDTH * (RADIUS-1-STRENGH*Y)

                mov     bx,RADIUS
                add     bx,[AddX]
                shl     bx,1
                mov     ax,[Y]
                imul    ax,STRENGH
                sar     ax,8
                imul    ax,MAXWIDTH
                neg     ax
                add     ax,RADIUS+MAXWIDTH*(RADIUS-1)
                mov     dx,[Dist]
                shr     dx,8
                add     ax,dx
                mov     [si+bx],ax

                ; Lenz[RADIUS-AddX-1,RADIUS-Y-1] = RADIUS-Hi(Dist)-1+
                ;     MAXWIDTH * (RADIUS-1-STRENGH*Y)

                mov     bx,RADIUS
                sub     bx,[AddX]
                dec     bx
                shl     bx,1
                mov     ax,[Y]
                imul    ax,STRENGH
                sar     ax,8
                imul    ax,MAXWIDTH
                neg     ax
                add     ax,RADIUS+MAXWIDTH*(RADIUS-1)
                mov     dx,[Dist]
                shr     dx,8
                sub     ax,dx
                dec     ax
                mov     [si+bx],ax

                ; LenzTable[RADIUS+AddX,RADIUS+Y] = RADIUS+Hi(Dist)+
                ;    MAXWIDTH * (RADIUS + STRENGH*Y)

                mov     bx,RADIUS
                add     bx,[AddX]
                shl     bx,1
                mov     ax,[Y]
                imul    ax,STRENGH
                sar     ax,8
                imul    ax,MAXWIDTH
                add     ax,RADIUS+MAXWIDTH*RADIUS
                mov     dx,[Dist]
                shr     dx,8
                add     ax,dx
                mov     [di+bx],ax

                ; LenzTable[RADIUS-AddX-1,RADIUS+Y] = RADIUS-Hi(Dist)-1+
                ;    MAXWIDTH * (RADIUS+STRENGH*Y)

                mov     bx,RADIUS
                sub     bx,[AddX]
                dec     bx
                shl     bx,1
                mov     ax,[Y]
                imul    ax,STRENGH
                sar     ax,8
                imul    ax,MAXWIDTH
                add     ax,RADIUS+MAXWIDTH*RADIUS
                mov     dx,[Dist]
                shr     dx,8
                sub     ax,dx
                dec     ax
                mov     [di+bx],ax

                ; Dist = Dist + (Strengh*Radius)/dY

                mov     ax,STRENGH*RADIUS
                cwd
                mov     bx,[AddY]
                idiv    bx
                add     [Dist],ax

                mov     ax,[AddY]               ; dY = R - dX
                imul    ax
                mov     bx,ax
                mov     ax,[AddX]
                imul    ax
                sub     bx,ax
                mov     ax,[R]
                imul    ax
                add     ax,bx
                sar     ax,1
                cwd
                mov     bx,[AddY]
                idiv    bx
                mov     [AddY],ax
                inc     [AddX]                  ; dX = dX+1
                jmp     MakLine

MakLineBreak:   mov     ax,[X]                  ; X = Radius' - Y
                imul    ax
                mov     bx,ax
                mov     ax,[Y]
                imul    ax
                sub     bx,ax
                mov     ax,RADIUSI*RADIUSI
                add     ax,bx
                sar     ax,1
                cwd
                mov     bx,[X]
                idiv    bx
                mov     [X],ax
                inc     [Y]                     ; Y = Y+1
                jmp     MakLoop
MakExit:        ret

GenLenz         endp

;-----------------------------------------------------------------------------
; WriteLenz - Writes the Lenz using the transformation matrix.
; In:
;  DI  - Starting offset location of the lenz.
;  DX  - Virtual picture used like background.
;-----------------------------------------------------------------------------

WriteLenz       proc near

                push    bp
                mov     ax,0A000h
                mov     es,ax
                lea     bx,[LenzTable]
                lea     si,[LenzWidth]
                mov     bp,di
                mov     cx,2*RADIUS
                cld
WriteLoop:      push    bx
                push    cx
                push    si
                push    di
                cmp     di,MAXWIDTH*MAXHEIGHT
                jae     WriteBreak
                mov     cx,[si]                 ; gets the scanline width.
                mov     ax,RADIUS
                sub     ax,cx
                add     di,ax
                add     bx,ax
                add     bx,ax
WriteLine:      push    es
                mov     es,dx
                mov     si,[bx]
                mov     al,es:[bp+si]
                mov     si,[bx+2]
                mov     ah,es:[bp+si]
                add     bx,4
                pop     es
                stosw
                loop    WriteLine
WriteBreak:     pop     di
                pop     si
                pop     cx
                pop     bx
                add     bx,4*RADIUS
                add     si,2
                add     di,MAXWIDTH
                loop    WriteLoop
                pop     bp
                ret

WriteLenz       endp


;-----------------------------------------------------------------------------
; LenzDemo - Performs the demostration.
; In:
;   DS      - Data Segment.
;   PicSeg  - VGA 320x200x256 Picture used for Background.
;-----------------------------------------------------------------------------

LenzDemo        proc  PicSeg:word
                local   X:word,Y:word,AddX:word,AddY:word

                mov     ax,13h                  ; sets 320x200x256 mode.
                int     10h

                call    GenLenz                 ; creates the lenz matrix.

                lea     di,[Palette]
                mov     cx,768
                xor     ax,ax
                cld
                rep     stosb
                lea     si,[Palette]
                call    SetPalette

                mov     ax,@data
                mov     ds,ax
                lea     di,[Palette]            ; generate the palette.
                mov     cx,256
                xor     bx,bx

GenPalette:     mov     ax,bx
                shr     ax,4
                and     ax,0Fh
                shl     ax,2
                mov     [di+0],al
                mov     ax,bx
                and     ax,0Fh
                shl     ax,1
                mov     [di+1],al
                mov     al,3Fh
                mov     [di+2],al
                add     di,3
                inc     bx
                loop    GenPalette

                push    es
                push    di
                push    ds
                xor     di,di
                xor     si,si
                cld
                mov     dx,0a000h             ; writes the picture
                mov     es,dx
                mov     dx,[picseg]
                mov     ds,dx
                mov     cx,32000
                rep     movsw
                pop     ds
                pop     di
                pop     es

                mov     [RandSeed],SEED         ; Randomize.

                mov     [X],RADIUS
                mov     [Y],RADIUS
                mov     [AddX],3
                mov     [AddY],2

DemoLoop:       mov     [fad],128      ;cmp
                je      full
                inc     fad
full:           call    rotpalette,[fad]
                mov     ax,[Y]                  ; outputs the lenz
                sub     ax,RADIUS               ; crystall ball at
                mov     dx,MAXWIDTH             ; center coordinates (X,Y).
                mul     dx
                add     ax,[X]
                sub     ax,RADIUS
                mov     di,ax
                mov     dx,[PicSeg]
                call    WriteLenz

AdjustX:        mov     ax,[X]                  ; adjust the X coord.
                add     ax,[AddX]
                cmp     ax,RADIUS
                jb      ChangeX
                cmp     ax,MAXWIDTH-RADIUS
                ja      ChangeX
                mov     [X],ax
                jmp     AdjustY
ChangeX:        call    Random
                shr     ax,15
                inc     ax
                cmp     [AddX],0
                jl      SetAddX
                neg     ax
SetAddX:        mov     [AddX],ax

AdjustY:        mov     ax,[Y]                  ; adjust the Y coord.
                add     ax,[AddY]
                cmp     ax,RADIUSI
                jb      ChangeY
                cmp     ax,MAXHEIGHT-RADIUSI
                ja      ChangeY
                mov     [Y],ax
                jmp     Continue
ChangeY:        call    Random
                and     ax,1
                inc     ax
                cmp     [AddY],0
                jl      SetAddY
                neg     ax
SetAddY:        mov     [AddY],ax

Continue:       mov     ah,1                    ; any key pressed?
                int     16h
                je      DemoLoop
                cmp     [FAD],0
                je      quit
                dec     [fad]
                jmp     full
quit:
                mov     ah,0                    ; flush keyboard.
                int     16h
                
DemoExit:
                mov     es,[PicSeg]             ; Blanks the picture.
                xor     di,di
                mov     cx,MAXWIDTH*MAXHEIGHT
                xor     ax,ax
                cld
                rep     stosb

                mov     ax,03h                  ; restores 80x25x16 mode.
                int     10h
                ret

LenzDemo        endp


;-----------------------------------------------------------------------------
; Start - Startup Code called from DOS.
; In:
;   ES - Program Segment Prefix.
;-----------------------------------------------------------------------------

Start           proc

                mov     ax,@Data
                mov     ds,ax
                call    LenzDemo,SEG WormPic
                mov     ax,4C00h
                int     21h

Start           endp

                end     Start
