
;        
;        Project: Plasma Effect [ASM]
;        File   : PLASMEFF.ASM
;           Version: 1.00        Created: 261194   Modified: 261194
;    
;        Nice and fast plasma effect by X3M Productions.
;          If you have any questions, e-mail: srs@alkymi.unit.no
;        


.MODEL SMALL
.STACK 400

DOSSEG
LOCALS

PAL_DIVIDER = 2


.DATA


CosTable LABEL BYTE
INCLUDE COSTBL.INC


Palette LABEL BYTE
	i = 0
	REPT 128 SHR PAL_DIVIDER
                DB      63, i, 63-i
		i = i + (1 SHL (PAL_DIVIDER-1))
	ENDM
	i = 0
	REPT 128 SHR PAL_DIVIDER
		DB	63-i, 63, i
		i = i + (1 SHL (PAL_DIVIDER-1))
	ENDM
	i = 0
	REPT 128 SHR PAL_DIVIDER
		DB	0, 63-i, 63
		i = i + (1 SHL (PAL_DIVIDER-1))
	ENDM
	i = 0
	REPT 128 SHR PAL_DIVIDER
		DB	i, 0, 63
		i = i + (1 SHL (PAL_DIVIDER-1))
	ENDM


VTime1  DB 2
VTime2  DB 1
VTime3  DB 3
VTime4  DB 4


UDATASEG

PlasmaPal DB (256 SHR (PAL_DIVIDER-1))*3 DUP (?)

Time1    DB ?
Time2    DB ?
Time3    DB ?
Time4    DB ?


.CODE
.STARTUP

	CLD
	MOV		AX,13h
	INT   10h
	CLI
	MOV		DX,3c4h
	MOV		AX,604h
	OUT		DX,AX
	MOV 	AX,0F02h
	OUT		DX,AX
	MOV   DX,3D4h
	MOV   AX,14h
	OUT   DX,AX
	MOV   AX,0E317h
	OUT   DX,AX
	MOV   AL,9
	OUT   DX,AL
	INC   DX
	IN    AL,DX
	AND   AL,0E0h
	ADD   AL,7
	OUT   DX,AL
	MOV   DX,3c8h
	MOV   AL,256-(256 SHR (PAL_DIVIDER-1))
	OUT   DX,AL
	INC   DX
	MOV   CX,(256 SHR (PAL_DIVIDER-1))*3
	MOV   SI,OFFSET Palette

@@pl1:
	LODSB
	OUT   DX,AL
	LOOP  @@pl1
	MOV   AX,0A000h
	MOV   ES,AX
	MOV   SI,OFFSET CosTable

MainLoop:
	MOV   DX,3DAh

@@vs1:
	IN		AL,DX
	TEST  AL,8
	JZ    @@vs1

@@vs2:
	IN    AL,DX
	TEST  AL,8
	JNZ   @@vs2
	XOR   DI,DI
	MOV   AH,50
	MOV   CL,Time3
	MOV   CH,Time4

@@lv:
	PUSH  AX
        MOV   AH,80
	MOV   DL,Time1
	MOV   DH,Time2

@@lh:
	MOV		BX,BP
	MOV   AL,BL
; ADD   AL,AH                  ; Could make for more perturbations.
	XOR   BH,BH
	MOV   BL,DL
	ADD   AL,[SI+BX]
	MOV   BL,DH
	ADD   AL,[SI+BX]
	MOV   BL,CL
	ADD   AL,[SI+BX]
	MOV   BL,CH
	ADD   AL,[SI+BX]

	IFDIF %PAL_DIVIDER,<1>
		OR		AL, (0FFh SHL (9-PAL_DIVIDER)) AND 0FFh
	ENDIF

	STOSB
	ADD   DL,1
	ADD   DH,3
	DEC   AH
	JNZ   @@lh
	ADD   CL,2
	ADD   CH,1
	POP   AX
	DEC   AH
	JNZ   @@lv

	DEC   BP
	MOV   BX,BP
	XOR   BL,BH
	XOR   BL,-1[DI]
	XOR   BL,CL
	XOR   BL,DL
	ADD   BL,CH
	ADD   BL,DH

	XOR   BH,BH
	MOV   DI,OFFSET VTime1
	TEST  BL,8
	JNZ   @@dec
	AND   BL,3
	CMP   BYTE PTR [DI+BX],3
	JG    @@sum
	INC   BYTE PTR [DI+BX]
	JMP   @@sum

@@dec:
	AND   BL,3
	CMP   BYTE PTR [DI+BX],-3
	JL    @@sum
	DEC   BYTE PTR [DI+BX]

@@sum:
	MOV   DL,VTime1
	MOV   DH,VTime2
	MOV   CL,VTime3
	MOV   CH,VTime4
	ADD   Time1,DL
	SUB   Time2,DH
	ADD   Time3,CL
	SUB   Time4,CH
	MOV   AH,1
	INT   16h
	JNZ   Bye
	JMP   MainLoop

Bye:
	XOR   AH,AH
	INT   16h
	MOV   AX,3
	INT   10h
	XOR   BH,BH
	MOV   DX,1700h
	MOV   AH,2
	INT   10h
	MOV   AX,4C00h
	INT   21h

END


