;===================================;
;				    ;
; ZOOMROTATER coded by maLi/FiNESSE ;
; e-mail: igo.gruden@uni-lj.si      ;
; programming in TASM 3.2           ;
; date: 14.4.1996		    ;
;				    ;
;===================================;
.model large,c
.386
.stack 100h
.data


filename db 'fns_logo.pcx',0
fhandle  dw ? ;file handle
palette  db 786 dup (?)
startx	 dw ? ;start x of picture
starty   dw ? ;start y of picture
sizex	 dw ? ;width of picture
sizey    dw ? ;height of picture
pcxver   db ? ;pcx version-must be 5 for 320x200x256 .pcx file
picture  dw ? ;segment of allocated block-picture
picture2 dw ?
screen	 dw ? ;segment of virtual screen
nomemory db 'not enough memory$'
nofile	 db 'file error$'
nopcx    db 'this is not valid 256 colors .pcx file$'
filesize equ 19990
len      db ? 
angle	 dw ?
scale	 dw ? ;direction of angle
adir	 db ? ;direction of scale
sdir	 db ?
angle1	 dw ?
scale1   dw ?
yc	 dw ?
ys	 dw ?
xs	 dw ?
xc	 dw ?
xt	 dw ?
yt	 dw ?
color    db ?

include ytable.inc
include zoomrot.inc

.code

malloc macro _segment,_size
       mov eax,4a00h
       mov ebx,_size
       int 21h
       mov eax,4800h
       int 21h
       mov _segment,ax
       endm
	
free macro _segment
     mov ax,_segment
     mov es,ax
     mov eax,4900h
     int 21h
     endm


;============= I N I T   D E M O - A L L O C A T E . . . =============
	mov ax,@data
	mov ds,ax
	
	malloc screen,1000h        ;save segment
	malloc picture,1000h       ;save segment
	malloc picture2,1000h      ;save segment
	
	
	mov ax,3d00h         ;open file
	xor al,al            ;normal file
	lea dx,filename
	int 21h              
	jc error_file        ;error
	mov fhandle,ax       ;save file handle

	push ds
	mov ax,screen	     
	mov ds,ax
	xor dx,dx            
	mov ax,3f00h	     ;read from file
	mov bx,cs:[fhandle]  ;set file handler
	mov ax,3f00h
	mov cx,filesize      ;file size
	int 21h
	pop ds
	mov ax,3e00h	     ;close file
	mov bx,cs:[fhandle]
	int 21h
        
;================== L O A D    . P C X     F I L E ===========        
        mov ax,screen
	mov fs,ax
	mov si,1
	mov al,fs:[si]
	cmp al,5             ;checking if it's 256 colors .pcx file
	jnz error_pcx	     ;it's not... 
	
	add si,3
	mov ax,word ptr fs:[si]
	mov startx,ax        ;read start x of picture
	
	add si,2
	mov ax,word ptr fs:[si]
	mov starty,ax        ;read start y of picture
	
	add si,2
	mov ax,word ptr fs:[si]
	mov sizex,ax	     ;read size x of picture 
	
	add si,2
	mov ax,word ptr fs:[si]
	mov sizey,ax	     ;read size y of picture 
	
        mov si,filesize
        sub si,768
        mov cx,768
        xor di,di           ;read palette
        read_pal:
        mov al,fs:[si]
        shr al,2
        mov [palette+di],al
        inc si
        inc di
        loop read_pal

        mov ax,0013h
        int 10h
	
        mov dx,3c2h      ;get into a square aspect ratio
        mov ax,0e3h
	out dx,ax
	
	call setpal
        mov si,127           ;ignore pcx header

	mov ax,picture       ;where to decode picture
	mov es,ax

	xor di,di
	cld
	pcx_main:
	
	mov al,fs:[si]	     
	inc si
	mov bl,al
	and bl,0c0h	     ;is compressed?
	cmp bl,0c0h
	jnz not_compressed   
	
	and al,3fh	     ;it's compressed
	mov len,al	     ;lenght of packet
	mov al,fs:[si]	     ;color
	inc si
	jmp draw_pcx
	
	not_compressed:
	mov bl,1
	mov len,bl
	
	draw_pcx:

	mov cl,len            ;draw pixel(s)
	xor ch,ch	      ;lenght of block is in len
	rep stosb             ;color is in al
        
	cmp di,63999          ;is picture drawn?
        jb pcx_main

	push ds
	mov ax,picture2
	mov es,ax
	mov ax,picture
	mov ds,ax
        mov cx,16000
	xor si,si
	xor di,di
	rep movsd	      ;copy picture to picture2	
	pop ds


;============ D O    R O T A T I O N   &   Z O O M I N G ===============

	mov ax,106
	mov scale1,ax
	mov ax,500
	mov angle1,ax
	
	xor ax,ax
	mov scale,ax	 ;set scale to 0
	mov angle,ax     ;set angle to 0
	mov adir,al	 ;set adir to 0
	mov sdir,al	 ;set sdir to 0
	
	mov ax,picture   ;set segment of picture
	mov fs,ax
	mov ax,picture2
	mov es,ax
	
	mov ax,screen    ;set segment of virtual screen
	mov gs,ax
	
	rotate_main:

	call spucaj
	
	mov al,sdir
	cmp al,0
	jnz dec_scale    ;if sdir=1 then we have to decrease scale
	
	
	mov ax,scale1
	sub ax,4
	mov scale1,ax
	mov ax,scale     ;otherwise we have to increase it
	add ax,4
	mov scale,ax
	cmp ax,106       ;is scale 106?
	jbe scale_done   ;no
	mov al,1	 ;yes
	mov sdir,al	 ;we have to change direction of scalling
			 ;set adir to 1
	dec_scale:       ;sdir=0 so we have to decrease scale
	mov ax,scale1
	add ax,4
	mov scale1,ax
	mov ax,scale
	sub ax,4
	mov scale,ax
	cmp scale,0      ;is scale 0?
	jnz scale_done   ;no
	xor al,al        ;yes
	mov sdir,al	 ;we have to change direction of scalling
		         ;set sdir to 0
	scale_done:
	
	mov al,adir
	cmp al,0
	jnz dec_angle    ;if adir=1 then we have to decrease angle
	
	
	mov ax,angle1
	sub ax,8
	mov angle1,ax
	mov ax,angle     ;otherwise we have to increase it
	add ax,8
	mov angle,ax
	cmp ax,500       ;is angle 500?
	jbe angle_done   ;no
	mov al,1	 ;yes
	mov adir,al	 ;we have to change direction of rotating
			 ;set adir to 1
	dec_angle:       ;adir=0 so we have to decrease angle
	mov ax,angle1
	add ax,8
	mov angle1,ax
	mov ax,angle
	sub ax,8
	mov angle,ax
	cmp angle,0      ;is angle 0?
	jnz angle_done   ;no
	xor al,al        ;yes
	mov adir,al	 ;we have to change direction of rotation
		         ;set adir to 0
	angle_done:
	
	
	
	
	
	
	
	
	mov ax,scale
	mov si,ax       ;si = offset in scale table
	
	mov ax,angle
	mov di,ax	;di = offset in cosinus and sinus table

	mov cx,0ffffh
	sub cx,99	;set cx to -100
	
	drawY_rotate:
	mov bx,0ffffh
	sub bx,159	;set bx to -160 because we want to rotate around 
	mov ax,[cos+di]
	imul cx
	sar ax,7
	mov yc,ax       ;yc=cos(angle)*y
	
	mov ax,[sin+di]
	imul cx
	sar ax,7
	mov ys,ax	;ys=sin(angle)*y

	drawX_rotate:

;============ R O T A T E    &    S C A L E =================        
        mov bp,[zoom+si]
        mov ax,[cos+di] 
	imul bx
	sar ax,7 
	sub ax,ys
	imul bp
	sar ax,7
	mov xt,ax;xt=(cos(angle)*x-sin(angle)*y) * SCALE

	mov ax,[sin+di]
	imul bx
	sar ax,7 
        add ax,yc
	imul bp
	sar ax,7;yt=(sin(angle)*x+cos(angle)*y) * SCALE
	
	push di
	add ax,100
	cmp ax,199
	ja @@done
        mov di,ax
	add di,di
	mov ax,[ytab+di]
	mov bp,ax
	mov ax,xt
	add ax,160
	cmp ax,319
	ja @@done
	add bp,ax
	mov al,fs:[bp] ;check pixel at xt and yt in picture
	cmp al,1
	jb @@done
	mov color,al

	
	mov ax,cx
	add ax,100
	cmp ax,199
	ja @@done
	mov di,ax
	add di,di
	mov bp,[ytab+di]
	mov ax,bx
	add ax,160
	cmp ax,319
	ja @@done
	add bp,ax
	mov al,color
	mov gs:[bp],al ;and put it to x and y to screen
        
        @@done:
        
        pop di
        
        
        inc bx
	cmp bx,160
	jl drawX_rotate;x loop
	
	inc cx
	cmp cx,100
	jl drawY_rotate;y loop

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	mov ax,scale1
	mov si,ax       ;si = offset in scale table
	
	mov ax,angle1
	mov di,ax	;di = offset in cosinus and sinus table

	mov cx,0ffffh
	sub cx,99	;set cx to -100
	
	drawY_rotate1:
	mov bx,0ffffh
	sub bx,159	;set bx to -160 because we want to rotate around 
	mov ax,[cos+di]
	imul cx
	sar ax,7
	mov yc,ax       ;yc=cos(angle)*y
	
	mov ax,[sin+di]
	imul cx
	sar ax,7
	mov ys,ax	;ys=sin(angle)*y

	drawX_rotate1:

;============ R O T A T E    &    S C A L E =================        
        mov bp,[zoom+si]
        mov ax,[cos+di] 
	imul bx
	sar ax,7 
	sub ax,ys
	imul bp
	sar ax,7
	mov xt,ax;xt=(cos(angle)*x-sin(angle)*y) * SCALE

	mov ax,[sin+di]
	imul bx
	sar ax,7 
        add ax,yc
	imul bp
	sar ax,7;yt=(sin(angle)*x+cos(angle)*y) * SCALE
	
	push di
	add ax,100
	cmp ax,199
	ja @@done1
        mov di,ax
	add di,di
	mov ax,[ytab+di]
	mov bp,ax
	mov ax,xt
	add ax,160
	cmp ax,319
	ja @@done1
	add bp,ax
	mov al,es:[bp] ;check pixel at xt and yt in picture
	cmp al,1
	jb @@done1
	mov color,al

	
	mov ax,cx
	add ax,100
	cmp ax,199
	ja @@done1
	mov di,ax
	add di,di
	mov bp,[ytab+di]
	mov ax,bx
	add ax,160
	cmp ax,319
	ja @@done1
	add bp,ax
	mov al,color
	mov gs:[bp],al ;and put it to x and y to screen
        
        @@done1:
        pop di
        
        
        inc bx
	cmp bx,160
	jl drawX_rotate1;x loop
	
	inc cx
	cmp cx,100
	jl drawY_rotate1;y loop

	
	call vretrace
	call flip
	
	mov ax,100h
	int 16h
	jz rotate_main


        mov ax,0003h
	int 10h
        
        jmp end_progy

	error_file:
	mov ax,900h
	lea dx,nofile
	int 21h
	jmp end_progy
	
	error_pcx:
	mov ax,900h
	lea dx,nopcx
	int 21h
	jmp end_progy

	error_nomemory:
	mov ax,900h
	lea dx,nomemory
	int 21h
	
	end_progy:

	free screen ;deallocate memory 
	free picture;deallocate memory
	free picture2;deallocate memory
	
	mov ax,4c00h
	int 21h

vretrace proc near 
         uses ax,dx
         mov dx,3dah 
         vr:         
         in al,dx    
         and al,8    
         jnz vr      
         vnr:        
         in al,dx    
         and al,8
         jz vnr      
         ret                 
         endp           
                       
flip proc near          
     uses ax,cx,si,di,ds,es
     mov ax,screen
     mov ds,ax         
     mov ax,0a000h         
     mov es,ax         
     xor di,di             
     xor si,si          
     mov cx,16000      
     rep movsd
     ret                
     endp                    

spucaj proc near
       uses ax,cx,di,es
       mov ax,screen
       mov es,ax
       xor eax,eax
       mov cx,16000
       xor di,di
       rep stosd
       ret
       endp	

setpal proc near
       uses ax,cx,dx,si
       mov dx,3c8h      
       xor al,al
       out dx,al
       inc dx
       mov cx,768
       lea si,palette
       rep outsb
       ret
       endp


end

