;===================================;
;				    ;
; ZOOMROTATER coded by maLi/FiNESSE ;
; e-mail: igo.gruden@uni-lj.si      ;
; programming in TASM 3.2           ;
; date: 14.4.1996		    ;
;				    ;
;===================================;
.model large,c
.386
.stack 100h
.data


filename db 'fns_logo.pcx',0
fhandle  dw ? ;file handle
palette  db 786 dup (?)
startx	 dw ? ;start x of picture
starty   dw ? ;start y of picture
sizex	 dw ? ;width of picture
sizey    dw ? ;height of picture
pcxver   db ? ;pcx version-must be 5 for 320x200x256 .pcx file
picture  dw ? ;segment of allocated block-picture
screen	 dw ? ;segment of virtual screen
nomemory db 'not enough memory$'
nofile	 db 'file error$'
nopcx    db 'this is not valid 256 colors .pcx file$'
filesize equ 19990
len      db ? 
angle	 dw ?
scale	 dw ? ;direction of angle
adir	 db ? ;direction of scale
sdir	 db ?

yc	 dd ?
ys	 dd ?
xs	 dd ?
xc	 dd ?
xt	 dd ?
yt	 dd ?

color    db ?

include ytable.inc
include zoomrot.inc

.code

malloc macro _segment,_size
       mov eax,4a00h
       mov ebx,_size
       int 21h
       mov eax,4800h
       int 21h
       mov _segment,ax
       endm
	
free macro _segment
     mov ax,_segment
     mov es,ax
     mov eax,4900h
     int 21h
     endm


;============= I N I T   D E M O - A L L O C A T E . . . =============
	mov eax,@data
	mov ds,eax
	
	malloc screen,1000h        ;save segment
	malloc picture,1000h       ;save segment
	
	
	mov eax,3d00h         ;open file
	lea dx,filename
	int 21h              
	jc error_file        ;error
	mov fhandle,ax       ;save file handle

	push ds
	mov ax,screen	     
	mov ds,ax
	xor edx,edx            
	mov eax,3f00h	     ;read from file
	mov bx,cs:[fhandle]  ;set file handler
	mov eax,3f00h
	mov ecx,filesize      ;file size
	int 21h
	pop ds
	mov eax,3e00h	     ;close file
	mov bx,cs:[fhandle]
	int 21h
        
;================== L O A D    . P C X     F I L E ===========        
        mov ax,screen
	mov fs,ax
	mov esi,1
	mov al,fs:[esi]
	cmp al,5             ;checking if it's 256 colors .pcx file
	jnz error_pcx	     ;it's not... 
	
	add esi,3
	mov ax,word ptr fs:[esi]
	mov startx,ax        ;read start x of picture
	
	add esi,2
	mov ax,word ptr fs:[esi]
	mov starty,ax        ;read start y of picture
	
	add esi,2
	mov ax,word ptr fs:[esi]
	mov sizex,ax	     ;read size x of picture 
	
	add esi,2
	mov ax,word ptr fs:[esi]
	mov sizey,ax	     ;read size y of picture 
	
        mov esi,filesize
        sub esi,768
        mov ecx,768
        xor edi,edi           ;read palette
        read_pal:
        mov al,fs:[esi]
        shr al,2
        mov [palette+edi],al
        inc esi
        inc edi
        loop read_pal

        mov eax,0013h
        int 10h
	
        mov dx,3c2h      ;get into a square aspect ratio
        mov ax,0e3h
;        out dx,ax
	
	call setpal
        mov esi,127           ;ignore pcx header

	mov ax,picture       ;where to decode picture
	mov es,ax

	xor edi,edi
	cld
	pcx_main:
	
	mov al,fs:[esi]	     
	inc esi
	mov bl,al
	and bl,0c0h	     ;is compressed?
	cmp bl,0c0h
	jnz not_compressed   
	
	and al,3fh	     ;it's compressed
	mov len,al	     ;lenght of packet
	mov al,fs:[esi]	     ;color
	inc esi
	jmp draw_pcx
	
	not_compressed:
	mov bl,1
	mov len,bl
	
	draw_pcx:

	mov cl,len            ;draw pixel(s)
	xor ch,ch	      ;lenght of block is in len
	rep stosb             ;color is in al
            
	cmp edi,63999          ;is picture drawn?
        jb pcx_main

;============ D O    R O T A T I O N   &   Z O O M I N G ===============

	xor eax,eax
	mov scale,ax	 ;set scale to 0
	mov angle,ax     ;set angle to 0
	mov adir,al	 ;set adir to 0
	mov sdir,al	 ;set sdir to 0
	
	mov ax,picture   ;set segment of picture
	mov fs,ax
	mov ax,screen    ;set segment of virtual screen
	mov gs,ax
	
	rotate_main:

	call spucaj
	
	mov al,sdir
	cmp al,0
	jnz dec_scale    ;if sdir=1 then we have to decrease scale
	
	
	mov ax,scale     ;otherwise we have to increase it
	add ax,4
	mov scale,ax
	cmp ax,106       ;is scale 106?
	jbe scale_done   ;no
	mov al,1	 ;yes
	mov sdir,al	 ;we have to change direction of scalling
			 ;set adir to 1
	dec_scale:       ;sdir=0 so we have to decrease scale
	mov ax,scale
	sub ax,4
	mov scale,ax
	cmp ax,0      ;is scale 0?
	jnz scale_done   ;no
	xor al,al        ;yes
	mov sdir,al	 ;we have to change direction of scalling
		         ;set sdir to 0
	scale_done:
	
	mov al,adir
	cmp al,0
	jnz dec_angle    ;if adir=1 then we have to decrease angle
	
	
	mov ax,angle     ;otherwise we have to increase it
	add ax,8
	mov angle,ax
	cmp ax,500       ;is angle 500?
	jbe angle_done   ;no
	mov al,1	 ;yes
	mov adir,al	 ;we have to change direction of rotating
			 ;set adir to 1
	dec_angle:       ;adir=0 so we have to decrease angle
	mov ax,angle
	sub ax,8
	mov angle,ax
	cmp ax,0      ;is angle 0?
	jnz angle_done   ;no
	xor al,al        ;yes
	mov adir,al	 ;we have to change direction of rotation
		         ;set adir to 0
	angle_done:
	
	
	
	mov si,scale       ;si = offset in scale table
	
	mov di,angle	;di = offset in cosinus and sinus table

	mov cx,0ffffh
	sub cx,99	;set cx to -100
	
	drawY_rotate:
	
	mov bx,0ffffh
	sub bx,159	;set bx to -160 because we want to rotate around 
	
	mov ax,[cos+di]
	imul cx
	sar ax,7
	cwde
	mov yc,eax       ;yc=cos(angle)*y
	
	mov ax,[sin+di]
	imul cx
	sar ax,7
	cwde
	mov ys,eax	;ys=sin(angle)*y

	drawX_rotate:

;============ R O T A T E    &    S C A L E =================        
        
        mov bp,[zoom+si];ebp=SCALE
        
        mov ax,[cos+di] 
	imul bx
	sar ax,7 
	cwde
	sub eax,ys
	imul bp
	sar ax,7
	cwde
	mov xt,eax;xt=(cos(angle)*x-sin(angle)*y) * SCALE
	    
	mov ax,[sin+di]
	imul bx
	sar ax,7 
        cwde
        add eax,yc
	imul bp
	sar ax,7;yt=(sin(angle)*x+cos(angle)*y) * SCALE
	
	push di
	add ax,100
	cmp ax,199
	ja @@done
        mov di,ax
	add di,di
	mov ax,[ytab+di]
	mov bp,ax
	cwde
	mov eax,xt
	add eax,160
	cmp eax,319
	ja @@done
	add ebp,eax
	
	mov al,fs:[ebp] ;check pixel at xt and yt in picture
	cmp al,1
	jb @@done
	
	mov color,al

	
	mov ax,cx
	add ax,100
	cmp ax,199
	ja @@done
	mov di,ax
	add di,di
	mov bp,[ytab+di]
	mov ax,bx
	add ax,160
	cmp ax,319
	ja @@done
	add bp,ax
	mov al,color
	mov gs:[bp],al ;and put it to x and y to screen
        
        @@done:
        
        pop di
        
        
        inc bx
	cmp bx,160
	jl drawX_rotate;x loop
	
	inc cx
	cmp cx,100
	jl drawY_rotate;y loop

	
	call vretrace
	call flip
	
	mov eax,100h
	int 16h
	jz rotate_main


        mov eax,0003h
	int 10h
        
        jmp end_progy

	error_file:
	mov ax,900h
	lea dx,nofile
	int 21h
	jmp end_progy
	
	error_pcx:
	mov ax,900h
	lea dx,nopcx
	int 21h
	jmp end_progy

	error_nomemory:
	mov ax,900h
	lea dx,nomemory
	int 21h
	
	end_progy:

	free screen ;deallocate memory 
	free picture;deallocate memory
	
	mov eax,4c00h
	int 21h

vretrace proc near 
         uses ax,dx
         mov dx,3dah 
         vr:         
         in al,dx    
         and al,8    
         jnz vr      
         vnr:        
         in al,dx    
         and al,8
         jz vnr      
         ret                 
         endp           
                       
flip proc near          
     uses eax,ecx,esi,edi,ds,es
     mov ax,screen
     mov ds,ax         
     mov eax,0a000h         
     mov es,eax         
     xor edi,edi             
     xor esi,esi          
     mov ecx,16000      
     rep movsd
     ret                
     endp                    

spucaj proc near
       uses eax,ecx,edi,es
       mov ax,screen
       mov es,ax
       xor eax,eax
       mov ecx,16000
       xor edi,edi
       rep stosd
       ret
       endp	

setpal proc near
       uses ax,cx,dx,si
       mov dx,3c8h      
       xor al,al
       out dx,al
       inc dx
       mov cx,768
       lea si,palette
       rep outsb
       ret
       endp


end

