{$G+}
uses crt;
type pictype=array[0..63999] of byte;
     pictypep=^pictype;
     rgb=record
    	   r,g,b:byte;
	 end;

     palette=array[0..255] of rgb;

var pal1:palette;
    pal2:palette;
    palc1:palette;
    palc2:palette;
    pic1,pic2,pic3:pictypep;

procedure waitretrace; assembler;
asm
  mov dx,$3da
  @vr:
  in al,dx
  test al,8
  jz @vr
  @vd:
  in al,dx
  test al,8
  jnz @vd
end;

procedure setpalette(p:palette); assembler;
asm
  push ds
  mov  dx,$3c8
  sub  al,al
  out  dx,al
  mov  ds,word ptr p+2
  mov  si,word ptr p
  mov  cx,$300
  inc  dx
  rep  outsb
  pop  ds
end;


procedure showpic(pic:pictypep);assembler;
asm
  push ds
  mov ax,word(pic+2)
  mov ds,ax
  mov ax,0a000h
  mov es,ax
  xor si,si
  xor di,di
  mov cx,32000
  rep movsw
  pop ds
end;

procedure fadeto(pal,topal:palette);
var i,j:byte;
begin
  for i:=0 to 63 do begin
    for j:=0 to 255 do begin
      if pal[j].r>topal[j].r then dec(pal[j].r);
      if pal[j].r<topal[j].r then inc(pal[j].r);
      if pal[j].g>topal[j].g then dec(pal[j].g);
      if pal[j].g<topal[j].g then inc(pal[j].g);
      if pal[j].b>topal[j].b then dec(pal[j].b);
      if pal[j].b<topal[j].b then inc(pal[j].b);
    end;
    setpalette(pal);
    waitretrace;
  end;
end;

procedure loadcel(name:string;var where;var pal:palette);
var f:file;
begin
  {$I-}
  assign(f,name);
  reset(f,1);
    {$I+}
  If ioresult=0 then begin
    seek(f,32);
    blockread(f,pal,768);
    blockread(f,where,64000);
    close(f);
  end
end;

procedure makecrossfade;
var colors:array[0..255] of record
		              pix1,pix2:byte;
                            end;
    t,t1:word;
    num:word;
    pix1,pix2:byte;
begin
  num:=1;
  t:=0;
  for t:=0 to 63999 do begin
    pix1:=pic1^[t];
    pix2:=pic2^[t];
    for t1:=0 to num-1 do
    if (pix1=colors[t1].pix1) and (pix2=colors[t1].pix2) then begin
      pic3^[t]:=t1;
      t1:=256;
      break;
    end;
    if t1<>256 then begin
      pic3^[t]:=num;
      palc1[num]:=pal1[pix1];
      palc2[num]:=pal2[pix2];
      colors[num].pix1:=pix1;
      colors[num].pix2:=pix2;
      num:=num+1;
    end;
    if num>255 then begin
      writeln('more Then 256 Colors . ');
      halt;
    end;
  end;
end;

begin
  new(pic1);
  new(pic2);
  new(pic3);
  loadcel('pic1.cel',pic1^,pal1);
  loadcel('pic2.cel',pic2^,pal2);
  asm
    mov ax,0013h
    int 10h
  end;
  repeat
    makecrossfade;
    showpic(pic3);
    fadeto(palc1,palc2);
    fadeto(palc2,palc1);
  until keypressed;
  asm
    mov ax,0003h
    int 10h
  end;
  dispose(pic1);
  dispose(pic2);
  dispose(pic3);
end.


