;========================================;
;  ;
;  DOBULE ZOOMROTATER WITH CROSS FADE  ; 
;  ;
; 				         ;
; Code: MALi/FiNESSE                     ;
; E-mail: igo.gruden@uni-lj.si           ;
; Programming in TASM 4.0                ;
; Date: 11.6.1996	                 ;
;			                 ;
;========================================;
.model large,c
locals
.386
.stack 100h
.data


filename db 'fns_logo.pcx',0
filesize equ 19990

fhandle  dw ? ;file handle

palette  db 786 dup (?)

startx	 dw ? ;start x of picture
starty   dw ? ;start y of picture
sizex	 dw ? ;width of picture
sizey    dw ? ;height of picture


picture  dw ? ;segment of allocated block-picture
screen	 dw ? ;segment of virtual screen

len      db ? 

angle	 dd ?
scale	 dd ? 

adir	 db ? ;direction of angle
sdir	 db ? ;direction of scale


yc	 dd ?
ys	 dd ?
xs	 dd ?
xc	 dd ?
xt	 dd ?
yt	 dd ?
m	 dd ?


color    db ?

include ytable32.inc
include zomrot32.inc


ends


.code

;=============== M A C R O S ===============
malloc macro _segment,_size
       mov eax,4a00h
       mov ebx,_size
       int 21h
       mov eax,4800h
       int 21h
       mov _segment,ax
       endm
	
free macro _segment
     mov ax,_segment
     mov es,ax
     mov eax,4900h
     int 21h
     endm

	
flip macro _segment          
     uses eax,ecx,esi,edi,ds,es
     mov ax,_segment
     mov ds,ax         
     mov eax,0a000h         
     mov es,eax         
     xor edi,edi             
     xor esi,esi          
     mov ecx,16000      
     rep movsd
     endm

clear macro _segment
      uses eax,ecx,edi,es
      mov ax,_segment
      mov es,ax
      xor eax,eax
      mov ecx,16000
      xor edi,edi
      rep stosd
      endm
;========================================================


	mov eax,@data  ;set DS to data segment
	mov ds,eax
	
	mov eax,0013h   ;set video mode
	int 10h
	
	malloc screen,1000h        ;allocate memory1
	malloc picture,1000h       ;allocate memory2
	
;============= R E A D   . P C X     F I L E    T O   S E G M E N T =========        
	mov eax,3d00h         ;open file
	lea dx,filename
	int 21h              
	mov cs:[fhandle],ax       ;save file handle

	push ds
	mov ax,screen	     
	mov ds,ax
	xor edx,edx            
	mov eax,3f00h	     ;read from file
	mov bx,cs:[fhandle]  ;set file handler
	mov eax,3f00h
	mov ecx,filesize     ;file size
	int 21h
	pop ds
	mov eax,3e00h	     ;close file
	mov bx,cs:[fhandle]
	int 21h
        
;================== D E C O D E    . P C X     F I L E ===========        
        mov ax,screen
	mov fs,ax
	
        mov esi,filesize      ;move to the end of file hwere palette is
        sub esi,768	      
        mov ecx,768           
        xor edi,edi           ;read palette
        read_pal:
        mov al,fs:[esi]
        shr al,2
        mov [palette+edi],al
        inc esi
        inc edi
        loop read_pal

	call setpal
        mov esi,127          ;skip .pcx header
			     ;we assume picture is 320x200
	mov ax,picture       ;where to decode picture
	mov es,ax

	cld
	xor edi,edi
	pcx_main:
	
	mov al,fs:[esi]	     
	inc esi
	mov bl,al
	and bl,0c0h	     ;is compressed?
	cmp bl,0c0h
	jnz not_compressed   
	
	and al,3fh	     ;it's compressed
	mov len,al	     ;lenght of packet
	mov al,fs:[esi]	     ;color
	inc esi
	jmp draw_pcx
	
	not_compressed:
	mov bl,1
	mov len,bl
	
	draw_pcx:

	mov cl,len            ;draw pixel(s)
	xor ch,ch	      ;lenght of block is in len
	rep stosb             ;color is in al
            
	cmp edi,63999          ;is picture drawn?
        jl pcx_main

	flip picture
	
	mov ax,picture
	mov fs,ax
	mov ax,screen
	mov gs,ax
	
	
	@@loop_rotate_main:

	
	mov ecx,0ffffffffh
	sub ecx,99
	
	@@loop_draw_Y:

	
	mov ebx,0ffffffffh
	sub ebx,159

	@@loop_draw_X:

	;yc=cos(angle)*y
	;ys=sin(angle)*y

	;xt=(cos(angle)*x-sin(angle)*y) * SCALE
	;yt=(sin(angle)*x+cos(angle)*y) * SCALE
	
	inc ebx
	cmp ebx,160
	jl @@loop_draw_X

	inc ecx
	cmp ecx,100
	jl @@loop_draw_Y
	
	call vretrace
	flip screen
	
	mov eax,100h
	int 16h		 ;w8 until key is pressed
	jz @@loop_rotate_main

	
	mov eax,0003h	 ;set text mode
	int 10h
	
	
	free screen ;deallocate memory1 
	free picture;deallocate memory1
	
	mov eax,4c00h  ;terminate program and return to DOS
	int 21h















vretrace proc near 
         uses ax,dx
         mov dx,3dah 
         vr:         
         in al,dx    
         and al,8    
         jnz vr      
         vnr:        
         in al,dx    
         and al,8
         jz vnr      
         ret                 
         endp           
                       
setpal proc near
       uses ax,cx,dx,si
       mov dx,3c8h      
       xor al,al
       out dx,al
       inc dx
       mov cx,768
       lea si,palette
       rep outsb
       ret
       endp

ends

end
