.386
.model flat,c
.stack 100h
.code

pcx_name  db 'face1.pcx',0
error_msg db 'error while allocating memory or reading pcx file$'
palette	  db 768 dup (?)
f_handle  dw ?
base_ptr  dd ?
pcx_ptr   dd ?
screen    dd ?
pcx_color db ?
pcx_len	  db ?
xt	  dd ?;texture x
yt	  dd ?;texture y 
ys	  dd ?;szoom*y
yc	  dd ?;czoom*y
xs	  dd ?;szoom*x
xc	  dd ?;czoom*x
czoom	  dd ?;cos*zoom
szoom	  dd ?;sin*zoom
angle	  dd ?
scale     dd ?
dang	  dd ?
dsca	  dd ?
video_ptr equ 0a0000h
pcx_size  equ 8481

include zoomrot.inc

ytab label word
i=0
rept 200
  dw i*320
  i=i+1
endm


zr:
	
        mov     ax,0ee02h
        int     31h
        mov     [base_ptr],ebx
        
        mov	ax,0013h
	int	10h
        
        mov 	dx,3c2h      ;get into a square aspect ratio
        mov 	ax,0e3h
	out 	dx,ax
        
        mov	edx,320*200             ;allocate a 64K memory
        mov     ax,0ee42h
        int	31h
	jc	@@error
	mov	[screen],edx	        ;save pointer
	
        mov	edx,320*200             ;allocate a 64K memory
        mov     ax,0ee42h
        int	31h
	jc	@@error
	mov	[pcx_ptr],edx	        ;save pointer

	mov	ax,3d00h		;open file
	lea	edx,pcx_name
	int	21h
	jc	@@error
	mov	[f_handle],ax		;save file handle

	mov	ax,3f00h		;read from file
	mov	bx,[f_handle]
	mov	ecx,pcx_size
	mov	edx,[screen]		;to pcx_ptr
	int	21h

	mov	ax,3e00h		;close file
	mov	bx,[f_handle]
	int	21h
        
        mov	esi,[screen]		;get palette
	add	esi,pcx_size-768
	xor	ebx,ebx
	
	@@pcx_read_palette:
	mov	al,byte ptr [esi]
	shr	al,2
	mov	[palette+ebx],al
	inc	esi
	inc 	ebx
	cmp	ebx,768
	jb	@@pcx_read_palette

	mov	dx,3c8h      		;set palette
	xor 	al,al
	out 	dx,al
	inc 	dx
	xor 	ebx,ebx
	@@pcx_set_palette:
	mov	al,[palette+ebx]
	out	dx,al
	inc	ebx
	cmp	ebx,768
	jb	@@pcx_set_palette
	
	mov	edx,[pcx_ptr]
	
        xor 	edi,edi
	mov	esi,[screen]
	inc	esi
	mov	al,byte ptr [esi]
	cmp	al,5			;check if file is valid pcx file
	jne	@@error

	add	esi,126			;ignore pcx header
	
	@@pcx_decode:

	mov 	al,byte ptr [esi]
	inc 	esi
	mov	ah,al
	and	ah,0c0h			;check if packet is compressed
	cmp	ah,0c0h
	jne	@@pcx_packer_not_compressed
	and	al,03fh
	mov	pcx_len,al
	mov	al,byte ptr [esi]
	inc	esi
	mov	pcx_color,al
	jmp	@@pcx_init_packet
	
	
	@@pcx_packer_not_compressed:
	mov	pcx_len,1		
	mov	pcx_color,al

	@@pcx_init_packet:
	movzx	ecx,pcx_len
	mov	cl,pcx_len
	mov	al,pcx_color
	
	@@pcx_draw_packet:
	mov	[edx],al
	inc	edx
	inc 	edi
	dec	ecx
	jnz	@@pcx_draw_packet
	
	cmp	edi,63999
	jb	@@pcx_decode
        
	
	xor	eax,eax
	mov	angle,eax
	mov	eax,64
	mov	scale,eax
	mov	eax,1
	mov	dang,eax
	mov	dsca,eax

	@@rotate_zoom:

	mov	eax,dang
	cmp	eax,0
	je	@@dec_angle
	mov  	eax,angle
	add	eax,8
	cmp	eax,510
	jl	@@angle_ok
	xor	eax,eax
	mov	dang,eax
	mov	eax,510
	jmp 	@@angle_ok
	@@dec_angle:
	mov	eax,angle
	sub	eax,8
	cmp 	eax,0
	jg	@@angle_ok
	mov	eax,1
	mov 	dang,eax
	xor	eax,eax
	@@angle_ok:
	mov	angle,eax

	mov	eax,dsca
	cmp	eax,0
	je	@@dec_scale
	mov  	eax,scale
	add	eax,2
	cmp	eax,128
	jl	@@scale_ok
	xor	eax,eax
	mov	dsca,eax
	mov	eax,128
	jmp 	@@scale_ok
	@@dec_scale:
	mov	eax,scale
	sub	eax,2
	cmp 	eax,0
	jge	@@scale_ok
	mov	eax,1
	mov 	dsca,eax
	xor	eax,eax
	@@scale_ok:
	mov	scale,eax
	
	mov  	edi,scale
	movsx	ebx,zoom[edi]
	
	mov  	edi,angle
	
	movsx	eax,cos[edi]
	imul	ebx;COS*ZOOM
	shrd	eax,edx,7
	mov	czoom,eax
	
	movsx	eax,sin[edi]
	imul	ebx;SIN*ZOOM
	shrd	eax,edx,7
	mov	szoom,eax
	
	call	clear
	
	mov	ebx,0ffffffffh
	sub	ebx,99

	
	@@y_loop:

	mov	eax,ebx
	imul	czoom
	shrd	eax,edx,7
	mov	yc,eax;y*cos*zoom
	
	mov	eax,ebx
	imul	szoom
	shrd	eax,edx,7
	mov	ys,eax;y*sin*zoom
	
	
	mov	ecx,0ffffffffh
	sub	ecx,159

	
	@@x_loop:
	
	mov	eax,ecx
	imul	czoom	 
	shrd	eax,edx,7
	mov	xc,eax;x*cos*zoom
	
	mov	eax,ecx
	imul	szoom
	shrd	eax,edx,7
	mov	xs,eax;x*sin*zoom
	
	mov	eax,xc
	sub	eax,ys
	add	eax,160
	cmp	eax,319
	jg	@@done
	mov	xt,eax
	
	mov	eax,xs
	add	eax,yc
	add	eax,100
	cmp	eax,199
	jg	@@done
	mov	yt,eax
	
	mov	esi,yt
	add	esi,esi
	movzx   esi,ytab[esi]
	add	esi,xt
	mov	edi,[pcx_ptr]
	add	edi,esi
	mov	al,byte ptr [edi]
	
	mov	esi,ebx
	add	esi,100
	cmp	esi,199
	jg	@@done
	add	esi,esi
	movzx   esi,ytab[esi]
	mov	ebp,ecx
	add	ebp,160
	cmp	ebp,319
	jg	@@done
	add	esi,ebp

	mov	edi,[screen]
	add	edi,esi
	mov	[edi],al

	@@done:
	
	inc	ecx
	cmp	ecx,160
	jl	@@x_loop
	
	inc	ebx
	cmp	ebx,100
	jl	@@y_loop
	
	call	flip
	call	vretrace
	
	mov	ax,100h
	int	16h
	jz	@@rotate_zoom
	
	jmp	@@ok
	
	@@error:
	
	mov	ax,900h
	lea	edx,error_msg
	int	21h

	@@ok:
	
	mov	ax,0003h
	int	10h
	
	mov	ax,4c00h
	int	21h


;======================================;
;= CLEAR proc                         =;
;= what   : proc clear virtual screen =;
;= in     : /                         =;
;= out    : /                         =;
;= destroy: /                         =;
;======================================;
clear proc near
      uses    eax,ecx,edi
      mov     edi,[screen]
      mov     ecx,16000
      xor     eax,eax
      rep     stosd
      ret
      endp

;========================================;
;= FLIP proc                            =;
;= what   : proc move data from virtual =;
;=          screen to visible screen    =;
;= in     : /                           =;
;= out    : /                           =;
;= destroy: /                           =;
;========================================;
flip proc near
     uses    ecx,esi,edi
     mov     edi,video_ptr
     sub     edi,[base_ptr]
     mov     esi,[screen]
     mov     ecx,16000
     rep     movsd
     ret
     endp

;===========================================;
;= VRETRACE proc                           =;
;= what   : proc wait for vertical retrcae =;
;= in     : /                              =;
;= out    : /                              =;
;= destroy: /                              =;
;===========================================;
vretrace proc near
         uses    ax,dx
         mov     dx,3dah 
         @@vr:         
         in      al,dx    
         and 	 al,8    
         jnz 	 @@vr      
         @@vnr:        
         in 	 al,dx    
         and 	 al,8
         jz      @@vnr      
	 ret
	 endp




end zr

