.386
locals
.model flat,c
.stack 100h
.code

pcx_name  db 'face1.pcx',0
error_msg db 'error while allocating memory or reading pcx file$'
greetz	  db 'DOUBLE ZOOMROTATOR WITH FADING',13,10
	  db 'Code: MALi/FiNESSE - 1996$',13,10
palette   db 768 dup (?)
palette1  db 768 dup (?)
f_handle  dw ?
base_ptr  dd ?
pcx_ptr   dd ?
pcx_ptr1  dd ?
screen    dd ?
pcx_color db ?
pcx_len	  db ?
xt	  dd ?;texture x
yt	  dd ?;texture y 
ys	  dd ?;szoom*y
yc	  dd ?;czoom*y
xs	  dd ?;szoom*x
xc	  dd ?;czoom*x
czoom	  dd ?;cos*zoom
szoom	  dd ?;sin*zoom
angle	  dd ?
scale     dd ?
dang	  dd ?
dsca	  dd ?
dfade	  dd ?
fade	  dd ?
video_ptr equ 0a0000h
pcx_size  equ 8481

include zoomrot.inc

ytab label word
i=0
rept 200
  dw i*320
  i=i+1
endm


zr1:
	
;==========================================;
;= LOAD_PCX macro                         =;
;= what   : load .pcx file to memory      =;
;= in     : filename,size,segment,palette =;
;= out    : /                             =;
;= destroy: /                             =;
;==========================================;
load_pcx macro pcx_name,pcx_size,pcx_seg,pal
         uses	 eax,ebx,ecx,edx,esi,edi
         mov     ax,3d00h		;open file
	 lea	 edx,pcx_name
	 int	 21h
	 jc	 @@error
	 mov	 [f_handle],ax		;save file handle

	 mov	 ax,3f00h		;read from file
	 mov	 bx,[f_handle]
	 mov	 ecx,pcx_size
	 mov	 edx,[screen]		;to pcx_ptr
	 int	 21h

	 mov	 ax,3e00h		;close file
	 mov	 bx,[f_handle]
	 int	 21h
        
         mov	 esi,[screen]		;get palette
	 add	 esi,pcx_size-768
	 xor	 ebx,ebx
	
	 @@pcx_read_palette:
	 mov	 al,byte ptr [esi]
	 shr	 al,2
	 mov	 [pal+ebx],al
	 inc	 esi
	 inc 	 ebx
	 cmp	 ebx,768
	 jb	 @@pcx_read_palette

	 mov	 edx,[pcx_seg]
	
         xor  	 edi,edi
	 mov	 esi,[screen]
	 inc	 esi
	 mov	 al,byte ptr [esi]
	 cmp	 al,5			;check if file is valid pcx file
	 jne	 @@error

	 add	 esi,126			;ignore pcx header
	
	 @@pcx_decode:

	 mov 	 al,byte ptr [esi]
	 inc 	 esi
	 mov	 ah,al
	 and	 ah,0c0h			;check if packet is compressed
	 cmp	 ah,0c0h
	 jne	 @@pcx_packer_not_compressed
	 and	 al,03fh
	 mov	 pcx_len,al
	 mov	 al,byte ptr [esi]
	 inc	 esi
	 mov	 pcx_color,al
	 jmp	 @@pcx_init_packet
	
	
	 @@pcx_packer_not_compressed:
	 mov	 pcx_len,1		
	 mov	 pcx_color,al

	 @@pcx_init_packet:
	 movzx	 ecx,pcx_len
	 mov	 cl,pcx_len
	 mov	 al,pcx_color
	
	 @@pcx_draw_packet:
	 mov	 [edx],al
	 inc	 edx
	 inc 	 edi
	 dec	 ecx
	 jnz	 @@pcx_draw_packet
	
	 cmp	 edi,63999
	 jb	 @@pcx_decode
	 endm


        mov     ax,0ee02h
        int     31h
        mov     [base_ptr],ebx
        
        mov	ax,0013h
	int	10h
        
        mov 	dx,3c2h      ;get into a square aspect ratio
        mov 	ax,0e3h
	out 	dx,ax
        
        mov	edx,320*200             ;allocate a 64K memory
        mov     ax,0ee42h
        int	31h
	jc	@@error
	mov	[screen],edx	        ;save pointer
	
        mov	edx,320*200             ;allocate a 64K memory
        mov     ax,0ee42h
        int	31h
	jc	@@error
	mov	[pcx_ptr],edx	        ;save pointer

        mov	edx,320*200             ;allocate a 64K memory
        mov     ax,0ee42h
        int	31h
	jc	@@error
	mov	[pcx_ptr1],edx	        ;save pointer
	
	load_pcx pcx_name pcx_size pcx_ptr palette
	
	mov	ecx,320*200		;make picture
	mov	esi,[pcx_ptr]
	mov	edi,[pcx_ptr1]
	@@make_pic:
	mov	al,[esi+ecx]
	add	al,32
	mov	[edi+ecx],al
	dec	ecx
	jnz	@@make_pic
	
	xor     ecx,ecx			;make palette
	@@make_pal:
	mov	al,[palette+ecx]
	mov	[palette+ecx+32*3+1],al
	inc	ecx
	cmp	ecx,32*3
	jb 	@@make_pal

	mov	ecx,768			;copy palette to palette1
	@@copy_pal:
	mov	al,[palette+ecx]
	mov	[palette1+ecx],al
	dec	ecx
	jnz	@@copy_pal

	
	mov	ecx,32*3
	xor	al,al
	@@del_pal:
	mov	[palette+ecx+32*3],al
	dec	ecx
	jnz	@@del_pal

	call	set_pal
	
	xor	eax,eax
	mov	angle,eax
	mov	scale,eax
	mov	fade,eax
	mov	eax,1
	mov	dang,eax
	mov	dsca,eax
	mov	dfade,eax
	
	@@rotate_zoom:

	mov	eax,dang
	cmp	eax,0
	je	@@dec_angle
	mov  	eax,angle
	add	eax,8
	cmp	eax,510
	jl	@@angle_ok
	xor	eax,eax
	mov	dang,eax
	mov	eax,510
	jmp 	@@angle_ok
	@@dec_angle:
	mov	eax,angle
	sub	eax,8
	cmp 	eax,0
	jg	@@angle_ok
	mov	eax,1
	mov 	dang,eax
	xor	eax,eax
	@@angle_ok:
	mov	angle,eax

	mov	eax,dsca
	cmp	eax,0
	je	@@dec_scale
	mov  	eax,scale
	add	eax,4
	cmp	eax,128
	jl	@@scale_ok
	xor	eax,eax
	mov	dsca,eax
	mov	eax,128
	jmp 	@@scale_ok
	@@dec_scale:
	mov	eax,scale
	sub	eax,4
	cmp 	eax,0
	jge	@@scale_ok
	mov	eax,1
	mov 	dsca,eax
	xor	eax,eax
	@@scale_ok:
	mov	scale,eax

	mov  	edi,scale
	movsx	ebx,zoom[edi]
	
	mov  	edi,angle
	
	movsx	eax,cos[edi]
	imul	ebx;COS*ZOOM
	shrd	eax,edx,7
	mov	czoom,eax
	
	movsx	eax,sin[edi]
	imul	ebx;SIN*ZOOM
	shrd	eax,edx,7
	mov	szoom,eax
	
	call	clear
	
	mov	ebx,0ffffffffh
	sub	ebx,99

	
	@@y_loop:

	mov	eax,ebx
	imul	czoom
	shrd	eax,edx,7
	mov	yc,eax;y*cos*zoom
	
	mov	eax,ebx
	imul	szoom
	shrd	eax,edx,7
	mov	ys,eax;y*sin*zoom
	
	
	mov	ecx,0ffffffffh
	sub	ecx,159

	
	@@x_loop:
	
	mov	eax,ecx
	imul	czoom	 
	shrd	eax,edx,7
	mov	xc,eax;x*cos*zoom
	
	mov	eax,ecx
	imul	szoom
	shrd	eax,edx,7
	mov	xs,eax;x*sin*zoom
	
	mov	eax,xc
	sub	eax,ys
	add	eax,160
	cmp	eax,319
	jg	@@done
	mov	xt,eax
	
	mov	eax,xs
	add	eax,yc
	add	eax,100
	cmp	eax,199
	jg	@@done
	mov	yt,eax
	
	mov	esi,yt
	add	esi,esi
	movzx   esi,ytab[esi]
	add	esi,xt
	mov	edi,[pcx_ptr]
	add	edi,esi
	mov	al,byte ptr [edi]
	cmp	al,0
	je	@@done
	
	mov	esi,ebx
	add	esi,100
	cmp	esi,199
	jg	@@done
	add	esi,esi
	movzx   esi,ytab[esi]
	mov	ebp,ecx
	add	ebp,160
	cmp	ebp,319
	jg	@@done
	add	esi,ebp

	mov	edi,[screen]
	add	edi,esi
	mov	[edi],al

	@@done:
	
	inc	ecx
	cmp	ecx,160
	jl	@@x_loop
	
	inc	ebx
	cmp	ebx,100
	jl	@@y_loop
	
	mov	edi,128
	sub  	edi,scale
	movsx	ebx,zoom[edi]
	
	mov	edi,510
	sub  	edi,angle
	
	movsx	eax,cos[edi]
	imul	ebx;COS*ZOOM
	shrd	eax,edx,7
	mov	czoom,eax
	
	movsx	eax,sin[edi]
	imul	ebx;SIN*ZOOM
	shrd	eax,edx,7
	mov	szoom,eax

	
	mov	ebx,0ffffffffh
	sub	ebx,99

	
	@@y_loop1:

	mov	eax,ebx
	imul	czoom
	shrd	eax,edx,7
	mov	yc,eax;y*cos*zoom
	
	mov	eax,ebx
	imul	szoom
	shrd	eax,edx,7
	mov	ys,eax;y*sin*zoom
	
	
	mov	ecx,0ffffffffh
	sub	ecx,159

	@@x_loop1:
	
	mov	eax,ecx
	imul	czoom	 
	shrd	eax,edx,7
	mov	xc,eax;x*cos*zoom
	
	mov	eax,ecx
	imul	szoom
	shrd	eax,edx,7
	mov	xs,eax;x*sin*zoom
	
	mov	eax,xc
	sub	eax,ys
	add	eax,160
	cmp	eax,319
	jg	@@done1
	mov	xt,eax
	
	mov	eax,xs
	add	eax,yc
	add	eax,100
	cmp	eax,199
	jg	@@done1
	mov	yt,eax
	
	mov	esi,yt
	add	esi,esi
	movzx   esi,ytab[esi]
	add	esi,xt
	mov	edi,[pcx_ptr1]
	add	edi,esi
	mov	al,byte ptr [edi]
	cmp	al,32
	je	@@done1
	
	mov	esi,ebx
	add	esi,100
	cmp	esi,199
	jg	@@done1
	add	esi,esi
	movzx   esi,ytab[esi]
	mov	ebp,ecx
	add	ebp,160
	cmp	ebp,319
	jg	@@done1
	add	esi,ebp

	mov	edi,[screen]
	add	edi,esi
	mov	[edi],al

	@@done1:
	
	inc	ecx
	cmp	ecx,160
	jl	@@x_loop1
	
	inc	ebx
	cmp	ebx,100
	jl	@@y_loop1

	mov	eax,dfade
	cmp	eax,0
	je	@@fade_dec
	
	mov	ebx,32*3
	@@fade:
	
	mov	al,[palette+ebx]
	cmp 	al,0
	jbe	@@fade_done
	dec	al
	mov	[palette+ebx],al
	@@fade_done:
	
	mov	al,[palette+ebx+32*3]
	mov	ah,[palette1+ebx+32*3]
	cmp	al,ah
	jae	@@fade_done1
	inc	al
	mov	[palette+ebx+32*3],al
	
	@@fade_done1:
	
	dec	ebx
	jnz	@@fade
	
	mov	eax,fade
	inc	eax
	cmp	eax,25
	jb	@@fade_ok
	xor 	ecx,ecx
	mov	dfade,ecx
	@@fade_ok:
	mov	fade,eax
	jmp	@@draw

	@@fade_dec:
	mov	ebx,32*3
	@@fade1:
	mov	al,[palette+ebx]
	mov	ah,[palette1+ebx]
	cmp	al,ah
	jae	@@fade1_done
	inc	al
	mov	[palette+ebx],al
	@@fade1_done:
	
	mov	al,[palette+ebx+32*3]
	cmp 	al,0
	jbe	@@fade1_done1
	dec	al
	mov	[palette+ebx+32*3],al
	@@fade1_done1:
	
	
	
	
	
	
	dec	ebx
	jnz	@@fade1
	mov	eax,fade
	dec	eax
	cmp	eax,0
	ja	@@fade1_ok
	mov	ecx,1
	mov	dfade,ecx
	@@fade1_ok:
	mov	fade,eax
	
	@@draw:
	
	call	vretrace
	call	set_pal
	call	flip
	
	mov	ax,100h
	int	16h
	jz	@@rotate_zoom
	
	mov	ax,0003h
	int	10h

	jmp	@@ok

	@@error:
	
	mov	ax,900h
	lea	edx,error_msg
	int	21h

	@@ok:
	
	mov	ax,900h
	lea	edx,greetz
	int	21h
	
	mov	ax,4c00h
	int	21h


;======================================;
;= CLEAR proc                         =;
;= what   : proc clear virtual screen =;
;= in     : /                         =;
;= out    : /                         =;
;= destroy: /                         =;
;======================================;
clear proc near
      uses    eax,ecx,edi
      mov     edi,[screen]
      mov     ecx,16000
      xor     eax,eax
      rep     stosd
      ret
      endp

;========================================;
;= FLIP proc                            =;
;= what   : proc move data from virtual =;
;=          screen to visible screen    =;
;= in     : /                           =;
;= out    : /                           =;
;= destroy: /                           =;
;========================================;
flip proc near
     uses    ecx,esi,edi
     mov     edi,video_ptr
     sub     edi,[base_ptr]
     mov     esi,[screen]
     mov     ecx,16000
     rep     movsd
     ret
     endp

;===========================================;
;= VRETRACE proc                           =;
;= what   : proc wait for vertical retrcae =;
;= in     : /                              =;
;= out    : /                              =;
;= destroy: /                              =;
;===========================================;
vretrace proc near
         uses    ax,dx
         mov     dx,3dah 
         @@vr:         
         in      al,dx    
         and 	 al,8    
         jnz 	 @@vr      
         @@vnr:        
         in 	 al,dx    
         and 	 al,8
         jz      @@vnr      
	 ret
	 endp

;===========================================;
;= SET_PAL proc                            =;
;= what   : proc set palette               =;
;= in     : palette1                       =;
;= out    : /                              =;
;= destroy: /                              =;
;===========================================;
set_pal proc near
	uses	ax,ebx,dx
        mov	dx,3c8h      		
	xor 	al,al
	out 	dx,al
	inc 	dx
	xor 	ebx,ebx
	@@set_palette:
	mov	al,[palette+ebx]
	out	dx,al
	inc	ebx
	cmp	ebx,768
	jb	@@set_palette
	ret
	endp



end zr1

