// IPX EXAMPLE FOR WATCOM C/C++ (10.0a) UNDER DOS4GW PMODE DPMI.
// Written by Daniel Jeppson d94dj@efd.lth.se 960511 03:28 AM (8

// You are hearby granted the right to use this code freely but
// I would appreciate a credit or greet if you find it useful...

// Also, this code would not have been possible without the cool
// guys at ID-software and the IPX code (DOOM) that they released.

// I would also like to thank Daniel John Lee Parnell,
// s921878@minyos.xx.rmit.EDU.AU, for his IPX.DOC file.

// (Both these files can be found at x2ftp.oulu.fi)

// If any of you experts out there find something terribly wrong
// with this code, do not flame me but send me a notification and
// I'll remove the bug.. (8

#include "int.h"    // My asm header file..
#include <stdio.h>
#include <i86.h>
#include <conio.h>
#include <graph.h>

#include "ipx.c"    // More ipx code..

#define RECIEVERS 2     // Number of recievers
#define SOCKET 0x869c   // Socket (0x869C is the official DOOM socket I think)

void printdata(char far *ippe,dword size)
{ // Prints data, character by character.. Max size chars...
  // I expect there to be a better way to do this but printf
  // refused to print the text..
  int q;
  char buf[10];

  _settextcolor(14);
  q=0;
  while (ippe[q]!=0 && q<size)
  {
    sprintf(buf,"%c",ippe[q]);
    _outtext(buf);
    if (ippe[q]=='>') _settextcolor(7);
    q++;
  }
}

void main(int argc, char *argv[])
{
  word recievel[RECIEVERS];    // selectors for the lowmem allocated for recievers
  word recieveseg[RECIEVERS];  // segments for the lowmem allocated for recievers
  word sendl,sendseg;          // selector and segment for the lowmem allocated for sender
  char key=1;                 // Keypressed save...
  int q;                      // Counter.. Used here and there... (8
  char buf[100];
  int size=0;
  char buffer[256];
  char *namestring;
  char *arg;
  
  struct rccoord old_pos;
  byte row=1;
  
  
  _setvideomode(_TEXTC80);

  if (argc>1)
  {
    arg=(char *)calloc(strlen(argv[1])+1,1);
    strcpy(arg,argv[1]);
    if (arg[0]=='-' || arg[0]=='/')
    {
      printf("IPX - Chat          by Daniel Jeppsson 1996-05-11\n\n");
      printf("                    Contact me at:\n");
      printf("                      d94dj@efd.lth.se\n");
      printf("                      cid94pdj@lustudat.student.lu.se\n");
      printf("                      dj@p6.lurivax.ct.se\n");
      printf("                      Fidonet: 2:200/134.6\n");      
      printf("Parameters:\n");
      printf("  -anything         This little help\n");
      printf("  /anything         Again, this little help... (8\n");
      printf("  NAME              Sets your chatname to NAME!\n");
      printf("                    No parameters give you the name ANONYMOUS!");
      printf("\n\n");
      exit(0);
    }
    namestring=(char *)calloc(strlen(argv[1])+3,1);
    strcpy(namestring,argv[1]);
    strcat(namestring,"> ");
  }
    else
  {
    namestring="ANONYMOUS> ";
  }
  
  if (!opensocket(0,SOCKET))  // Opensocket?
  { // Yepp..
    sprintf(buf,"INFO - main : SocketID = %x\n",(dword)socketid);
    _outtext(buf);
 
    initipx(); // initialize the ipx routines.

    for (q=0;q<6;q++) nodes[0].node[q]=localadd->node[q]; // HOME
    for (q=0;q<6;q++) nodes[MAXNODES].node[q]=0xff; // BROADCAST

    // setup senders and recievers..
    send=(struct packet far *)MK_FP(getlowmem(sizeof(struct packet)/16+1),0);
    sendl=lsel;
    sendseg=lseg;
    initsendpacket(send);
    
    for (q=0;q<RECIEVERS;q++)
    {
      recieve[q]=(struct packet far *)MK_FP(getlowmem(sizeof(struct packet)/16+1),0);
      recievel[q]=lsel;
      recieveseg[q]=lseg;
      initrecievepacket(recieve[q]);
    }

    // if the program lives still, we're online (hopefully).. (8
    _outtext("INFO - main : IPX initiated...\n");

    _clearscreen(0);
    _settextposition(25,2);
    _setbkcolor(_BLUE);
    for (q=0;q<78;q++) _outtext(" ");
    _setbkcolor(_BLACK);
    _settextposition(25,2);

    // !MAINLOOP!
    while (key!=27)
    {
      if (kbhit()) key=getch();  // If user pressed a key, read it and put it in var. key.

      for (q=0;q<RECIEVERS;q++)  // Scan recievers and check for package...
        if (recieve[q]->ecb.inuse==0) // Is this reciever waiting for delivery?
        {
          old_pos=_gettextposition();
          _settextposition(row,1);
          printdata(recieve[q]->data,255); // Prints the incoming package..


           row=_gettextposition().row+1;
           if (row>24)
           {
             row--;
            _settextwindow(1,1,24,80);
            _scrolltextwindow(1);
            _settextwindow(1,1,25,80);
           }

          _settextposition(old_pos.row,old_pos.col);

          listenforpacket(recieveseg[q]); // Set the reciever up again to recieve...
        }
      if (key>31 && size<77)
      {
        buffer[size++]=key;
        _setbkcolor(_BLUE);
        sprintf(buf,"%c",key);
        _outtext(buf);
        _setbkcolor(_BLACK);   
        key=1;
      }
      if (key==8 && size>0)
      {
        size--;
        _setbkcolor(_BLUE);   
        _settextposition(_gettextposition().row,_gettextposition().col-1);
        _outtext(" ");
        _setbkcolor(_BLACK);      
        _settextposition(_gettextposition().row,_gettextposition().col-1);
        key=0;
      }
      if (key==13 && size>0) // User pressed return and current line should be sent..
      {
        buffer[size]=0;
        _fstrcpy(send->data,(char far *)namestring);
        _fstrcat(send->data,(char far *)buffer);

        while (send->ecb.inuse!=0); // wait until the sender is free for sending...

        // send this package!
        sendpacket(sendseg,MAXNODES,send);

        _setbkcolor(_BLUE);
        _settextposition(_gettextposition().row,2);
        for (q=0;q<size;q++) _outtext(" ");        
        _settextposition(_gettextposition().row,2);
        _setbkcolor(_BLACK);
   
        key=1;

        size=0;
      }
    } // HERE ENDETH THE !MAINLOOP! (8

    _clearscreen(0);

    // Closing down IPX...
    _outtext("INFO - main : Closing down IPX...\n");
    closesocket(socketid);

    // I should free the memory now but the system crashed a couple of times
    // if I did so I let it be... (8
  }
    else
  { // No socket found...
    sprintf(buf,"ERROR - main : Could not open socket %x\n",(dword)SOCKET);
    _outtext(buf);
    exit(0);
  }

}
