// IPX EXAMPLE FOR WATCOM C/C++ (10.0a) UNDER DOS4GW PMODE DPMI.
// Written by Daniel Jeppson d94dj@efd.lth.se 960511 03:28 AM (8

// You are hearby granted the right to use this code freely but
// I would appreciate a credit or greet if you find it useful...

// Please see the readme.txt and chat.c for more information...

#define word unsigned short // These two lines must be the two most
#define byte unsigned char  // commonly defined ever.. (8 

#define MAXNODES 2      // Maximum number of nodes

#include "ipx.h"              // My ipx header file..
#include <i86.h>
#include <stdio.h>

struct nodeadr nodes[MAXNODES+1];  // Last is broadcast and first is local...

static struct rminfo
{
  long EDI;
  long ESI;
  long EBP;
  long reserved_by_system;
  long EBX;
  long EDX;
  long ECX;
  long EAX;
  short flags;
  short ES,DS,FS,GS,IP,CS,SP,SS;
} RMI;

static struct localaddr
{
  byte network[4];
  byte node[6];
};
struct localaddr far *localadd; // The local address...
word localaddl; // Selector to the localadd lowmem allocated.

union REGS regs;
struct SREGS sregs;

void clearrmi(void)
{ // Clear the RMI registers...
  memset(&sregs,0,sizeof(sregs));
  memset(&RMI,0,sizeof(RMI));
}

void callrealint(byte inten)
{ // This routine calls a realmode interrupt (interrupt inten)
  int interrupt_no=0x31;

  // Use DMPI call 300h to issue the DOS interrupt
  regs.w.ax = 0x0300;
  regs.h.bh = 0;
  regs.h.bl = inten;
  regs.w.cx = 0;
  sregs.es = FP_SEG(&RMI);
  regs.x.edi = FP_OFF(&RMI);
  int386x( interrupt_no, &regs, &regs, &sregs );
}

word swap(word swappen)
{ // swap the low and high order byte of a word...
  return (swappen<<8)+((swappen&65280)>>8);
}

byte opensocket(byte longevity,word socket)
{ // Open up a socket.. Returns 0xff if everything went fine..

  //Set up real-mode call structure
  clearrmi();
  RMI.EBX=0x0;  
  RMI.EAX=longevity;
  RMI.EDX=swap(socket);
  callrealint(0x7a);
  socketid=swap(RMI.EDX);
  
  return (byte)(RMI.EAX);
}

void closesocket(word socket)
{ // Closes an open socket.. Do not forget to call this routine!!
  clearrmi();
  RMI.EBX=0x1;
  RMI.EDX=swap(socket);
  callrealint(0x7a);
}

void initipx(void)
{ // Does what it is called... (8
  
  clearrmi();
  RMI.EAX=0x7A00;
  callrealint(0x2f);
  if ((RMI.EAX&255)!=255)
  {
    printf("ERROR - initipx : Could not find IPX INT 2f - 7A00h\n");
    exit(0);
  }
  getlocaladdress();
}

void getlocaladdress(void)
{
  localadd=(struct localaddr far *)MK_FP(getlowmem(sizeof(struct localaddr)/16+1),0);
  localaddl=lsel;
  clearrmi();
  RMI.EBX=9;
  RMI.ES=lseg;
  RMI.ESI=0;
  callrealint(0x7a);
}

void listenforpacket(word packetseg)
{
  clearrmi();
  RMI.ESI=0;          // Offset to ECB is 0 when you allocate lowmem...
  RMI.ES=packetseg;
  RMI.EBX=4;
  RMI.EAX=0;
  callrealint(0x7a);
  if (RMI.EAX&255) {printf("ERROR - listenforpacket"); exit(0);}
}

void initrecievepacket(struct packet far *packetet)
{
  _fmemset(packetet,0,sizeof(struct packet));

  packetet->ecb.inuse=0x1d;
  packetet->ecb.socket=swap(socketid);
  packetet->ecb.fragcount=1;
  packetet->ecb.fragdata[0]=sizeof(struct ecbtype);
  // fragdata[0] is the offset to the ipx header.
  // Since ipx comes after ecb it's sizeof(ecb) bytes
  // after the allocated memory...

  packetet->ecb.fragdata[1]=lseg;
  // lseg contains the latest allocated lowmem segment.
  
  packetet->ecb.fragsize=sizeof(struct packet)-sizeof(struct ecbtype);
  listenforpacket(lseg);
}                     

void initsendpacket(struct packet far *packetet)
{
  _fmemset(packetet,0,sizeof(struct packet));
  
  packetet->ecb.socket=swap(socketid);
  packetet->ecb.fragcount=1;
  packetet->ecb.fragdata[0]=sizeof(struct ecbtype);
  packetet->ecb.fragdata[1]=lseg;
  packetet->ecb.fragsize=sizeof(struct packet)-sizeof(struct ecbtype);


  packetet->ecb.immedaddr[0]=0xff;
  packetet->ecb.immedaddr[1]=0xff;
  packetet->ecb.immedaddr[2]=0xff;
  packetet->ecb.immedaddr[3]=0xff;
  packetet->ecb.immedaddr[4]=0xff;
  packetet->ecb.immedaddr[5]=0xff;
  packetet->ipx.dest.node[0]=0xff;
  packetet->ipx.dest.node[1]=0xff;
  packetet->ipx.dest.node[2]=0xff;
  packetet->ipx.dest.node[3]=0xff;
  packetet->ipx.dest.node[4]=0xff;
  packetet->ipx.dest.node[5]=0xff;

  packetet->ipx.check=0xffff;
  packetet->ipx.ptype=0x00;
  packetet->ipx.dest.net[0]=localadd->network[0];
  packetet->ipx.dest.net[1]=localadd->network[1];
  packetet->ipx.dest.net[2]=localadd->network[2];
  packetet->ipx.dest.net[3]=localadd->network[3];
  packetet->ipx.dest.socket=swap(socketid);
  packetet->ipx.src.net[0]=localadd->network[0];
  packetet->ipx.src.net[1]=localadd->network[1];
  packetet->ipx.src.net[2]=localadd->network[2];
  packetet->ipx.src.net[3]=localadd->network[3];
  packetet->ipx.src.node[0]=localadd->node[0];
  packetet->ipx.src.node[1]=localadd->node[1];
  packetet->ipx.src.node[2]=localadd->node[2];
  packetet->ipx.src.node[3]=localadd->node[3];
  packetet->ipx.src.node[4]=localadd->node[4];
  packetet->ipx.src.node[5]=localadd->node[5];
  packetet->ipx.src.socket=swap(socketid);
}

void sendpacket(word ecbseg,int dest, struct packet far *packetet)
{ // Sends a packet...
  // ecbseg is the senders segment...
  int q;
  clearrmi();

  for (q=0;q<6;q++)
    packetet->ecb.immedaddr[q]=packetet->ipx.dest.node[q]=nodes[dest].node[q];
      
  RMI.ESI=0;
  RMI.ES=ecbseg;
  RMI.EBX=3;
  callrealint(0x7a);
  if (RMI.EAX&255)
  {
    printf("ERROR - sendpacket : sending packet...");
    exit(0);
  }
}

