{$X+,B-,V-}

UNIT nwBindry;

INTERFACE

USES nwMisc;

{ Primary Functions:                    Interrupt: comments:

* AddBinderyObjectToSet                 (F217/41)
* ChangeBinderyObjectPassword           (F217/40) Unencrypted Passwords.
  ChangeEncrBinderyObjectPassword       (F217/4B) Encrypted Passwords.
* ChangeBinderyObjectSecurity           (F217/38)
- ChangePassword                        (F217/01) #2
* ChangePropertySecurity                (F217/3B)
* CloseBindery                          (F217/44)
* CreateBinderyObject                   (F217/32)
* CreateProperty                        (F217/39)
* DeleteBinderyObject                   (F217/33)
* DeleteBinderyObjectFromSet            (F217/42)
* DeleteProperty                        (F217/3A)
* GetBinderyAccessLevel                 (F217/46)
* GetBinderyObjectID                    (F217/35)
* GetBinderyObjectName                  (F217/36)
- GetMemberSetMofGroupG                 (F217/09) #6
* IsBinderyObjectInSet                  (F217/43)
- MapNumberToGroupName                  (F217/08) #5
- MapNumberToObject                     (F217/04) #4
- MapObjectToNumber                     (F217/03) #3
* OpenBindery                           (F217/45)
* ReadPropertyValue                     (F217/3D)
* RenameBinderyObject                   (F217/34)
* ScanBinderyObject                     (F217/37)
* ScanProperty                          (F217/3C)
* VerifyBinderyObjectPassword           (F217/3F) Unencrypted Passwords.
* VerifyEncrBinderyObjectPassword       (F217/4A) Encrypted passwords
* WritePropertyValue                    (F217/3E)

  Secondary Functions:

* IsShellLoaded
* IsUserLoggedOn
* ExistsUser
* GetRealUserName
* IsGroupMember
* AddUserToGroup
* DeleteUserFromGroup

Notes: -Names of Objects & properties are automaticly converted to uppercase
        by the above functions.
       -Functions marked with a '*' are tested (with 3.11) and found correct.
        (See example programs in XBIND.ZIP, e.g. SCANBIND,TSTBIND,BACKBIN).
       -Functions marked with # are not implemented in this API.
        #2: This call has been replaced by F217/40 ChangeBinderyObjectPassword.
        #3: Replaced by F217/35 GetBinderyObjectID.
        #4,#5: Replaced by F217/36 GetBinderyObjectName.
        #5: replaced by F217/37 ScanBinderyObject and F217/3D ReadPropertyValue.

Related Functions in other units:

  GetConnectionInformation (nwConn)
  GetObjectConnectionNumbers (nwConn)
  LoginToFileServer (nwConn)
  ScanObjectTrusteePaths (nwDir)
}

CONST
 { known object types: }
  OT_WILD                        = -1;
  OT_UNKNOWN                     = 0;
  OT_USER                        = 1;
  OT_USER_GROUP                  = 2;
  OT_PRINT_QUEUE                 = 3;
  OT_FILE_SERVER                 = 4;
  OT_JOB_SERVER                  = 5;
  OT_GATEWAY                     = 6;
  OT_PRINT_SERVER                = 7;
  OT_ARCHIVE_QUEUE               = 8;
  OT_ARCHIVE_SERVER              = 9;
  OT_JOB_QUEUE                   = $0A;
  OT_ADMINISTRATION              = $0B;
  OT_NAS_SNA_GATEWAY             = $21;
  OT_REMOTE_BRIDGE_SERVER        = $24;
  OT_ASYNC_BRIDGE_SERVER         = $26;   { note: # }
  OT_TCPIP_GATEWAY               = $27;
  OT_X25_BRIDGE                  = $28;   { # }
  OT_X25_GATEWAY                 = $29;   { # EICON X25 Gateway }
  OT_TIME_SYNCHRONIZATION_SERVER = $2D;
  OT_ARCHIVE_SERVER_DYNAMIC_SAP  = $2E;
  OT_DI3270_GATEWAY              = $45;   { # }
  OT_ADVERTISING_PRINTSERVER     = $47;
  OT_BTRIEVE_VAP                 = $4B;   { # Btrieve 5.0 Server; used to be $50 }
  OT_BTRIEVE_5_SERVER            = $4B;   { # }
  OT_NETWARE_SQL_SERVER          = $4C;   { # SQL VAP/NLM }
  OT_XTREE_NETWORK               = $4D;   { # }
  OT_BTRIEVE_4_SERVER            = $50;   { # Btrieve v.4.xx Server }
  OT_PRINT_QUEUE_USER            = $53;
  OT_EICON_ROUTER                = $58;   { # }
  OT_ARCSERVE_30                 = $66;   { # }
  OT_WANCOPY_UTILITY             = $72;   { # }
  OT_TES_NETWARE_FOR_VMS         = $7A;   { # }
  OT_EMERALD_BACKUP              = $92;   { # }
  OT_NETWARE_ACCESS_SERVER       = $98;   { # }
  OT_PORTABLE_NETWARE            = $9E;   { # }
  OT_POWERCHUTE                  = $A1;   { # }
  OT_COMPAQ_IDA_STATUS_MONITOR   = $AC;   { # }
  OT_BINDERY                     = $0102; { # }
  OT_ORACLE_DATABASE_SERVER      = $0103; { # }
  OT_RSPCX_SERVER                = $0107; { # Rconsole }
  OT_CSA_MUX                     = $0114; { # }
  OT_CSA_LSA                     = $0115; { # }
  OT_CSA_CM                      = $0116; { # }
  OT_CSA_SMA                     = $0117; { # }
  OT_CSA_DBA                     = $0118; { # }
  OT_CSA_NMA                     = $0119; { # }
  OT_CSA_SSA                     = $011A; { # }
  OT_CSA_STATUS                  = $011B; { # }
  OT_CSA_APPC                    = $011E; { # }
  OT_CSA_TEST                    = $0126; { # }
  OT_CSA_TRACE                   = $012A; { # }
  OT_COMMUNICATIONS_EXEC         = $0130; { # }
  OT_NNS_DOMAIN                  = $0133; { # }
  OT_NNS_PROFILE                 = $0135; { # }
  OT_NW386_PRINT_QUEUE           = $0137; { # }
  OT_LANSPOOL_SERVER             = $0141; { # }
  OT_COMPAQ_SNMP_AGENT           = $0174; { # }
  OT_HP_LASERJET                 = $030C; { # }
  OT_PC3M                        = $037E; { # ?Tape Backup?}
  OT_ARCSERVE_40                 = $03C4; { # }
  OT_NETWARE_SQL                 = $03DE; { # }
  OT_SITE_LOCK_VRS_FILES         = $0429; { # }
  OT_SITE_LOCK_CHECKS            = $0529; { # }
  OT_SITE_LOCK                   = $0B29; { # , see $2380 }
  OT_SITE_LOCK_APPLICATIONS      = $0C29; { # }
  OT_SITE_LOCK_2                 = $2380; { # , see $0B29 }
  OT_SITE_LOCK_SERVER            = $4808; { # }
  OT_SITE_LOCK_USER              = $5555; { # }
  OT_TAPEWARE                    = $6312; { # }
  OT_RABBIT_GATEWAY              = $6F00; { # }
  OT_TAPEWARE_AGENT              = $7F82; { # }
 { object types are reserved upto $8000 }
  OT_LANPORT                     =Word($8002); { * }
  OT_INTEL_NETPORT               =Word($8002); { * }
  OT_QUICK_NETWARE_MANAGEMENT    =Word($8888); { * }
  OT_WORDPEFECT_NETWARE_VERSION  =Word($8888); { * }
  OT_PEGASUS_MAIL                =Word($9009); { * }
  OT_QNT_ACCESS_WS               =Word($B0EF); { * }
{ note #: These object type numbers are probably correct,
          but there are no (Novell) standard names for these object types.
       *: These object type numbers may be in use for other purposes by
          other applications.                                              }

 { bindery security: }
  BS_ANY_READ       = $00;
  BS_LOGGED_READ    = $01;
  BS_OBJECT_READ    = $02;
  BS_SUPER_READ     = $03;
  BS_BINDERY_READ   = $04;

  BS_ANY_WRITE      = $00;
  BS_LOGGED_WRITE   = $10;
  BS_OBJECT_WRITE   = $20;
  BS_SUPER_WRITE    = $30;
  BS_BINDERY_WRITE  = $40;

{property & object objFlag/propFlags Constants:}
  BF_ITEM           = $00;
  BF_SET            = $02;
  BF_DYN_PROP       = $10; {1}
  BF_STAT_PROP      = $00; {1}
  { or BF_ITEM/SET with BF_xx_PROP to obtain propFlags }
  BF_STAT_OBJ       = $00; {1}
  BF_DYN_OBJ        = $01; {1}

{ Note 1: not available in the NW interface for C }


Type propertyType=Array[1..128] of Byte;

Var result:word;

{F217/32 [2.15c+] }
Function CreateBinderyObject(objName:string; objType:Word;
                             objFlaG, objSecurity :Byte   ):boolean;
{ Creates an object in the bindery.
  objName: name of the new object (47 chars)
  objType: object type number (own type number or OT_xxx constant)
  objFlag: identifies an object as static (BF_STAT_OBJ (0))
           or dynamic (BF_DYN_OBJ (1))
           (dynamic objects are removed from the bindery when the server goes down)
  objSecurity: high nibble: write privileges needed to modify this object
               low  nibble: read privileges needed to access this object
               (default: $31 Supervisor write/Logged read) }

{F217/33 [2.15c+] }
Function DeleteBinderyObject( objName:String; objType:Word ):boolean;
{ deletes a bindery object and all asociated properties. }

{F217/34 [2.15c+]}
Function RenameBinderyObject( objName,NewObjName :string; objType :word ):boolean;
{ This function allows the (supervisor-equivalent) user to rename an object,
  given its' type and old name.                                              }

{F217/35 [2.15c+] }
Function GetBinderyObjectID( objName:String; objType:word;
                             Var object_ID:Longint       ):boolean;
{ returns the object ID of an object, given its type and name.       }

{F217/36 [2.15c+] }
Function GetBinderyObjectName( object_Id:LongInt;
                               Var objName:String; Var objType:word ):boolean;
{ returns the type and name of an object, given its four BYTE-id. }

{F217/37 [2.15c+]}
Function ScanBinderyObject( SearchObjName: String;
                            SearchObjType: Word;
              {i/o:}    Var lastObjSeen  : Longint;
              {out:}    Var RepName      : String;
                        Var RepType      : Word;
                        Var RepId        : LongInt;
                        Var RepFlag      : Byte;
                        Var RepSecurity  : Byte;
                        Var RepHasProperties: Boolean
                          ) :boolean;
{ This function scans the bindery and returns complete information about
  a bindery object. It can be called iteratively.
  -When called for the first time, supply -1 for lastObjSeen.
  -Subsequent calls can then made (with lastObjSeen as an I/O parameter)
   until error FCh: 'No Such Object' occurs.

  * as SearchObjName means all object names.
  the SearchObjType is the object Type (OT_xxxxx). ( OT_WILD= -1: any type ) }

{F217/38 [2.15c+]}
Function ChangeBinderyObjectSecurity(objName :String; objType :Word;
                                     NewObjSecurity :Byte           ):boolean;
{ Changes the security of a Bindery object. This call is made successfully,
  if the user is supervisor equivalent and the current security is unequal to
  NetWare Read/ NetWare Write.                                              }

{F217/39 [2.15c+]}
Function CreateProperty( objName:String; objType:Word;
                    propertyName:String; propFlags,propSecurity:Byte ):boolean;
{ Creates a property to be associated with a bindery object.
  Property flags tell whether a property is dynamic or static and whether
  the property is defined as static or dynamic.  (see BF_xxx constants )    }

{F217/3A [2.15c+]}
Function DeleteProperty( objName:String; objType:Word;
                         propertyName:String          ):boolean;
{ Deletes a property from a bindery object.
  The property field may contain wildcards.                                 }

{F217/3B [2.15c+] }
Function ChangePropertySecurity( objName:String; objType:Word;
                                propName:String; newPropSecurity:Byte ):boolean;
{ The user must have read and write access to the property to make this call.
  The call can't assign a greater security level than the security level of
  the caller.                                                               }

{F217/3C [2.15c+]}
Function ScanProperty( objName:String; objType:Word; searchPropName:String;
            {i/o var:} Var SequenceNumber:LongInt;
            { output:} Var propName:String;
                       Var propFlags:Byte;
                       Var propSecurity:Byte;
                       Var propHasValue:Boolean;
                       Var moreProperties:Boolean  ):boolean;
{ Sequence number should be -1 the first time this call is made.
  The call can be reiterated (by supplying the returned Seq.#) until
  moreProperties=FALSE or nwBindry.Result=NO_SUCH_PROPERTY.
  searchPropName may contain wildcards;
  If propHasValue=TRUE, the value can be read by calling ReadPropertyValue;
  moreProperties=TRUE if more properties exist for this object.            }

{F217/3D [2.15c+]}
Function ReadPropertyValue( objName:String; objType:Word;
                            propName:String; segmentNumber:Word;
                            Var propValue   : propertyType;
                            Var moreSegments: Boolean;
                            Var propFlags   : Byte              ):boolean;
{ Returns the value of a property associated with a Bindery object.     }

{F217/3E [2.15c+]}
Function WritePropertyValue( objName:String; objType:Word;
                   propName:String; segmentNbr: Byte; propValue:propertyType;
                   moreSegments:Boolean                   ):boolean;
{ Changes the value of a (NON-SET) property associated with a Bindery object.
  To write values to set-properties, use the AddBinderyObjectToSet call.
  The user needs write access to the property to make this call.

  SegmentNBR should be set to 1 the first time this call is made. If there are
  more segments, this value should be increased by EXACTLY 1.
  If you know how many segments already exist, then you can set segmentNbr to
  any segment in the range 1..'max_segment' and change that segment.

  The moreSegments flag should be set to TRUE if the current segment is NOT
  the last segment to be written to. Setting this Flag to true will delete all
  segments with a higher segmentnumber than the segment currently written to. }

{F217/3F [2.15c+]}
FUNCTION VerifyBinderyObjectPassword
          ( objName:string; objType:Word; password:string):boolean;
{ Verifies the accuracy of a password for a bindery object. }
{ for netware 3.xx remember to have previously (eg in the autoexec.ncf file )
  set allow unencrypted passwords = on
  on the console, otherwise this call always fails !
  Note that intruder lockout status is affected by this call !
  Netware security isn't that stupid....
  Passwords need to be converted to upper case, NULL if there is no password. }

{F217/4A [2.15c+]}
FUNCTION VerifyEncrBinderyObjectPassword
          ( objName:string; objType:Word; password:string):boolean;
{ Verifies the accuracy of a password for a bindery object. }
{ Encrypts passwords. }
{ Passwords need to be converted to upper case, NULL if there is no password. }

{F217/40 [2.0/2.1/3.x] }
Function ChangeBinderyObjectPassword(objName:String; objType:Word;
                                     oldPassWord,newPassWord:String ):boolean;
{ Changes the password of a bindery object.
  Allow unencrypted passwords must be ON!
  Old Password can be NULL. To log into a file server, an object must have a
  PASSWORD property. User must have read and write access to the bindery object. }

{F217/41 [2.15c+]}
Function AddBinderyObjectToSet(objName:String; objType:Word;propName,
                               memberName:String; memberType:Word ):boolean;
{ Adds a bindery object (member) to a property set.
  user must have write access to the set property.                        }

{F217/42 [2.15c+]}
Function DeleteBinderyObjectFromSet(objName:String; objType:Word;propName,
                                    memberName:String; memberType:Word ):boolean;
{ Deletes a (member) bindery object from a property set.
  user must have write access to the set property.                        }

{F217/43 [2.15c+]}
Function IsBinderyObjectInSet(objName:String; objType:Word;propName,
                              memberName:String; memberType:Word ):boolean;
{ Allows the programmer to check whether a bindery object is a member of a
  set-property. memberName( of memberType) is the object to be searched for,
  PropName (attached to the object with name objName (of objType))
  is the property containing the set to be searched.
  User must have read rights to the object and the property.
  Ex: ('EVERYONE',OT_USER_GROUP,'GROUP_MEMBERS','SUPERVISOR',OT_USER)  }

{F217/44 [2.15c+]}
Function CloseBindery:boolean;
{ Closes the bindery files so they can be backed up. (Supervisor only) }

{F217/45 [2.15c+]}
Function OpenBindery:boolean;
{ This call must be used after the CloseBindery call. No other bindery
  call will work while the bindery is closed.                          }

{F217/46 [2.15c+] }
Function getBinderyAccessLevel( {out:} Var SecurityAccesslevel:byte;
                                       Var ObjId:Longint          ): Boolean;
{ It returns the user's access level to the bindery.                      }
{ Often used as a quick way of determining the current users' object id   }
{ use the BS_xxxx constants to determine the exact rights of the user     }

{F217/17 [3.x]}
FUNCTION GetEncryptionKey(VAR key : TencryptionKey): Boolean;
{ called by LoginToFileserver (nwConn), and VerifyBinderyObjectPassword,
  ChangeBonderyObjectPassword (nwBindry) to get an encryption key for
  the encryption function. }


{************************** secondary functions: ****************************}

Function IsShellLoaded:boolean;
Function IsUserLoggedOn:boolean;
Function ExistsUser(userObjName:string):boolean;
Function GetRealUserName(userObjname:string; Var realname:string):boolean;
Function IsGroupMember(GroupName,UserObjName:String): Boolean;
Function AddUserToGroup(userName,GroupName:String):boolean;
Function DeleteUserFromGroup(userName,GroupName:String):boolean;

IMPLEMENTATION{=============================================================}

USES Dos;

Var UnitReqBuffer:array[1..576] of byte;
    UnitReplyBuffer:array[1..576] of byte;
    UnitRegs:registers;

Procedure F2SystemCall(subf:byte;req_size,rep_size:word);
begin
With UnitRegs
 do begin
    DS := Seg(UnitReqBuffer);  SI := Ofs(UnitReqBuffer);   CX := Req_size;
    ES := Seg(UnitReplyBuffer);DI := Ofs(UnitReplyBuffer); DX := rep_size;
    AH := $F2; AL := subf;
    MSDOS(UnitRegs);
    Result:=al;
    end;
end;


{F217/17 [3.x]}
FUNCTION GetEncryptionKey(VAR key : TencryptionKey): Boolean;
Var req : RECORD
          len : WORD;
          func: BYTE;
          END         ABSOLUTE UnitReqBuffer;
BEGIN
With req
 do begin
    len := 1;
    func := $17;
    end;
F2Systemcall($17,sizeof(req),sizeof(key));
Move(UnitReplyBuffer,key,8);
GetEncryptionKey:=(Result=0);
END;


{F217/3F [2.15c+]}
FUNCTION VerifyBinderyObjectPassword
          ( objName:string;objType:Word; password : string):boolean;
{ Verifies the accuracy of a password for a bindery object. }
{ Passwords need to be converted to upper case, NULL if there is no password. }
var  Request_buffer : record
                      buffer_length : Word;
                      subfunction   : byte;
                      obj_type      : word; { hi-lo }
                      _ObjectName   : string[48];
                      _PassWord     : string[127];
                      end                       ABSOLUTE UnitReqBuffer;
begin
With request_buffer
do begin
   buffer_length := SizeOf(request_buffer)-2;
   subfunction :=$3F;
   obj_type:=swap(objType); { force hi-lo }
   UpString(objName);
   UpString(password);
   PStrCopy(_ObjectName,objName,48); _ObjectName[48]:=#0; UpString(_ObjectName);
   PStrCopy(_PassWord,password,127); Upstring(_PassWord);
  end;
F2SystemCall($17,sizeof(request_buffer),0);
VerifyBinderyObjectPassword:=(result=0);
{ possible resultcodes:
$00    0      verification of object_name/password combination
$96  150      Sever out of memory
$C5  197      account disabled due to intrusion lockout
$D6  214      unencrypted password calls not allowed on this v3+ server
$F0  240      Wildcard not allowed
$FB  251      no such property
$FC  252      no such object_name on this server
$FE  254      Server Bindery Locked
$FF  255      Bindery failure (No such object or bad password)        }
end;


{F217/4A [3.x]}
FUNCTION VerifyEncrBinderyObjectPassword(ObjName: String; ObjType: Word; PassWord: String): Boolean;

   FUNCTION VerifyEncrypted(ObjName : String; ObjType : Word; VAR key : TencryptionKey): Boolean;
   VAR req : RECORD
             BufLen  : Word;
             _func   : Byte;
             _key    : TencryptionKey;
             _ObjType: Word;
             _ObjName: String[48];
             End                   ABSOLUTE UnitReqBuffer;
   Begin
   With req
    do Begin
       _func := $4A;
       _key  := key;
       _ObjType := Swap(objType);
       PstrCopy(_ObjName,ObjName,48); UpString(_ObjName);
       if ObjName[0]<#48
        then _objName[0]:=objName[0]
        else _objname[0]:=#48;
       BufLen:=ord(_ObjName[0])+12;
       End;
   F2systemCall($17,sizeof(req),0);
   VerifyEncrypted:=(result=0);
   End;

VAR
  key : TencryptionKey;
  ObjId:LongInt;
  _pw:string;
  _lpw:Byte;

Begin
UpString(password);
_pw:=password;if _pw[0]>#127 Then _pw[0]:=#127;
_lpw:=length(password);
if _lpw=0 Then _pw:=#0;

IF GetEncryptionKey(key)
 Then Begin
      IF GetBinderyObjectId(objName,objType,ObjId)
       Then Begin
            EncryptPassword(objId,_pw,key);
            VerifyEncrypted(ObjName, ObjType, key);
            End;
      End
 Else VerifyBinderyObjectPassword(ObjName, ObjType, Password);

VerifyEncrBinderyObjectPassword := (result=0);
End;



{F217/37 [2.15c+]}
Function ScanBinderyObject( SearchObjName: String;
                            SearchObjType: Word;
              {i/o:}    Var lastObjSeen  : Longint;
              {out:}    Var RepName      : String;
                        Var RepType      : Word;
                        Var RepId        : LongInt;
                        Var RepFlag      : Byte;
                        Var RepSecurity  : Byte;
                        Var RepHasProperties: Boolean
                          ) :boolean;
{ This function scans the bindery and returns complete information about
  a bindery object. }
var TempStr:string;
    req : record
          length          : word;
          subfunction     : byte;
          last_obj_id     : longint; {hi-lo}
          search_obj_type : word;    {hi-lo}
          search_obj_name : string[48];
          end                           ABSOLUTE UnitReqBuffer;
    rep : record
          object_id   : longint; {hi-lo}
          object_type : word;    {hi-lo}
          object_name : array [1..48] of byte;
          object_flag : byte;
          security    : byte;
          properties  : byte;
          end                           ABSOLUTE UnitReplyBuffer;
   count : integer;
begin
with req
do begin
   length := SizeOf(req)-2;
   subfunction := $37;
   last_obj_id := Lswap(lastObjseen);  { force hi-lo }
   search_obj_type:= swap(Word(SearchObjType)); { force hi-lo }
   PstrCopy(Search_obj_name,SearchObjName,48); Search_obj_Name[48]:=#0; UpString(Search_obj_name);
   end;
F2Systemcall($17,sizeOf(req),sizeOf(rep));
With rep
do begin
   repFlag := object_flag;
   repHasProperties := (properties>0);
   repSecurity := security;
   repType := swap(object_type); { force lo-hi }
   repId := Lswap(object_id);    { force lo-hi }
   lastObjSeen := repId;
   ZStrCopy(repName,Object_Name,48);
   end;
scanBinderyObject:=(result=0);
{ Possible Resultcodes:
  96h server out of memory; EFh Invalid Name; FCh No Such Object;
  FEh Server Bindery Locked; FFh Bindery failure                  }
end;


{F217/3D [2.15c+]}
Function ReadPropertyValue( objName:String; objType:Word;
                            propName:String; segmentNumber:Word;
                            Var propValue   : propertyType;
                            Var moreSegments: Boolean;
                            Var propFlags   : Byte              ):boolean;
{ Returns the value of a property associated with a Bindery object.     }
var req : record
          len         : word;
          subfunction : byte;
          _objType    : word;  { hi-lo }
          _ObjName    : string[48];
          _segNbr     : byte;
          _propName   : string[15];
          end                       ABSOLUTE UnitReqBuffer;
   reply : record
           _propValue : propertyType; {array [1..128] of byte}
           _moreSegments : byte;
           _propFlags : byte;
           end                      ABSOLUTE UnitReplyBuffer;
BEGIN
 With req
 do begin
    len:=SizeOf(req)-2;
    subfunction  := $3d;
    _objType:=swap(objType); { force hi-lo }
    _segNbr:=segmentNumber;
    PStrCopy(_ObjName,objName,48); _ObjName[48]:=#0; UpString(_ObjName);
    PStrCopy(_PropName,propName,15); UpString(_propName);
    end;
 With reply
 do begin
    _moreSegments := 1;
    _propFlags := 0;
    end;
F2Systemcall($17,sizeof(req),sizeof(reply));
if result=0
 then begin
      propValue:=reply._propValue;
      moreSegments:=reply._moreSegments>0;
      propFlags:=reply._propFlags;
      end;
ReadPropertyValue:=(result=0);
{ 96 server out of memory; EC no such segment; F0 wilcard not allowed;
  f1 invalid bindery security; f9 no property read privileges;
  fb no such property; fc no such object; FE Server Bindery Locked;
  FF Bindery Failure.                                                 }
end;


{F217/36 [2.15c+] }
Function GetBinderyObjectName( object_Id:LongInt;
                               Var objName:String; Var objType:word ):boolean;
{ returns the type and name of an object, given its four BYTE-id. }
Var Req :record
         len:word;
         subF:byte;
         _objId:LongInt;  { hi-lo }
         end                            ABSOLUTE UnitReqBuffer;
   reply:record
         _objId:LongInt;  { hi-lo }
         _objType:word;   { hi-lo }
         _objName:array[1..48] of Byte;
         end                            ABSOLUTE UnitReplyBuffer;
BEGIN
WITH req
do begin
   len :=SizeOf(Req)-2;
   SubF:=$36;
   _objId:=Lswap(object_Id); { force hi-lo }
   end;
F2SystemCall($17,sizeOf(req),sizeOf(reply));
IF result=0
 then begin
      ZstrCopy(objName,reply._objName,48);
      objType:=swap(reply._objType); { force lo-hi }
      end;
GetBinderyObjectName:=(result=0);
end;


{F217/35 [2.15c+] }
Function GetBinderyObjectID( objName:String; objType:word;
                             Var object_ID:Longint       ):boolean;
{ returns the object ID of an object, given its type and name.       }
Var req:record
         len:word;
         subF:Byte;
         _objType:word;   { hi-lo }
         _objName:string[48];
         end                       ABSOLUTE UnitReqBuffer;
    Reply:record
         _objId:LongInt;  { hi-lo }
         _objType:word;   { hi-lo }
         _objName:array[1..48] of char;
         end                       ABSOLUTE UnitReplyBuffer;
BEGIN
WITH req
do begin
   len :=SizeOf(Req)-2;
   SubF:=$35;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#0;
   UpString(_objName);
   end;
F2SystemCall($17,sizeOf(req),sizeOf(reply));
IF result=0 then object_ID:=Lswap(reply._objId); { force lo-hi }
GetBinderyObjectID:=(result=0);
end;


{F217/46 [2.15c+]}
Function getBinderyAccessLevel(Var SecurityAccessLevel:byte;
                               Var objId:Longint ):boolean;
{ It returns the user's access level to the bindery.                      }
{ Often used as a quick way of determining the current users' object id   }
{ use the BS_xxxx constants to determine the exact rights of the user     }
Var req:record
        len      :word;
        subF     :byte;
        end                         ABSOLUTE UnitReqBuffer;
    reply:record
          accLeveL:byte;
          _objId:longInt;
          fill:array[1..20] of byte;
          end                       ABSOLUTE UnitReplyBuffer;
BEGIN
With req
 do begin
    subF:=$46;
    len:=sizeOf(req)-2;
    end;
F2SystemCall($17,sizeOf(req),sizeOf(reply));
If result=0
 then with reply
       do begin
          SecurityAccessLevel:=accLevel;
          objId:=Lswap(_objId);
          end;
GetBinderyAccessLevel:=(result=0);
end;



{F217/45 [2.15c+]}
Function OpenBindery:boolean;
{ This call must be used after the CloseBindery call. No other bindery
  call will work while the bindery is closed.                          }
Var req  :record
          len:word;
          subFunc:byte;
          end            ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=1;
   subFunc:=$45;
   end;
F2SystemCall($17,sizeOf(req),0);
OpenBindery:=(result=0)
end;


{F217/44 [2.15c+]}
Function CloseBindery:boolean;
{ Closes the bindery files so they can be backed up. (Supervisor only) }
Var req  :record
          len:word;
          subFunc:byte;
          end           ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$44;
   end;
F2SystemCall($17,sizeOf(req),0);
CloseBindery:=(result=0)
end;


{F217/32 [2.15c+] }
Function CreateBinderyObject(objName:string; objType:Word;
                             objFlaG, objSecurity :Byte   ):boolean;
{ Creates an object in the bindery.
  objName: name of the new object (47 chars)
  objType: object type number (own type number or OT_xxx constant)
  objFlag: identifies an object as static (0) or dynamic (1)
           (dynamic objects are removed from the bindery when the server goes down)
  objSecurity: high nibble: write privileges needed to modify this object
               low  nibble: read privileges needed to access this object
               (default: $31 Supervisor write/Logged read) }
Var req  :record
          len          :word;
          subFunc      :byte;
          _objFlag     :Byte;
          _objSecurity :Byte;
          _objType     :word; { hi-lo }
          _objName     :string[48]
          end                        ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$32;
   _objFlag:=objFlag;
   _objSecurity:=objSecurity;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
  end;
F2SystemCall($17,sizeof(req),0);
CreateBinderyObject:=(result=0)
{ 96h server out of memory; EEh Object Already Exists; EFh Invalid Name
  F1h invalid Bindery security; F5h no object create privileges
  FEh Server Bindery Locked; FFh Bindery Failure                        }
end;



{F217/33 [2.15c+] }
Function DeleteBinderyObject( objName:String; objType:Word ):boolean;
{ deletes a bindery object and all asociated properties. }
Var req  :record
          len      :word;
          subFunc  :byte;
          _objType :Word; { hi-lo }
          _objName :string[48];
          end                   ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$33;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#48; UpString(_objName);
   end;
F2SystemCall($17,sizeOf(req),0);
DeleteBinderyObject:=(result=0)
{ 96h Server out of memory; EFh Invalid name; F0h wildcard not allowed;
  F4h No object delete privileges; FCh no such object
  FEh Server Bindery Locked; FFh bindery failure                        }
end;


{F217/34 [2.15c+]}
Function RenameBinderyObject( objName,NewObjName :string; objType :word ):boolean;
{ This function allows the (supervisor-equivalent) user to rename an object,
  given its' type and old name.                                              }
Var req  :record
          len         :word;
          subFunc     :byte;
          _objType    :word; { hi-lo }
          _objName    :string[48];
          _NewObjName :string[48];
          end                       ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$34;
   _objType:=swap(objType); { force hi-lo }
   PstrCopy(_objName,objName,48); _objName[48]:=#0; Upstring(_objName);
   PstrCopy(_NewObjName,NewObjName,48); _NewObjName[48]:=#0; UpString(_NewObjName);
   end;
F2SystemCall($17,sizeOf(req),0);
RenameBinderyObject:=(result=0)
{ 96h Server out of memory; EFh Invalid name; F0h wildcard not allowed;
  F3h No object rename privileges; FCh no such object
  FEh Server Bindery Locked; FFh bindery failure                        }
end;



{F217/43 [2.15c+]}
Function IsBinderyObjectInSet(objName:String; objType:Word;
                 propName, memberName:String; memberType:Word ):boolean;
{ Allows the programmer to check whether a bindery object is a member of a
  set-property. Objectname( of Objecttype) is the object to be searched for,
  PropName (attached to the object with name memberName (of memberType))
  is the property containing the set to be searched.
  User must have read rights to the object and the property.
  Ex: ('SUPERVISOR',OT_USER,'GROUP_MEMBERS','EVERYONE',OT_USER_GROUP)       }
Var req  :record
          len         :word;
          subFunc     :byte;
          _objType    :Word;       { hi-lo   }
          _objName    :String[48]; { [48]=#0 }
          _propName   :String[15];
          _memObjType :Word;       { hi-lo   }
          _memName    :String[48]; { [48]=#0 }
          end                      ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$43;
   _objType:=swap(objType); { force hi-lo }
   PstrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   PstrCopy(_propName,propName,15); UpString(_propName);
   _memObjType:=swap(memberType); { force hi-lo }
   PStrCopy(_memName,memberName,48); _memName[48]:=#0; UpString(_memName);
   end;
F2SystemCall($17,sizeOf(req),0);
IsBinderyObjectInSet:=(result=0)
{ 96h Server out of memory; EA No Such member; EB Not Group Property
  F0h wildcard not allowed; F9 No Property read privileges;
  FCh no such object; FEh Server Bindery Locked; FFh bindery failure        }
end;



{F217/41 [2.15c+]}
Function AddBinderyObjectToSet(objName:String; objType:Word;
                  propName, memberName:String; memberType:Word ):boolean;
{ Adds a bindery object to a property set.
  user must have write access to the set property.                        }
Var req  :record
          len         :word;
          subFunc     :byte;
          _objType    :Word;       { hi-lo   }
          _objName    :String[48]; { [48]=#0 }
          _propName   :String[15];
          _memObjType :Word;       { hi-lo   }
          _memName    :String[48]; { [48]=#0 }
          end                      ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$41;
   _objType:=swap(objType); { force hi-lo }
   PstrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   PstrCopy(_propName,propName,15); UpString(_propName);
   _memObjType:=swap(memberType); { force hi-lo }
   PStrCopy(_memName,memberName,48); _memName[48]:=#0; UpString(_memName);
   end;
F2SystemCall($17,sizeOf(req),0);
AddBinderyObjectToSet:=(result=0)
{ 96h Server out of memory; E9 Member already Exists; EB Not Group Property
  F0h wildcard not allowed; F8 No Property write privileges;
  FCh no such object; FEh Server Bindery Locked; FFh bindery failure        }
end;


{F217/42 [2.0/2.1/3.x]}
Function DeleteBinderyObjectFromSet(objName:String; objType:Word;
                       propName, memberName:String; memberType:Word ):boolean;
{ Deltes a bindery object from a property set.
  user must have write access to the set property.                        }
Var req  :record
          len         :word;
          subFunc     :byte;
          _objType    :Word;       { hi-lo   }
          _objName    :String[48]; { [48]=#0 }
          _propName   :String[15];
          _memObjType :Word;       { hi-lo   }
          _memName    :String[48]; { [48]=#0 }
          end                       ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$42;
   _objType:=swap(objType); { force hi-lo }
   PstrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   PstrCopy(_propName,propName,15); UpString(_propName);
   _memObjType:=swap(memberType); { force hi-lo }
   PStrCopy(_memName,memberName,48); _memName[48]:=#0; UpString(_memName);
   end;
F2SystemCall($17,sizeOf(req),0);
DeleteBinderyObjectFromSet:=(result=0)
{ 96h Server out of memory; EA No Such Member; EB Not Group Property
  F0h wildcard not allowed; F8 No Property write privileges; FB No Such property;
  FCh no such object; FEh Server Bindery Locked; FFh bindery failure        }
end;


{F217/38 [2.15c+]}
Function ChangeBinderyObjectSecurity(objName :String; objType :Word;
                                     NewObjSecurity :Byte           ):boolean;
{ Changes the security of a Bindery object. This call is made successfully,
  if the user is supervisor equivalent and the current security is unequal to
  NetWare Read/ NetWare Write.                                              }
Var req  :record
          len      :word;
          subFunc  :byte;
          _NobjSec :Byte;
          _objType :Word; { hi-lo }
          _objName :String[48]; { [48]=#0 }
          end                     ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$38;
   _NobjSec:=NewObjSecurity;
   _objType:=swap(objType); { force hi-lo }
   PstrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   end;
F2SystemCall($17,sizeOf(req),0);
ChangeBinderyObjectSecurity:=(result=0)
{ Completion Codes:
  96 Server out of memory; F0 Wildcard Not Allowed; F1 Invalid Bindery Security;
  FC No Such Object; FE Server Bindery Locked; FF Bindery Failure.           }
end;




{F217/40 [2.0/2.1/3.x] }
Function ChangeBinderyObjectPassword(objName:String; objType:Word;
                                  oldPassWord,newPassWord:String ):boolean;
{ Changes the password of a bindery object.
  Allow unencrypted passwords must be ON!
  Old Password can be NULL. To log into a file server, an object must have a
  PASSWORD property. User must have read and write access to the bindery object. }
Var req  :record
          len      :word;
          subFunc  :byte;
          _objType :Word;        { hi-lo }
          _objName :String[48];  { [48]=#0 }
          _oldPW   :String[128]; { wow! a password of 128 chars! }
          _newPW   :String[128];
          end                     ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$40;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _ObjName[48]:=#0; UpString(_objName);
   PStrCopy(_oldPW,oldPassWord,128); UpString(_oldPW);
   PStrCopy(_newPW,newPassWord,128); UpString(_newPW);
   end;
F2SystemCall($17,sizeOf(req),0);
ChangeBinderyObjectPassword:=(result=0)
{ Completion Codes:
  96 Server Out Of Memory; F0 Wildcard Not Allowed; FB No Such Property;
  FC No Such Object; FE Server Bindery Locked; FF No Such Object *OR*
  No Password Associated With Object *OR* Old Password Invalid.           }
end;




{F217/39 [2.15c+]}
Function CreateProperty( objName:String; objType:Word;
                    propertyName:String; propFlags,propSecurity:Byte ):boolean;
{ Creates a property to be associated with a bindery object.
  property flags tell whether a property is dynamic or static and whether
  the property is defined as static or dynamic.                            }
Var req  :record
          len       :word;
          subFunc   :byte;
          _objType  :Word;       { hi-lo }
          _objName  :String[48]; { [48]=#0 }
          _propFlags:Byte;
          _propSec  :Byte;
          _propName :String[15];
          end                      ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$39;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   _propFlags:=propFlags;
   _propSec:=propSecurity;
   PStrCopy(_propName,propertyName,15); UpString(_propName);
   end;
F2SystemCall($17,sizeof(req),0);
CreateProperty:=(result=0)
{ Completion Codes:
  96 Server Out Of Memory; ED Property already exists; EF Invalid Name;
  F0 Wildcard Not Allowed; F1 Invalid Bindery Security; F7 No Property Create Privileges;
  FC No Such Object; FE Server Bindery Locked; FF Bindery Failure           }
end;


{F217/3A [2.15c+]}
Function DeleteProperty( objName:String; objType:Word;
                         propertyName:String          ):boolean;
{ Deletes a property from a bindery object.
  The property field may contain wildcards.                                 }
Var req  :record
          len       :word;
          subFunc   :byte;
          _objType  :Word;       { hi-lo }
          _objName  :String[48]; { [48]=#0 }
          _propName :String[15];
          end                    ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$3A;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   PStrCopy(_propName,propertyName,15); UpString(_propName);
   end;
F2SystemCall($17,sizeOf(req),0);
DeleteProperty:=(result=0)
{ Completion Codes:
  96 Server Out Of Memory; F0 Wildcard Not Allowed; F1 Invalid Bindery Security;
  F6 No property delete privileges; FB No Such property;
  FC No Such Object; FE Server Bindery Locked; FF Bindery Failure           }
end;


{F217/3C [2.15c+]}
Function ScanProperty( objName:String; objType:Word; searchPropName:String;
            {i/o var:} Var SequenceNumber:LongInt;
            { output:} Var propName:String;
                       Var propFlags:Byte;
                       Var propSecurity:Byte;
                       Var propHasValue:Boolean;
                       Var moreProperties:Boolean  ):boolean;
{ Sequence number should be -1 the first time this call is made.
  The call can be reiterated (by supplying the returned Seq.#) until
  moreProperties=FALSE or nwBindry.Result=NO_SUCH_PROPERTY.
  searchPropName may contain wildcards;
  If propHasValue=TRUE, the value can be read by calling ReadPropertyValue;
  moreProperties=TRUE if more properties exist for this object.            }
Var req  :record
          len       :word;
          subFunc   :byte;
          _objType  :Word;    {hi-lo}
          _objName  :String[48];
          _SeqNbr   :LongInt; {hi-lo}
          _propName :String[15];
          end                    ABSOLUTE UnitReqBuffer;
    reply:record
          _propName :array[1..16] of Byte;
          _propFlags:Byte;
          _propSec  :Byte;
          _SeqNbr   :Longint; {hi-lo}
          _propHasValue:Byte;
          _moreProp :Byte;
          end                   ABSOLUTE UnitReplyBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$3C;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   _SeqNbr:=Lswap(SequenceNumber); { force hi-lo }
   PstrCopy(_propName,searchPropName,15); UpString(_propName);
   end;
F2SystemCall($17,sizeof(req),sizeof(reply));
With reply
do begin
   SequenceNumber:=Lswap(_SeqNbr); { force lo-hi }
   ZStrCopy(propName,_propName,15);
   propFlags:=_propFlags;
   propSecurity:=_propSec;
   propHasValue:=(_propHasValue>0);
   moreProperties:=(_moreProp>0);
   end;
ScanProperty:=(result=0)
{ Completion Codes:
  96 Server Out Of Memory; F1 Invalid Bindery Security; FB No Such property;
  FC No Such Object; FE Server Bindery Locked; FF Bindery Failure           }
end;


{F217/3E [2.15c+]}
Function WritePropertyValue( objName:String; objType:Word;
                   propName:String; segmentNbr: Byte; propValue:propertyType;
                   moreSegments:Boolean                   ):boolean;
{ Changes the value of a (NON-SET) property associated with a Bindery object.}
Var req  :record
          len         :word;
          subFunc     :byte;
          _objType    :Word; { hi-lo }
          _objName    :String[48];
          _segNbr     :Byte;
          _EraseRemainingSeg:Byte; { FF=true 00=false }
          _propName   :String[15];
          _propValSeg :propertyType;
          end                        ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$3E;
   _objType:=swap(objType); { force hi-lo }
   PStrCopy(_objName,objName,48); _objName[48]:=#0; UpString(_objName);
   _segNbr:=segmentNbr;
   if moreSegments
     then _EraseRemainingSeg:=$00
     else _EraseRemainingSeg:=$FF;
   PstrCopy(_propName,propName,15); UpString(_propName);
   _propValSeg:=propValue;
   end;
F2SystemCall($17,sizeOf(req),0);
WritePropertyValue:=(result=0)
{ Completion Codes:
  96 Server Out Of Memory; E8 Not Item Property; EC no such segment;
  F0 Wildcard Not Allowed; F1 Invalid Bindery Security;
  F8 No property write privileges; FB No Such property;
  FC No Such Object; FE Server Bindery Locked; FF Bindery Failure           }
end;

{F217/3B [2.15c+] }
Function ChangePropertySecurity( objName:String; objType:Word;
                                propName:String; newPropSecurity:Byte ):boolean;
{ The user must have read and write access to the property to make this call.
  The call can't assign a greater security level than the security level of
  the caller.                                                               }
Var req  :record
          len:word;
          subFunc:byte;
          _objType:Word; { hi-lo }
          _objName:String[48];
          _NewPropSec:Byte;
          _PropName:String[15];
          end                   ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$3B;
   _objType:=swap(objType); { force hi-lo }
   PstrCopy(_objName,objName,48); _objName[48]:=#0; Upstring(_objName);
   _NewPropSec:=NewPropSecurity;
   PstrCopy(_propName,propName,15); Upstring(_propName);
   end;
F2SystemCall($17,sizeOf(req),0);
ChangePropertySecurity:=(result=0)
{ Completion Codes:
  96 Server Out Of Memory; F0 Wildcard Not Allowed; F1 Invalid Bindery Security;
  FB No Such property;  FC No Such Object; FE Server Bindery Locked;
  FF Bindery Failure                                                         }
end;



{=======SECONDARY FUNCTIONS===================================================}



Function IsShellLoaded:boolean;
Var mask:byte;
    id:LongInt;
begin
IsShellLoaded:=( nwBindry.getBinderyAccessLevel(mask,id) and (id<>0));
end;


Function IsUserLoggedOn:boolean;
Var mask:byte;
    id:LongInt;
    objName:String;
    objType:word;
begin
IsUserLoggedOn:=( nwBindry.getBinderyAccessLevel(mask,id)
                  and (id<>0)
                  and nwBindry.GetBinderyObjectName(id,objName,objType)
                )
end;


Function GetRealUserName(userObjName:string; Var realname:string):boolean;
Var propValue:propertyType;
    moreSeg:Boolean;
    w,propFlag:Byte;
begin
If ReadPropertyValue(userObjName,OT_USER,'IDENTIFICATION',1,propValue,moreSeg,propFlag)
 then begin
      ZStrCopy(realname,propValue,128);
      w:=1;
      While ((w<=128) and (realname[w]<>#0)) do inc(w);
      realName[0]:=chr(w);
      end
 else realname:='';
end;

Function GetUserObjectID:LongInt;
Var mask:byte;
    id:LongInt;
begin
if getBinderyAccessLevel(mask,id)
 then GetUserObjectID:=id
 else getUserObjectID:=-1;
{ -1 : look at nwBindry.result for error number }
end;


Function ExistsUser(userObjName:string):boolean;
Var nam:string;
    typ:word;
    id:LongInt;
    f,s:byte;
    hasProp:boolean;
    lastObjSeen:LongInt;
begin
lastObjSeen:=-1;
ExistsUser:=scanBinderyObject(userObjName,OT_USER,lastObjSeen,nam,typ,id,f,s,hasProp);
end;

Function IsGroupMember( GroupName,UserObjName:String): Boolean;
begin
IsGroupMember:=IsBinderyObjectInSet(GroupName,OT_USER_GROUP,'GROUP_MEMBERS',
                                    UserObjName,OT_USER);
end;




Function AddUserToGroup(userName,GroupName:String):boolean;
begin
{ first create the necessary properties. They may already exist. }

CreateProperty(userName,OT_USER,'GROUPS_I''M_IN',
               BF_SET,BS_SUPER_WRITE OR BS_LOGGED_READ);
IF (result<>$00) and (result<>$ED) { property already exists }
then begin AddUserToGroup:=false;exit end; { bindery failure / bad username}

CreateProperty(userName,OT_USER,'SECURITY_EQUALS',
               BF_SET,BS_SUPER_WRITE OR BS_LOGGED_READ);
IF (result<>$00) and (result<>$ED) { property already exists }
then begin AddUserToGroup:=false;exit end;

{ The following construction seems a bit overdone, but it is needed to keep
  the bindery consistent. A user is either fully added to a group OR
  nothing happens, this way we ensure that a user is not 'patially added'
  to a group.
  If the user already is a member of the group, no error is returned. }
IF AddBinderyObjectToSet(Groupname,OT_USER_GROUP,'GROUP_MEMBERS',
                         userName,OT_USER)
 then begin
      IF AddBinderyObjectToSet(userName,OT_USER,'GROUPS_I''M_IN',
                               GroupName,OT_USER_GROUP)
       then begin
            IF AddBinderyObjectToSet(userName,OT_USER,'SECURITY_EQUALS',
                                     GroupName,OT_USER_GROUP)
             then begin
                  AddUserToGroup:=true;
                  exit;
                  end
             else begin { attempt to delete partially setup member }
                  DeleteBinderyObjectFromSet(Groupname,OT_USER_GROUP,'GROUP_MEMBERS',
                                             userName,OT_USER);
                  DeleteBinderyObjectFromSet(userName,OT_USER,'GROUPS_I''M_IN',
                                             GroupName,OT_USER_GROUP)
                  end
            end
       else begin
            DeleteBinderyObjectFromSet(Groupname,OT_USER_GROUP,'GROUP_MEMBERS',
                                       userName,OT_USER);
            end;
      end;
if result=$E9 then result:=$00; { $E9: user already a member of group }
AddUserToGroup:=(result=0);
{ As all these called functions are in this unit, you can check nwBindry.result
  for the errorcode. }
{ resultcodes: $FC user OR group object doesn't exist. }
end;




Function DeleteUserFromGroup(userName,GroupName:String):boolean;
begin
{ The following construction seems a bit overdone, but it is needed to keep
  the bindery consistent. A user is either totally deleted from a group OR
  nothing happens, this way we ensure that a user is not 'patially deleted'
  from a group.
  If the user was not a member of the group, no error is returned. }
IF DeleteBinderyObjectFromSet(Groupname,OT_USER_GROUP,'GROUP_MEMBERS',
                              userName,OT_USER)
 then begin
      IF DeleteBinderyObjectFromSet(userName,OT_USER,'GROUPS_I''M_IN',
                                    GroupName,OT_USER_GROUP)
       then begin
            IF DeleteBinderyObjectFromSet(userName,OT_USER,'SECURITY_EQUALS',
                                          GroupName,OT_USER_GROUP)
             then begin
                  DeleteUserFromGroup:=True;
                  exit;
                  end
             else begin { attempt to repair partially deleted member }
                  AddBinderyObjectToSet(Groupname,OT_USER_GROUP,'GROUP_MEMBERS',
                                        userName,OT_USER);
                  AddBinderyObjectToSet(userName,OT_USER,'GROUPS_I''M_IN',
                                        GroupName,OT_USER_GROUP)
                  end
            end
       else AddBinderyObjectToSet(Groupname,OT_USER_GROUP,'GROUP_MEMBERS',
                                  userName,OT_USER);
      end;
if result=$EA then result:=0; { $EA: user obj NOT a member of group }
DeleteUserFromGroup:=false;
{ As all these called functions are in this unit, you can check nwBindry.result
  for the errorcode. }
{ Resultcodes: $FC user OR group object doesn't exist.   }
end;


end. { end of unit nwBindry }

