{$B-,V-,X+}
UNIT nwConn;

INTERFACE

{ Primary Functions:                    Interrupt: comments:

  AttachToFileServer                    (F100)
* DetachFromFileServer                  (F101)
  EnterLoginArea                        (F217/0A)
* GetConnectionInformation              (F217/16)
* GetConnectionNumber                   (DC..)
* GetInternetAddress                    (F217/13)
* GetObjectConnectionNumbers            (F217/15)
* GetStationAddress                     (EE..)
- GetStationsLoggedInformation          (F217/05) (5)
- Login                                 (F217/00) (3)
* LoginToFileserver                     (F217/14)  UNencrypted
* LoginEncrToFileserver                 (F217/18)  encrypted
* Logout                                (F219)
* LogoutFromFileServer                  (F102)
- MapUserToStationSet                   (F217/02) (4)

* EndOfJob                              (D6)      to be rewritten to F218
* GetConnectionID                       (EF04)
  GetConnectionIDtable                  (EF03)    (6)
* GetDefaultConnectionID                (F002)
  GetDriveConnectionID                  (EF02)
  GetDriveFlag                          (EF01)
  GetDriveHandle                        (EF00)
* GetFileServerName                     (EF04)
  GetNetwareShellVersion                (EA00)
  GetNumberOfLocalDrives                (DB..)
* GetPreferredConnectionID              (F001)
* GetPrimaryConnectionID                (F005)
  GetTaskMode                           (B503)
  GetTaskModePointer                    (B504)
  GetWorkstationEnvironment             (EAxx,xx>00) (2)
  SetEndOfJobStatus                     (BB..)
  SetNetwareErrorMode                   (DD..)
* SetPreferredConnectionID              (F000)
  SetPrimaryConnectionID                (F004)

  Secondary Functions:

  IsConnectionIDinUse                   (EF03)
* GetUserAtConnection                   (GetConnectionInformation)
* GetObjectLoginControl                 (nwBindry.ReadPropertyValue)

Notes: -Only functions marked with a * have been tested; others might work.
       -(2): This function is an extension to EA00 GetNetwareShellVersion.
             A function that returns all returned information from the call
             EAxx,xx>00 is sometimes referred to as GetWShardwareAndOS.
       -(6): This function returns the complete Connection ID table. The
             partial function IsConnectionIDInUse has been moved to the
             secondary function group.

       -NOT implemented in this API:
        (3): This function has been replaced by F217/14 LoginToFileServer.
        (4): Replaced by F217/15 GetObjectConnectionNumbers.
        (5): Replaced by F217/16 GetConnectionInformation.

       -NW 386 can support up to 250 connections, NW 286 Max 100.
       -Type TconnectionList=array[1..250] of byte (Declared in unit nwMisc)

Related functions in other units:
---------------------------------
SendBroadcastMessage (nwMess) ; sends a message to a list of connections.
}
Uses nwMisc,nwBindry;

CONST
  DRIVE_PERMANENT = $01; { Drive permanently assigned to fileserver directory }
  DRIVE_TEMPORARY = $02; { Drive temporary assigned to FS dir. Released by EOJ }
  DRIVE_NETWORK   = $03; { Normal drive mapping }
  DRIVE_LOCAL     = $80; { Drive is local. ! By ORing with one of the above bits,
                           it can be reassigned to a FS directory.                  }

Type
  TconnIDTable=Record  { used by getConnectionIDtable }
               SlotInUse       :Byte; { 0=Free, >0 : In use }
               OrderNbr        :Byte;  { 1..8, order of servers in table,
                                         sorted by network/node address.}
               NetWorkNbr      :LongInt;
               PhysNodeAddress :TnodeAddress; { 6 bytes hi-lo }
               SocketNbr       :Word;         { receiving socket on server }
               ReceiveTimeOut  :Word;
               RouterPhysNAddr :TnodeAddress; { 6 bytes hi-lo }
               PacketSeqNbr    :Byte;
               ConnectionNumber:Byte; { this WS is known as connection x by this server,
                                        FF:no connection }
               ConnectionStatus:Byte; { FFh?/0?: connection functioning }
               MaxTimeOut      :Word;
               Filler          :array[1..5] of byte;
               end;

  TloginControl=Record
                AccountDisabled           :boolean;
                AccountExpirationDate     :NovTimeRec; { dmy valid only }

                MinimumPasswordLength     :byte;
                PasswordControlFlag       :byte;
                DaysBetweenPasswordChanges:word;
                PasswordExpirationDate    :NovTimeRec;
                LastLoginTime             :NovTimeRec; {dmy, hms valid only }
                GraceLoginsRemaining      :Byte;
                MaxGraceLoginsAllowed     :byte;
                BadLoginCount             :byte;
                AccountResetTime          :NovTimeRec; {dmy, hms valid only }
                LastIntruderAdress        :TinterNetworkAdress;

                MaxConcurrentConnections  :byte;
                LoginTimes                :array[1..42] of byte;

                unknown1                  :byte;
                unknown2                  :NovTimeRec;
                end;

Var result:word;

{BB.. [2.0/2.1/3.x]}
Function SetEndOfJobStatus( EndOfJobFlag: Boolean ):Boolean;
{ When this function is called with EndOfJobFlag=False and control is returned
  to the root COMMAND.COM, COMMAND.COM will NOT perform an EOJ action.     }

{F218 [2.15c+]}
FUNCTION EndOfJob(All : Boolean):boolean;
{ forces an end of job
  If All is TRUE, then ends all jobs, otherwise ends a single job.
  Ending a job unlocks and clears all locked or logged files and records.
  It close all open network and local files and resets error and lock modes.
  It also resets the workstation environment.                               }

{F219 [2.15c+]}
Function Logout:boolean;
{logout from all file servers, remains attached to Server, effective EOJ }

{DB.. [2.0/2.1/3.x]}
Function GetNumberOfLocalDrives( Var drives:Byte ):Boolean;

{DC.. [2.0/2.1/3.x]}
Function GetConnectionNumber(Var ConnectionNbr:byte):boolean;
{ returns connection number of requesting WS (1..100) }

{DD.. [2.0/2.1/3.x]}
Function SetNetwareErrorMode( errMode:Byte):boolean;
{ Sets the shell's handling mode for dealing with netware errors.
  0: default, INT 24 handler 'Abort, Retry, Fail';
  1: a netware error number is returned in AL;
  2: the netware error number is translated to a DOS error number,
     this number is returned.
  An EOJ resets the errormode to 0.                                      }

{E3../0A [2.0/2.1/3.x]}
Function EnterLoginArea( LoginSubDirName:String;
                         numberOfLocalDrives:Byte ):boolean;
{ Changes the login directory. Used by boot-proms.
  LoginSubDirName contains the name of a sub directory under SYS:LOGIN
  (e.g. 'V330' means login.exe is to be executed in directory SYS:LOGIN\V330)}

{F217/13 [2.15c+]}
Function GetInternetAddress( ConnNbr : byte;
                              var NetworkNumber:LongInt; { 4 bytes }
                              var physNodeAddress:TnodeAddress; { 6 bytes }
                              Var socketNumber : Word
                              ):boolean;

{F217/14 [2.15c+] UNENCRYPTED}
Function LoginToFileServer( objName:String; objType:word;
                            password : string              ):boolean;

{F217/18 [2.15c+] ENCRYPTED}
FUNCTION LoginEncrToFileServer(ObjName: String; ObjType: Word;
                               PassWord: String            ): Boolean;

{F217/15 [2.15c+]}
Function GetObjectConnectionNumbers( objName:String; objType:Word;
                                     Var numberOfConnections: Byte;
                                     Var connections: TconnectionList ):boolean;
{ returns a list of connectionnumbers where objects of the desired type and
  name are logged in.
  Tconnectionlist is defined as an array[1..100] of byte. Max connections for
  Netware 286 = 100. Netware 386 allows more than 100 connections.
  The NumberofConnections is greater or equal to 0,
  if >0 then connections[1..NumberOfConnections] contains a list of connections. }

{F217/16 [2.15c+]}
Function GetConnectionInforMation (ConnectionNbr:byte;
                                   Var objName:String;
                                   Var objType:Word;
                                   Var objId:LongInt;
                                   Var LoginTime:NovTimeRec ):boolean;

{EA00 [2.0/2.1/3.x]}
Function GetNetwareShellVersion( Var MajorVersion,MinorVersion,
                                     RevisionLevel :Byte       ):Boolean;
{ Returns information about a WS environment. Queries shell.
  See also: GetWorkstationEnvironment                                   }

{EAxx,xx>00 [2.0/2.1/3.x]}
Function GetWorkstationEnvironment(Var OStype,OSversion,
                              HardwareType,ShortHWType:String):Boolean;

{EE.. [2.0/2.1/3.x]}
FUNCTION GetStationAddress( var physicalNodeAddress: TNodeAddress ):boolean;
{ Get the physical station address (6 bytes hi-endian) }

{EF00 [2.0/2.1/3.x]}
Function GetDriveHandle( Drive:Byte; Var Handle:Byte ):boolean;
{ The call returns a pointer to the shell's Drive Handle Table. (32 bytes)
  (Drives A..Z and temporary drives [\]^_' )
  If a drive has been assigned a directory handle on the file server,
  the handle can be found in the DHT at the position corresponding with the drive letter.}

{EF01 [2.0/2.1/3.x]}
Function GetDriveFlag( Drive:Byte; Var Flag:Byte ):Boolean;
{ This call returns a pointer to the shell's Drive Flag Table (32 Bytes)
  Each entry indicates a drive's status (permanent,temporary,local,unassigned)
  For further explanation see the DRIVE_xxx constants.}

{EF02 [2.0/2.1/3.x]}
Function getDriveConnectionID( Drive:Byte; Var connID:Byte):boolean;
{ returns the servernumber (1..8) associated with a drive. }

{EF03 [2.0/2.1/3.x]}
Function GetConnectionIDTable( connID: byte ; Var table: TconnIDtable ):boolean;

{EF04 [2.0/2.1/3.x]}
Function GetConnectionID( serverName: String; Var connID: byte):boolean;

{EF04 [2.0/2.1/3.x]}
Function GetFileServerName( connectionID : byte; var ServerName : string):boolean;
{ get name of file server. file server number must be in range [1..8] }

{F000 [2.0/2.1/3.x]}
Function SetPreferredConnectionID( connectionID :byte ):boolean;
{ The preferred server is the default server to which the request packets are sent.
  Calls are routed to the preferred server. (IF explicitly set!).
  If the preferred server was not set then the requests are routed to
  the server that is attached to the current drive. If the current
  drive is a local drive then the requests will be sent to the primary
  server (mostly the server the shell initially attached to.)            }

{F001 [2.0/2.1/3.x]}
Function GetPreferredConnectionID(var connID : byte):boolean;

{F002 [2.0/2.1/3.x]}
FUNCTION GetDefaultConnectionID(var connID :byte):boolean;
{ Returns the connection ID of the file server to which
  the packets are currently being sent.                                    }

{F004 [2.0/2.1/3.x]}
FUNCTION SetPrimaryConnectionID( primaryConnectionID :Byte ):boolean;

{F005 [2.0/2.1/3.x]}
FUNCTION GetPrimaryConnectionID(var connID :byte ):boolean;
{ returns connection number of default file server (1..8) }

{F100 [2.0/2.1/3.x]}
function AttachToFileServer( ConnID : Byte) : Boolean;
{ Create an attachment between a server and a workstation }
{ Does not Login the workstation }

{F101 [2.0/2.1/3.x]}
Function DetachFromFileServer( connectionID:byte ):boolean;
{ removes server from shell's server table. Relinquishes the
  fileserver connection number and breaks the connection.         }

{F102 [2.0/2.1/3.x]}
Function LogoutFromFileServer(var ConnectionID: byte):boolean;
{logout from one file server}


{B503: (Shell version >=3.01)}
Function GetTaskMode( Var taskMode:Byte):boolean;

{B504: (shell version >=3.01)}
Function GetTaskModePointer( PtaskMode:Pointer ):boolean;

{***** secondary Functions, Result variable is not used*******************}

{EF03 [2.0/2.1/3.x] secondary Function }
Function IsConnectionIDinUse( connID: byte ):boolean;

Function GetUserAtConnection( ConnectionNbr:byte; var username: string):boolean;
{This function provides a short method of obtaining just the USERID.}

Function GetEffectiveConnectionID(Var connId:byte):boolean;
{What server are the requests currently sent to? }

Function GetObjectLoginControl(ObjName:string; ObjType:word;
                               VAR LoginControlInfo:TloginControl):boolean;

IMPLEMENTATION{=============================================================}

USES Dos;

Var UnitReqBuffer:array[1..576] of byte;
    UnitReplyBuffer:array[1..576] of byte;
    UnitRegs:registers;

Procedure F2SystemCall(subf:byte;req_size,rep_size:word);
begin
With UnitRegs
 do begin
    DS := Seg(UnitReqBuffer);  SI := Ofs(UnitReqBuffer);   CX := Req_size;
    ES := Seg(UnitReplyBuffer);DI := Ofs(UnitReplyBuffer); DX := rep_size;
    AH := $F2; AL := subf;
    MSDOS(UnitRegs);
    Result:=al;
    end;
end;


{F000 [2.0/2.1/3.x]}
Function SetPreferredConnectionID( connectionID :byte ):boolean;
{ The preferred server is the default server to which the request
  packets are sent.
  Calls are routed to the preferred server. (IF explicitly set!).
  If the preferred server was not set then the requests are routed to
  the server that is attached to the current drive. If the current
  drive is a local drive then the requests will be sent to the primary
  server (mostly the server the shell initially attached to.)            }
var regs : registers;
begin
 regs.ax := $F000;
 regs.dl := connectionID; { 1..8, 0 to clear }
 msdos(regs);
 result:=0;
 SetPreferredConnectionID:=TRUE;
end;

{F004 [2.0/2.1/3.x]}
FUNCTION SetPrimaryConnectionID( primaryConnectionID :Byte ):boolean;
var regs : registers;
begin
 regs.ax := $F004;
 regs.dl := primaryConnectionID; { 1..8, or 0 to clear }
 msdos(regs);
 result:=0;
 SetPrimaryConnectionID:=TRUE;
end;

{F005 [2.0/2.1/3.x]}
FUNCTION GetPrimaryConnectionID(var connID :byte ):boolean;
{ returns connection number of the primary file server (1..8) }
var regs : registers;
begin
 regs.ax := $F005;
 msdos(regs);
 connID := regs.al;
 result:=0;
 GetPrimaryConnectionID:=((connID>0) and (connID<9))
end;

{F002 [2.0/2.1/3.x]}
FUNCTION GetDefaultConnectionID(var connID :byte):boolean;
{ Returns the connection ID of the file server to which
  the packets are currently being sent.                                    }
var regs : registers;
begin
 regs.ax := $F002;
 msdos(regs);
 connID := regs.al; { 1..8 }
 result:=0;
 GetDefaultConnectionID:=((connID>0) and (connID<9))
end;

{F001 [2.0/2.1/3.x]}
Function GetPreferredConnectionID(var connID : byte):boolean;
var regs : registers;
begin
 regs.ax := $F001;
 msdos(regs);
 connID := regs.al; { 1..8, or 0 if the preferred server was not set }
 { The preferred coneection is reset to 0 by an EOJ. }
 result:=0;
 GetPreferredConnectionID:=((connID>0) and (connID<9))
end;



{EF03 [2.0/2.1/3.x]}
Function GetConnectionIDTable( connID: byte ; Var table: TconnIDtable ):boolean;
Type ptarr=^tarr;
     tarr=array[0..8*32] of byte;
Var regs:registers;
begin
If ((connID<1) or (ConnID>8))
 then Result:=$FF
 else begin
      regs.ax:=$EF03;
      MsDos(regs);
      move( ptarr(Ptr(regs.es,regs.si))^[(connID-1)*32], table, 32 );
      table.socketNbr:=swap(table.socketNbr); { force lo-hi }
      table.NetworkNbr:=Lswap(table.NetworkNbr); { force lo-hi }
      table.ReceiveTimeOut:=swap(table.ReceiveTimeOut); { force lo-hi }
      table.MaxTimeOut:=swap(table.MaxTimeOut); { force lo-hi }
      Result:=$00;
      end;
GetConnectionIDTable:=(Result=0);
end;

{EF04 [2.0/2.1/3.x]}
Function GetConnectionID( serverName: String; Var connID: byte):boolean;
var regs       : registers;
    name_table : array [1..8*48] of Byte;
    server     : array [1..8] of string;
    count      : integer;
    p          : ^byte;
    lname      : string;
begin
 lname:=serverName; UpString(lname);
 regs.ax := $EF04;
 msdos(regs);
 result:=regs.AL;

 p := ptr(regs.es, regs.si); { pointer to shell's server name table. }
 move(p^,name_table,8*48);
for count := 1 to 8 do server[count] := '';
 { name table 8 entries by 48 decimal chars. Asciiz strings. }
for count := 0 to 7
  do ZstrCopy(server[count+1],name_table[1+ count*48],48);

count:=1;
While ((count<9) and (server[count]<>lName))
 do inc(count);
If count=9
 then begin
      Result:=$FF; { server name not found }
      GetConnectionID:=False
      end
 else begin
      connID:=count;
      Result:=$00;
      GetConnectionID:=TRUE;
      end;
end;

{EF04 [2.0/2.1/3.x]}
Function GetFileServerName( connectionID : byte; var ServerName : string):boolean;
{ get name of file server. file server number must be in range [1..8] }
var regs       : registers;
    name_table : array [1..8*48] of Byte;
    server     : array [1..8] of string;
    count      : integer;
    p          : ^byte;
begin
 regs.ax := $EF04;
 msdos(regs);
 result:=regs.AL;

 p := ptr(regs.es, regs.si); { pointer to shell's server name table. }
 move(p^,name_table,8*48);
for count := 1 to 8 do server[count] := '';
 { name table 8 entries by 48 decimal chars. Asciiz strings. }
for count := 0 to 7
  do ZstrCopy(server[count+1],name_table[1+ count*48],48);
if ((connectionID<1) or (connectionID>8))
  then serverName:= server[1]
  else ServerName := server[connectionID];
IF ServerName=''
 then result:=$FF
 else result:=$00;
GetFileServerName:=result=0;
end;


{F100 [2.0/2.1/3.x]}
function AttachToFileServer( ConnID : Byte) : Boolean;
{ Create an attachment between a server and a workstation }
{ Does not Login the workstation }
Var NovRegs:Registers;
begin
with NovRegs
do begin
   AX := $F100;
   DL := ConnID;
   MsDos(NovRegs);
   Result := AL;
   end;
AttachToFileServer:=(Result=0);
{ possible return codes:
  F8 already attached to server; F9 No free connection slots at server;
  FA no more server slots; FE Server Bindery Locked;
  FF No response from server }
end;

{F101 [2.0/2.1/3.x]}
Function DetachFromFileServer( connectionID:byte ):boolean;
{ removes server from shell's server table. Relinquishes the
  fileserver connection number and breaks the connection.         }
var regs : registers;
begin
 regs.ax := $F101;
 regs.dl := connectionID; { 1..8 }
 msdos(regs);
 result := regs.al;
 DetachFromFileServer:=(result=0);
{ returncodes: 00 successful; FF Connection Doesn't exist }
end;

{DC.. [2.0/2.1/3.x]}
Function GetConnectionNumber(Var ConnectionNbr:byte):boolean;
{ returns connection number of requesting WS (1..100) }
var regs:Registers;
begin
regs.Ah:=$DC;
MsDos(regs);
ConnectionNbr:=Regs.AL; { logical WS connection # }
{ cl= first digit of logical conn #, ch= second digit of conn# }
result:=0;
GetConnectionNumber:=true;
end;


{F217/16 [2.15c+]}
Function GetConnectionInformation (ConnectionNbr:byte;
                                   Var objName:String;
                                   Var objType:Word;
                                   Var objId:LongInt;
                                   Var LoginTime:NovTimeRec ):boolean;
Var
  I,X            : Integer;
  RequestBuffer  : Record
                   PacketLength : Integer;
                   FunctionVal  : Byte;
                   _ConnectionNo : Byte;  { 1..100, nw286 needs this info }
                   End        ABSOLUTE UnitReqBuffer;
  ReplyBuffer    : Record
                   _objId        :LongInt;  { hi-lo }
                   _ObjType     : word;     { hi-lo }
                   _ObjName     : Array [1..48] of Byte;
                   _LoginTime    : NovTimeRec;
                   Reserved:word;
                   End        ABSOLUTE UnitReplyBuffer;
Begin
With RequestBuffer
Do Begin
   PacketLength := 2;
   FunctionVal := $16;
   _ConnectionNo := ConnectionNbr;
   End;
F2SystemCall($17,SizeOf(requestBuffer),SizeOf(ReplyBuffer));
If Result = 0
 Then Begin
      With ReplyBuffer
      Do Begin
         ZstrCopy(ObjName,_objName,48);
         ObjId:=Lswap(_objId);
         ObjType:=swap(_objType);
         logintime:=_logintime;
         End;
      End;
{ patch to have a NIL object return an error. }
if objName='' then result:=$FD; { no_such_connection }
GetConnectionInformation:=(result=0);
End { GetConnectInfo };



{F217/14 [2.15c+,unencrypted]}
Function LoginToFileServer( objName:String; objType:word;
                            password : string             ):boolean;
Var req  :record
          len      :word;
          subFunc  :byte;
          _objType :Word; { hi-lo }
          _objName :String[47]; { asciiz?  }
          _objPassw:String[127]; { allowed to be '' }
          end            ABSOLUTE UnitReqBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$14;
   _objType:=swap(objType);
   PStrCopy(_objName,objName,47); _objName[47]:=#0; UpString(_objName);
   PStrCopy(_objPassw,password,127); UpString(_objPassw);
   end;
F2SystemCall($17,SizeOf(req),0);
LoginToFileServer:=(result=0)
end;


{F217/18 [3.x]}
FUNCTION LoginEncrToFileServer(ObjName: String; ObjType: Word; PassWord: String): Boolean;
{ assumes the current effective server = the server to login to. }


   FUNCTION LoginEncrypted(ObjName : String; ObjType : Word; VAR key : TencryptionKey): Boolean;
   VAR req : RECORD
             BufLen  : Word;
             _func   : Byte;
             _key    : TencryptionKey;
             _ObjType: Word;
             _ObjName: String[48];
             End                  ABSOLUTE UnitReqBuffer;
   Begin
   With req
    do Begin
       _func := $18;
       _key  := key;
       _ObjType := Swap(objType);
       PstrCopy(_ObjName,ObjName,48); UpString(_ObjName);
       if ObjName[0]<#48
         then _objName[0]:=objName[0]
         else _objname[0]:=#48;
       BufLen:=ord(_ObjName[0])+12;
       End;
   F2SystemCall($17,SizeOf(req),0);
   LoginEncrypted:=(result=0);
   End;

VAR
  key : TencryptionKey;
  ObjId:LongInt;
  _pw:string;
  _lpw:Byte;

Begin
UpString(password);
_pw:=password;if _pw[0]>#127 Then _pw[0]:=#127;
_lpw:=length(password);
if _lpw=0 Then _pw:=#0;

IF GetEncryptionKey(key)
 Then Begin
      writeln('getencryptionkey: OK');
      IF GetBinderyObjectId(objName,objType,ObjId)
       Then Begin
            EncryptPassword(objId,_pw,key);
            writeln('encryptpassword: OK');
            LoginEncrypted(ObjName, ObjType, key);
            End;
      End
 Else begin
      writeln('Getencryptionkey failed. trying unencrypted login..');
      LoginToFileServer(ObjName, ObjType, Password);
      end;

LoginEncrToFileServer:= (result=0);
End;


{F219 [2.15c+]}
Function Logout:boolean;
{logout from all file servers, remains attached to Server, effective EOJ }
begin
 F2SystemCall($19,0,0);
end;


{F102 [2.0/2.1/3.x]}
Function LogoutFromFileServer(var ConnectionID: byte):boolean;
{logout from one file server}
var regs : registers;
begin
 regs.ah := $F1;
 regs.al := $02;
 regs.dl := connectionID;
 msdos(regs);
 result:=00;
 LogoutFromFileServer:=True;
end;

{EE.. [2.0/2.1/3.x]}
FUNCTION GetStationAddress( var physicalNodeAddress: TNodeAddress ):boolean;
{ Get the physical station address (6 bytes hi-endian) }
Var Regs              :Registers;
Begin
 {Get the physical address from the Network Card}
 Regs.Ah := $EE;
 MsDos(Regs);
 result:=Regs.AL;
 {nw node= CX BX AX hi-endian}
 physicalNodeAddress[1]:=Regs.CH;
 physicalNodeAddress[2]:=Regs.CL;
 physicalNodeAddress[3]:=Regs.bh;
 physicalNodeAddress[4]:=Regs.bl;
 physicalNodeAddress[5]:=Regs.ah;
 physicalNodeAddress[6]:=Regs.al;
 result := 0;
 GetStationAddress:=true;
End;


{F217/13 [2.15c+]}
Function GetInternetAddress( ConnNbr : byte;
                              var NetworkNumber:LongInt; { 4 bytes }
                              var physNodeAddress:TnodeAddress; { 6 bytes }
                              Var socketNumber : Word
                              ):boolean;
Var  Request_buffer : record
                     length      : word;
                     subfunction : byte;
                     connection  : byte;
                     end            ABSOLUTE UnitReqBuffer;
      Reply_Buffer : record
                     network : LongInt; { array [1..4] of byte } { hi-lo }
                     node    : array [1..6] of byte;             { hi-lo }
                     socket  : word; { array [1..2] of byte }    { hi-lo }
                     end            ABSOLUTE UnitReplyBuffer;
BEGIN
With request_buffer
do begin
   length := 2;
   subfunction := $13;
   connection := ConnNbr;
   end;
F2SystemCall($17,SizeOf(request_buffer),SizeOf(Reply_buffer));
if result = 0
then With reply_buffer
      do begin
         NetWorkNumber:=Lswap(network); { force lo-hi }
         move(node,physNodeAddress,6);  { _is_ and stays hi-lo }
         socketNumber:=swap(socket);    { force lo-hi }
         end;
GetInternetAddress:=(result=0);
end;

{D6.. [2.0/2.1/3.x]}
FUNCTION EndOfJob(All : Boolean):boolean;
{ forces an end of job
  If All is TRUE, then ends all jobs, otherwise ends a single job.
  Ending a job unlocks and clears all locked or logged files and records.
  It close all open network and local files and resets error and lock modes.
  It also resets the workstation environment.                               }
Var NovRegs:Registers;
BEGIN
with NovRegs
do begin
   AH := $D6;
   if All
    then BX := $FFFF
    else BX := $00;
   end;
MsDos(NovRegs);
Result:=$00;
EndOfJob:=True;
end;

{$IFDEF NewCalls}

{F218 [2.15c+]}
FUNCTION EndOfJob(All : Boolean):boolean;
{ forces an end of job
  If All is TRUE, then ends all jobs, otherwise ends a single job.
  Ending a job unlocks and clears all locked or logged files and records.
  It close all open network and local files and resets error and lock modes.
  It also resets the workstation environment.                               }
Var req:record
        len:word;
        _all:word;
        end ABSOLUTE UnitReqBuffer;
   { ERR: unclear how the req buffer should be... }
BEGIN
if All
 then req._all := $FFFF
 else req._all := $0000;
req.len:=2;
F2SystemCall($18,2,0);
Result:=$00;
EndOfJob:=True;
end;

{$ENDIF}


{E3../0A [2.0/2.1/3.x]}
Function EnterLoginArea( LoginSubDirName:String;
                         numberOfLocalDrives:Byte ):boolean;
{ Changes the login directory. Used by boot-proms.
  LoginSubDirName contains the name of a sub directory under SYS:LOGIN
  (e.g. 'V330' means login.exe is to be executed in directory SYS:LOGIN\V330)}
Var regs:registers;
Var req  :record
          len:word;
          subFunc:byte;
          _numLocDr:Byte;
          _subDirName:String[255];
          end;
    reply:record
          len:word;
          end;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$0A;
   _numLocDr:=numberOfLocalDrives;
   PstrCopy(_subDirName,LoginSubDirName,255); UpString(_subDirName);
   end;
Reply.len:=$00;
With regs
do begin
   AH:=$E3;
   Ds:=seg(Req);
   si:=ofs(Req);
   Es:=seg(Reply);
   di:=ofs(Reply);
   MsDos(regs);
   result:=AL;
   end;
EnterLoginArea:=(result=0)
end;

{F217/15 [2.15c+]}
Function GetObjectConnectionNumbers( objName:String; objType:Word;
                                     Var numberOfConnections: Byte;
                                     Var connections: TconnectionList ):boolean;
{ returns a list of connectionnumbers where objects of the desired type and
  name are logged in.
  Tconnectionlist is defined as an array[1..100] of byte. Max connections for
  Netware 286 = 100. Netware 386 allows more than 100 connections.
  If you pass a bad Objectname or the object is not logged in, the errorcode
  is NOT set to NO_SUCH_OBJECT ($FC), but GetObjectConnectionNumbers returns 0.}
Var req  :record
          len:word;
          subFunc:byte;
          _objType:Word; { hi-lo}
          _objName:String[47];
          end               ABSOLUTE UnitReqBuffer;
    reply:record
          _NbrOfConn:Byte;
          _connList:TconnectionList
          end               ABSOLUTE UnitReplyBuffer;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$15;
   PstrCopy(_objName,objName,47); _objname[47]:=#0; UpString(_objName);
   _objType:=swap(objType);
   end;
F2SystemCall($17,SizeOf(req),SizeOf(reply));
With reply
do begin
   connections:=_connList;
   NumberOfConnections:=_NbrOfConn;
   end;
getObjectConnectionNumbers:=(result=0)
end;

{EF00 [2.0/2.1/3.x]}
Function GetDriveHandle( Drive:Byte; Var Handle:Byte ):boolean;
{ The call returns a pointer to the shell's Drive Handle Table. (32 bytes)
  (Drives A..Z and temporary drives [\]^_' )
  If a drive has been assigned a directory handle on the file server,
  the handle can be found in the DHT at the position corresponding with the drive letter.}
Type pArr=^arr;
     arr=array[0..31] of byte;
Var regs:registers;
    Udrive:char;
begin
regs.ax:=$EF00;
MsDos(regs);
if Drive>31
 then result:=$0105
 else begin
      Handle:=Parr(Ptr(Regs.Es,Regs.Si))^[Drive];
      Result:=0;
      end;
GetDriveHandle:=(Result=0);
end;

{EF01 [2.0/2.1/3.x]}
Function GetDriveFlag( Drive:Byte; Var Flag:Byte ):Boolean;
{ This call returns a pointer to the shell's Drive Flag Table (32 Bytes)
  Each entry indicates a drive's status (permanent,temporary,local,unassigned)
  For further explanation see the DRIVE_xxx constants.}
Type pArr=^arr;
     arr=array[0..31] of byte;
Var regs:registers;
begin
regs.ax:=$EF01;
MsDos(Regs);
If Drive>31
  then result:=$0105
  else begin
       Flag:=Parr(Ptr(Regs.es,regs.si))^[Drive];
       Result:=0;
       end;
GetDriveFlag:=(Result=0);
end;

{EF02 [2.0/2.1/3.x]}
Function getDriveConnectionID( Drive:Byte; Var connID:Byte):boolean;
{ returns the servernumber (1..8) associated with a drive. }
Type pArr=^arr;
     arr=array[0..31] of byte;
Var regs:registers;
begin
regs.ax:=$EF02;
MsDos(Regs);
If Drive>31
 then result:=$0105
 else begin
      connID:=Parr(Ptr(Regs.es,regs.si))^[Drive];
      Result:=0;
      end;
GetDriveConnectionID:=(Result=0);
end;

{EA00 [2.0/2.1/3.x]}
Function GetNetwareShellVersion( Var MajorVersion,MinorVersion,
                                     RevisionLevel :Byte       ):Boolean;
{ Returns information about a WS environment. Queries shell.
  See also: GetWorkstationEnvironment                                   }
Var regs:Registers;
    reply:record
          stringz4:array[1..4*32] of byte;
          end;
Begin
With regs
do begin
   AX:=$EA00;
   ES:=seg(reply);
   DI:=ofs(reply);
   MsDos(regs);
   MajorVersion:=BH;
   MinorVersion:=BL;
   { shell version>=3.00 : }
   { CH = Shell Type. 0=conventional, 1= expanded, 2= extended }
   RevisionLevel:=CL; { 1=A,2=B etc. }
   end;
Result:=$00;
GetNetwareShellVersion:=True;
end;

{EAxx,xx>00 [2.0/2.1/3.x] (shell version >=3.00) }
Function GetWorkstationEnvironment(Var OStype,OSversion,
                              HardwareType,ShortHWType:String):Boolean;
Var regs:Registers;
    reply:record
          stringz4:array[1..4*32] of char;
          end;
    sNo,k:Byte;
Begin
With regs
do begin
   AX:=$EA01;
   BX:=$00;
   ES:=seg(reply);
   DI:=ofs(reply);
   MsDos(regs);
   end;
OStype:='';
OSVersion:='';
HardwareType:='';
ShortHWtype:='';
sNo:=0;k:=0;
With reply
do begin
   while sNo<4
   do begin
      inc(k);
      while ((k<128) and (stringz4[k]<>#0))
      do begin
         Case sNo of
          0:OStype:=OStype+stringz4[k];
          1:OSversion:=OSversion+stringz4[k];
          2:HardwareType:=HardwareType+stringz4[k];
          3:ShortHWtype:=ShortHWtype+stringz4[k];
         end; {case}
         inc(k);
         end;
      inc(Sno);
      end;
   end;
Result:=$00;
GetWorkstationEnvironment:=True;
end;

{DD.. [2.0/2.1/3.x]}
Function SetNetwareErrorMode( errMode:Byte):boolean;
{ Sets the shell's handling mode for dealing with netware errors.
  0: default, INT 24 handler 'Abort, Retry, Fail';
  1: a netware error number is returned in AL;
  2: the netware error number is translated to a DOS error number,
     this number is returned.
  An EOJ resets the errormode to 0.                                      }
Var regs:registers;
begin
Regs.AH:=$DD;
Regs.DL:=errMode;
MsDos(Regs);
{ regs.al now contains previous error mode }
Result:=$00;
SetNetWareErrorMode:=True;
end;

{BB.. [2.0/2.1/3.x]}
Function SetEndOfJobStatus( EndOfJobFlag: Boolean ):Boolean;
{ When this function is called with EndOfJobFlag=False and control is returned
  to the root COMMAND.COM, COMMAND.COM will NOT perform an EOJ action.     }
Var regs:Registers;
begin
regs.AH:=$BB;
If EndOfJobFlag
 then regs.AL:=$01
 else regs.AL:=$00;
MsDos(Regs);
{ AL now contains previous EOJ Flag }
Result:=$00;
SetEndOfJobStatus:=True;
end;

{DB.. [2.0/2.1/3.x]}
Function GetNumberOfLocalDrives( Var drives:Byte ):Boolean;
Var regs:registers;
begin
regs.ah:=$DB;
MsDos(Regs);
drives:=Regs.AL;
Result:=$00;
GetNumberOfLocalDrives:=TRUE;
end;

{B503: (Shell version >=3.01)}
Function GetTaskMode( Var taskMode:Byte):boolean;
Var regs:registers;
begin
Regs.AX:=$B503;
MsDos(Regs);
taskMode:=Regs.AL;
result:=0;
GetTaskMode:=TRUE;
end;

{B504: (shell version >=3.01)}
Function GetTaskModePointer( PtaskMode:Pointer ):boolean;
Var Regs:Registers;
begin
Regs.AX:=$B504;
MsDos(regs);
PtaskMode:=Ptr(regs.ES,regs.BX);
result:=0;
GetTaskModePointer:=TRUE;
end;

{=======SECONDARY FUNCTIONS===================================================}

{
Function template(   ):boolean;
Var regs:registers;
Var req  :record
          len:word;
          subFunc:byte;

          end;
    reply:record
          len:word;
          end;
Begin
WITH req
do begin
   len:=SizeOf(req)-2;
   subFunc:=$

   end;
Reply.len:=$FF;
With regs
do begin
   AX:=$E300;
   Ds:=seg(Req);
   si:=ofs(Req);
   Es:=seg(Reply);
   di:=ofs(Reply);
   MsDos(regs);
   result:=AL;
   end;
With reply
do begin

   end;
template:=(result=0)
end; }


{EF03 [2.0/2.1/3.x] secondary Function }
Function IsConnectionIDinUse( connID: byte ):boolean;
Type ptarr=^arr;
     arr=array[0..8*32] of byte;
Var regs:registers;
begin
If ((connID<1) or (ConnID>8))
 then IsConnectionIDInUse:=TRUE
 else begin
      regs.ax:=$EF03;
      MsDos(regs);
      IsConnectionIDinUse:=(ptarr(Ptr(regs.es,regs.si))^[(connID-1)*32] = $FF)
      end;
end;



Function GetUserAtConnection( ConnectionNbr:byte; var username: string):boolean;
{This function provides a shorter method of obtaining just the USERID.}
var id:LongInt;
    typ:word;
    time:NovTimeRec;
begin
 getUserAtConnection:=GetConnectionInformation(ConnectionNbr,username,typ,id,time);
end;


Function GetEffectiveConnectionID(Var connId:byte):boolean;
begin
if NOT (GetPreferredConnectionID(connId) and (connId<>0))
 then if NOT (GetDefaultConnectionID(ConnId) and (connId<>0))
       then GetPrimaryConnectionId(ConnId);
GetEffectiveConnectionID:=(result=$00);
end;


Function GetObjectLoginControl(ObjName:string; ObjType:word;
                               VAR LoginControlInfo:TloginControl):boolean;
{ Caller must have access to the bindery property LOGIN_CONTROL.
  Default: you need to be supervisor-equivalent or the object the property
           is associated with. (reading your 'own' information)

  PasswordcontrolFlag:
  00 User is allowed to change PW.
  01 User is NOT allowed to change PW.
  02 User is allowed to change PW, but the new password must be unique.
  03 User is NOT allowed to change PW, and a new password, to be changed
     by the supervisor, must be unique.
}
Var LCpropVal:PropertyType;
    lc:record
       _AccExpDate          :array[1..3] of byte; {yy mm dd}
       _AccDisabled         :boolean;
       _PWexpDate           :array[1..3] of byte; {yy mm dd}
       _GraceLoginsRemaining:byte;
       _DaysBetwPWchanges   :word;
       _MaxGraceLogins      :byte;
       _minPWlen            :byte;
       _unknown1            :byte;
       _MaxConcConn         :byte;
       _loginTimes          :array[1..42] of byte;
       _LastLoginTime       :array[1..6] of byte; {yy mm dd hh mm ss}
       _PWcontrol           :byte;
       _unknown2            :array[1..6] of byte; {time of last intrusion??}
       _badLoginCount       :byte;
       _AccountResetTime    :LongInt; { minutes since 1/1/1985 }
       _lastIntruderAdress  :TinterNetworkAdress;
       end        ABSOLUTE LCpropVal;
    moreSegments:boolean;
    propFlags:byte;

begin
IF nwBindry.ReadPropertyValue(ObjName,ObjType,'LOGIN_CONTROL',1,
                              LCpropval,moreSegments,propFlags)
 then begin
      FillChar(LoginControlInfo,SizeOf(LoginControlInfo),#0);
      With LoginControlInfo
       do begin
          AccountDisabled           :=lc._AccDisabled;
          move(lc._AccExpDate[1],AccountExpirationDate.year,3);
          move(lc._PWexpDate[1],PasswordExpirationDate.year,3);
          MinimumPasswordLength     :=lc._minPWlen;
          PasswordControlFlag       :=lc._PWcontrol;
          DaysBetweenPasswordChanges:=swap(lc._DaysBetwPWchanges);
          Move(lc._lastLoginTime[1],LastLoginTime.year,6);
          GraceLoginsRemaining      :=lc._GraceLoginsRemaining;
          MaxGraceLoginsAllowed     :=lc._maxGraceLogins;
          BadLoginCount             :=lc._badLoginCount;
          {AccountResetTime         := .. }
          LastIntruderAdress        :=lc._LastIntruderAdress;
          LastIntruderAdress.socket :=swap(LastIntruderAdress.socket); {force lo-hi}
          MaxConcurrentConnections  :=lc._MaxConcConn;
          Move(lc._LoginTimes[1],LoginTimes[1],42);

          unknown1:=lc._unknown1;
          move(lc._unknown2[1],unknown2.year,6);
          end;
      end
 else result:=nwBindry.result;
end;


end. { end of unit nwConn }

