{$X+,V-,B-}
UNIT nwServ;

INTERFACE

uses NwMisc,nwConn;

Var result:word;

{ Primary Functions:                      Interrupt: Comments:

* CheckConsolePrivileges                  (F217/C8)
* ClearConnectionNumber                   (F217/D2)
* DisableFileServerLogin                  (F217/CB)
  DisableTransactionTracking              (F217/CF)
* DownFileServer                          (F217/D3) (3)
* EnableFileServerLogin                   (F217/CC)
  EnableTransactionTracking               (F217/D0)
  GetBinderyObjectDiskSpaceLeft           (F217/E6)
  GetConnectionsOpenFiles                 (F217/DB)
  GetDiskUtilization                      (F217/0E)
* GetFileServerDateAndTime                (F214)
* GetFileServerDescriptionStrings         (F217/C9)
* GetFileserverLoginStatus                (F217/CD)
  GetPathFromDirectoryEntry               (F216/1A) [E2../1A]
* GetNetworkSerialNumber                  (F217/12) (2)
* GetServerInformation                    (F217/11) (1)
* SetFileServerDateAndTime                (F217/CA)
* VerifyNetworkSerialNumber               (F217/0C) (2)

  Functions that MAY NOT be supported by NW 386:
  (their F2 interfaces might work...)

  GetConnectionsTaskInformation           (F217/DA)
  GetConnectionsUsageStats                (F217/E5)
  GetConnectionsUsingAFile                (F217/DC)
  GetDiskCacheStats                       (F217/D6)
  GetDiskChannelStats                     (F217/D9)
  GetDriveMappingTable                    (F217/D7)
  GetFileServerLANIOStats                 (F217/E7)
  GetFileSystemStats                      (F217/D4)
  GetLANDriverConfigInfo                  (F217/E3)
  GetLogicalRecordInformation             (F217/E0)
  GetLogicalRecordsByConnection           (F217/DF)
  GetPhysicalDiskStats                    (F217/D8)
  GetPhysicalRecordLocksByFile            (F217/DE)
  GetPhysRecLocksByConnectAndFile         (F217/DD)


  Secondary functions:

  CheckNetwareVersion

  Not supported by netware 3.x:

- GetFileServerMiscInformation            (F217/E8) (1) (4)

Notes: The Functions marked with an - are NOT implemented in this API,
       because they are not supported by NW 386.

       (1) Please don't confuse these two functions.
       (2) Functions not normally supported in NW API's, but
           closely related to the functions in this unit.
       (3) ERROR: will down the server regardless of the ForceFlag parameter.
       (4) F217/.. returns error 251: Unknown Request. Call not implemented.
}


Type TserverInfo=Record
                ServerName         : string[48];
                NetwareVersion     : Byte;
                NetwareSubVersion  : Byte; { 0..99 }
                ConnectionsMax     : word;
                ConnectionsInUse   : word;
                MaxConnVol         : word; { max connected volumes }
                {---Advanced Netware 2.1x/3.x------------}
                OS_revision        : byte;
                SFT_level          : byte;
                TTS_level          : byte;
                peak_conn_used     : word; { max simult.used connections}
                accounting_version : byte;
                vap_version        : byte;
                queuing_version               : byte;
                print_server_version          : byte;
                virtual_console_version       : byte;
                security_restrictions_level   : byte;
                Internetwork_bridge_version   : byte;
                Undefined                     : Array [1..60] of Byte;
                End;

Type TfileInfoRecord=record
                     taskNbr:Byte;
                     lockFlag:Byte;
                     AccessFlag:Byte;
                     LockType:Byte; { 00 no lock; FE file lock; FF locked by Begin Share File Set }
                     volumeNbr:Byte; { 0..31 }
                     DirEntry:Word;
                     FileName:string[13];
                     end;

{Bitfields for lock flags:
 bit 0	file is locked
 bit 1	file opened Shareable
 bit 2	logged
 bit 3	file opened Normal
 bit 6	TTS holding lock
 bit 7	Transaction Flag set on file

Bitfields for access flags:
 bit 0	file open for reading by calling station
 bit 1	file open for writing by calling station
 bit 2	deny reads by other stations
 bit 3	deny writes by other stations
 bit 4	file detached
 bit 5	TTS Holding Detach
 bit 6	TTS Holding Open}



{F217/C8 [2.15c+]}
FUNCTION CheckConsolePrivileges : Boolean;

{F217/D2 [2.15c+]}
Function ClearConnectionNumber(connectionNbr:byte):boolean;
{ Console Rights needed;
  -Terminates a connection. }

{F217/CB [2.15c+]}
FUNCTION DisableFileServerLogin : Boolean;

{F217/CF [2.15c+]}
FUNCTION DisableTransactionTracking : Boolean;

{F217/D3 [2.15c+]}
FUNCTION DownFileServer (ForceFlag : Boolean) : Boolean;

{F217/CC [2.15c+]}
FUNCTION EnableFileServerLogin : Boolean;

{F217/D0 [2.15c+]}
FUNCTION EnableTransactionTracking : Boolean;

{F217/E6 [2.15c+]}
FUNCTION GetBinderyObjectDiskSpaceLeft
            (    ObjID : longInt;
             var SystemElapsedTime,UnusedDiskBlocks : longint;
             var RestrictionEnforced : Boolean             ) : Boolean;

{F217/DB [2.15c+]}
FUNCTION GetConnectionsOpenFiles
           ( ConnID,ConnNumber  : Byte;
     {i/o:}  var LastRecordSeen : word;
     {out:}  var FileInfo: TfileInfoRecord ) : Boolean;
{ To be called Iteratively.
  LastRecordSeen is an i/o parameter;
  -An initial value of 0 has to be supplied;
  -The function can be called until LastRecordSeen becomes 0,
   indicating the end of the FIR-list. }
{ normally a great number of File Information Records (FIR's) can be returned by one call.
  We have changed the function so that it returns one FIR per call. }
{ the calling workstation must have console operator privileges. }


{F217/0E [2.15c+]}
FUNCTION GetDiskUtilization(volNbr:byte; objID:Longint;
                        Var usedDirs,usedFiles,usedBlocks:Word ):Boolean;

{F214    [2.15c+]}
FUNCTION GetFileServerDateAndTime ( Var time:NovTimeRec): Boolean;

{F217/C9 [2.15c+]}
FUNCTION GetFileServerDescriptionStrings(Var companyName,
                                             VersionAndRevision,revisionDate,
                                             copyrightNotice:String
                                         ):Boolean;

{F217/CD [2.15c+]}
FUNCTION GetFileServerLoginStatus (Var LoginEnabled:Boolean): Boolean;
{ if Login is enabled then returns TRUE in LoginEnabled }
{ rusult byte:  00h  - Success, C6h No Console Rights }
{Caller must have operator status.}


{F216/1A [2.15c+]}
FUNCTION GetPathFromDirectoryEntry(connID:word;
                                   volNbr:Byte; dirEntry:word;
                               Var Path:String                ):Boolean;
{To be used in conjunction with the GetConnectionsOpenFiles func.}

{F217/12 [2.15c+]}
Function GetNetworkSerialNumber(Var serialNbr:LongInt; Var ApplicNbr:Word ):Boolean;
{return the serial number and application number for the software
	  installed on the file server}
{SeeAlso: VerifyNetworkSerialNumber,GetServerInformation}

{F217/11 [2.15c+]}
Function GetServerInformation (Var serverInfo:TserverInfo):boolean;
{determine the version of software installed on the file server and how it is configured}


{F217/CA [2.15c+]}
FUNCTION SetFileServerDateAndTime(time:NovTimeRec):Boolean;
{need console operator privileges to do this}

{F217/OC [2.15c+]}
Function VerifyNetworkSerialNumber(serialNbr: LongInt ;
                               Var ApplicNbr: Word     ):Boolean;
{if the network serial number to be verified is correct, the reply
	  buffer will contain the corresponding application number }

{*********************** Secondary Functions ******************************}

{ [1.x/2.x/3.x] }
FUNCTION CheckNetwareVersion(MinimumVersion,MinimumSubVersion,
                             MinimumRevision,MinimumSFT,MinimumTTS:word):Boolean;

IMPLEMENTATION{=============================================================}


USES Dos;

Var UnitReqBuffer:array[1..576] of byte;
    UnitReplyBuffer:array[1..576] of byte;
    UnitRegs:registers;

Procedure F2SystemCall(subf:byte;req_size,rep_size:word);
begin
With UnitRegs
 do begin
    DS := Seg(UnitReqBuffer);  SI := Ofs(UnitReqBuffer);   CX := Req_size;
    ES := Seg(UnitReplyBuffer);DI := Ofs(UnitReplyBuffer); DX := rep_size;
    AH := $F2; AL := subf;
    MSDOS(UnitRegs);
    Result:=al;
    end;
end;


{F217/D2 [2.15c+]}
Function ClearConnectionNumber(connectionNbr:byte):boolean;
{ Console Rights needed;
  -Terminates a connection. }
Var req: record
         len : word;
         subf: byte;
         _connNbr:byte;
         end          ABSOLUTE UnitReqBuffer;
begin
With req
do begin
   len:=2;
   subf:=$D2;
   _connNbr:=connectionNbr
   end;
F2SystemCall($17,SizeOf(req),0);
ClearConnectionNumber:=(result=0);
{result codes: 00 successful; C6 No Console Rights}
end;

{F214 [2.15c+]}
FUNCTION GetFileServerDateAndTime ( Var time:NovTimeRec): Boolean;
Var reply : NovTimeRec ABSOLUTE UnitReplyBuffer;
BEGIN
F2SystemCall($14,0,SizeOf(reply));
time:=reply;
if time.year>100 then time.year:=time.year-100;
{ year<80 : 21st century }
getFileServerDateAndTime:=TRUE;
end;


{F217/CA [2.15c+]}
FUNCTION SetFileServerDateAndTime (time:NovTimeRec): Boolean;
Var req  : record
           Len:word;
           subF:byte;
           _time:NovTimeRec
           end              ABSOLUTE UnitReqBuffer;
BEGIN
{ year<80 : 21st century }
WITH req
do begin
   Len:=SizeOf(req)-3; { dow is no parameter }
   subF:=$CA;
   _time:=time;
   end;
F2SystemCall($17,SizeOf(req),0);
SetFileServerDateAndTime:=(Result=$00);
{ Resulcodes: $00 Success; $C6 No Console Operator Rights }
end;


{F217/11 [2.15c+]}
Function GetServerInformation (Var serverInfo:TserverInfo):boolean;
{determine the version of software installed on the file server and how it is configured}

{SeeAlso: GetDiskUtilization, GetNetworkSerialNumber, GetFileServerLoginStatus,
          GetFileServerDateAndTime}

Var  Request: Record
              Len  : word;
              SubF : Byte;
              End         ABSOLUTE UnitReqBuffer;
     Reply: TserverInfo   ABSOLUTE UnitReplyBuffer;
     t:word;
Begin
With Request
Do Begin
   Len := 1;
   SubF:= $11;
   End;
F2SystemCall($17,SizeOf(request),SizeOf(reply)-1);
Move(UnitReplyBuffer[1],UnitReplyBuffer[2],SizeOf(reply)-1);
serverInfo:=reply;
With serverinfo
do begin
   connectionsMax  :=Swap(connectionsMax);   { force lo-hi again }
   ConnectionsInUse:=Swap(connectionsInUse);
   MaxConnVol      :=Swap(maxConnVol);
   peak_conn_used  :=Swap(peak_conn_used);
   for t:=48 downto 1
    do if serverInfo.serverName[t]=#0 then serverInfo.serverName[0]:=chr(t-1);
   end;
GetServerInformation:=(result=0);
End;



{F217/C9 [2.15c+]}
FUNCTION GetFileServerDescriptionStrings(Var companyName,
                                             VersionAndRevision,revisionDate,
                                             copyrightNotice:String
                                         ):Boolean;
{SeeAlso: GetFileServerLoginStatus, GetServerInformation. }
Var  x,xofs : word;
     request : record
               len : word;
               subf: byte;
               end         ABSOLUTE UnitReqBuffer;
     reply : record
             stuff : array [1..512] of byte;
             end           ABSOLUTE UnitReplyBuffer;
begin
With request
do begin
   len  := 1;
   subf := $c9;
   end;
F2SystemCall($17,SizeOf(request),SizeOf(reply));
companyName:=''; VersionAndRevision:='';
revisionDate:=''; copyrightNotice:='';
if result=$00
then begin

     x:=1;xofs:=x;
     while (reply.stuff[x]<>$00) and (x<512) do inc(x);
     ZStrCopy(companyName,reply.stuff[xofs],x-xofs);

     inc(x);xofs:=x; { skip 1 zero. ? skip more zero's? }
     While (reply.stuff[x]<>$00) and (x<512) do inc(x);
     ZStrCopy(VersionAndRevision,reply.stuff[xofs],x-xofs);

     inc(x);xofs:=x;
     While (reply.stuff[x]<>$00) and (x<512) do inc(x);
     ZStrCopy(revisionDate,reply.stuff[xofs],x-xofs); { mm/dd/yy }

     inc(x);xofs:=x;
     While (reply.stuff[x]<>$00) and (x<512) do inc(x);
     ZStrCopy(copyrightNotice,reply.stuff[xofs],x-xofs);
     end;

GetFileServerDescriptionStrings:=(Result=$00);
end;



{F217/D3 [2.15c+]}
FUNCTION DownFileServer (ForceFlag : Boolean) : Boolean;
Var request : record
              len : word;
              subf: byte;
              down_flag : byte;
              end           ABSOLUTE UnitReqBuffer;
BEGIN
With request
do begin
   len  := 2;
   subf := $D3;
   if ForceFlag then down_flag := $01
                else down_flag := $00;
   end;
F2SystemCall($17,SizeOf(request),0);
DownFileServer:=(result=0);
{ resultcodes: 00=successful; C6 No Console Rights ; FF Open Files}
end;


{F217/CF [3.x]}
FUNCTION DisableTransactionTracking : Boolean;
{ Caller must have console-operator rights. }
Var request : record
              len : word;
              subf: byte
              end         ABSOLUTE UnitReqBuffer;
BEGIN
With request
do begin
   len := 1;
   subf:= $CF;
   end;
F2SystemCall($17,SizeOf(request),0);
DisableTransactionTracking:=(result=0);
{ resultcodes: 00=successful; C6 No Console Rights }
end;


{F217/D0 [3.x]}
FUNCTION EnableTransactionTracking : Boolean;
{ Caller must have console-operator rights. }
Var request : record
              len : word;
              subf: byte
              end         ABSOLUTE UnitReqBuffer;
BEGIN
With request
do begin
   len := 1;
   subf:= $D0;
   end;
F2SystemCall($17,SizeOf(request),0);
EnableTransactionTracking:=(result=0);
{ resultcodes: 00=successful; C6 No Console Rights }
end;


{F217/CB [2.15c+]}
FUNCTION DisableFileServerLogin : Boolean;
{ Caller must have console-operator rights. }
Var request : record
              len : word;
              subf: byte
              end        ABSOLUTE UnitReqBuffer;
BEGIN
With request
do begin
   len := 1;
   subf:= $CB;
   end;
F2SystemCall($17,SizeOf(request),0);
DisableFileServerLogin:=(result=0);
{ resultcodes: 00=successful; C6 No Console Rights }
end;



{F217/CC [2.15c+]}
FUNCTION EnableFileServerLogin : Boolean;
{ Caller needs console-operator rights. }
Var request : record
              len : word;
              subf: byte
              end         ABSOLUTE UnitReqBuffer;
BEGIN
With request
do begin
   len := 1;
   subf:= $CC;
   end;
F2SystemCall($17,SizeOf(request),0);
EnableFileServerLogin:=(result=0);
{ resultcodes: 00=successful; C6 No Console Rights }
end;



{F217/CD [2.15c+]}
FUNCTION GetFileServerLoginStatus( Var LoginEnabled:Boolean ): Boolean;
{ if Login is enabled then returns TRUE in LoginEnabled }
{ result byte:  00h  - Success, C6h No Console Rights }
{ Caller must have operator status.}
Var Reply  : record
             Flag    : Byte;
             end            ABSOLUTE UnitReplyBuffer;
   Request : record
             Len     : Word;
             SubF    : Byte;
             end            ABSOLUTE UnitReqBuffer;
begin
with Request
do begin
   Len     := 1;
   SubF    := $CD;
   end;
F2SystemCall($17,SizeOf(request),SizeOf(reply));
LoginEnabled:=Boolean(Reply.Flag);
GetFileServerLoginStatus := (result=0);
end;


{F217/C8 [2.15c+]}
FUNCTION CheckConsolePrivileges : Boolean;
Var Request : record
              Len  : Word;
              SubF : Byte;
              end         ABSOLUTE UnitReqBuffer;
begin
with Request
do begin
   Len  := 1;
   SubF := $C8;
   end;
F2SystemCall($17,SizeOf(request),0);
CheckConsolePrivileges := (Result=$00);
{ result byte:  00h  - Success, C6h No Console Rights }
end;


{F217/E6 [3.x]}
FUNCTION GetBinderyObjectDiskSpaceLeft
            ( ObjID : longInt;
             var SystemElapsedTime,UnusedDiskBlocks : longint;
             var RestrictionEnforced : Boolean             ) : Boolean;
{ Caller needs console-operator rights. }
Var Request : record
              Len   : Word;
              SubF  : Byte;
              _objID: Longint; {hi-lo}
              end               ABSOLUTE UnitReqBuffer;
    Reply   : record
              _SysElapTime: Longint; {hi-lo} { ticks since system-up }
              _objId      : Longint; {hi-lo}
              _UnUsedDBl  : Longint; {hi-lo}
              _RestrEnforced:Byte;
              end               ABSOLUTE UnitReplyBuffer;
begin
with Request
do begin
   Len  := SizeOf(Request)-2;
   SubF := $E6;
   _objId:=Lswap(objID); {force hi-lo}
   end;
F2SystemCall($17,SizeOf(request),SizeOf(reply));
if result=$00
then with reply
     do begin
        systemElapsedTime:=Lswap(_sysElapTime); {force lo-hi}
        UnusedDiskBlocks :=Lswap(_UnUsedDBl);   {force lo-hi}
        RestrictionEnforced:=(_RestrEnforced=$00); {00 enforced, FF not enforced }
        end;
if request._objId<>reply._objId then result:=$101;

GetBinderyObjectDiskSpaceLeft:=(Result=0);
{ Resultcodes: 00: successful; C6 No Console Rights }
end;


{F217/DB [2.15c+]}
FUNCTION GetConnectionsOpenFiles
           ( ConnID,ConnNumber  : Byte;
     {i/o:}  var LastRecordSeen : word;
     {out:}  var FileInfo: TfileInfoRecord ) : Boolean;

{ the calling workstation must have console operator privileges }
{ LastRecordSeen is an i/o parameter;
  -An initial value of 0 has to be supplied;
  -The function can be called until LastRecordSeen becomes 0,
   indicating the end of the FIR-list.

  to be called iteratively. }

Type Barr=array[1..14] of byte;
Var Req: record
         len:word;
         subf:byte;
         logicalConnNbr:word; {hi-lo}
         lastRecSeen:word; {hi-lo, $0000 on first call }
         end                 ABSOLUTE UnitReqBuffer;
    Reply: record
           nextReqRec : word; { hi-lo, use as lastRecSeen in next iterative call }
                              { $0000 if no more records }
           RecCount   : byte;
           FileInfoRec: TfileInfoRecord;
           fill:array[1..10] of byte;
           end               ABSOLUTE UnitReplyBuffer;
    resConnID:Byte;

{ normally a great number of File Information Records can be returned by one call.
  We have changed the function so that it returns one FIR per call. }

begin
{ !! set server with connID as preferred server !  }
GetPreferredConnectionID(resConnID);
SetPreferredConnectionID(connID);

With req
do begin
   len:=sizeof(req)-2;
   subf:=$DB;
   logicalConnNbr:=swap(connNumber); { force hi-lo }
   lastRecSeen:=swap(LastRecordSeen); { force hi-lo }
   end;
F2SystemCall($17,SizeOf(req),SizeOf(reply));
if result=$00
then begin
     if reply.recCount<>1
     then result:=$101
     else begin
          LastRecordSeen:=swap(reply.NextReqRec); { force lo-hi }
          FileInfo:=Reply.FileInfoRec;
          fileinfo.DirEntry:=swap(fileinfo.DirEntry); { force lo-hi again }
          ZstrCopy(fileInfo.filename,Barr(reply.FileInfoRec.filename),14);
          end;
     end;

{ !! reset old preferred server ! }
SetPreferredConnectionID(resConnID);

GetConnectionsOpenFiles:=(result=$00);
{ errorcodes: $00 Success; $C6 no console privileges }
end;


{F216/1A [2.x/3.x]}
FUNCTION GetPathFromDirectoryEntry( connID:word;
                                    volNbr:Byte; dirEntry:word;
                                Var Path:String                ):Boolean;
{To be used in conjunction with the GetConnectionsOpenFiles func.
 SeeAlso: GetConnectionsOpenFiles,
          GetDirectoryPath (nwDir),GetVolumeName (nwDir).}
Var Req: record
         len:word;
         subf:byte;
         _volNbr:byte;
         _dirEntry:word; {hi-lo}
         end                ABSOLUTE UnitReqBuffer;
    Reply: record
           _Path:array[1..256] of byte;
           end              ABSOLUTE UnitReplyBuffer;
    resConnID:Byte;
begin
{ !! set server with connID as preferred server !  }
GetPreferredConnectionID(resConnID);
SetPreferredConnectionID(connID);

With req
do begin
   len:=sizeof(req)-2;
   subf:=$1A;
   _volNbr:=volNbr;
   _dirEntry:=swap(dirEntry); { force hi-lo }
   end;
F2SystemCall($16,SizeOf(req),SizeOf(reply));
if result=$00
then ZstrCopy(Path,reply._path,255)
else path:='';

{ !! reset old preferred server ! }
SetPreferredConnectionID(resConnID);

GetPathFromDirectoryEntry:=(result=$00);
{ errorcodes: $00 Success; $C6 no console privileges }
end;


{F217/0E 2.15c+}
FUNCTION GetDiskUtilization(volNbr:byte; objID:Longint;
                        Var usedDirs,usedFiles,usedBlocks:Word ):Boolean;
{ SeeAlso: GetServerInformation,getBinderyObjectDiskSpaceLeft }
Var Reply   : record
              _volNbr:Byte;
              _objID:Longint; {hi-lo}
              _usedDirs,_usedFiles,_usedBlocks:Word; { all hi-lo }
              end           ABSOLUTE UnitReplyBuffer;
    Request : record
              Len  : Word;
              SubF : Byte;
              _volNbr:Byte;
              _objID:longInt; { hi-lo }
              end           ABSOLUTE UnitReqBuffer;
begin
with Request
do begin
   Len  := SizeOf(Request)-2;
   SubF := $0E;
   _volNbr:=volNbr;
   _objID:=Lswap(objID);
   end;
F2SystemCall($17,SizeOf(request),SizeOf(reply));
if result=$00
then begin
     with Reply
     do begin
        usedDirs:=swap(_usedDirs);    { force lo-hi }
        usedFiles:=swap(_usedFiles);  { force lo-hi }
        usedBlocks:=swap(_usedBlocks);{ force lo-hi }
        end;
     end;
GetDiskUtilization:=(result=$00);
{Resultcodes: 00h successful; 98h volume dosn't exist
   	      F2h no Object read privileges }
end;


{F217/12 [2.15c+]}
Function GetNetworkSerialNumber(Var serialNbr:LongInt; Var ApplicNbr:Word ):Boolean;
{return the serial number and application number for the software
	  installed on the file server}
{SeeAlso: VerifyNetworkSerialNumber,GetServerInformation}
Var Reply  : record
             _serNbr   : LongInt; {hi-lo}
             _applicNbr: Word;    {hi-lo}
             end                  ABSOLUTE UnitReplyBuffer;
   Request : record
             Len     : Word;
             SubF    : Byte;
             end                  ABSOLUTE UnitReqBuffer;
begin
with Request
do begin
   Len     := 1;
   SubF    := $12;
   end;
F2SystemCall($17,SizeOf(request),SizeOf(reply));
with reply
do begin
   ApplicNbr:=swap(_applicNbr);   { force lo-hi }
   serialNbr:=Lswap(_serNbr);     { force lo-hi }
   end;
GetNetworkSerialNumber := (result=0);
end;



{F217/OC [2.15c+]}
Function VerifyNetworkSerialNumber(serialNbr: LongInt ;
                               Var ApplicNbr: Word     ):Boolean;
{if the network serial number to be verified is correct, the reply
	  buffer will contain the corresponding application number }
{SeeAlso: GetNetworkSerialNumber}
Var Reply  : record
             _applicNbr: word; {hi-lo}
             end                ABSOLUTE UnitReplyBuffer;
   Request : record
             Len        : Word;
             SubF       : Byte;
             _netwSerNbr: LongInt; {hi-lo}
             end                ABSOLUTE UnitReqBuffer;
begin
with Request
do begin
   Len     := 1;
   SubF    := $0C;
   _netwSerNbr:=Lswap(serialNbr);
   end;
F2SystemCall($17,SizeOf(request),SizeOf(reply));
with reply
do begin
   ApplicNbr:=swap(_applicNbr); { force lo-hi }
   end;
VerifyNetworkSerialNumber := (result=0);
end;


{****************** secondary functions ************************************}


{OLD E3 Call, used by CheckNetwareVersion}
Function GetE3ServerInformation (Var serverInfo:TserverInfo):boolean;
Var  Reg            : Registers;
     RequestBuffer  : Record
                      PacketLength : Integer;
                      FunctionVal  : Byte;
                      End;
     Replylength:word ABSOLUTE serverInfo;
     t:byte;
Begin
With RequestBuffer
Do Begin
   PacketLength := 1;
   FunctionVal := $11;
   End;
ReplyLength := $80;
With Reg
Do Begin
   Ah := $e3;
   Ds := Seg(RequestBuffer);
   Si := Ofs(RequestBuffer);
   Es := Seg(ServerInfo);
   Di := Ofs(ServerInfo);
   End;
MsDos(Reg);
result:=reg.AL;
GetE3ServerInformation:=(result=0);
End;


FUNCTION CheckNetwareVersion(MinimumVersion,MinimumSubVersion,
                             MinimumRevision,MinimumSFT,MinimumTTS:word):Boolean;
{ checks if the current OS/TTS/SFT version is greater or equal to the minimal version }
Var info:TserverInfo;
    res:boolean;
begin
IF GetServerInformation(info) OR GetE3ServerInformation(info)
then begin
     IF (info.NetwareVersion>MinimumVersion)
       then res:=true
       else if (info.NetwareVersion=MinimumVersion)
               AND (info.NetwareSubVersion>MinimumSubVersion)
            then res:=true
            else if (info.NetwareVersion=MinimumVersion)
                    AND (info.NetwareSubVersion=MinimumSubVersion)
                    AND (info.OS_Revision>=MinimumRevision)
                 then res:=true
                 else res:=false
     end
else res:=false;

CheckNetwareVersion:=res AND (info.SFT_Level>=MinimumSFT)
                         AND (info.TTS_Level>=MinimumTTS)
end;


end. {unit nwServ}