{$X+,V-,B-}
Program tstacct;


uses nwBindry,nwConn,nwAcct;

CONST testObjName='TEST';

Var connId    :byte;
    currServer:string;
    balance,limit,holds      :Longint;
    newBalance,newLimit      :LongInt;
    nCharge,nCancelHoldAmount:Longint;
    oldBalance,Oldholds      :LongInt;

begin
If NOT AccountingInstalled
 then begin
      writeln('error#:',nwAcct.result);
      write('Err:Accounting isn''t installed on the current effective server:');
      GetEffectiveConnectionID(ConnID);
      GetFileServerName(connId,currServer);
      writeln(currServer);
      exit; { exit program }
      end;

AddAccountingServer('SUPERVISOR',OT_USER);


IF GetAccountStatus(testObjName,OT_USER,balance,limit,holds)
  then begin
       writeln('Current account status for user ',testObjName,' :');
       writeln('Balance     :',balance);
       writeln('Credit Limit:',limit);
       writeln('Holds       :',holds);
       end
  else writeln('Err: GetAccountStatus failed. error #',nwAcct.result);

writeln('Setting new account values..');
newBalance:=1020304;
newLimit:=123456;
IF NOT SetAccountStatus(testObjName,OT_USER,newBalance,newLimit)
 then writeln('Err: SetAccountStatus failed. error #',nwAcct.result);

IF GetAccountStatus(testObjName,OT_USER,balance,limit,holds)
  then begin
       writeln('Current account status for user ',testObjName,' :');
       writeln('Balance     :',balance);
       writeln('Credit Limit:',limit);
       writeln('Holds       :',holds);
       if (balance<>newBalance) or (newLimit<>Limit)
        then writeln('Err: the new account values where not set!');
       end
  else writeln('Err: GetAccountStatus failed. error #',nwAcct.result);

OldBalance:=balance;
nCharge:=100;
nCancelHoldAmount:=0;
Writeln('Submitting an account charge. charge=',ncharge,',CancelHold=',ncancelholdamount);
IF NOT SubmitAccountCharge(testObjName,OT_USER,nCharge,nCancelHoldAmount,
                           OT_USER,0,'no note')
 then writeln('Err: SubmitAccountCharge failed. error #',nwAcct.result);

IF GetAccountStatus(testObjName,OT_USER,balance,limit,holds)
  then begin
       writeln('Current account status for user ',testObjName,' :');
       writeln('Balance     :',balance);
       writeln('Credit Limit:',limit);
       writeln('Holds       :',holds);
       if (balance<>(oldBalance-nCharge))
        then writeln('Err: the account charge was not carried out !');
       end
  else writeln('Err: GetAccountStatus failed. error #',nwAcct.result);


OldBalance:=balance;
nCharge:=-200;
nCancelHoldAmount:=0;
Writeln('Submitting a NEGATIVE account charge. charge=',ncharge,',CancelHold=',ncancelholdamount);
Writeln(' (in fact increasing the balance of the ',testObjName,' object.');
IF NOT SubmitAccountCharge(testObjName,OT_USER,nCharge,nCancelHoldAmount,
                           OT_USER,0,'no note')
 then writeln('Err: SubmitAccountCharge failed. error #',nwAcct.result);

IF GetAccountStatus(testObjName,OT_USER,balance,limit,holds)
  then begin
       writeln('Current account status for user ',testObjName,' :');
       writeln('Balance     :',balance);
       writeln('Credit Limit:',limit);
       writeln('Holds       :',holds);
       if (balance<>(oldBalance-nCharge))
        then writeln('Err: the account charge was not carried out !');
       end
  else writeln('Err: GetAccountStatus failed. error #',nwAcct.result);

OldHolds:=holds;
writeln('Submit an hold in the amount of 1234');
IF SubmitAccountHold(testObjName,OT_USER,1234)
 then begin
      GetAccountStatus(testObjName,OT_USER,balance,limit,holds);
      writeln('Current account status for user ',testObjName,' :');
      writeln('Balance     :',balance);
      writeln('Credit Limit:',limit);
      writeln('Holds       :',holds);

      if (holds<>(OldHolds+1234))
        then writeln('Err: the account hold was not carried out !');
      end
 else writeln('Err: SubmitAccountHold failed. error #',nwAcct.result);

Writeln('Submit a charge of 1000, unhold 1234');
OldHolds:=holds;
nCharge:=1000;
nCancelHoldAmount:=1234;
IF SubmitAccountCharge(testObjName,OT_USER,nCharge,nCancelHoldAmount,
                       OT_USER,0,'no note')
 then begin
      GetAccountStatus(testObjName,OT_USER,balance,limit,holds);
      writeln('Current account status for user ',testObjName,' :');
      writeln('Balance     :',balance);
      writeln('Credit Limit:',limit);
      writeln('Holds       :',holds);

      if (holds<>(OldHolds-1234))
        then writeln('Err: the account hold was not carried out !');
      end
 else writeln('Err: SubmitAccountHold failed. error #',nwAcct.result);

IF DeleteAccountHolds(testObjName,OT_USER)
 then begin
      writeln('All further holds bythis accounting server were released.');
      GetAccountStatus(testObjName,OT_USER,balance,limit,holds);
      writeln('Current account status for user ',testObjName,' :');
      writeln('Balance     :',balance);
      writeln('Credit Limit:',limit);
      writeln('Holds       :',holds);
      end
 else writeln('Err: DeleteAccountHolds failed. error #',nwAcct.result);

IF SubmitAccountNote(testObjName,OT_USER,
                     OT_USER,0,'<<TEST OF ACCOUNTNOTE>>')
   then begin
        writeln('Accountnote was submitted correctly.');
        writeln('Please use a hexeditor and have look at \system\net$acct.dat');
        writeln('to check if the accountnote was added to the file.');
        end
  else writeln('Err: SubmitAccountNote failed. error #',nwAcct.result);

end.