{$B-,V-,X+}
Program ScanBind; {as of 931229}

Uses nwMisc,nwComm,nwBindry;

Type string30=string[30];
     PobjRec=^objRec;
     objRec=Record
            objId:LongInt;
            name:string30;
            next:PobjRec;
            end;

Var PstartObj:Pobjrec;

procedure WriteReadSecurity(sec:Byte);
begin
Case LoNibble(Sec) of
   BS_ANY_READ       :write('Any (0)');
   BS_LOGGED_READ    :write('Log (1)');
   BS_OBJECT_READ    :write('Obj (2)');
   BS_SUPER_READ     :write('Sup (3)');
   BS_BINDERY_READ   :write('Netw(4)');
   else writeln('Unknown. (Read Rights Flag=$',HexStr(LoNibble(Sec),2),')');
end;{case}
end;

Procedure WriteWriteSecurity(Sec:Byte);
begin
Case (HiNibble(Sec) SHL 4) of
   BS_ANY_WRITE      :write('Any (0)');
   BS_LOGGED_WRITE   :write('Log (1)');
   BS_OBJECT_WRITE   :write('Obj (2)');
   BS_SUPER_WRITE    :write('Sup (3)');
   BS_BINDERY_WRITE  :write('Netw(4)');
   else writeln('Unknown. (Write Rights Flag=$',HexStr(HiNibble(Sec) SHL 4,2),')');
end; {case}
end;

Procedure PutInLinkedList(objId:LongInt;objName:String;objType:Word);
Var rp,np,lp:PobjRec;
    lName:string;
begin
lName:=objname;
if lName[0]>#20 then lName[0]:=#20; { shorten object name; }
New(np);
if objType=OT_USER
 then lname:=lname+' (User)'
 else if objType=OT_USER_GROUP
      then lname:=lname+' (Group)';
np^.name:=lname;
np^.objId:=objId;
np^.next:=NIL;
If PstartObj=NIL
 then PstartObj:=np
 else begin
      lp:=PstartObj;
      while (lp^.next<>NIL) do lp:=lp^.next;
      lp^.next:=np;
      end;
end;

Function getNameFromLL(id:Longint):String;
Var rp:PobjRec;
begin
rp:=PstartObj;
While ((rp<>NIL) and (rp^.objId<>id)) do rp:=rp^.next;
if rp=NIL then getNameFromLL:='!error: ID not found in stored ID List.'
          else getNameFromLL:=rp^.name;
end;

Procedure ShowSet(pset:PropertyType);
Var i:Byte;
    objId:LongInt;
begin
{ A segment of a set-property consists of a list of object IDs,
  each ID 4 bytes long, stored hi-lo.
  The end of the list (within THIS segment) is marked by an ID of 00000000. }
i:=1;
Repeat
 objId:=MakeLong((pset[i] *256 +pset[i+1]), ( pset[i+2] *256 + pset[i+3] ) );
 if objId<>0
  then writeln('    *',GetNameFromLL(objId),'(',HexStr(objId,8),')');
 inc(i,4);
Until (i>128) or (objId=0);
end;

Procedure DumpPropVal(DontSkipZeros:boolean;pv:propertyType);
Var t,g,skip:Byte;
    c:char;
    s:string;
begin
if DontSkipZeros
 then skip:=7
 else begin
      skip:=128;
      while (pv[skip]=$00) and (skip>1) do dec(skip);
      skip:=(skip-1) DIV 16;
      end;
t:=0;
While t<=skip
do begin
   s:='';
   write('    *');
   for g:=1 to 16
   do begin
      write(HexStr(pv[t*16+g],2),' ');
      c:=chr(pv[t*16+g]);
      if c>=' ' then s:=s+c else s:=s+' ';
      end;
   writeln(s);
   inc(t);
   end;
end;


Var lastObjSeen:LongInt;
    objName:String;
    objType:Word;
    objId:LongInt;
    objFlag:Byte;
    objSec:Byte;
    objHasProp:Boolean;

    SecAccessLevel:Byte;
    MyObjId:LongInt;

    SeqNumber:LongInt;
    propName:String;
    propFlags,propSecurity:Byte;
    propHasValue,moreProperties:Boolean;

    SegNbr:Byte;
    propValue:propertyType; { array[1..128] of byte }
    moreSeg:boolean;

    tempString:String;

begin
Writeln('ScanBind V1.2');
Writeln('Provides information about all accessible bindery objects.');

If NOT (IpxInitialize and IsShellLoaded)
 then begin
      writeln('Error: Scanbind requires:');
      writeln('       -IPX to be loaded;');
      writeln('       -The Netware Shell to be loaded.');
      halt(1);
      end;

GetBinderyAccessLevel(SecAccessLevel,MyObjId);
write('All objects with a read security level <= ');
WriteReadSecurity(SecAccessLevel); writeln(' will be shown.');
writeln;

{ put all objects in a table}
lastObjSeen:=-1;
PstartObj:=NIL;

While ScanBinderyObject('*',OT_WILD,lastObjSeen,
                        objName,objType,objID,objFlag,objSec,objHasProp)
  do PutInLinkedList(objId,objName,objType);

if nwBindry.Result<>$FC { no such object }
 then writeln('Error Scanning Objects: $',HexStr(nwBindry.Result,2));


{ show all objects and asociated properties/values:}
lastObjSeen:=-1;

While ScanBinderyObject('*',OT_WILD,lastObjSeen,
                        objName,objType,objID,objFlag,objSec,objHasProp)
do begin
   writeln(HexStr(objId,8),' ',objName);

   write('The object type is :');
   Case objType of
      OT_UNKNOWN                     :writeln('Unknown Object Type ');
      OT_USER                        :writeln('User ');
      OT_USER_GROUP                  :writeln('User group ');
      OT_PRINT_QUEUE                 :writeln('Print Queue ');
      OT_FILE_SERVER                 :writeln('Fileserver ');
      OT_JOB_SERVER                  :writeln('Jobserver ');
      OT_GATEWAY                     :writeln('Gateway ');
      OT_PRINT_SERVER                :writeln('Printserver ');
      OT_ARCHIVE_QUEUE               :writeln('Archive Queue ');
      OT_ARCHIVE_SERVER              :writeln('Archive Server ');
      OT_JOB_QUEUE                   :writeln('Job Queue ');
      OT_ADMINISTRATION              :writeln('Administration Object');
      OT_NAS_SNA_GATEWAY             :writeln('NAS SNA Gateway ');
      OT_REMOTE_BRIDGE_SERVER        :writeln('Remote Bridge Server ');
      OT_ASYNC_BRIDGE_SERVER         :writeln('Asynchrone Comm. Bridge Server ');
      OT_TCPIP_GATEWAY               :writeln('TCP/IP Gateway ');
      OT_X25_BRIDGE                  :writeln('X.25 Bridge ');
      OT_X25_GATEWAY                 :writeln('X.25 Gateway ');
      OT_TIME_SYNCHRONIZATION_SERVER :writeln('Time Synchronization Server ');
      OT_ARCHIVE_SERVER_DYNAMIC_SAP  :writeln('Archive Server (Dynamic SAP) ');
      OT_DI3270_GATEWAY              :writeln('DI3270 Gateway ');
      OT_ADVERTISING_PRINTSERVER     :writeln('Printserver ');
      OT_BTRIEVE_VAP                 :writeln('Btrieve VAP ');
      OT_BTRIEVE_5_SERVER            :writeln('Btrieve 5.x server ');
      OT_PRINT_QUEUE_USER            :writeln('Print Queue User ');
      OT_X25_BRIDGE                  :writeln('X.25 Bridge ');
      OT_DI3270_GATEWAY              :writeln('DI 3270 Gateway ');
      OT_NETWARE_SQL_SERVER          :writeln('NW SQL Server ');
      OT_XTREE_NETWORK               :writeln('XTree Network ');
      OT_WANCOPY_UTILITY             :writeln('Wancopy Utility ');
      OT_TES_NETWARE_FOR_VMS         :writeln('TES NW for VMS ');
      OT_NETWARE_ACCESS_SERVER       :writeln('NW Access Server ');
      OT_PORTABLE_NETWARE            :writeln('Portable Netware ');
      OT_BINDERY                     :writeln('Bindery ');
      OT_ORACLE_DATABASE_SERVER      :writeln('Oracle Dtabase Server ');
      OT_COMMUNICATIONS_EXEC         :writeln('Communications Exec ');
      OT_NNS_DOMAIN                  :writeln('NNS Domain ');
      OT_NW386_PRINT_QUEUE           :writeln('NW 386 Print Queue ');
      OT_LANSPOOL_SERVER             :writeln('LanSpool Server ');
      OT_BTRIEVE_4_SERVER            :writeln('Btrieve 4.x Server ');
      OT_EICON_ROUTER                :writeln('EICON Router ');
      OT_ARCSERVE_30                 :writeln('ArcServe 3.0 ');
      OT_EMERALD_BACKUP              :writeln('Emerald Backup ');
      OT_POWERCHUTE                  :writeln('Powerchute ');
      OT_COMPAQ_IDA_STATUS_MONITOR   :writeln('Compaq IDA status Monitor ');
      OT_RSPCX_SERVER                :writeln('RSPCX Server (Rconsole) ');
      OT_CSA_MUX                     :writeln('CSA MUX ');
      OT_CSA_LSA                     :writeln('CSA LSA ');
      OT_CSA_CM                      :writeln('CSA CM ');
      OT_CSA_SMA                     :writeln('CSA SMA ');
      OT_CSA_DBA                     :writeln('CSA DBA ');
      OT_CSA_NMA                     :writeln('CSA NMA ');
      OT_CSA_SSA                     :writeln('CSA SSA ');
      OT_CSA_STATUS                  :writeln('CSA Status ');
      OT_CSA_APPC                    :writeln('CSA Appc ');
      OT_CSA_TEST                    :writeln('CSA Test ');
      OT_CSA_TRACE                   :writeln('CSA Trace ');
      OT_NNS_DOMAIN                  :writeln('NNS Domain ');
      OT_NNS_PROFILE                 :writeln('NNS Profile ');
      OT_NW386_PRINT_QUEUE           :writeln('NW386 Print Queue ');
      OT_COMPAQ_SNMP_AGENT           :writeln('Compaq SNMP Agent ');
      OT_HP_LASERJET                 :writeln('HP Laserjet ');
      OT_PC3M                        :writeln('PC3M (? tapebackup) ');
      OT_ARCSERVE_40                 :writeln('ArcServe 4.0 ');
      OT_NETWARE_SQL                 :writeln('Netware SQL ');
      OT_SITE_LOCK_VRS_FILES         :writeln('SiteLock -Vrs_files ');
      OT_SITE_LOCK_CHECKS            :writeln('SiteLock -checks ');
      OT_SITE_LOCK                   :writeln('SiteLock ');
      OT_SITE_LOCK_APPLICATIONS      :writeln('SiteLock -applications ');
      OT_SITE_LOCK_2                 :writeln('SiteLock ');
      OT_SITE_LOCK_SERVER            :writeln('SiteLock Server ');
      OT_SITE_LOCK_USER              :writeln('SiteLock User ');
      OT_RABBIT_GATEWAY              :writeln('Rabbit Gateway ');
      OT_PEGASUS_MAIL                :writeln('Pegasus Mail ');
      OT_TAPEWARE_AGENT              :writeln('TapeWare File System Agent ');
      OT_TAPEWARE                    :writeln('TapeWare NLM ');
      OT_QNT_ACCESS_WS               :writeln('QNT Access ');
      $8002                          :writeln('Intel Lanport / Netport ');

      else writeln('objType=',objType,' (unknown)');
   end; {case}

   Case objFlag of
    0:writeln('The object is a static object.');
    1:writeln('The object is a dynamic object.');
    else writeln('Unknown objectFlag:',objFlag);
   end; {case}

   write('Security: Read: ');WriteReadSecurity(objSec);
   write(' / Write: ');WriteWriteSecurity(objSec); writeln;

   if objHasProp
    then begin
         SeqNumber:=-1;
         writeln('The object has the following properties:');

         While ScanProperty({in}  objName,objType,'*',
                            {i/o} SeqNumber,
                            {out} propName,propFlags,propSecurity,
                                  propHasValue,moreProperties)
         do begin
            write('  ',propName);

            if HiNibble(propFlags)=0
             then write ('  (Static')   { 0 }
             else write ('  (Dynamic');  { 1 }

            Case LoNibble(propFlags) of
             BF_ITEM:writeln(' Item-Property)');
             BF_SET :writeln(' Set-Property)');
             else writeln(' property), Property type=  ',LoNibble(propFlags),' (Unknown, not Item or Set)');
            end; {case}

            write('    Security: Read: ');WriteReadSecurity(propSecurity);
            write(' /Write: ');WriteWriteSecurity(propSecurity); writeln;

          { show value of properties: }
            if propHasValue
             then begin
                  if LoNibble(propFlags)=BF_SET
                   then begin
                        SegNbr:=1;

                        While ReadPropertyValue(objName,objType,propName,SegNbr,
                                                propValue,moreSeg,propFlags)
                         do begin
                            ShowSet(propValue);
                            inc(SegNbr);
                            end;
                        If nwBindry.Result<>$EC { no such segment }
                         then writeln('Error Reading Property Values: $',
                                       HexStr(nwBindry.Result,2));
                        end
                   else begin { item property }
                        if propName='IDENTIFICATION'
                         then begin
                              getRealUserName(objName,tempString);
                              writeln('    *',tempString)
                              end
                        else if propname='Q_DIRECTORY'
                         then begin
                              { asciiz string in 1st seg }
                              SegNbr:=1;
                              IF ReadPropertyValue(objName,objType,propName,SegNbr,
                                                   propValue,moreSeg,propFlags)
                              then begin
                                   ZStrCopy(tempString,propValue,127);
                                   writeln('    *',tempString);
                                   end
                              end
                        else if propname='ACCOUNT_BALANCE'
                         then begin
                              { conversion of 1st 4 bytes to longint }
                              SegNbr:=1;
                              IF ReadPropertyValue(objName,objType,propName,SegNbr,
                                                   propValue,moreSeg,propFlags)
                              then writeln('    *',makeLong((propvalue[1] *256 +propvalue[2]),
                                                            (propvalue[3] *256 +propvalue[4] )))
                              end
                         else begin { structure not known, dump it }
                              SegNbr:=1;
                              While ReadPropertyValue(objName,objType,propName,SegNbr,
                                                      propValue,moreSeg,propFlags)
                               do begin
                                  inc(segNbr);
                                  DumpPropVal(moreSeg,propValue);
                                  end;

                              If nwBindry.Result<>$EC { no such segment }
                                then writeln('Error Reading Property Values: $',
                                             HexStr(nwBindry.Result,2));
                              end

                        end;
                  end {if propHasValue then }
             else begin { prop has NO value }
                  writeln('    *<property has no value>');
                  end;
            end; { While scanProperty do }

         If nwBindry.Result<>$FB { no such property }
          then writeln('Error Scanning Properties: $',HexStr(nwBindry.Result,2));
         end { if objHasProp then }
    else begin { object has NO properties }
         writeln('  <object has no properties>');
         end;

   writeln;
   end;  { While scanObject }
if nwBindry.Result<>$FC { no such object }
 then writeln('Error Scanning Objects: $',HexStr(nwBindry.Result,2));
end.