{$X+,V-,B-}
program LogCon;

{ Shows the use of the GetObjectLoginControl Function. }

uses nwMisc,nwConn;

CONST TestObjName='TEST';
      { name of the object whose LOGIN_CONTROL property is read. }
      { must be of objecttype 'ot_user' }

Var li:TloginControl;
    s:string;

{
     BadLoginCount             :byte;
     AccountResetTime          :NovTimeRec;  dmy, hms valid only
     LastIntruderAdress        :TinterNetworkAdress;

     MaxConcurrentConnections  :byte;
     LoginTimes                :array[1..42] of byte;

     unknown1                  :byte;
     unknown2                  :array[1..6] of byte;
}

begin
IF NOT GetObjectLoginControl(TestObjName,1,li)
 then begin
      writeln('GetObjectLoginCntrol Failed. error#',nwConn.result);
      halt(1);
      end;

writeln('Logincontrol Information:');
writeln;
if li.AccountDisabled then writeln('The account is DISABLED.');

NovTimeRec2String(li.AccountExpirationDate,s);delete(s,1,5);
if pos('lid date &',s)>0 then s:='No expiration date set.';
writeln('Account Expires: ',s);

writeln;
writeln('Minimum Password length =',li.MinimumPasswordLength);
writeln('Days between password changes =',li.DaysBetweenPasswordChanges);

NovTimerec2String(li.PasswordExpirationDate,s);delete(s,1,5);
if pos('lid date &',s)>0 then s:='No Expiration date set.';
writeln('Password Expiration date: ',s);

write('Password control flag: ');
CASE li.PasswordControlFlag of
 0:writeln('User is allowed to change password.');
 1:writeln('Supervisor must change password.');
 2:writeln('User is allowed to change password. Passwords must be unique.');
 3:writeln('Supervisor must change passwords. Passwords must be unique.');
 else writeln('Unknown Password control Flag:',li.PasswordControlFlag);
end; {case}

writeln;
IF li.MaxGraceLoginsAllowed=0
 then writeln('Grace logins are unlimited.')
 else begin
      writeln('Max. Grace Logins: ',li.MaxGraceLoginsAllowed);
      writeln('Remaining Grace Logins: ',li.GraceLoginsRemaining);
      end;
writeln;

NovTimeRec2String(li.LastLoginTime,s);delete(s,1,5);
if pos('lid date &',s)>0 then s:='Object has never logged in.';
writeln('Last login time: ',s);

writeln;
NovTimeRec2String(li.Unknown2,s);delete(s,1,5);
if pos('lid date &',s)>0 then s:='?? time not set.';
writeln('unknown2 ??? time: ',s);

end.