{ Skeleton of the program; still to be worked out when File and Directory
  Services are finished. }


	   LastRecordSeen is an i/o parameter;
	   -An initial value of 0 has to be supplied;
	   -The function can be called until LastRecordSeen becomes 0,
	    indicating the end of the FIR-list.


	   Type TfileInfoRecord is declared in unit nwServ:

	   Type TfileInfoRecord=record
				taskNbr   :Byte;
				lockFlag  :Byte;
				AccessFlag:Byte;
				LockType  :Byte;
				volumeNbr :Byte; { 0..31 }
				DirEntry  :Word;
				FileName  :string[13];
				end;

	   LockType =  00 no lock;
		       FE file lock;
		       FF locked by Begin Share File Set

	   Bitfields for lock flags:
	    bit 0       file is locked
	    bit 1       file opened Shareable
	    bit 2       logged
	    bit 3       file opened Normal
	    bit 6       TTS holding lock
	    bit 7       Transaction Flag set on file

	   Bitfields for access flags:
	    bit 0       file open for reading by calling station
	    bit 1       file open for writing by calling station
	    bit 2       deny reads by other stations
	    bit 3       deny writes by other stations
	    bit 4       file detached
	    bit 5       TTS Holding Detach
	    bit 6       TTS Holding Open

	   The calling workstation must have console operator privileges.

SeeAlso  : GetPathFromDirectoryEntry,CheckConsolePrivileges.

Example  :

  Var lastRec: word;

      FIR:TfileInfoRecord;


  GetConnectionID(serverName,connID); { Get the connection ID of the
					current server with the function
					getConnectionID ( or determine
					the connectionID of other servers
					thru other calls ) }
  GetPreferredServer(oldConnID);
  SetPreferredServer(connID);  { Save old Preferred Server Number and
				 make server 'ConnID' the preferred
				 server. FROM NOW ON, ALL REQUESTS/
				 functions WILL BE SERVICED BY -THIS-
				 SERVER. }

  IF NOT CheckConsolePrivileges  { You can use the function
				   CheckConsolePrivileges to avoid
				   console privilege errors in the
				   getConnectionsOpenFiles Function. }
   then begin
	writeln('!error..etc..');
	halt(1)
	end;

  GetConnectionNumber(connNmbr);{ Use the getConnectionNumber to get
				  your connectionNumber (or other
				  calls to get other Object connection
				  numbers) }

  SetPreferredServer(oldConnID); { From now on, all requests/functions
				   will again be serviced by the original
				   server. Note that the
				   GetConnectionsOpenFiles function has
				   its own connectionID parameter, it
				   takes care of its own server routing. }

  LastRec:=0; (initial value must be 0 )

  While GetConnectionsOpenFiles(connID,connNmbr,lastRec,FIR)
	AND (lastRec<>0)
  do begin
     {..work with -or- analyze FIR..}
     {..filename= FIR.Filename (max 14 chars), to get full filename}
     {..call the GetPathFromDirectoryEntryFunction:}

     GetPathFromDirectoryEntry(connID,FIR.volumeNbr,FIR.DirEntry,Path);
     writeln(Path);

     end;


