include machine.e
sequence four_bytes, values_to_be_saved, returned_bits
integer demo_file
atom value_to_be_restored

puts(1,"This program will demonstrate how to save negative and positive\n")
puts(1,"integers to file after converting them into 4 bytes, and then \n")
puts(1,"read them back and re-assemble them into their original values.\n")
puts(1,"Because puts() strips off the upper 24 bits (bit 2 to the power\n")
puts(1,"of 8 to bit to the power of 31), the procedure used to convert\n")
puts(1,"negative numbers back from the four bytes made by int_to_bytes()\n")
puts(1,"needs to be modified. First of all, the eighth element, not the\n")
puts(1,"thirty-second element, is treated as the sign bit. Second, you\n")
puts(1,"subtract {255,255,255,255} from the four_elements instead of\n")
puts(1,"using not_bits(). Third, you add -1 after converting the\n")
puts(1,"adjusted four bytes to an integer using bytes_to_int().\n\n")

values_to_be_saved = {31619125,-31619125}

for values = 1 to 2 do
     four_bytes = int_to_bytes(values_to_be_saved[values])
     demo_file = open("demo.fle","wb")
     printf(1,"Saving To File: %9d\n",values_to_be_saved[values])
     for bytes = 1 to 4 do
          puts(demo_file,four_bytes[bytes])
     end for
     close(demo_file)

     four_bytes = {}
     demo_file = open("demo.fle","rb")
     for bytes = 1 to 4 do
          four_bytes = four_bytes & getc(demo_file)
     end for
     close(demo_file)

     returned_bits = int_to_bits(four_bytes[4],8)
     if returned_bits[8] = 1 then
          four_bytes =  four_bytes - 255
          value_to_be_restored = bytes_to_int(four_bytes)
          value_to_be_restored = value_to_be_restored - 1
     else
          value_to_be_restored = bytes_to_int(four_bytes)
     end if

     printf(1,"Retrieved From File: %9d\n\n",value_to_be_restored)

end for

