with Text_IO;
with SuperClass;
package body ChildClass is

	-- The child operations can either "inherit", "overide",
	-- or "overload" the parent operations. But to inherit or
	-- overide, the child class MUST invoke the parent operation with
	-- an explicit call (i.e., method inheritance is NOT
	-- automatic as with derived types).

	procedure Create( Object : in out Child_Type ) is
	begin
		SuperClass.Create( Object.Parent );
		Object.New_Data := 0;
		Object.Other_Stuff := 0;
	end;

	procedure Alter_State( Object  : in out Child_Type;
								  Alteror : in integer ) is
	begin
		-- Here's an example of inheritance with extension...
		-- First call Parent's method
		SuperClass.Alter_State( Object.Parent, Alteror );
		-- Now EXTEND the behavior by adding specialized behavior
		Object.New_Data := 25;
		Object.Other_Stuff := Alteror + 3;
	end;

	function Is_Usable( Object : in Child_Type ) return boolean is
		Result : boolean;
	begin
		Result := SuperClass.Is_Usable( Object.Parent );
		return Result;
	end;

	procedure Display( Label : in String; Object : in Child_Type ) is
		package intgr_IO is new Text_IO.Integer_IO( integer );
		use intgr_IO;
	begin
		SuperClass.Display( "<<--Inherited Class-->>**", Object.Parent );
		Text_IO.Put("   New_Data    :");
		Intgr_IO.Put( Object.New_Data );
		Text_IO.New_Line;
		Text_IO.Put("   Other_Stuff :");
		Intgr_IO.Put( Object.Other_Stuff );
		Text_IO.New_Line;
	end Display;

	procedure New_Operation is
	begin
		Text_IO.Put_Line("This is the new Operation.");
	end;

end ChildClass;

