with Text_IO;
with IO_Exceptions;
use IO_Exceptions;
with SuperClass;
with ChildClass;
procedure Inherit is

	-- Spencer Roberts, Jan 30, 1994.
	-- Please pass this example on to help eliminate
	-- the myth that OOP is not possible using Ada 83.
  
	type User_Input_Type is (P, C, Q);
	package E_IO is new Text_IO.Enumeration_IO( User_Input_Type );
	Parent   : SuperClass.Class_Type;
	Child    : ChildClass.Child_Type;
	Answer   : boolean;
	Response : User_Input_Type;
	Inc      : integer;
begin
	Inc := 0;
	Text_IO.Put_Line("This is a simple driver to test all the operations");
	Text_IO.Put_Line("of the inherited type.  This proves that the Inheritance");
	Text_IO.Put_Line("by Extension idium works using Ada 83.");
	for i in 1 .. 18 loop
		Text_IO.New_Line;
	end loop;
	Main:
	loop
		Text_IO.Put_Line("Enter P to test [P]arent, C for [C]hild, [Q]uit ->> ");
		E_IO.Get( Response );
		exit when Response = Q;
		case Response is
			when P =>
				Text_IO.Put("--------- Testing Parent Type ");
				Text_IO.Put_Line("-------------------");
				Text_IO.New_Line;

				-- call all parent operations
				SuperClass.Create( Parent );   -- state is OK
				SuperClass.Display( "<<--SuperClass-->>!!", Parent );
				SuperClass.Alter_State( Parent, 1 );  -- state is NOT_OK
				Text_IO.Put_Line("                             Parent not doing so well...");
				SuperClass.Display( "<<--SuperClass-->>!!", Parent );
				Answer := SuperClass.Is_Usable( Parent );
				if Answer = TRUE then
					SuperClass.Display( "<<--SuperClass-->>!!", Parent );
				else
					Text_IO.Put_Line("                          Parent not OK...FIXING");
					Text_IO.New_Line;
				end if;
				SuperClass.Alter_State( Parent, 0 );
				Answer := SuperClass.Is_Usable( Parent );
				if Answer = TRUE then
					SuperClass.Display( "<<--SuperClass-->>!!", Parent );
				else
					Text_IO.Put_Line("Parent not OK...");
				end if;
				SuperClass.Alter_State( Parent, Inc );  -- state is uncertain
				Text_IO.Put_Line("                       Parent's state depends on loop...");
				SuperClass.Display( "<<--SuperClass-->>!!", Parent );
				for i in 1 .. 5 loop
					Text_IO.New_Line;
				end loop;
			when C =>
				Text_IO.Put("********** Testing Child Type ");
				Text_IO.Put_Line("*******************");

				-- call all child operations
				ChildClass.Create( Child );
				ChildClass.Display( "<<--ChildClass-->>##", Child );
				ChildClass.Alter_State( Child, 1 );
				ChildClass.Display( "<<--ChildClass-->>##", Child );
				Answer := ChildClass.Is_Usable( Child );
				if Answer = TRUE then
					ChildClass.Display( "<<--ChildClass-->>##", Child );
				else
					Text_IO.Put_Line("                           Child not OK...FIXING");
					Text_IO.New_Line;
				end if;
				ChildClass.Alter_State( Child, 0 );
				Answer := ChildClass.Is_Usable( Child );
				if Answer = TRUE then
					ChildClass.Display( "<<--ChildClass-->>##", Child );
				else
					Text_IO.Put_Line("Child not OK...");
				end if;
				ChildClass.Alter_State( Child, Inc + 5 );
				ChildClass.Display( "<<--ChildClass-->>##", Child );
			when others => exit Main;
		end case;
		Inc := Inc + 1;
	end loop Main;
exception
	when Data_Error =>
		Text_IO.Put_Line("I said enter a P, C or Q ...");
	when others =>
		null;
end Inherit;
