with Text_IO;
package body SuperClass is

	procedure Create( Object : in out Class_Type ) is
	begin
		Object.State := OK;
		Object.Data := 0;
	end;

	procedure Alter_State( Object  : in out Class_Type;
								  Alteror : in integer ) is
	begin
		case Alteror is
			when 0 => Object.State := OK;
			when 1 => Object.State := Not_OK;
			when others => Object.State := Uncertain;
		end case;
		Object.Data := Alteror;
	end;

	function Is_Usable( Object : in Class_Type ) return boolean is
	begin
		if Object.State = OK then
			return TRUE;
		else
			return FALSE;
		end if;
	end;

	procedure Display( Label  : in String;
							 Object : in Class_Type ) is
		package O_IO is new Text_IO.Enumeration_IO( State_Type );
		package intgr_IO is new Text_IO.Integer_IO( integer );
		use O_IO;  use intgr_IO;
		S : State_Type;
	begin
		Text_IO.Put_Line( Label );
		Text_IO.Put("   State : ");
		S := Object.State;
		O_IO.Put( S );
		Text_IO.New_Line;
		Text_IO.Put("   Data  : ");
		Intgr_IO.Put(Object.Data);
		Text_IO.New_Line;
	end;

end SuperClass;

