package SuperClass is

	-- This class (and Child) demonstrate Inheritance
	-- with Extension in Ada83.  Note that this
	-- does NOT use the drived type mechanism
	-- since one cannot add data components...
	-- this technique overcomes this.  However,
	-- it does NOT provide Polymorphism.  This is
	-- done with Variant Records, but does create
	-- some recompilation issues. True OOP will
	-- come this year with Ada9X (Ada 94).

	Size : natural := 100; -- some static attribute
	type Class_Type is private;   -- the object
	type State_Type is private;   -- state variable
	Class_Exception : exception;
	procedure Create( Object : in out Class_Type );
	procedure Alter_State( Object  : in out Class_Type;
								  Alteror : in integer );
	function Is_Usable( Object : in Class_Type ) return boolean;
	procedure Display( Label  : in String;
							 Object : in Class_Type );
private
	type State_Type is ( OK, Not_OK, Uncertain );
	type Class_Type is
		record   --can be any type
			State : State_Type;
			Data  : integer;
		end record;
end;
