-- BOOK.ADA   Ver. 2.01   10-MAR-1992   Copyright 1988-1992 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- This program creates a printable "book" file from the tutorial text in
-- ADA_TUTR.DAT.  This is by no means required for the course, but is provided
-- because several users have asked for it.  Be prepared to print almost 500
-- pages!  For the format of the input data file, please see the preliminary
-- comments in ADA_TUTR.ADA.
--
with DIRECT_IO, TEXT_IO; use TEXT_IO;
procedure BOOK is
   subtype BLOCK_SUBTYPE is STRING(1 .. 64);
   package RANDOM_IO is new DIRECT_IO(BLOCK_SUBTYPE);
   DATA_FILE  : RANDOM_IO.FILE_TYPE;   -- The file from which screens are read.
   PRNT       : FILE_TYPE;                   -- The output file, to be printed.
   BLOCK      : BLOCK_SUBTYPE;               -- Block read from the input file.
   VPOS       : INTEGER;                        -- Number of the current block.
   HPOS       : INTEGER;              -- Current position within current block.
   HIGHEST_SN : INTEGER;                -- Highest screen number in the course.
   MIDDLE_SN  : INTEGER;          -- Screen number when we change output files.
   INDX       : STRING(1 .. 1984);                 -- Index from the Data File.
   ANSWER     : STRING(1 .. 80);                 -- User response to questions.
   LEN        : INTEGER;                                   -- Length of ANSWER.
   FILE_OK    : BOOLEAN := FALSE;    -- True when data file opens successfully.
   PC_WRITE   : BOOLEAN;      -- True if book file will be printed by PC-Write.
   LEGAL_NOTE : constant STRING := " Copyright 1988-92 John J. Herro ";
                       -- LEGAL_NOTE isn't used by the program, but it causes
                       -- most compilers to place this string in the .EXE file.
   procedure OPEN_INPUT_FILE is separate;
   procedure OPEN_OUTPUT_FILE(S: in STRING) is separate;
   procedure PRINT_INSTRUCTIONS is separate;
   procedure PRINT_TITLE_PAGE is separate;
   procedure PRINT_SCREEN(SN : in INTEGER) is separate;
begin
   OPEN_INPUT_FILE;
   if FILE_OK then
      PRINT_INSTRUCTIONS;
      OPEN_OUTPUT_FILE("FIRST");
      PRINT_TITLE_PAGE;
      MIDDLE_SN := (101 + HIGHEST_SN)/2;
      for SN in 101 .. HIGHEST_SN loop
         if SN = MIDDLE_SN then
            CLOSE(PRNT);
            OPEN_OUTPUT_FILE("SECOND");
         end if;
         PRINT_SCREEN(SN);
      end loop;
      PUT_LINE("Both book files are created and ready for printing.");
      RANDOM_IO.CLOSE(DATA_FILE);
      CLOSE(PRNT);
   end if;
end BOOK;

separate (BOOK)
procedure OPEN_INPUT_FILE is
   DATA_FILE_NAME : constant STRING := "ADA_TUTR.DAT";
begin
   RANDOM_IO.OPEN(DATA_FILE, RANDOM_IO.IN_FILE, DATA_FILE_NAME);
   for I in 1 .. 31 loop                 -- Read index from start of Data File.
      RANDOM_IO.READ(DATA_FILE, ITEM => BLOCK, FROM => RANDOM_IO.COUNT(I));
      INDX(64*I - 63 .. 64*I) := BLOCK;
   end loop;
   HIGHEST_SN := INTEGER'VALUE(INDX(6 .. 8));
   FILE_OK := TRUE;
exception
   when RANDOM_IO.NAME_ERROR =>
      PUT("I'm sorry.  The file " & DATA_FILE_NAME & " seems to be missing.");
   when others =>
      PUT("I'm sorry.  The file " & DATA_FILE_NAME);
      PUT_LINE(" seems to have the wrong form.");
end OPEN_INPUT_FILE;



separate (BOOK)
procedure OPEN_OUTPUT_FILE(S: in STRING) is
   OK : BOOLEAN := FALSE;                 -- True when file opens successfully.
begin
   PUT_LINE("Please type the name of the output file for the " & S & " half");
   PUT("of the tutorial:  ");
   GET_LINE(ANSWER, LEN);
   while not OK loop
      begin
         CREATE(FILE => PRNT, MODE => OUT_FILE, NAME => ANSWER(1 .. LEN));
         OK := TRUE;
      exception
         when others => null;
      end;
      if not OK then
         PUT_LINE("Unable to create file.  Please retype name:  ");
         GET_LINE(ANSWER, LEN);
      end if;
   end loop;
   NEW_LINE(2);
end OPEN_OUTPUT_FILE;

separate (BOOK)
procedure PRINT_INSTRUCTIONS is
begin
   PUT_LINE("This program creates two printable ""book"" files from the");
   PUT_LINE("tutorial text in ADA_TUTR.DAT.  This is by no means required");
   PUT_LINE("for the course, but is provided because several users have");
   PUT_LINE("asked for it.  Be prepared to print almost 500 pages!");
   NEW_LINE(2);
   PUT_LINE("If you'll be using PC-Write to print the files, I'll use");
   NEW_LINE;
   PUT_LINE("""boldface"" commands in the output files.  Otherwise, I'll");
   NEW_LINE;
   PUT_LINE("double space the output files like this and emphasize");
   PUT_LINE("                              ---------     ---------");
   PUT_LINE("text by placing hyphens below the lines like this.");
   PUT_LINE("                -------                 ---------");
   NEW_LINE;
   PUT_LINE("Will you be using PC-Write to print the files?");
   PUT     ("Please type Y or N and press Enter:  ");
   GET_LINE(ANSWER, LEN);
   NEW_LINE(2);
   while LEN > 1 and ANSWER(1) = ' ' loop         -- Ignore any leading spaces.
      ANSWER(1 .. ANSWER'LAST - 1) := ANSWER(2 .. ANSWER'LAST);
   end loop;
   PC_WRITE := ANSWER(1) = 'Y' or ANSWER(1) = 'y';
end PRINT_INSTRUCTIONS;

separate (BOOK)
procedure PRINT_TITLE_PAGE is
begin
   NEW_PAGE(PRNT);
   NEW_LINE(PRNT);
   PUT_LINE(PRNT, "   AAA   DDDD    AAA          TTTTT  U   U  TTTTT  RRRR");
   PUT_LINE(PRNT, "  A   A  D   D  A   A           T    U   U    T    R   R");
   PUT_LINE(PRNT, "  AAAAA  D   D  AAAAA   ===     T    U   U    T    RRRR");
   PUT_LINE(PRNT, "  A   A  D   D  A   A           T    U   U    T    R  R");
   PUT_LINE(PRNT, "  A   A  DDDD   A   A           T     UUU     T    R   R");
   NEW_LINE(PRNT);
   PUT_LINE(PRNT, "This is a copy of the tutorial text from ADA-TUTR, The");
   PUT_LINE(PRNT, "Interactive Ada Tutor, ver. 2.01.  BEGIN WITH SCREEN 104.");
   NEW_LINE(PRNT);
   PUT_LINE(PRNT, "            Copyright 1988-1992 John J. Herro");
   NEW_LINE(PRNT);
   PUT_LINE(PRNT, "You may copy this book, in printed or machine-readable");
   PUT_LINE(PRNT, "form, if you observe the Shareware notice in Screen 104.");
   PUT_LINE(PRNT, "Please distribute complete copies of the ADA-TUTR program");
   PUT_LINE(PRNT, "along with this book.  If you don't have a copy of");
   PUT_LINE(PRNT, "ADA-TUTR, send $10 for a trial copy or $30 for a");
   PUT_LINE(PRNT, "registered copy for full use by one individual.  Send $5");
   PUT_LINE(PRNT, "more if you prefer a 3.5"" diskette.");
   NEW_LINE(PRNT);
   PUT_LINE(PRNT, "             Software Innovations Technology");
   PUT_LINE(PRNT, "                  1083 Mandarin Drive NE");
   PUT_LINE(PRNT, "                 Palm Bay, FL  32905-4706");
   NEW_LINE(PRNT);
   PUT_LINE(PRNT, "                      (407) 951-0233");
   NEW_PAGE(PRNT);
   NEW_LINE(PRNT);
end PRINT_TITLE_PAGE;

separate (BOOK)
procedure PRINT_SCREEN(SN : in INTEGER) is
   EXPANDING  : BOOLEAN := FALSE;       -- True when expanding multiple spaces.
   PROMPTING  : BOOLEAN := FALSE;      -- True for first character in a prompt.
   BOLD       : BOOLEAN := FALSE;        -- True when text is being emphasized.
   OUT1, OUT2 : STRING(1 ..120) := (others => ' ');    -- Lines of output text.
   PLACE      : INTEGER := 1;         -- Current position within OUT1 and OUT2.
   LIMIT      : INTEGER;           -- Position of last non-space char. in OUT2.
   LINE_NUM   : INTEGER := 1;                  -- Current line being displayed.
   SPACE      : constant STRING(1 .. 69) := (others => ' ');
   procedure SHOW(C : in CHARACTER) is separate;
   procedure SCREEN_CHAR is separate;
   procedure END_OF_SCREEN is separate;
begin
   if SN = 103 then
      PUT(PRNT, SPACE(1 .. 27) & "*** X TAKES YOU HERE. ***");
      PUT_LINE(PRNT, SPACE(1 .. 17) & "Screen 103");
   else
      PUT_LINE(PRNT, SPACE & "Screen" & INTEGER'IMAGE(SN));
   end if;
   NEW_LINE(PRNT, 2);
   VPOS := 95*(CHARACTER'POS(INDX(SN*4 - 394)) - 32) +        -- Point to start
               CHARACTER'POS(INDX(SN*4 - 393)) - 32;          -- of current
   HPOS := CHARACTER'POS(INDX(SN*4 - 392)) - 32;              -- screen.
   RANDOM_IO.READ(DATA_FILE, ITEM => BLOCK, FROM => RANDOM_IO.COUNT(VPOS));
   while BLOCK(HPOS) /= '[' or EXPANDING loop     -- [ starts the control info.
      SCREEN_CHAR;
   end loop;
   END_OF_SCREEN;
end PRINT_SCREEN;

separate (BOOK.PRINT_SCREEN)
procedure SHOW(C : in CHARACTER) is
begin
   OUT1(PLACE) := C;
   if BOLD and not PC_WRITE then
      OUT2(PLACE) := '-';
   end if;
   PLACE := PLACE + 1;
end SHOW;



separate (BOOK.PRINT_SCREEN)
procedure SCREEN_CHAR is
   procedure PROCESS_CHAR is separate;
begin
   if EXPANDING then
      for I in INTEGER range 1 .. CHARACTER'POS(BLOCK(HPOS)) - 32 loop
         SHOW(' ');
      end loop;
      EXPANDING := FALSE;
   elsif PROMPTING then
      PROMPTING := FALSE;
      if BLOCK(HPOS) = 'b' then
         PUT(PRNT, "Please type a space to go on, or B to go back.");
      elsif BLOCK(HPOS) = 'q' then
         PUT(PRNT, "Please type a space to go on, or B or Q to go ");
         PUT(PRNT, "back to the question.");
      else
         PROCESS_CHAR;
      end if;
   else
      PROCESS_CHAR;
   end if;
   HPOS := HPOS + 1;
   if HPOS > BLOCK'LENGTH then
      VPOS := VPOS + 1;
      HPOS := 1;
      RANDOM_IO.READ(DATA_FILE, BLOCK, FROM => RANDOM_IO.COUNT(VPOS));
   end if;
end SCREEN_CHAR;

separate (BOOK.PRINT_SCREEN.SCREEN_CHAR)
procedure PROCESS_CHAR is
   BOLDFACE : constant CHARACTER := CHARACTER'VAL(2);          -- For PC-Write.
begin
   case BLOCK(HPOS) is
      when '{'    => PUT_LINE(PRNT, OUT1(1 .. PLACE - 1));
                     if not PC_WRITE then                -- { = CR-LF.
                        LIMIT := OUT2'LAST;
                        while LIMIT > 0 and then OUT2(LIMIT) = ' ' loop
                           LIMIT := LIMIT - 1;
                        end loop;
                        PUT_LINE(PRNT, OUT2(1 .. LIMIT));
                        OUT2 := (others => ' ');
                     end if;
                     LINE_NUM := LINE_NUM + 1;
                     OUT1 := (others => ' ');
                     PLACE := 1;
      when '@'    => EXPANDING := TRUE;                  -- @ = several spaces.
      when '^'    => SHOW(' ');                          -- ^ = bright + space.
                     if not BOLD and PC_WRITE then
                        SHOW(BOLDFACE);
                     end if;
                     BOLD := TRUE;
      when '~'    => if BOLD and PC_WRITE then           -- ~ = normal + space.
                        SHOW(BOLDFACE);
                     end if;
                     BOLD := FALSE;
                     SHOW(' ');
      when '%'    => if not BOLD and PC_WRITE then       -- % = bright.
                        SHOW(BOLDFACE);
                     end if;
                     BOLD := TRUE;
      when '`'    => if BOLD and PC_WRITE then           -- ` = normal.
                        SHOW(BOLDFACE);
                     end if;
                     BOLD := FALSE;
      when '}'    => for I in LINE_NUM .. 23 loop        -- } = go to line 24.
                        NEW_LINE(PRNT);
                        if not PC_WRITE then
                           NEW_LINE(PRNT);
                        end if;
                     end loop;
                     PROMPTING := TRUE;
      when '\'    => SHOW(' ');                          -- \ = rev. vid. + sp.
      when '$'    => if SN = 103 then                    -- $ = screen #.
                        SHOW(' '); SHOW('_'); SHOW('_'); SHOW('_');
                     else
                        SHOW('$');
                     end if;
      when '#'    => if SN = 103 then                    -- # = % completed.
                        SHOW(' '); SHOW('_'); SHOW('_');
                     else
                        SHOW('#');
                     end if;
      when others => SHOW(BLOCK(HPOS));
   end case;
end PROCESS_CHAR;

separate (BOOK.PRINT_SCREEN)
procedure END_OF_SCREEN is
   CTRL_INFO : BLOCK_SUBTYPE;          -- Control info. for the current screen.
   I         : INTEGER;                     -- Used to index through CTRL_INFO.
begin
   PUT_LINE(PRNT, OUT1(1 .. PLACE - 1));
   if PC_WRITE then
      NEW_LINE(PRNT);
   else
      LIMIT := OUT2'LAST;
      while LIMIT > 0 and then OUT2(LIMIT) = ' ' loop
         LIMIT := LIMIT - 1;
      end loop;
      PUT_LINE(PRNT, OUT2(1 .. LIMIT));
   end if;
   PLACE := 1;
   while BLOCK(HPOS) /= ']' loop    -- Read control information from Data File.
      HPOS := HPOS + 1;
      if HPOS > BLOCK'LENGTH then
         VPOS := VPOS + 1;
         HPOS := 1;
         RANDOM_IO.READ(DATA_FILE, BLOCK, FROM => RANDOM_IO.COUNT(VPOS));
      end if;
      CTRL_INFO(PLACE) := BLOCK(HPOS);
      PLACE := PLACE + 1;
   end loop;
   if CTRL_INFO(1 .. PLACE - 1) = "]" then
      PUT_LINE(PRNT, "(Program ends after this screen.)");
   elsif CTRL_INFO(1 .. PLACE - 1) = "#]" then
      PUT_LINE(PRNT, "(User types the next screen number.)");
   else
      I := 1;
      while I + 4 < PLACE loop
         PUT(PRNT, "  '" & CTRL_INFO(I) & "' " & CTRL_INFO(I+1..I+3));
         I := I + 4;
         if I = 33 then
            NEW_LINE(PRNT);
         end if;
      end loop;
      NEW_LINE(PRNT);
   end if;
   NEW_PAGE(PRNT);
   NEW_LINE(PRNT);
end END_OF_SCREEN;
