include image.e
------gfx_file.e
------By Augorian
------E-Mail : augorian@xtra.co.nz
------v 1.0
------------------------------------------------------------------
--use: save_gfx_file ( qfiles , qout_file )                     --
--                  to save all files listed in in qfiles       --
--                  to the file named in out_file               --
------------------------------------------------------------------
--use: s=load_gfx_file (file_name)                              --
--                  to load the data from the file, file_name   --
--          s[1] is the palette data (256 colors)               --
--          s[2] is the bitmap data                             --
--              to make variables clearer:                      --
--                  after loading the file do:                  --
--                  pal =s[1] ( pal is the palette sequence     --
--              sprites =s[2] ( sprites holds all the bmp data  --
--                  use: all_palette(pal/4) to setup the colors --
------------------------------------------------------------------
global procedure save_gfx_file (sequence qfiles , sequence qout_file)
sequence lngth
atom qfiles2
atom qfn
object qbitmap , qpal
sequence qsprites
lngth={0,0,0}
qfiles2  = length(qfiles)
qsprites = repeat(0,qfiles2)
for qdelay = 1 to qfiles2 do
    qbitmap = read_bitmap(qfiles[qdelay])
    if atom(qbitmap) then
	printf(1,"Error Opening Bitmap Number %d",qdelay)
	abort(1)
    end if
    qsprites[qdelay] = qbitmap[2]
end for
qpal =qbitmap[1]
qfn=open(qout_file,"wb")
for qloop = 1 to 256 do
puts(qfn,qpal[qloop][1])
puts(qfn,qpal[qloop][2])
puts(qfn,qpal[qloop][3])
end for

lngth[1]=qfiles2
lngth[2]=floor(lngth[1]/100)
lngth[3]=lngth[1]-(lngth[2]*100)
puts(qfn,lngth[2])
puts(qfn,lngth[3])

for qsprite = 1 to qfiles2 do
lngth[1]=length(qsprites[qsprite])
lngth[2]=floor(lngth[1]/100)
lngth[3]=lngth[1]-(lngth[2]*100)
puts(qfn,lngth[2])
puts(qfn,lngth[3])

lngth[1]=length(qsprites[qsprite][1])
lngth[2]=floor(lngth[1]/100)
lngth[3]=lngth[1]-(lngth[2]*100)
puts(qfn,lngth[2])
puts(qfn,lngth[3])
for qx=1  to length(qsprites[qsprite])  do
for qy=1  to length(qsprites[qsprite][qx])  do
puts(qfn,qsprites[qsprite][qx][qy])
end for
end for
end for
close(qfn)
end procedure

global function load_gfx_file (sequence file_name)
object sprites
object fn
object pal
object files2
object pos
pos={0,0}
pal=repeat({0,0,0},256)
fn=open(file_name,"rb")
for loop = 1 to 256 do
pal[loop][1]=getc(fn)
pal[loop][2]=getc(fn)
pal[loop][3]=getc(fn)
end for
files2=getc(fn)
files2=files2*100
files2=files2+getc(fn)
sprites=repeat(0,files2)
for sprite = 1 to files2 do
pos[1]=getc(fn)
pos[1]=pos[1]*100
pos[1]=pos[1]+getc(fn)
pos[2]=getc(fn)
pos[2]=pos[2]*100
pos[2]=pos[2]+getc(fn)
sprites[sprite]=repeat(repeat(0,pos[2]),pos[1])
for x=1  to pos[1] do
for y=1  to pos[2]  do
sprites[sprite][x][y]=getc(fn)
end for
end for
end for
close(fn)
return {pal,sprites}
end function
