--------------------------------SCREEN.E----------------------------------------
---------------------------Created BY Augorian----------------------------------
----------------------E-Mail : augorian@xtra.co.nz------------------------------
---------------THIS IS ONLY FOR USE IN GRAPHICS_MODE 19-------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--ALL Co-Ordinates for these procedures are given in the form : {Y,X}
--------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--Procedures:
-------------
--set_screens(atom x)   --Sets the number of screens that are available
			--for use with the other procedures.
			--NOTE that each screen will require 64000 bytes
			--so 6 screens will require 375 KBytes.
-------------------------------------------------------------------------------
--screen_copy(atom dest , atom source)
			--Makes screen number[dest] the same as 
			--screen number[source]
-------------------------------------------------------------------------------

--CLS(atom u)           --Sets all pixels of screen number u to 0.
			--(CLears the Screen)
-------------------------------------------------------------------------------
--poke_screen(atom u)   --Sticks the pixels of screen number u into
			    --video memory.
			    --Must call graphics_mode(19) first or
			    --you will not get any screen output.
-------------------------------------------------------------------------------
--display(sequence p , sequence s , atom u)
			--Displays image s at point p on screen u.
			--s is a sequence of sequences , loaded using
			    --read_bitmap()  OR my load_gfx_file().
			--p is a position between {0,0} and {199,319} inclusive.
			--u is the screen number on which to display the image.
			
			--This procedure will ignore pixels of color 0,
			    --so if you want see-through areas on an image,
			    --make sure they are color 0.
			--You must make sure that the image will fit on the
			    --screen without going over any of the edges,
			    --DISPLAYING IMAGES OFF THE SCREEN WILL CRASH!
			--If you do not need see-through areas, use fdisplay()
			    --as fdisplay() is faster than display()
-------------------------------------------------------------------------------
--fdisplay(sequence p , sequence s , atom u)
			--This procedure is the same as display except that
			--it will NOT check for blank spaces, all pixels
			--will be drawn.
			--This procedure is also faster than display()
-------------------------------------------------------------------------------
--color_display(sequence p , sequence s , atom u , atom c)
			--This procedure is the same as display except that
			--it will add the value of c to all pixels
			    --it can be used for things such as changing
			    --the color of an image without having to
			    --create a whole new image.
-------------------------------------------------------------------------------
--display_clip(sequence p , sequence s , atom u)
			--This procedure is the same as display except that
			--there is no need to worry about fitting the image
			--inside the screen boundarys, the procedure makes sure
			--that anything to be drawn outside the screen
			--is not drawn.
			    --this is useful for when an image needs to be
			    --drawn part of it off the screen.
-------------------------------------------------------------------------------
--fdisplay_clip(sequence p , sequence s , atom u)
			--This procedure is the same as fdisplay except that
			--there is no need to worry about fitting the image
			--inside the screen boundarys, the procedure makes sure
			--that anything to be drawn outside the screen
			--is not drawn.
-------------------------------------------------------------------------------
--pal = load_fonts(sequence f)
			--this procedure loads the fonts to be used with
			--font_type()
			    --f is a sequence of file names eg.
			    --f={"font1.fnt","font2.fnt","font3.fnt"}
			--pal will be the palette sequence of the first
			    --font that is loaded.
			--a font file is created by using save_gfx_file()
			--it requires 128 bitmap images, from 000 to 127,
			--each one represents its respective ASCII value.
			    --The files "12x12.fnt" and "6x6.fnt" are included
			    --
		    --------------
			--fonts may be multi colored but its best to keep
			--to one color unless you know what youre doing,
			--otherwise you will get messy font colors.
		    --------------
			--tip: keep the font palette the same as that
			--used by the rest of your graphics!
-------------------------------------------------------------------------------
--font_type(sequence p , sequence t , object c , atom f , atom u)
			--displays the sequence of letters t , at position p
			--on screen number u , with color c and font number f.
		---------------------
			--p is the position ..{Y,X}
			--The text must fit on the screen or it will crash
			--so make sure you dont make the text too long!
		---------------------
			--t must be a sequence, if a single letter is desired,
			--it must still be a sequence.
		---------------------
			--If c is an atom then the entire text is that color.
			    --If c is a sequence then it must be the same length
			    --as the sequence t, each letter will be it
			    --corrisponding color. eg
				--f="RED BLUE"
				--c={4,4,4,0,1,1,1,1}
				--red will be colored red and blue will be blue.
		---------------------
			--f is the font number to use.
			--It must be between 1 and the number of fonts loaded.
			--u is the screen number to display the text on.
-------------------------------------------------------------------------------
include gfx_file.e

global integer SCREENS
global sequence screen
global sequence font
SCREENS=1
screen=repeat(repeat(repeat(0,320),200),SCREENS)
font={}

-------------------------------------------------------------------------------
global procedure set_screens(integer x)
    SCREENS=x
    screen=repeat(repeat(repeat(0,320),200),SCREENS)
end procedure--set_screens
-------------------------------------------------------------------------------
global procedure screen_copy(integer dest , integer source)
    screen[dest]=screen[source]
end procedure--screen_copy
-------------------------------------------------------------------------------
global procedure CLS(integer u)
    screen[u]=repeat(repeat(0,320),200)
end procedure--CLS
-------------------------------------------------------------------------------
global procedure poke_screen(integer u)
    for y = 0 to 199 do
	poke(#A0000+(y*320),screen[u][y+1])
    end for
end procedure--poke_screen
-------------------------------------------------------------------------------
global procedure v_poke_screen(integer u , sequence lim)
    for y = lim[1] to lim[2] do
	poke(#A0000+(y*320),screen[u][y+1])
    end for
end procedure--poke_screen
-------------------------------------------------------------------------------
global procedure display(sequence p , sequence s , integer u)
integer l
l=length(s[1])
    for y = 1 to length(s) do
	for x = 1 to l do
	    if s[y][x] then --blank space check
		screen[u][y+p[1]][x+p[2]]=s[y][x]
	    end if
	end for
    end for
end procedure--display
-------------------------------------------------------------------------------
global procedure fdisplay(sequence p , sequence s , integer u)
integer l
l=length(s[1])
    for y = 1 to length(s) do
	screen[u][y+p[1]][p[2]+1..p[2]+l]=s[y]
    end for
end procedure--fdisplay
-------------------------------------------------------------------------------
global procedure color_display(sequence p , sequence s , integer u , integer c)
integer l
l=length(s[1])
    for y = 1 to length(s) do
	for x = 1 to l do
	    if s[y][x] then --blank space check
		screen[u][y+p[1]][x+p[2]]=s[y][x]+c
	    end if
	end for
    end for
end procedure--cdisplay
-------------------------------------------------------------------------------
global procedure display_clip(sequence p , sequence s , integer u)
integer l,j,a,b
j=length(s)
l=length(s[1])
a=1
b=1
if p[1] + j > 200 then
    j = 200 - p[1]
end if
if p[2] + l > 320 then
    l = 320 - p[2]
end if
if p[1]<0 then
    a=1-p[1]
end if
if p[2]<0 then
    b=1-p[2]
end if
    for y = a to j do
	for x = b to l do
	    if s[y][x] then --blank space check
		screen[u][y+p[1]][x+p[2]]=s[y][x]
	    end if
	end for
    end for
end procedure--mdisplay
-------------------------------------------------------------------------------
global procedure fdisplay_clip(sequence p , sequence s , integer u)
integer l,j,a,b
j=length(s)
l=length(s[1])
a=1
b=1
if p[1] + j > 200 then
    j = 200 - p[1]
end if
if p[2] + l > 320 then
    l = 320 - p[2]
end if
if p[1]<0 then
    a=1-p[1]
end if
if p[2]<0 then
    b=1-p[2]
end if
    for y = a to j do
	screen[u][y+p[1]][b+p[2]..l+p[2]]=s[y][b..l]
    end for
end procedure--mdisplayf
-------------------------------------------------------------------------------
global function load_fonts(sequence f)
object f_data
sequence p
font={}
    if atom (f[1]) then
	f_data=load_gfx_file(f)
	p=f_data[1]
	font=append(font,f_data[2])
    else
	for i = 1 to length(f) do
	    f_data=load_gfx_file(f[i])
	    p=f_data[1]
	    font=append(font,f_data[2])
	end for
    end if
    return p
end function--load_fonts
-------------------------------------------------------------------------------
global procedure font_type(sequence p,sequence t,object c,integer f, integer u)
integer l
l=length(font[f][1][1])+1
for i = 1 to length(t) do
    if atom(c) then
	color_display(p,font[f][t[i]+1],u,c)
    else
	color_display(p,font[f][t[i]+1],u,c[i])
    end if
    
    p[2]=p[2]+l
end for
end procedure--font_type
-------------------------------------------------------------------------------
