include image.e
include sort.e
include bitmap.e

--  << bm_demo.ex >> -- demonstration of bitmap.e routines
--  Colin Taylor - 71630.1776@compuserve.com
--  version 1.1 - 3/11/97, 6/1/97

----------------< local variables >---------------------------------------------

sequence c, m1, m2, m3, m4, r1, r2, r3, r4, s1, s2, s3, s4, t1, t2, t3, t4, w

----------------< initialize variables >----------------------------------------

c = {9,15,5,1,3,15,13,15,12,4}  -- text colors
m1 = bm_expand(bm_load("bm1.bm"),200)  -- "Euphoria" bitmap
s1 = bm_tile(bm_expand({{187},{238},{187},{238}},8),{200,60})  -- texture 1
s2 = bm_tile(bm_expand({{85},{170},{85},{170}},8),{200,60})  -- texture 2
s3 = bm_tile(bm_expand({{17},{68},{17},{68}},8),{200,60})  -- texture 3
s4 = bm_tile({{7,7,8,8},{7,8,8,7},{8,8,7,7},{8,7,7,8}},{200,60})  -- pattern
w = repeat(0, 58) & {1,1,2,3,4,5,5,6,6,5,5,4,3,2,1,1,0,0,1,1,2,3,4,4,5,
	5,4,4,3,2,1,1}              -- warp offset

----------------< local routines >----------------------------------------------

procedure pause(atom s)
-- pause for s seconds
    atom t
    t = time()+s
    while time() < t do
    end while
end procedure  -- pause

function contact(sequence a1, sequence a2)
-- checks for overlap between 2 rectangular areas and returns TRUE or FALSE
    return not (a2[2][1] < a1[1][1] or a2[2][2] < a1[1][2]
	or a2[1][1] > a1[2][1] or a2[1][2] > a1[2][2])
end function  -- contact

function overlap(sequence a1, sequence a2)
-- Returns the screen coordinates of the overlap between 2 rectangular areas 
    sequence x_list, y_list
    x_list = sort({a1[1][1], a1[2][1], a2[1][1], a2[2][1]})
    y_list = sort({a1[1][2], a1[2][2], a2[1][2], a2[2][2]})
    return {{x_list[2], y_list[2]}, {x_list[3], y_list[3]}}  -- overlap area
end function  -- overlap

procedure put_image(sequence s)
    integer x, y, x2, y2
    sequence size
    x = rand(500)-20
    y = rand(470)-30
    if contact({{x, y}, {x+199, y+59}}, {{219, 209}, {418, 268}}) then
	t1 = save_image({x, y}, {x+199, y+59})
	t2 = overlap({{x, y}, {x+199, y+59}}, {{219, 209}, {418, 268}})
	t3 = bm_trim(s, t2[1]-{x, y}+1, t2[2]-{x, y}+1)* not
		bm_trim(m1, t2[1]-{218, 208}, t2[2]-{218, 208})
	t4 = bm_insert(s, t3, t2[1]-{x, y}+1)
	display_image({x, y}, t1*not(t4)+t4)
    else
	t2 = s
	x2 = 200
	y2 = 60
	if x < 0 then
	    t2 = bm_trim(t2, {1-x, 1}, {200, 60})
	    x2 = 200+x
	    x = 0
	end if
	if y < 0 then
	    t2 = bm_trim(t2, {1, 1-y}, {x2, 60})
	    y2 = 60+y
	    y = 0
	end if
	t1 = save_image({x, y}, {x+x2-1, y+y2-1})
	display_image({x, y}, t1*not(t2)+t2)
    end if
end procedure  -- put_image

----------------< end of routines >---------------------------------------------

if graphics_mode(18) then
    puts(2, "need graphics mode 18\n")
    abort(1)
end if
bk_color(9) 
clear_screen()
m2 = m1 and not bm_shift(m1, {1, 1}, 0)   -- make highlight image
-- fade in highlight
display_image({219, 209}, (m2 and s3)*15)
pause(0.2)
display_image({219, 209}, (m2 and s2)*15)
pause(0.2)
display_image({219, 209}, (m2 and s1)*15)
pause(0.2)
display_image({219, 209}, m2*15)
pause(0.2)
-- fade in text
display_image({219, 209}, m2*15+(s3 and m1 and not m2))
pause(0.2)
display_image({219, 209}, m2*15+(s2 and m1 and not m2))
pause(0.2)
display_image({219, 209}, m2*15+(s1 and m1 and not m2))
pause(0.2)
display_image({219, 209}, m2*15+(m1 and not m2))
pause(0.2)
-- display shadow
m1 = bm_resize(m1, {0, 0}, {11, 14}, 0)  -- enlarge bitmaps to hold shadow
m2 = bm_resize(m2, {0, 0}, {11, 14}, 0)  --  "
for i = 1 to 15 do   -- extend shadow
    m3 = bm_shift(m1, {i, i}, 0)
    m4 = m3 and not m1  -- shadow image
    display_image({219, 209}, m2*15+(m1 and not m2)+m4*8)  -- and not m4
end for
pause(0.5)
-- change text colors
for i = 1 to 10 do
    display_image({219, 209}, m2*15+(m1 and not m2)*c[i]+m4*8)
    pause(0.05)
end for
pause(0.2)
for i = 15 to 1 by -1 do  -- retract shadow
    m3 = bm_shift(m1, {i-1, i-1}, 0)
    m4 = m3 and not m1
    display_image({219, 209}, m2*15+(m1 and not m2)*4+m4*8)
end for
m1 = bm_resize(m1, {0, 0}, -{11, 14}, 0)  -- put bitmaps back to original size
m2 = bm_resize(m2, {0, 0}, -{11, 14}, 0)  --  "
-- horziontal wipe to pattern
m3 = bm_trim(s1, {1, 1}, {8, 60})  -- start to build wipe mask
m4 = repeat(repeat(1, 200), 60)    --  "
m4 = bm_insert(m4, m3, {1, 1})     --  "
display_image({219, 209}, m2*15+(m1 and not m2 and m4)*4
	    +(m1 and not m2 and not m4)*s4)
m3 = bm_trim(s2, {1, 1}, {8, 60})  -- continue to build wipe mask
m4 = bm_shift(m4, {8, 0}, 0)
m4 = bm_insert(m4, m3, {1, 1})
display_image({219, 209}, m2*15+(m1 and not m2 and m4)*4
	    +(m1 and not m2 and not m4)*s4)
m3 = bm_trim(s3, {1, 1}, {8, 60})  -- finish wipe mask
m4 = bm_shift(m4, {8, 0}, 0)
m4 = bm_insert(m4, m3, {1, 1})
display_image({219, 209}, m2*15+(m1 and not m2 and m4)*4
	    +(m1 and not m2 and not m4)*s4)
for i = 1 to 14 do  -- shift wipe mask for length of text
    m4 = bm_shift(m4, {14, 0}, 0)
    display_image({219, 209}, m2*15+(m1 and not m2 and m4)*4
		+(m1 and not m2 and not m4)*s4)
end for
pause(1)
-- roll
m3 = m2*15+(m1 and not m2)*s4
for i = 1 to 60 do
    display_image({219, 209}, bm_roll(m3, {0, -i}))
end for
pause(0.5)
-- rolling warp
for i = 1 to 90 do
    w = w[90] & w[1..89]
    display_image({219, 209}, bm_warp(m3, w, 0))
    pause(0.05)
end for
pause(0.5)
-- vertical wipe to color
m3 = bm_trim(s1, {1, 1}, {200, 2})  -- start mask
m4 = repeat(repeat(1, 200), 60)
m4 = bm_insert(m4, m3, {1, 1})
display_image({219, 209}, m2*15+(m1 and not m2 and m4)*s4
	+(m1 and not m2 and not m4))
m3 = bm_trim(s2, {1, 1}, {200, 2})  -- continue mask
m4 = bm_shift(m4, {0, 2}, 0)
m4 = bm_insert(m4, m3, {1, 1})
display_image({219, 209}, m2*15+(m1 and not m2 and m4)*s4
	+(m1 and not m2 and not m4))
m3 = bm_trim(s3, {1, 1}, {200, 2})  -- finish mask
m4 = bm_shift(m4, {0, 2}, 0)
m4 = bm_insert(m4, m3, {1, 1})
display_image({219, 209}, m2*15+(m1 and not m2 and m4)*s4
	+(m1 and not m2 and not m4))
for i = 1 to 30 do  -- shift mask vertically
    m4 = bm_shift(m4, {0, 2}, 0)
    display_image({219, 209}, m2*15+(m1 and not m2 and m4)*s4
	+(m1 and not m2 and not m4))
end for
pause(0.5)
-- fade out text
display_image({219, 209}, m2*15+(s1 and m1 and not m2))
pause(0.2)
display_image({219, 209}, m2*15+(s2 and m1 and not m2))
pause(0.2)
display_image({219, 209}, m2*15+(s3 and m1 and not m2))
pause(0.2)
display_image({219, 209}, m2*15)
pause(0.2)
-- fade out highlight
display_image({219, 209}, (m2 and s1)*15)
pause(0.2)
display_image({219, 209}, (m2 and s2)*15)
pause(0.2)
display_image({219, 209}, (m2 and s3)*15)
pause(0.2)
display_image({219, 209}, (m2 and s3)*9)
pause(1)
-- bring up text
display_image({219, 209}, (m1 and s3)*7)
pause(0.2)
display_image({219, 209}, (m1 and s3)*15)
pause(0.2)
display_image({219, 209}, (m1 and s2)*15)
pause(0.2)
display_image({219, 209}, (m1 and s1)*15)
pause(0.2)
display_image({219, 209}, m1*15)
-- invert and rotate the "Euphoria" graphic
r1 = m1
t1 = r1 and bm_shift(not r1, {1, 1}, 0)
r1 = (r1 and not t1)*4+t1*15
r2 = bm_invert(r1)
t2 = r2 and bm_shift(not r2, {1, 1}, 0)
r2 = (r2 and not t2)*6+t2*15
r3 = bm_rotate(bm_rotate(r2))
t3 = r3 and bm_shift(not r3, {1, 1}, 0)
r3 = (r3 and not t3)+t3*15
r4 = bm_invert(r3)
t4 = r4 and bm_shift(not r4, {1, 1}, 0)
r4 = (r4 and not t4)*2+t4*15
-- show the inverted and rotated "Euphoria"s
while get_key() = -1 do
    put_image(r1)
    put_image(r2)
    put_image(r3)
    put_image(r4)
end while
-- reset graphics mode
if graphics_mode(-1) then
end if
