include graphics.e
include image.e
include bitmap.e

-- << bm_demo3.ex >> -- demonstration of bitmap fade in/out using filters
-- Colin Taylor - 71630.1776@compuserve.com
-- version 1.0 - 6/1/97

----------------< local variables >---------------------------------------------

sequence loc, image, mask, size, back
integer back_color
sequence filter0, filter1, filter2, filter3, filter4
sequence mask0, mask1, mask2, mask3, mask4
atom delay_time

----------------< initialize variables >----------------------------------------

-- filter bitmaps (these will be tiled to the size of the main image)
filter0 = {{1,0,0,0,1,0,0,0},  -- 12.5% of pixels turned on
	   {0,0,0,0,0,0,0,0},
	   {1,0,0,0,1,0,0,0},
	   {0,0,0,0,0,0,0,0}}
filter1 = {{1,0,0,0,1,0,0,0},  -- 25% of pixels turned on
	   {0,0,1,0,0,0,1,0},
	   {1,0,0,0,1,0,0,0},
	   {0,0,1,0,0,0,1,0}}
filter2 = {{1,0,0,1,1,0,0,1},  -- 50% of pixels turned on
	   {0,1,1,0,0,1,1,0},
	   {1,0,0,1,1,0,0,1},
	   {0,1,1,0,0,1,1,0}}
filter3 = {{1,1,0,1,1,1,0,1},  -- 75% of pixels turned on
	   {0,1,1,1,0,1,1,1},
	   {1,1,0,1,1,1,0,1},
	   {0,1,1,1,0,1,1,1}}
filter4 = {{1,1,0,1,1,1,0,1},  -- 87.5% of pixels turned on
	   {1,1,1,1,1,1,1,1},
	   {1,1,0,1,1,1,0,1},
	   {1,1,1,1,1,1,1,1}}
loc = {210, 200}
delay_time = 0.1

----------------< local routines >----------------------------------------------

procedure pause(atom seconds)
    atom t
    t = time()
    while time() < t+seconds do
    end while
end procedure  -- pause

----------------< end of routines >---------------------------------------------

if graphics_mode(18) then
    puts(2, "need graphics mode 18\n")
    abort(1)
end if

-- make a random background graphic
polygon(7, 1, {{0, 0}, {639, 0}, {639, 479}, {0, 479}})
for x = 1 to 100 do
    draw_line(rand(15), {{rand(638), rand(478)}, {rand(638), rand(478)}})
end for

-- prepare the main image, mask image and background image
image = bm_load("bm2.bm")
size = bm_size(image)
back_color = image[4][4]
mask = (image=back_color)
back = save_image(loc, loc+size-1)

-- To accomplish the fade-in effect, the mask is modified to hide a portion
-- of the foreground color(s) of the image as well as all of the background
-- color of the image.  The original mask is combined with the 5 filter
-- bitmaps to allow 12.5%, 25%, 50% 75% and 87.5% of the foreground color(s) 
-- to show.  The fade can be made smoother by using more filter steps.

mask0 = mask or bm_tile(filter0, size)  -- expand filter to size of image and
mask1 = mask or bm_tile(filter1, size)  -- combine with mask image
mask2 = mask or bm_tile(filter2, size)  -- 
mask3 = mask or bm_tile(filter3, size)  --
mask4 = mask or bm_tile(filter4, size)  --

position(5, 14)
puts(1, " Fade in / fade out of a bitmap image using filters: ")
position(24, 29)
puts(1, " Press a key to end... ")

while get_key() = -1 do
    pause(0.5)
    display_image(loc, back*mask4+image*(not mask4))  -- show 12.5% of image
    pause(delay_time)
    display_image(loc, back*mask3+image*(not mask3))  -- show 25% of image
    pause(delay_time)
    display_image(loc, back*mask2+image*(not mask2))  -- show 50% of image
    pause(delay_time)
    display_image(loc, back*mask1+image*(not mask1))  -- show 75% of image
    pause(delay_time)
    display_image(loc, back*mask0+image*(not mask0))  -- show 87.5% of image
    pause(delay_time)
    display_image(loc, back*mask+image*(not mask))  -- show 100% of image
    pause(2.5)
    display_image(loc, back*mask0+image*(not mask0))  -- 87.5%
    pause(delay_time)
    display_image(loc, back*mask1+image*(not mask1))  -- 75%
    pause(delay_time)
    display_image(loc, back*mask2+image*(not mask2))  -- 50%
    pause(delay_time)
    display_image(loc, back*mask3+image*(not mask3))  -- 25%
    pause(delay_time)
    display_image(loc, back*mask4+image*(not mask4))  -- 12.5%
    pause(delay_time)
    display_image(loc, back)  -- 0%
    pause(1.5)
    image = image+3-rand(6)  -- change color of image to relieve the monotony
end while

if graphics_mode(-1) then
end if

