-----------------------------------------------------------------------------
-- CALC - expression evaluator
--  * stores expressions in postfix (reverse polish) notation
--
-- 1.01 - divide by zero error, includable
-- by Matt Sephton (u5ms@csc.liv.ac.uk)
-----------------------------------------------------------------------------
without type_check
-----------------------------------------------------------------------------
global constant TRUE = 1, FALSE = 0
global constant numbers = "0123456789."
global constant operators = "()+-*/^"
global constant seperators = ","
global constant valid_symbols = numbers & operators & seperators
global constant operator_precedence = "(+-*/^"
global constant switches = "/V"
-----------------------------------------------------------------------------
type boolean(integer num)
    return num = 1 or num = 0
end type
-----------------------------------------------------------------------------
--valid symbol
global type valid(integer sym)
    return find(sym, valid_symbols)
end type                                                                 
-----------------------------------------------------------------------------
--operator
type operator(atom op)
    return find(op, "()+-*/^") > 0
end type
-----------------------------------------------------------------------------
function precedence(integer operator)
--operator precedence
--order: +- are 1, */ are 2, ^ is 3
    return floor((match({operator}, operator_precedence)) / 2)
end function
-----------------------------------------------------------------------------
procedure text_color(integer c)
-- set the foreground text color to c
-- why include graphics.e for one function?
    machine_proc(9, c)
end procedure
-----------------------------------------------------------------------------
global function upper(object x)
-- convert letters in atom or sequence to upper case
    return x - (x >= 'a' and x <= 'z') * ('a' - 'A')
end function
-----------------------------------------------------------------------------
procedure printRPN(sequence rpn)
--print expression as generated by toRPN
    for e = 1 to length(rpn) do
        --every other symbol in another colour
        text_color(7+8*remainder(e, 2))
        
        if sequence(rpn[e]) then        --operator
            printf(1, "%s", rpn[e][1])
        else                            --constant
            print(1, rpn[e])
        end if
    end for
    --default colour
    text_color(7)
end procedure
-----------------------------------------------------------------------------
function change(sequence symbols)
--position of next change in symbol type
    integer e
    boolean an_operator
    
    if length(symbols) > 1 then    
        e = 1
        an_operator = operator(symbols[e])
        
        if not an_operator then     --numeric
            while e < length(symbols) and operator(symbols[e]) = an_operator do
                e = e + 1
            end while
            if operator(symbols[e]) then
                return e
            else
                return e + 1
            end if
        else                        --operator
            return e + 1
        end if
    else
        return length(symbols) + 1
    end if
end function
-----------------------------------------------------------------------------
function s2a(sequence sNumber)
-- convert decimal string (sequence) to numerical value (atom)
-- this procedure is faster for me than using value()
    atom val
    integer pos
    
    val = 0
    pos = 0
    
    while pos < length(sNumber) do             --int part
        pos = pos + 1
        if sNumber[pos] >= '0' and sNumber[pos] <= '9' then
            val = val * 10 + sNumber[pos] - '0'
        else
            exit    --decimal point encountered
        end if
    end while
    
    if pos < length(sNumber) then               --fract part
        for d = pos + 1 to length(sNumber) do
            if sNumber[d] >= '0' and sNumber[d] <= '9' then
                val = val + power(10, pos-d) * (sNumber[d] - '0')
            end if
        end for
    end if
    
    return val
end function
-----------------------------------------------------------------------------
global procedure usage()
--show user usage information
    puts(1, "Usage: CALC expression [" & switches & "]\n   eg. CALC 5*(4+3)-2/1")
    abort(1)
end procedure
-----------------------------------------------------------------------------
global function toRPN(sequence infix)
--convert infix expression to rpn expression
    sequence rpn, stack
    boolean on_operator
    object g
    
    rpn = ""
    stack = ""

    while length(infix) != 0 do
        g = infix[1..change(infix)-1]
        infix = infix[change(infix)..length(infix)]

        on_operator = operator(g[1])
        
        if on_operator and atom(g[1]) then
            g = g[1]
        else
            g = s2a(g)
        end if
        
        if not on_operator then
        --constant
            rpn = append(rpn, g)                --copy(g)
        
        elsif length(stack) = 0 and on_operator then
        --first operator
            stack = prepend(stack, {g})         --push({g})
        
        elsif g = '(' then
        --left bracket (signal)
            stack = prepend(stack, {g})         --push({g})
        
        elsif g = ')' then
        --right bracket (flush until signal)
            while stack[1][1] != '(' do
                rpn = append(rpn, stack[1])     --copy(stack[c])
                stack = stack[2..length(stack)]
            end while
            stack = stack[2..length(stack)]
        
        elsif on_operator and precedence(g) <= precedence(stack[1][1]) then
        --lower or equal precedence operator
            while compare({}, stack) != 0 do
                if precedence(stack[1][1]) >= precedence(g) then
                    rpn = append(rpn, stack[1])     --copy(stack[1])
                    stack = stack[2..length(stack)]
                else
                    exit
                end if
            end while
            stack = prepend(stack, {g})             --push({g})
        
        elsif on_operator and precedence(g) > precedence(stack[1][1]) then
        --higher precedence operator
            stack = prepend(stack, {g})         --push({g})
        
        end if
    end while
    
    if length(stack) then               --some operators still on stack
        for i = 1 to length(stack) do
            rpn = append(rpn, stack[i])         --copy(stack[1])
        end for
        stack = {}
    end if
    
    --infix = 5*(4+3)-2/1
    --  rpn = {5,4,3,{43'+'},{42'*'},2,1,{47'/'},{45'-'}}
    return rpn
end function
-----------------------------------------------------------------------------
global function evalRPN(sequence rpn)
--perform calulation of rpn expression
    atom result
    object symbol
    sequence stack, operand
    
    result = 0
    stack = {}
    operand = {0,0}
    
    while length(rpn) do
        symbol = rpn[1]
        rpn = rpn[2..length(rpn)]
        
        if atom(symbol) then        --constant
            stack = prepend(stack, symbol)      --push(symbol) = constant
        else                        --operator
            --get two most recent operands
            operand = stack[1..2]
            stack = stack[3..length(stack)]
            --divide by zero
            if operand[1] = 0 then
                puts(1, "Attempt to divide by 0")
                abort(4)
            end if
        
            --binary operator calculations
            if symbol[1] = '+' then
                stack = prepend(stack, operand[2] + operand[1]) --push(add)
                
            elsif symbol[1] = '-' then
                stack = prepend(stack, operand[2] - operand[1]) --push(sub)
                
            elsif symbol[1] = '*' then
                stack = prepend(stack, operand[2] * operand[1]) --push(mult)
                
            elsif symbol[1] = '/' then
                stack = prepend(stack, operand[2] / operand[1]) --push(div)
                
            elsif symbol[1] = '^' then
                stack = prepend(stack, power(operand[2], operand[1])) --push(power)
                
            end if
        end if
    end while
    
    if length(stack) > 1 then
        puts(1, "Invalid internal expression\n\nPlease report to u5ms@csc.liv.ac.uk!")
        abort(3)
    else
        return stack[1]
    end if
end function

