-----------------------------------------------------------------------------
-- Calc - Matt's Expression evaluator
--
-- TEST BED 1.00
--
-- by Matt Sephton (u5ms@csc.liv.ac.uk)
-----------------------------------------------------------------------------
include calc.e
-----------------------------------------------------------------------------
sequence expr
atom eval, verbose
-----------------------------------------------------------------------------
procedure preprocess()
--clean up command line
    sequence cl
    integer p

    --trim program files off
    cl = command_line()
    
    if length(cl) < 3 then
        usage()
    else
        cl = cl[3..length(cl)]
    end if

    expr = ""
    verbose = FALSE
    --combine args
    for i = 1 to length(cl) do
        if not match(upper(cl[i]), switches) then
            expr = expr & cl[i]
        else
            verbose = TRUE
        end if
    end for
    
    --command line has more than switches
    if compare({}, expr) = 0 then
        usage()
    end if
    
    --remove commas (thousand delimter) in right to left scan
    p = length(expr)
    while p > 0 do
        if expr[p] = ',' then
            expr = expr[1..p-1] & expr[p+1..length(expr)]
        end if
        p = p - 1
    end while
    
    --valid equation
    for i = 1 to length(expr) do
        if not valid(expr[i]) then
            printf(1, "Invalid symbol found\n%s\n", {expr})
            puts(1, repeat(32, i-1) & "^")
            abort(2)
        end if
    end for
end procedure
-----------------------------------------------------------------------------
procedure output()
    if verbose then
        puts(1, "CALC, by Matt Sephton (u5ms@csc.liv.ac.uk)\n")
        --printRPN(toRPN(expr))
        printf(1, "\n%s\n = ", {expr})
    end if
    eval = evalRPN(toRPN(expr))
    
    if integer(eval) then
        printf(1, "%d", eval)
        if verbose then
            printf(1, "\n = %x (hex)", eval)
            printf(1, "\n = %o (oct)", eval)
        end if
    else
        printf(1, "%g", eval)
    end if
end procedure
-----------------------------------------------------------------------------
preprocess()
output()

