
WindowDialog subclass: #Chooser
  instanceVariableNames: 
    'reply multipleSelect listBox initialListBoxSelection '
  classVariableNames: ''
  poolDictionaries: '' !


!Chooser class methods !
 
chooseFrom: aCollection default: anIntegerOrACollection

        "Added - Adrian Cho - Sunday Mar 15, 1992"

    ^self new chooseFrom: aCollection default: anIntegerOrACollection label: nil!
  
chooseFrom: aCollection default: anIntegerOrACollection label: aString

        "Added - Adrian Cho - Sunday Mar 15, 1992"

    ^self new chooseFrom: aCollection default: anIntegerOrACollection label: aString!
   
comment

        "Adrian Cho - Sunday Mar 15, 1992 - Prompt user with a listbox that allows selection of items and answer indexes of items selected.  The parameter
        anIntegerOrACollection is one or more indexes that define the initial selection in the listbox.  If this parameter is an Integer, then the listbox is a single selection
        listbox.  If this parameter is a Collection, then the listbox is a multiple selection listbox.  A multiple selection chooser always answers a collection of selected
        indexes which may be zero in size.  A single selection listbox answers an Integer specifying the index of the selected item - this will never be zero.  If the user
        selected Cancel, then nil is answered.  The user may dismiss the listbox by selecting the OK or Cancel pushbuttons, or double clicking on a listbox item."!
 
example1

        "Added - Adrian Cho - Monday Mar 16, 1992"

    ^self chooseFrom: #('John' 'Fred' 'Bill' 'Sam') default: 1.!
  
example2

        "Added - Adrian Cho - Monday Mar 16, 1992"

    ^self chooseFrom: #('John' 'Fred' 'Bill' 'Sam') default: #(1 3)!
  
example3

        "Added - Adrian Cho - Monday Mar 16, 1992"

    ^self chooseFrom: #('John' 'Fred' 'Bill' 'Sam') default: #(1 3) label: 'Pick A Name'! !



!Chooser methods !
 
cancel: aButton

        "Private - Added - Adrian Cho - Sunday Mar 15, 1992 - The user selected cancel."

    self mainView close!
 
chooseFrom: aCollection default: anIntegerOrACollection label: aString

        "Private - Added - Adrian Cho - Sunday Mar 15, 1992"

    | staticText charSize lineHeight |

    reply := nil.

    anIntegerOrACollection isInteger
    ifTrue: [multipleSelect := false]
    ifFalse: [multipleSelect := true].

    initialListBoxSelection := anIntegerOrACollection.

    aString isNil
    ifTrue: [self label: 'Chooser']
    ifFalse: [self labelWithoutPrefix: aString].

    self when: #opened perform: #opened:.

    charSize := WindowDialog unitMultiplier.
    lineHeight := charSize y.

    self addSubpane: (staticText :=
        StaticText new
            contents: 'Select one or more items:';
            framingBlock: [:box | (box leftTop rightAndDown: (2 @ 1) * charSize) extentFromLeftTop: (28 @ 1) * charSize ] ).

    multipleSelect
    ifTrue: [
        self addSubpane: (listBox :=
            MultipleSelectListBox new
            contents: aCollection;
            framingBlock: [:box | (box leftTop rightAndDown: (2 @ 3) * charSize) extentFromLeftTop: (28 @ 13) * charSize ] ).

        staticText contents: 'Select one or more items:']
    ifFalse: [
        self addSubpane: (listBox :=
            ListBox new
            contents: aCollection;
            framingBlock: [:box | (box leftTop rightAndDown: (2 @ 3) * charSize) extentFromLeftTop: (28 @ 13) * charSize ] ).

        staticText contents: 'Select one item:'].

    listBox
        when: #doubleClickSelect perform: #ok:;
        font: (
            Font
            face: 'System'
            size: 9 @ 20
            fixedWidth: false
            bold: true
            hollow: nil
            italic: false
            negative: nil
            strikeOut: false
            underscore: false).

    self addSubpane: (
        Button new
            setStyle: #defaultPushButton;
            contents: '&OK';
            when: #clicked perform: #ok:;
            framingBlock: [:box | (box leftTop rightAndDown: (6 @ 17) * charSize) extentFromLeftTop: (8 @ 2) * charSize ] ).

    self addSubpane: (
        Button new
            contents: '&Cancel';
            when: #clicked perform: #cancel:;
            framingBlock: [:box | (box leftTop rightAndDown: (18 @ 17) * charSize) extentFromLeftTop: (8 @ 2) * charSize ] ).

    self openWindow.

    ^reply!
 
initWindowSize

        "Private - Added - Adrian Cho - Sunday Mar 15, 1992 - Answer the window size."

    ^(32 @ 20) * WindowDialog unitMultiplier!
   
ok: aButton

        "Private - Added - Adrian Cho - Sunday Mar 15, 1992 - The user selected ok."

    multipleSelect
    ifTrue: [reply := listBox selections]
    ifFalse: [reply := listBox selection].

    self mainView close!

opened: topPane

        "Private - Added - Adrian Cho - Sunday Mar 15, 1992"

    listBox selection: initialListBoxSelection.! !
