include grid.e

global procedure ObjectBrowser()
  integer Key, Grid, ObjectGrid, PropertyGrid
  sequence Video1, Video2, s, s1, s2

  Video1 = save_text_image( { 1, 1 }, { 25, 80 } )
  bk_color( BLACK )  text_color( WHITE )  clear_screen()
  cursor( NO_CURSOR )  s = repeat( '', 80 )  wrap( 0 )
  for i = 1 to 24 do position( i, 1 )  puts( 1, s ) end for
  position( 25, 16 )
  puts( 1, "Press CONTROL ARROW KEYS to move windows around" )  wrap( 1 )
  Video2 = save_text_image( { 1, 1 }, { 25, 80 } )

  ObjectGrid = GridCreate()
  SetProperty( ObjectGrid, "Top",     2 )
  SetProperty( ObjectGrid, "Left",    3 )
  SetProperty( ObjectGrid, "Height",  8 )
  SetProperty( ObjectGrid, "Width",  28 )
  SetProperty( ObjectGrid, "Index",   1 )
  SetProperty( ObjectGrid, "Row",     1 )
  SetProperty( ObjectGrid, "Shadow",  1 )
  SetProperty( ObjectGrid, "Colors", { WHITE, BRIGHT_WHITE, BLACK, BLUE, CYAN, BLACK } )
  SetProperty( ObjectGrid, "Titles", { "ID", "ClassName" } )
  SetProperty( ObjectGrid, "Widths", { 3, 20 } )

  PropertyGrid = GridCreate()
  SetProperty( PropertyGrid, "Top",    12 )
  SetProperty( PropertyGrid, "Left",    3 )
  SetProperty( PropertyGrid, "Height", 11 )
  SetProperty( PropertyGrid, "Width",  75 )
  SetProperty( PropertyGrid, "Index",   1 )
  SetProperty( PropertyGrid, "Row",     1 )
  SetProperty( PropertyGrid, "Shadow",  1 )
  SetProperty( PropertyGrid, "Colors", { WHITE, BRIGHT_WHITE, BLACK, BLUE, CYAN, BLACK } )
  SetProperty( PropertyGrid, "Titles", { "Property", "Value" } )
  SetProperty( PropertyGrid, "Widths", { 20, 50 } )

  s = GetObjects()
  for i = 1 to length( s ) do s[ i ] = { i, s[ i ][ 2 ] } end for
  SetProperty( ObjectGrid, "Data", s )
  GridPaint( ObjectGrid )

  s  = GetProperty( ObjectGrid, "Data" )
  s1 =  GetPropNames( GetProperty( ObjectGrid, "Index" ) )
  s2 = GetPropValues( GetProperty( ObjectGrid, "Index" ) )
  for i = 1 to length( s1 ) do s1[ i ] = { s1[ i ], s2[ i ] } end for
  SetProperty( PropertyGrid, "Data", s1 )
  GridPaint( PropertyGrid )

  Grid = ObjectGrid
  while 1 do
    Key = wait_key()
    if Key = K_ESC then exit
    elsif Key = K_TAB then
      if Grid = ObjectGrid then Grid = PropertyGrid
        else Grid = ObjectGrid
      end if
    elsif Key = K_CTL_UP and GetProperty( Grid, "Top" ) > 1 then
      display_text_image( { 1, 1 }, Video2 )
      SetProperty( Grid, "Top", GetProperty( Grid, "Top" ) - 1 )
      GridPaint( ObjectGrid )  GridPaint( PropertyGrid )  GridPaint( Grid )
    elsif Key = K_CTL_DOWN and GetProperty( Grid, "Top"    ) <= 25 -
                               GetProperty( Grid, "Height" ) then
      display_text_image( { 1, 1 }, Video2 )
      SetProperty( Grid, "Top", GetProperty( Grid, "Top" ) + 1 )
      GridPaint( ObjectGrid )  GridPaint( PropertyGrid )  GridPaint( Grid )
    elsif Key = K_CTL_LEFT and GetProperty( Grid, "Left" ) > 1 then
      display_text_image( { 1, 1 }, Video2 )
      SetProperty( Grid, "Left", GetProperty( Grid, "Left" ) - 1 )
      GridPaint( ObjectGrid )  GridPaint( PropertyGrid )  GridPaint( Grid )
    elsif Key = K_CTL_RIGHT and GetProperty( Grid, "Left"  ) <= 80 -
                                GetProperty( Grid, "Width" ) then
      display_text_image( { 1, 1 }, Video2 )
      SetProperty( Grid, "Left", GetProperty( Grid, "Left" ) + 1 )
      GridPaint( ObjectGrid )  GridPaint( PropertyGrid )  GridPaint( Grid )
    end if
    if GridApply( Grid, Key ) then
      if Grid = ObjectGrid then
        s  = GetProperty( ObjectGrid, "Data" )
        s1 =  GetPropNames( GetProperty( ObjectGrid, "Index" ) )
        s2 = GetPropValues( GetProperty( ObjectGrid, "Index" ) )
        for i = 1 to length( s1 ) do s1[ i ] = { s1[ i ], s2[ i ] } end for
        SetProperty( PropertyGrid, "Data", s1 )
        GridRefresh( PropertyGrid )
      end if
    end if
  end while

  display_text_image( { 1, 1 }, Video1 )
end procedure

