-- Copyright 1997 - Francis Bussiere - email: claire@cyberglobe.net
-- Not responsible for any use or misuse - Use at your own risk

-- without type_check

-- INITS

sequence Classes, Objects

Classes = {}  Objects = {}

-- LOCALS

constant TO_LOWER = 'a' - 'A'

function UpperCase( object x )
-- convert atom or sequence to upper case
    return x - ( x >= 'a' and x <= 'z' ) * TO_LOWER
end function

-- GLOBALS

global function CreateObject( sequence Class, sequence Properties )
  sequence ClassName
  integer ClassID, ObjectID

  if atom( Class[ 1 ] ) then ClassName = UpperCase( Class )
    else ClassName = UpperCase( Class[ 1 ] )
  end if
  for i = 1 to length( Properties ) do
    Properties[ i ] = UpperCase( Properties[ i ] )
  end for
  if sequence( Class[ 1 ] ) then
    for i = 2 to length( Class ) do
      Class[ i ] = UpperCase( Class[ i ] )
    end for
    for i = 2 to length( Class ) do
      for j = 1 to length( Classes ) do
        if compare( Classes[ j ][ 1 ], Class[ i ] ) = 0 then
          Properties = Classes[ j ][ 4..length( Classes[ j ] ) ] & Properties
        end if
      end for
    end for
  end if
  ClassID   = 0
  for i = 1 to length( Classes ) do
    if compare( Classes[ i ][ 1 ], ClassName ) = 0 then ClassID = i end if
  end for
  if ClassID = 0 then
    Classes = Classes & { { ClassName, "CLASSID", "CLASSNAME" } }
    ClassID = length( Classes )
    for i = 1 to length( Properties ) do
      Classes[ ClassID ] = Classes[ ClassID ] & { Properties[ i ] }
    end for
  end if
  Objects  = Objects & { { ClassID, ClassName } }
  ObjectID = length( Objects )
  Objects[ ObjectID ] = Objects[ ObjectID ] & repeat( "", length( Properties ) )
  return ObjectID
end function

global procedure SetProperty( integer Self, sequence Property, object Value )
  Objects[ Self ][ find( UpperCase( Property ), Classes[ Objects[ Self ][ 1 ] ] ) - 1 ] = Value
end procedure

global function GetProperty( integer Self, sequence Property )
  return Objects[ Self ][ find( UpperCase( Property ), Classes[ Objects[ Self ][ 1 ] ] ) - 1 ]
end function

global function CloneObject( integer Object )
  Objects = Objects & { Objects[ Object ] }
  return length( Objects )
end function

global function GetPropNames( integer Self )
  return Classes[ Objects[ Self ][ 1 ] ][ 2..length( Classes[ Objects[ Self ][ 1 ] ] ) ]
end function

global function GetPropValues( integer Self )
  return Objects[ Self ]
end function

global function GetClasses()
  return Classes
end function

global function GetObjects()
  return Objects
end function

