-- with trace

include file.e
include get.e
include graphics.e
include image.e
include sort.e

include classes.e
include keys.e

-- ROUTINES

type string( object O )
  if atom( O ) then return 0 end if
  for i = 1 to length( O ) do
    if not atom( O[ i ] ) then return 0 end if
    if O[ i ] < ' ' or O[ i ] > 255 then return 0 end if
  end for
  return 1
end type

function sPrintString( object x )
-- Return the string representation of any
-- Euphoria data object. This is just like
-- the output from print(1, x), but you can
-- store it in a variable.
  sequence s

  if atom( x ) then
    return sprintf( "%g", x )
  else
    s = "{"
    if string( x ) then
      return sprintf( sprintf( "%%-%ds", { length( x ) } ), { x } )
    else
      for i = 1 to length( x ) do
        s = s & sPrintString( x[ i ] )
        if i < length( x ) then s = s & ',' end if
      end for
    end if
    s = s & "}"
    return s
  end if
end function

function left( sequence S, integer Width )
  if length( S ) <= Width then return S end if
  return S[ 1..Width ]
end function

function AnyToStr( object O )
  if string( O ) then return O
    else return sPrintString( O )
  end if
end function

procedure SetAttr( integer Top, integer Left, integer Height,
                   integer Width, sequence Colors )
  sequence s

  s = save_text_image( { Top, Left }, { Top + Height - 1, Left + Width - 1 } )
  for i = 1 to length( s ) do
    for j = 2 to length( s[ i ] ) by 2 do
      s[ i ][ j ] = Colors[ 1 ] * 16 + Colors[ 2 ]
    end for
  end for
  display_text_image( { Top, Left }, s )
end procedure

procedure Box( integer Top, integer Left, integer Height,
               integer Width, sequence Colors, atom Shadow )
  sequence s

  bk_color( Colors[ 1 ] )  text_color( Colors[ 2 ] )
  position( Top, Left )  wrap( 0 )
  puts( 1, '' & repeat( '', Width - 2 ) & '' )
  s = '' & repeat( ' ', Width - 2 ) & ''
  for i = 1 to Height - 2 do
    position( Top + i, Left )  puts( 1, s )
  end for
  position( Top + Height - 1, Left )
  puts( 1, '' & repeat( '', Width - 2 ) & '' )
  if length( Colors ) > 2 then
    SetAttr( Top, Left + Width - 1, Height, 1, { Colors[ 1 ], Colors[ 3 ] } )
    SetAttr( Top + Height - 1, Left + 1, 1, Width - 1, { Colors[ 1 ], Colors[ 3 ] } )
  end if
  if Shadow then
    SetAttr( Top + 1, Left + Width, Height - 1, 2, { GRAY, BLACK } )
    SetAttr( Top + Height, Left + 2, 1, Width, { GRAY, BLACK } )
  end if
  wrap( 1 )
end procedure

-- GRID METHODS

global function GridCreate()
  integer Self

  Self = CreateObject( "Grid", { "Top", "Left", "Height", "Width", "Colors",
                    "Shadow", "Titles", "Widths", "Data", "Index", "Row" } )
  SetProperty( Self, "Top",     1 )
  SetProperty( Self, "Left",    1 )
  SetProperty( Self, "Height", 13 )
  SetProperty( Self, "Width",  74 )
  SetProperty( Self, "Index",   1 )
  SetProperty( Self, "Row",     1 )
  SetProperty( Self, "Shadow",  1 )
  SetProperty( Self, "Colors", { WHITE, BRIGHT_WHITE, BLACK, BLUE, CYAN, BLACK } )
  return Self
end function

global procedure GridRefresh( integer Self )
  integer Top, Left, Width, Row, Index
  sequence Colors, Data, Widths, s

  Top    = GetProperty( Self, "Top"    )
  Left   = GetProperty( Self, "Left"   )
  Colors = GetProperty( Self, "Colors" )
  Data   = GetProperty( Self, "Data"   )
  Row    = GetProperty( Self, "Row"    )
  Index  = GetProperty( Self, "Index"  )
  Width  = GetProperty( Self, "Width"  )
  Widths = GetProperty( Self, "Widths" )
  if length( Colors ) > 4 then
    bk_color( Colors[ 5 ] )  text_color( Colors[ 6 ] )
  else
    bk_color( Colors[ 1 ] )  text_color( Colors[ 2 ] )
  end if
  for i = 2 to GetProperty( Self, "Height" ) - 2 do
    position( Top + i, Left + 1 )
    if sequence( Data ) and length( Data ) >= Index - Row + i - 1 then
      if sequence( Widths ) then
        s = " "
        for j = 1 to length( Widths ) do
          s = s & sprintf( sprintf( "%%-%ds ", { Widths[ j ] } ),
            { left( AnyToStr( Data[ Index - Row + i - 1 ][ j ] ), Widths[ j ] ) } )
        end for
      else
        s = sprintf( sprintf( " %%-%ds ", { Width - 4 } ),
          { left( AnyToStr( Data[ Index - Row + i - 1 ] ), Width - 4 ) } )
      end if
    else
      s = sprintf( sprintf( " %%-%ds ", { Width - 4 } ), { "" } )
    end if
    puts( 1, s )
  end for
  if length( Colors ) > 4 then
    bk_color( Colors[ 6 ] )  text_color( Colors[ 5 ] )
  else
    bk_color( Colors[ 2 ] )  text_color( Colors[ 1 ] )
  end if
  position( Top + 1 + Row, Left + 1 )
  if sequence( Data ) and length( Data ) >= Index then
    if sequence( Widths ) then
      s = " "
      for j = 1 to length( Widths ) do
        s = s & sprintf( sprintf( "%%-%ds ", { Widths[ j ] } ),
          { left( AnyToStr( Data[ Index ][ j ] ), Widths[ j ] ) } )
      end for
    else
      s = sprintf( sprintf( " %%-%ds ", { Width - 4 } ),
        { left( AnyToStr( Data[ Index ] ), Width - 4 ) } )
    end if
  else
    s = sprintf( sprintf( " %%-%ds ", { Width - 4 } ), { "" } )
  end if
  puts( 1, s )
end procedure

global procedure GridPaint( integer Self )
  integer Top, Left
  sequence Colors, Titles, Widths, s

  Top    = GetProperty( Self, "Top"    )
  Left   = GetProperty( Self, "Left"   )
  Colors = GetProperty( Self, "Colors" )
  Titles = GetProperty( Self, "Titles" )
  Widths = GetProperty( Self, "Widths" )
  Box( Top, Left, GetProperty( Self, "Height" ),
                  GetProperty( Self, "Width"  ),
          Colors, GetProperty( Self, "Shadow" ) )
  position( Top + 1, Left + 1 )
  if length( Colors ) > 3 then text_color( Colors[ 4 ] )
    else text_color( Colors[ 2 ] )
  end if
  if sequence( Titles ) then
    if sequence( Widths ) then
      s = " "
      for i = 1 to length( Widths ) do
        s = s & sprintf( sprintf( "%%-%ds ", { Widths[ i ] } ), { Titles[ i ] } )
      end for
    else
      s = " "
      for i = 1 to length( Titles ) do s = s & Titles[ i ] & ' ' end for
    end if
    puts( 1, s )
  end if
  GridRefresh( Self )
end procedure

global function GridApply( integer Self, atom Key )
  integer Row, Index

  Row   = GetProperty( Self, "Row"   )
  Index = GetProperty( Self, "Index" )
  if Key = K_UP then
    if Row   > 1 then SetProperty( Self, "Row",   Row   - 1 ) end if
    if Index > 1 then SetProperty( Self, "Index", Index - 1 ) end if
    GridRefresh( Self )
  elsif Key = K_DOWN then
    if Row <         GetProperty( Self, "Height" ) - 3 and
       Row < length( GetProperty( Self, "Data"   ) ) then
       SetProperty( Self, "Row", Row + 1 )
    end if
    if Index < length( GetProperty( Self, "Data" ) ) then
       SetProperty( Self, "Index", Index + 1 )
    end if
    GridRefresh( Self )
  elsif Key = K_HOME or Key = K_CTL_PGUP then
    SetProperty( Self, "Row",   1 )
    SetProperty( Self, "Index", 1 )
    GridRefresh( Self )
  elsif Key = K_END or Key = K_CTL_PGDN then
    SetProperty( Self, "Row",           GetProperty( Self, "Height" ) - 3 )
    SetProperty( Self, "Index", length( GetProperty( Self, "Data" ) )     )
    GridRefresh( Self )
  else
    return 0
  end if
  return 1
end function

