	-----------------------------------------------
	--  Euphoria functions written by Neil Kube  --
	-----------------------------------------------

global constant TRUE = 1, FALSE = 0

global procedure ShowSegments( integer digit, 
			sequence color, 
			sequence location, 
			integer offset, 
			atom scale )

-- This procedure is called by "ShowDigital"

--       111
--      2   3
--      2   3
--       444
--      5   6
--      5   6
--       777

	sequence segments
	atom SegColor
	location = location + offset * {18,0} * scale

	if digit = 1 then
		segments = {0,0,1,0,0,1,0}
	elsif digit = 2 then
		segments = {1,0,1,1,1,0,1}
	elsif digit = 3 then
		segments = {1,0,1,1,0,1,1}
	elsif digit = 4 then
		segments = {0,1,1,1,0,1,0}
	elsif digit = 5 then
		segments = {1,1,0,1,0,1,1}
	elsif digit = 6 then
		segments = {1,1,0,1,1,1,1}
	elsif digit = 7 then
		segments = {1,0,1,0,0,1,0}
	elsif digit = 8 then
		segments = {1,1,1,1,1,1,1}
	elsif digit = 9 then
		segments = {1,1,1,1,0,1,1}
	elsif digit = 0 then
		segments = {1,1,1,0,1,1,1}
	end if

	-- Top segment
	if segments[1] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{1,0}), 
		location+(scale*{12,0}),
		location+(scale*{10,2}),
		location+(scale*{3,2}),
		location+(scale*{1,0}) })

	-- Upper left segment
	if segments[2] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{0,1}), 
		location+(scale*{0,11}),
		location+(scale*{1,11}),
		location+(scale*{2,10}),
		location+(scale*{2,3}),
		location+(scale*{0,1}) })

	-- Upper right segment
	if segments[3] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{13,1}), 
		location+(scale*{13,11}),
		location+(scale*{12,11}),
		location+(scale*{11,10}),
		location+(scale*{11,3}),
		location+(scale*{13,1}) })

	-- Middle segment
	if segments[4] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{3,11}), 
		location+(scale*{10,11}),
		location+(scale*{11,12}),
		location+(scale*{10,13}),
		location+(scale*{3,13}),
		location+(scale*{2,12}),
		location+(scale*{3,11}) })

	-- Lower left segment
	if segments[5] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{0,23}), 
		location+(scale*{0,13}),
		location+(scale*{1,13}),
		location+(scale*{2,14}),
		location+(scale*{2,21}),
		location+(scale*{0,23}) })

	-- Lower right segment
	if segments[6] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{13,23}), 
		location+(scale*{13,13}),
		location+(scale*{12,13}),
		location+(scale*{11,14}),
		location+(scale*{11,21}),
		location+(scale*{13,23}) })

	-- Bottom segment
	if segments[7] then
		SegColor = color[1]
	else 
		SegColor = color[2]
	end if
	polygon( SegColor, 1, {
		location+(scale*{1,24}), 
		location+(scale*{12,24}),
		location+(scale*{10,22}),
		location+(scale*{3,22}),
		location+(scale*{1,24}) })

end procedure

global procedure ShowDigital(  atom number, 
			sequence color,
			sequence location,
			atom scale,
			integer width )
	integer nDigit
	atom nPowerOf10

	nPowerOf10 = 1
	for p = 1 to width do
	    nPowerOf10 = nPowerOf10 * 10
	end for
	nPowerOf10 = nPowerOf10 / 10

	number = floor( number )  -- Truncate any decimal fraction

	for p = 0 to ( width - 1 ) do
	    nDigit = floor( number/nPowerOf10 )
	    ShowSegments( nDigit, color, location, p, scale )
	    number = number - ( nPowerOf10 * nDigit )
	    nPowerOf10 = nPowerOf10 / 10
	end for

end procedure

global function min(sequence sArray)
-- return the minimum value stored in an array
	atom aMinValue
	if length( sArray ) = 1 then
		return sArray[1] 
	end if
	aMinValue = sArray[1]
	for i = 2 to length( sArray ) do
		if sArray[2] < aMinValue then
			aMinValue = sArray[2]
		end if
	end for
	return aMinValue
end function

global function max(sequence sArray)
-- return the maximum value stored in an array
	atom aMaxValue
	if length( sArray ) = 1 then
		return sArray[1] 
	end if
	aMaxValue = sArray[1]
	for i = 2 to length( sArray ) do
		if sArray[2] > aMaxValue then
			aMaxValue = sArray[2]
		end if
	end for
	return aMaxValue 
end function

global procedure pause(atom delay)
-- Gives control to calling module only after specified delay has elapsed
    atom t
    t = time()
    while time() < t+delay do
	-- just laze around for a millisecond or two...
    end while
end procedure

global function wait(atom delay)
-- Gives control to calling module after specified delay has elapsed OR
-- when a key is pressed.
-- Returns value as per get_key()
    atom t
    integer ReturnValue
    
    ReturnValue = -1
    t = time()
    while time() < t+delay do
	-- Check if a key has been pressed...
	ReturnValue = get_key()
	if ReturnValue = -1 then 
	    -- Carry on
	else
	    --  A key has been pressed - time to go!
	    exit
	end if
    end while
    return(ReturnValue)
end function

global procedure oops()
    sound(400)
    pause(.07)
    sound(200)
    pause(.07)
    sound(100)
    pause(.14)
    sound(0)
end procedure

global function Trim( sequence string )
	-- Trim any trailing spaces, tabs, CR & LF characters from input string 
	while TRUE do
		if length( string ) = 0 then
			exit
		end if
		if find( string[ length( string ) ], " \n\r\t" ) = 0 then
			exit
		end if
		string = string[ 1..length( string ) - 1 ]
	end while
	return string
end function

