--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=--
--= Euphoria Data Object Manager 1b =-=-=-- 
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=--
--= Done by Ralf Nieuwenhuijsen(EDM)    =--
--=  and Daniel Berstein (Compression)  =--
--= Email for any problems at:          =--
--=     <nieuwen@xs4all.nl>             =--
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-- 

-- We are both not responsible for any thing that may happen when you use 
--  this code.

-- If you use this, you MUST give us credits!!
-- If you make money with it, give us the source of your program.
-- If you make more than 1000 $ with a program that uses this code you
--          must pay us both 500 $ once.

-- Daniel Berstein has made his compression routines public and you can 
--      download them from the Official Euphoria HomePage or his HomePage.
-- Cause they are public i have used them in this library, and giving him
--      credits and half of the money if there will ever be some.

-- Compressing techniques...
--      Author:         Daniel Berstein
--      Email:          architek@geocities.com                                  
--      Webpage:        www.geocities.com/SiliconValley/Heights/9316
                            
-- Euphoria Data Object Manager...
--      Author:         Ralf Nieuwenhuijsen
--      Email:          nieuwen@xs4all.nl
--      Webpage:        http://www.xs4all.nl/~nieuwen (NOT UP YET)                            

-- The compressing code of Daniel Berstein is an translation of c-code 
--  by Nico E. Vries which uses the method suggested by:
--      Jussi Puttonen, Tino Raita and Jukka Teuhola

-- If you want the c-code and a lot of other info about compression and 
--      Euphoria visit Architek's HomePage. (Architek is Daniel Berstein!)
--  See above for the addres.

-----------------------------------------------------------------------------
-- edo_load () -----------------
--------------------------------
--  s = edo_load( file_name )        

-- Function to return an Euphoria Sequence stored in an EDO file.

-- file_name --> a sequence containing the filename & optional location
--                      of the [E]uphoria [D]ata [Object].

-----------------------------------------------------------------------------
-- edo_save () -----------------------------------
--------------------------------------------------
--  boolean = edo_save ( file_name , object )

-- Function which stored an Euphoria object do disk in an EDO file.

-- file_name --> a sequence containing the filename & optional location
--                      where the EDO file should be created.
-- object    --> an object which has to be stored, if it isn't a sequence,
--                      the integer or atom becomes a one-length sequence.

-----------------------------------------------------------------------------


include machine.e
include get.e 

sequence eom_data

function select_type(atom data)
sequence ret
    if data <= 15 then
        ret = {1,{0,0}}
    elsif data <= 255 then
        ret = {2,{0,1}}
    elsif data <= 65535 then
        ret = {3,{1,1,0}}
    elsif data <= 4294967295 then  
        ret = {4,{1,1,1,0}}
    else
        ret = {5,{1,1,1,1}}
    end if
    return ret
end function

function count_mark_type(atom data)
sequence ret
    if data <= 15 then
        ret = {1,0,0,0,0}
    elsif data <= 255 then
        ret = {0,1,0,0,0} 
    elsif data <= 65535 then
        ret = {0,0,1,0,0}
    elsif data <= 4294967295 then  
        ret = {0,0,0,1,0}
    else
        ret = {0,0,0,0,1}
    end if
    return ret
end function

function add_data(atom data)
object ret
    if data <= 15 then
        ret = 4
    elsif data <= 255 then
        ret = 8 
    elsif data <= 65536 then
        ret = 16
    elsif data <= 4294967295 then  
        ret = 32
    else
        ret = 64
    end if
    ret = int_to_bits (data,ret)
    return ret
end function

function shrink_sequence(sequence data)
sequence ret,chk,st_type,tp
atom chk_old
    ret = {1,1,0,0}
    chk = {0,0,0,0,0}
    for j=1  to length(data)  by 1  do
        if not sequence(data[j]) then
            chk = chk + count_mark_type(data[j])
        end if
    end for
    chk_old = 1
    for j=2  to 5  by 1  do
        if chk[j] > chk[chk_old] then
            chk_old = j
        end if
    end for
    st_type = {0}
    if chk_old = 1 then
        st_type[1] = 1
        ret = append(ret,0)
        ret = append(ret,0)
    elsif chk_old = 2 then
        st_type[1] = 2
        ret = append(ret,0)
        ret = append(ret,1)
    elsif chk_old = 3 then
        st_type[1] = 3
        ret = append(ret,1)
        ret = append(ret,0)
    elsif chk_old = 4 then
        st_type[1] = 4
        ret = append(ret,1)
        ret = append(ret,1)
        ret = append(ret,0)
    else
        st_type[1] = 5
        ret = append(ret,1)
        ret = append(ret,1)
        ret = append(ret,1)
    end if
    for j=1  to length(data)  by 1  do
        if sequence(data[j]) then
            ret= ret & shrink_sequence(data[j])
        else
            tp = select_type(data[j])
            if tp[1] = st_type[1] then
                ret = ret & {0} & add_data(data[j])
            else
                ret = ret & {1} & tp[2] & add_data(data[j])
            end if
        end if
    end for
    ret = ret & {1,1,0,1}
    return ret
end function

function shrink(object data)
sequence ret
    if not sequence(data) then
        data = {data}
    end if
    ret = shrink_sequence(data)
    return ret
end function

function expand(sequence data)
sequence ret,st
atom j, level
    ret = ""
    st=""
    j = 1
    level = 0
    while j <= length(data) do
    if data[j]=0 then               
        j=j+1
        trace(1)
        ret = ret & " " & sprintf("%f",bits_to_int(data[j..j+st[level]-1])) &","
        j=j+st[level]
    else
        j=j+1
        if data[j]=0 then       
            j=j+1
            if data[j]=0 then
              j=j+1
              ret=ret & " " & sprintf("%f",bits_to_int(data[j..j+3])) & " ,"
              j=j+4
            else
              j=j+1
              ret = ret & " " & sprintf("%f",bits_to_int(data[j..j+7])) & " ,"
              j=j+8
            end if
        else
            j=j+1
            if data[j]=0 then
                j=j+1
                if data[j]=0 then
                    j=j+1
                    ret = ret & " {"
                    level = level + 1
                    if data[j]=0 then
                        j=j+1
                        if data[j]=0 then
                            j=j+1
                            st = append(st,4)
                        else
                            j=j+1
                            st = append(st,8)
                        end if
                    else
                        j=j+1
                        if data[j]=0 then
                            j=j+1
                            st = append(st,16)
                        else
                            j=j+1
                            if data[j]=0 then
                                j=j+1
                                st = append(st,32)
                            else
                                j=j+1
                                st = append(st,64)
                            end if
                        end if
                    end if
                else
                    j=j+1
                    ret[length(ret)] = ' '
                    ret = ret & "}"
                    ret = ret & " ,"
                    
                    level = level - 1
                    st=st[1..length(st)-1]
                end if
            else
                j=j+1
                if data[j]=0 then
                  j=j+1
                  ret=ret & " " & sprintf("%f",bits_to_int(data[j..j+15])) & ","
                  j=j+16
                else
                    j=j+1
                    if data[j]=0 then
                    j=j+1
                    ret=ret &" " &sprintf("%f",bits_to_int(data[j..j+31])) & ","
                    j=j+32
                    else
                    j=j+1
                    ret=ret &" "&sprintf("%f",bits_to_int(data[j..j+63])) & ","
                    j=j+64
                    end if
                end if
            end if
        end if
    end if
    
    end while
    ret = value(ret[1..length(ret)-1])
    return ret[2]
end function



function INDEX(integer p1, integer p2)
    integer index
    index = xor_bits((p1*128),p2) + 1
    return index
end function            --End INDEX     


function get_next_eom_char ()
    atom temp            
    if remainder(length(eom_data),8) != 0 then print(1,length(eom_data)) return -1 end if
    if length(eom_data)<1 then
        return -1
    else 
        temp = bits_to_int(eom_data[1..8])
        eom_data = eom_data[9..length(eom_data)]
        return temp
    end if                             
end function

function edo_save_c(sequence edo_file)
    --Declaring variables
    sequence pcTable
    integer p1,p2,c,i,ctr,bctr,mask
    sequence buf
    object compOut

    --Open file, if unable to do it, return error (0)
    compOut = open(edo_file, "wb")
    if compOut = -1 then
        return 0
    end if

    --Initialize variables
    pcTable = repeat(32, 32768)
    buf = repeat(0,8)
    p1 = 0
    p2 = 0
    bctr = 0
    ctr = 0
    mask = 0

    --Main loop
    c = get_next_eom_char()
    while c != -1 do
        if pcTable[INDEX(p1,p2)] = c then
            mask = xor_bits(mask,power(2,ctr))
        else
            pcTable[INDEX(p1,p2)] = c
            buf[bctr+1] = c
            bctr = bctr + 1
        end if
        ctr = ctr + 1
        if ctr = 8 then
            puts(compOut, mask)
            i = 0
            while i < bctr do
                puts(compOut, buf[i+1])
                i = i + 1
            end while
            ctr = 0
            bctr = 0
            mask = 0
        end if
        p1 = p2
        p2 = c
        c = get_next_eom_char()
    end while
    
    --Flush characters in buffer
    if ctr then
        puts(compOut, mask)
        i = 0
        while i < bctr do
            puts(compOut, buf[i+1])
            i = i + 1
        end while
    end if
    --Compression succesful, close file and return (1)
    close(compOut)
    return 1
end function               

procedure add_next_eom_char (atom t)
    eom_data = eom_data & int_to_bits(t,8)
end procedure
                                   
function edo_load_c(object decompIn)
    --Declaring variables
    sequence pcTable
    integer p1,p2,ctr,mask,ci,co
    integer test

    --Initialize variables
    p1 = 0
    p2 = 0
    mask = 0
    pcTable = repeat(32,32768)
    ci = getc(decompIn)

    --Main loop
    while ci != -1 do
        mask = ci
        ctr = 0
        while ctr < 8 do
            test = and_bits(mask,power(2,ctr))
            if test then
                co = pcTable[INDEX(p1,p2)]
            else
                co = getc(decompIn)
                if co = -1 then
                    --Decompression completed, close file and return object
                    close(decompIn)
                    return 1
                else
                    pcTable[INDEX(p1,p2)] = co
                end if
            end if
            add_next_eom_char(co)
            p1 = p2
            p2 = co
            ctr = ctr + 1
        end while
        ci = getc(decompIn)
    end while
    --Decompression completed, close file and return object
    close(decompIn)
    return 1
end function            

global function edo_save (sequence edo_file, object edo)
    eom_data = shrink(edo)                             
    eom_data = int_to_bits(8-remainder(length(eom_data),8),8) & eom_data
    eom_data = eom_data & repeat(0,bits_to_int(eom_data[1..8]))
    return edo_save_c(edo_file) 
end function

global function edo_load (sequence edo_file)
object decompIn
    decompIn = open(edo_file, "rb")
    if decompIn = -1 then
        return {}
    end if  
    eom_data = {}           
    if not edo_load_c(decompIn) then
        return {}
    end if 
    eom_data = eom_data[9..length(eom_data)-bits_to_int(eom_data[1..8])]        
    return expand(eom_data)
end function



