// -*- C++ -*-
#define _ARRAY_C_
#pragma implementation
/* [ec2 3.1.2.2]
 *
 *
 *
 * source file: /usr2/Src/eon/eiffel/3122/library/bibt/array.e
 *
 */

#ident "@(#)class_txt:array"
//
// Class: ARRAY (#15), Cluster: "bibt"
// Version: 1.0.0.1, Built by: root, on: 10:17:53 Nov 17 1994
//
//
// Ancestor classes:
//
class ANY;

#include <array.H>

void* ARRAY::_rev_cvt ( int _type)
{
   switch ( _type) {
      case 19: return (ANY*) this;
      case 21: return (PLATFORM*) this;
      case 22: return (GENERAL*) this;
   }
   return (ARRAY*) this;
}


ARRAY* ARRAY::_ert_cvt_to_class ( void *_v, int _type)
{
   ARRAY* _tmp;

   switch ( _type) {
      case 19: _tmp = (ARRAY*) ((ANY*)_v)->_BaseType ( 19); break;
      case 21: _tmp = (ARRAY*) ((PLATFORM*)_v)->_BaseType ( 21); break;
      case 22: _tmp = (ARRAY*) ((GENERAL*)_v)->_BaseType ( 22); break;
      default: _tmp = (ARRAY*) _v;
   }
   return _tmp;
}

// features selected from ANY


ARRAY::ARRAY()
{
   lower = 0;
   upper = 0;
   count = 0;
   all_cleared = (BOOLEAN)0;
   if ( _ert_expand) {
      space = new CORE;
   } else {
      space = (CORE*)0;
   }
#ifdef NO_OPTIMISATION
   
#ifdef EIFFEL_ASSERT
   _class_assert = _set_class_assert ( 0x1f);
   _doing_invar = 0;
#endif // EIFFEL_ASSERT
#endif // NO_OPTIMISATION

   class_id = _ert_INTEGER_Const ( 15);
   _rescuing = 0;
   ANY::_base_id = class_id;
   PLATFORM::_base_id = class_id;
   GENERAL::_base_id = class_id;
   c_object_address = (POINTER)this;
   c_class_name = (POINTER)"ARRAY";
   bit_size = _ert_INTEGER_Const ( sizeof(*this) * BYTE_SIZE);
}
// Minimum index
// Maximum index
// Number of available indecies
// Are all items set to default values?
// Reset all items to default values
void ARRAY::clear_all()
{
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.clear_all\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "clear_all", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "clear_all", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "clear_all", _make_arg_list ( (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "clear_all", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "clear_all"



//Routine body "clear_all" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("clear_all");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.clear_all\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "clear_all", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "clear_all", "", false, (_ert_depth--,_ert_longjmp()));
}  // clear_all

// Allocate array; set interval to `minindex' - `maxindex'         
// (empty if `minindex' > `maxindex')
void ARRAY::make ( INTEGER minindex, INTEGER maxindex)
{
#ifdef NO_OPTIMISATION
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.make\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "make", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "make", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "make", _make_arg_list ( "minindex", (void*) &minindex, -6, "maxindex", (void*) &maxindex, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "make", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "make"

   resize ( minindex, maxindex);


//Routine body "make" ends...
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined ( EA_ENSURE)
   if ( !_ert_in_assertion && _class_assert & 0x2) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 101, "ARRAY", "make", "condition: 1", _ert_BOOLEAN_IMPLIES ((minindex > maxindex), (count == _ert_INTEGER_Const ( 0))), _ert_longjmp());

      _eiffel_rt_Assert ( 101, "ARRAY", "make", "condition: 1", _ert_BOOLEAN_IMPLIES ((minindex <= maxindex), (count == ((maxindex - minindex) + _ert_INTEGER_Const ( 1)))), _ert_longjmp());
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_ENSURE
#endif // NO_OPTIMISATION

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("make");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.make\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "make", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "make", "", false, (_ert_depth--,_ert_longjmp()));
}  // make

// Test if Current and `other' are            
// elementwise equal. If `T' is of            
// reference type, simple reference            
// equality is used.
BOOLEAN ARRAY::is_equal ( ARRAY* other)
{
   BOOLEAN result = (BOOLEAN) 0;
#ifdef NO_OPTIMISATION
#endif // NO_OPTIMISATION
   INTEGER index = (INTEGER)0;
   INTEGER other_index = (INTEGER)0;
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.is_equal\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "is_equal", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "is_equal", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "is_equal", _make_arg_list ( "other", other, 15, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "is_equal", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "is_equal"

   if ( (_ARRAY_chk ( other, "other")->count == count)) {
      result = _ert_BOOLEAN_Const ( true) ? true : false;
      
      index = lower;
      other_index = _ARRAY_chk ( other, "other")->lower;
      while ( 1) {
         if ( !((index > upper) || (result == _ert_BOOLEAN_Const ( false)))) {
            result = _ANY_chk ( item ( index), "item")->is_equal ( ((GENERAL*) _base2obj ( _ARRAY_chk ( other, "other")->item ( other_index), 22))) ? true : false;
            index = (index + _ert_INTEGER_Const ( 1));
            other_index = (other_index + _ert_INTEGER_Const ( 1));
         } else
            break;
      };
   }


//Routine body "is_equal" ends...
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined ( EA_ENSURE)
   if ( !_ert_in_assertion && _class_assert & 0x2) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 101, "ARRAY", "is_equal", "condition: 1", _ert_BOOLEAN_IMPLIES ((_ARRAY_chk ( other, "other")->count != count), (result == _ert_BOOLEAN_Const ( false))), _ert_longjmp());
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_ENSURE
#endif // NO_OPTIMISATION

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("is_equal");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.is_equal\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return result;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "is_equal", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "is_equal", "", false, (_ert_depth--,_ert_longjmp()));
   return (BOOLEAN) 0;
}  // is_equal

// Copy `other' elementwise onto Current.            
// If `T' is of reference type, only the            
// references will be copied.
void ARRAY::copy ( ARRAY* other)
{
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.copy\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "copy", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "copy", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "copy", _make_arg_list ( "other", other, 15, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "copy", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "copy"



//Routine body "copy" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("copy");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.copy\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "copy", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "copy", "", false, (_ert_depth--,_ert_longjmp()));
}  // copy

// Insert `element' after position `index'.
void ARRAY::insert ( ANY* element, INTEGER index)
{
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.insert\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "insert", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "insert", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "insert", _make_arg_list ( "element", element, 19, "index", (void*) &index, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "insert", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined (EA_REQUIRE)
   if ( !_ert_in_assertion && _class_assert & 0x1) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 100, "ARRAY", "insert", "inside_bounds", _ert_BOOLEAN_AND_THEN (((lower - _ert_INTEGER_Const ( 1)) <= index), (index < upper)), (_ert_depth--, _ert_longjmp()));
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_REQUIRE
#endif // NO_OPTIMISATION

// Routine body "insert"



//Routine body "insert" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("insert");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.insert\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "insert", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "insert", "", false, (_ert_depth--,_ert_longjmp()));
}  // insert

// Item at position `index'.
ANY* ARRAY::item ( INTEGER index)
{
   ANY* result = (ANY*) 0;
#ifdef NO_OPTIMISATION
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.item\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "item", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "item", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "item", _make_arg_list ( "index", (void*) &index, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "item", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined (EA_REQUIRE)
   if ( !_ert_in_assertion && _class_assert & 0x1) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 100, "ARRAY", "item", "inside_bounds", _ert_BOOLEAN_AND_THEN ((lower <= index), (index <= upper)), (_ert_depth--, _ert_longjmp()));
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_REQUIRE
#endif // NO_OPTIMISATION

// Routine body "item"

   result = get_element ( _CORE_chk ( space, "space")->space, (index - lower));


//Routine body "item" ends...
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined ( EA_ENSURE)
   if ( !_ert_in_assertion && _class_assert & 0x2) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 101, "ARRAY", "item", "condition: 1", (result != 0), _ert_longjmp());
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_ENSURE
#endif // NO_OPTIMISATION

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("item");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.item\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return result;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "item", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "item", "", false, (_ert_depth--,_ert_longjmp()));
   return (ANY*) 0;
}  // item

// Put `element' at position `index'.
void ARRAY::put ( ANY* element, INTEGER index)
{
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.put\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "put", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "put", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "put", _make_arg_list ( "element", element, 19, "index", (void*) &index, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "put", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined (EA_REQUIRE)
   if ( !_ert_in_assertion && _class_assert & 0x1) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 100, "ARRAY", "put", "inside_bounds", _ert_BOOLEAN_AND_THEN ((lower <= index), (index <= upper)), (_ert_depth--, _ert_longjmp()));
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_REQUIRE
#endif // NO_OPTIMISATION

// Routine body "put"

   set_element ( _CORE_chk ( space, "space")->space, (index - lower), element);


//Routine body "put" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("put");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.put\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "put", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "put", "", false, (_ert_depth--,_ert_longjmp()));
}  // put

// Remove element at position `index'.         
// Elements after `index' will move         
// one position left ( =towards lower indices).
void ARRAY::remove ( INTEGER index)
{
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.remove\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "remove", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "remove", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "remove", _make_arg_list ( "index", (void*) &index, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "remove", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined (EA_REQUIRE)
   if ( !_ert_in_assertion && _class_assert & 0x1) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 100, "ARRAY", "remove", "inside_bounds", _ert_BOOLEAN_AND_THEN ((lower <= index), (index <= upper)), (_ert_depth--, _ert_longjmp()));
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_REQUIRE
#endif // NO_OPTIMISATION

// Routine body "remove"



//Routine body "remove" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("remove");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.remove\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "remove", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "remove", "", false, (_ert_depth--,_ert_longjmp()));
}  // remove

// Rearrange array so that it can accomodate indicies down to `minindex'        
// and up to `maxindex'.  Preserves current array contents
void ARRAY::resize ( INTEGER minindex, INTEGER maxindex)
{
#ifdef NO_OPTIMISATION
#endif // NO_OPTIMISATION
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.resize\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "resize", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "resize", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "resize", _make_arg_list ( "minindex", (void*) &minindex, -6, "maxindex", (void*) &maxindex, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "resize", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "resize"

   if ( ( ( ((maxindex - minindex) + _ert_INTEGER_Const ( 1))) > count)) {
      if ( (space == 0)) {
         space = new CORE;
         space->allocate ( _ert_INTEGER_Const ( 1));
      }
      _CORE_chk ( space, "space")->expand ( ( ( ((maxindex - minindex) + _ert_INTEGER_Const ( 1))) *  ( (pointer_bits() / _ert_INTEGER_Const ( 8)))));
      lower = minindex;
      upper = maxindex;
      count = ( ( ((maxindex - minindex) + _ert_INTEGER_Const ( 1))) + count);
   }


//Routine body "resize" ends...
#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined ( EA_ENSURE)
   if ( !_ert_in_assertion && _class_assert & 0x2) {
      _ert_in_assertion++;

      _eiffel_rt_Assert ( 101, "ARRAY", "resize", "condition: 1", (lower <= minindex), _ert_longjmp());

      _eiffel_rt_Assert ( 101, "ARRAY", "resize", "condition: 1", (maxindex <= upper), _ert_longjmp());
      _ert_in_assertion--;

   }
#endif // EIFFEL_ASSERT && EA_ENSURE
#endif // NO_OPTIMISATION

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("resize");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.resize\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "resize", EXCEPT_FAIL, _ert_depth);
#endif

   default_rescue ();
   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "resize", "", false, (_ert_depth--,_ert_longjmp()));
}  // resize

// resize
// answer with value at position `index'
ANY* ARRAY::get_element ( POINTER area, INTEGER index)
{
   ANY* result = (ANY*) 0;
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.get_element\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "get_element", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "get_element", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "get_element", _make_arg_list ( "area", (void*) &area, -2, "index", (void*) &index, -6, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "get_element", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "get_element"

   result = ::_ert_array_item ( area, index);


//Routine body "get_element" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("get_element");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.get_element\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return result;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "get_element", EXCEPT_FAIL, _ert_depth);
#endif

   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "get_element", "", false, (_ert_depth--,_ert_longjmp()));
   return (ANY*) 0;
}  // get_element

// set value at position `index' to `data'
void ARRAY::set_element ( POINTER area, INTEGER index, ANY* data)
{
#ifdef NO_OPTIMISATION
#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s+++ ARRAY.set_element\n", (_ert_trace_depth++ * 3), "");
#endif // EIFFEL_TRACE

   _eiffel_rt_Assert( EXCEPT_NESTED_FUNCTIONS, "ARRAY", "set_element", "env table size exceeded", (_ert_depth != _ERT_JMP_MAX - 1), (_ert_longjmp()));

#endif // NO_OPTIMISATION
   _ert_cenv[ _ert_depth].caddr = this;
   if ( setjmp ( _ert_cenv[ _ert_depth++].jmpenv)) {
      if ( _rescuing) {
         _rescuing--;
         _eiffel_rt_Assert ( 115, "ARRAY", "set_element", "", false, (_ert_depth--,_ert_longjmp()));
      }
      goto _rescue;
   }

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT) && defined (EIFFEL_TRACE)
   if ( _class_assert) {
      if ( _doing_invar == 0)
         _enter_routine ( c_object_address, "ARRAY", "set_element", _make_arg_list ( "area", (void*) &area, -2, "index", (void*) &index, -6, "data", data, 0, (char *) 0));
      else
         _enter_routine ( c_object_address, "ARRAY", "set_element", _make_arg_list ( 0));
   }
#endif // EIFFEL_ASSERT && EIFFEL_TRACE
#endif // NO_OPTIMISATION

// Routine body "set_element"

   (void)::_ert_array_put ( area, index, data);


//Routine body "set_element" ends...

#ifdef NO_OPTIMISATION
#if defined (EIFFEL_ASSERT)
#if defined (EA_INVARIANT)
   _class_invariant("set_element");

#endif // EA_INVARIANT

   if ( _class_assert)
      _leave_routine();
#endif // EIFFEL_ASSERT

#ifdef EIFFEL_TRACE
   if ( _ert_trace_mode)
      printf ( "%*s--- ARRAY.set_element\n", (--_ert_trace_depth * 3), "");
#endif // EIFFEL_TRACE
#endif // NO_OPTIMISATION
   _ert_depth--;

   return;

_rescue:
   _rescuing++;

#ifdef EIFFEL_TRACE
   _ert_trace_log ( "ARRAY", "set_element", EXCEPT_FAIL, _ert_depth);
#endif

   if ( _class_assert)
      _leave_routine();

   _rescuing--;
   _eiffel_rt_Assert ( 106, "ARRAY", "set_element", "", false, (_ert_depth--,_ert_longjmp()));
}  // set_element

#ifdef NO_OPTIMISATION

#if defined (EIFFEL_ASSERT) && defined (EA_INVARIANT)
void
ARRAY::_class_invariant ( char* rtn)
{
   if ( _doing_invar++)
      return;

   if ( ! (_class_assert & 0x4))
      return;
   ANY::_class_invariant(rtn);
   _doing_invar = 0;

   return;
}
#endif // EIFFEL_ASSERT && EA_INVARIANT
#endif // NO_OPTIMISATION

void ARRAY::_Copy( INTEGER deep, INTEGER sclass, ARRAY* _arg)
{
   lower = _arg->lower;
   upper = _arg->upper;
   count = _arg->count;
   all_cleared = _arg->all_cleared;
   space->_Copy ( 1, 0, _arg->space);

   if ( deep) {
      if ( sclass) ANY::_Copy ( 1, 0, _arg);
      if ( sclass) PLATFORM::_Copy ( 1, 0, _arg);
      if ( sclass) GENERAL::_Copy ( 1, 0, _arg);
   }
}

ARRAY* ARRAY::_localClone( INTEGER deep, INTEGER sclass)
{
   ARRAY* result;

   result = new ARRAY;

   result->lower = _ert_INTEGER_Copy ( lower);
   result->upper = _ert_INTEGER_Copy ( upper);
   result->count = _ert_INTEGER_Copy ( count);
   result->all_cleared = _ert_BOOLEAN_Copy ( all_cleared);
   result->space = space->_localClone ( 1, 0);

   if ( deep) {
      if ( sclass) ANY::_localClone (1, 0);
      if ( sclass) PLATFORM::_localClone (1, 0);
      if ( sclass) GENERAL::_localClone (1, 0);
   }

   return result;
}

ARRAY* ARRAY::_Clone( INTEGER deep, INTEGER sclass, ARRAY* _arg)
{
   ARRAY* result;

   result = new ARRAY;

   result->_Copy ( deep, sclass, _arg);

   return result;
}

BOOLEAN ARRAY::_Equal ( INTEGER deep, INTEGER sclass, ARRAY* _arg)
{
   if ( _ert_INTEGER_Equal ( lower, _arg->lower) == false)
      return false;
   if ( _ert_INTEGER_Equal ( upper, _arg->upper) == false)
      return false;
   if ( _ert_INTEGER_Equal ( count, _arg->count) == false)
      return false;
   if ( _ert_BOOLEAN_Equal ( all_cleared, _arg->all_cleared) == false)
      return false;
   if ( space->_Equal ( 1, 0, _arg->space) == false)
      return false;

   if ( deep) {
      if ( sclass) if ( ANY::_Equal ( 1, 0, _arg) == false) return false;
      if ( sclass) if ( PLATFORM::_Equal ( 1, 0, _arg) == false) return false;
      if ( sclass) if ( GENERAL::_Equal ( 1, 0, _arg) == false) return false;
   }

   return true;
}

BOOLEAN ARRAY::_Conforms_to ( INTEGER other_id)
{
   INTEGER Parents[3] = { 19, 21, 22}, i;

   if ( class_id == other_id)
      return true;

   for ( i = 0; i < 3; i++)
      if ( Parents[i] == (int)other_id)
         return true;

   return false;
}

void ARRAY::_Add_gp ( int _p1)
{
   _gp_ids[0] = 1;
   _gp_ids[1] = _p1;
}

#ifdef NO_OPTIMISATION
ARRAY *_ARRAY_chk(ARRAY *rtc, char *fname)
{
   if ( !rtc)
      _eiffel_rt_Assert ( 107, "ARRAY", fname, "void target", 
			false, _ert_longjmp());
   return rtc;
}
#endif // NO_OPTIMISATION


