/*
 *
 * Non-expanded forms of basic type
*/
#include <stdio.h>

#include <ert.H>
#include <string.H>
#include <any.H>
#include <numeric.H>
#include <dbl_ref.H>

class STRING;

DOUBLE_REF::DOUBLE_REF () {
#ifdef _BOOLEAN_REF_H
	val = false; 
#else
	val = 0; 
#endif
	class_id = _bibt_DOUBLE_REF_id;		/* defined in ert.H */
	c_object_address = (POINTER) this;
	c_class_name = (POINTER) "DOUBLE_REF";
}

void DOUBLE_REF::set_value ( DOUBLE v) { val = v; }

DOUBLE DOUBLE_REF::item () { return val; }

void DOUBLE_REF::_Copy ( int deep, int sclass, DOUBLE_REF* v) { 
	val = v->val; 
}

BOOLEAN DOUBLE_REF::_Equal ( int deep, int sclass, DOUBLE_REF* v) {
	return v->val == val ? true : false; 
}

STRING* DOUBLE_REF::out() { 
	STRING *result;

   	result = new STRING;
   	result->make_from_double ( val);
	return result;
}

				 	/* BUG! we don't have STD_FILES available */
void DOUBLE_REF::print ( ANY *s)
{ 
	fprintf ( stderr, "%d", val); 
}
 
DOUBLE_REF* DOUBLE_REF::_Clone (
					int deep, int sclass, DOUBLE_REF *_arg) { 
	DOUBLE_REF *r = new DOUBLE_REF; r->val = _arg->val; return r; 
}

DOUBLE_REF*
_ert_clone_DOUBLE ( DOUBLE v)
{
	DOUBLE_REF *result;
	result = new DOUBLE_REF;
	result->val = v;
	return result;
}

DOUBLE_REF*
_ert_clone_DOUBLE_REF ( DOUBLE_REF *v)
{
	if ( v) {
		DOUBLE_REF *result;
		result = new DOUBLE_REF;
		result->val = v->val;
		return result;
	}

	return ( DOUBLE_REF *) 0;
}

DOUBLE_REF *_DOUBLE_REF_chk(DOUBLE_REF *rtc, char *fname)
{
   if ( !rtc)
      _eiffel_rt_Assert ( 107, "DOUBLE_REF", fname, "void target", 
			false, _ert_longjmp());
   return rtc;
}


BOOLEAN DOUBLE_REF::is_equal (DOUBLE_REF* p1) { 
	return _Equal( 1, 1, p1); 
}

BOOLEAN DOUBLE_REF::equal (ANY* p1, DOUBLE_REF* p2) { 
	return (p1)->_Equal ( 0, 1, p2); 
}

void DOUBLE_REF::copy ( DOUBLE_REF* p1) { 
	_Copy ( 0, 1, p1); 
}

DOUBLE_REF* DOUBLE_REF::clone (DOUBLE_REF *x) {
	 return _Clone( 0, 1, x); 
}

DOUBLE_REF* DOUBLE_REF::_localClone ( int deep, int sclass) { 
	DOUBLE_REF *r = new DOUBLE_REF; r->val = val; return r; 
}

BOOLEAN DOUBLE_REF::deep_equal ( DOUBLE_REF* p1, DOUBLE_REF* p2) {
	 return p1->_Equal ( 1, 1, p2); 
}

void DOUBLE_REF::deep_copy ( DOUBLE_REF* p1) { 
	_Copy ( 1, 1, p1); 
}

DOUBLE_REF* DOUBLE_REF::deep_clone ( DOUBLE_REF *x) {
	 return _Clone (1,1,x); 
}

DOUBLE_REF* _bibt_DOUBLE_DOUBLE_REF ( DOUBLE v)
{
	DOUBLE_REF *result;
	result = new DOUBLE_REF;
	result->set_value ( v);
	return result;
}

BOOLEAN DOUBLE_REF::_INFIX_LEQ ( DOUBLE_REF* other)
{
	return val < _DOUBLE_REF_chk ( other, "other")->val ? 
       		_ert_BOOLEAN_Const ( true) : _ert_BOOLEAN_Const ( false);
}

DOUBLE_REF* DOUBLE_REF::_INFIX_ADD ( DOUBLE_REF* other)
{
	DOUBLE_REF *r = new DOUBLE_REF; 
	r->val = _DOUBLE_REF_chk ( other, "other")->val + val;
	return r;
}

DOUBLE_REF* DOUBLE_REF::_INFIX_SUB ( DOUBLE_REF* other)
{
	DOUBLE_REF *r = new DOUBLE_REF; 
	r->val = _DOUBLE_REF_chk ( other, "other")->val - val;
	return r;
}

DOUBLE_REF* DOUBLE_REF::_INFIX_MUL ( DOUBLE_REF* other)
{
	DOUBLE_REF *r = new DOUBLE_REF; 
	r->val = _DOUBLE_REF_chk ( other, "other")->val * val;
	return r;
}

DOUBLE_REF* DOUBLE_REF::_INFIX_DIV ( DOUBLE_REF* other)
{
	DOUBLE_REF *r = new DOUBLE_REF; 
	r->val = _DOUBLE_REF_chk ( other, "other")->val / val;
	return r;
}

BOOLEAN DOUBLE_REF::_Conforms_to ( int other_id)  /* Don't use DOUBLE */
{
   	if ( class_id == other_id)
      	return true;

#ifdef _BOOLEAN_REF_H
	{
		ANY a;

		return a._Conforms_to ( other_id);
	}
#else
	{
   		NUMERIC n;

   		if ( n.class_id == other_id)
      		return true;

		return n._Conforms_to ( other_id);
	}
#endif
}
