with text_io;
--***********************************************
-- Recursive Factorial                          *
-- Guy Cox                                      *
-- Version 1.0                                  *
-- 17 May 1988                                  *
-- Inputs:                                      *
--      n - natural number                      *
-- Outputs                                      *
--      factorial of the input number           *
-- Raises:                                      *
--      numeric_error on result too large       *
--      data_error on incorrect data type       *
--***********************************************

procedure factorial is

package fac_io is new text_io.integer_io(natural);

any_number : natural;

function fac( n : in natural) return natural is
begin
  if n = 0 then return 1;     -- by definition
  elsif n = 1 then return 1;  -- by definition
  else
    return n *  fac(n - 1 );
  end if;
 end fac;

begin
   text_io.put("Enter a number ");
   fac_io.get(any_number);
   fac_io.put(fac(any_number));

exception
    when numeric_error =>
       text_io.put("That number is larger than I can handle (");
       fac_io.put(natural'last);
       text_io.put(")");
       text_io.new_line;
     when text_io.data_error =>
       text_io.put("Listen hosehead I said to enter a natural number");
     when others =>
       text_io.put("I am totally lost");
       text_io.new_line;
       raise; -- re-raise the exception so I can see the error
end factorial;
