--FALLING SNOW
-- 0.20  speed throttling
-- 0.21  poke off screen errors removed, added fancier graphics
--by Matt Sephton (u5ms@csc.liv.ac.uk)

-- Rob Craig: It was still sometimes poking off-screen so I put pixel() 
--            back in. mode 19 pixel() will be as fast as poke() in 1.5a
--            and will be totally safe.

without type_check

include get.e
include graphics.e
include image.e
include machine.e
include eulogo.e

constant GRAPHICS_MODE = 19             -- 320x200 256 colours, see graphics.e

constant POPULATION = 5000              -- number of specks
constant FPS = 1 / 50                   -- frames per sec (change divisor)

constant COLOUR = BRIGHT_WHITE          -- snow

sequence vc, speck
integer max_x, max_y, screen_x, screen_y

procedure init()
-- initialize global variables
    if graphics_mode(GRAPHICS_MODE) then
       puts(1, "Needs at least VGA graphics!\n")
       abort(1)
    end if
    vc = video_config()

    -- screen edge limits
    max_x = vc[VC_XPIXELS]
    max_y = vc[VC_YPIXELS]
    screen_x = max_x - 1
    screen_y = max_y - 1

    speck = {}
    
    text_color(BRIGHT_BLUE)
    position(9,6)
    puts(1, "F A L L I N G   S N O W   I N")
    position(19,13)
    puts(1, "by Matt Sephton")
    position(21,11)
    puts(1, "(u5ms@csc.liv.ac.uk)")
    display_image({29,91}, eulogo)
    
    --speed throttle
    tick_rate(100)
end procedure

procedure quit()
    --normal tick rate
    tick_rate(0)
    --revert to old graphics mode
    if graphics_mode(-1) then
    end if
end procedure

type video(integer x)
    return x >= 0 and x < 64000
end type

procedure fall()
-- main routine
    sequence old_pos
    atom k, throttle
    video v
    
    -- main loop
    while 1 do
	k = get_key()
	if k != -1 then         -- key pressed...
	   if k = 27 then       -- ESC, quits
	      exit
	   end if
	end if
    
	if length(speck) < POPULATION then
	    --add a new speck
	    speck = append(speck, {rand(screen_x), 0})
	end if

	--speed throttle
	throttle = time()
	--move all the specks
	for i = 1 to length(speck) do
	    --down
	    if get_pixel({speck[i][1], speck[i][2] + 1}) = BLACK then
		old_pos = speck[i]
		speck[i][2] = speck[i][2] + 1
	    --to left
	    elsif get_pixel({speck[i][1] - 1, speck[i][2] + 1}) = BLACK then
		old_pos = speck[i]
		speck[i][1] = speck[i][1] - 1
	    --to right
	    elsif get_pixel({speck[i][1] + 1, speck[i][2] + 1}) = BLACK then
		old_pos = speck[i]
		speck[i][1] = speck[i][1] + 1
	    --off screen
	    elsif speck[i][2] < 0 or speck[i][2] > screen_y or
		  speck[i][1] < 0 or speck[i][1] > screen_x then
		speck[i][1] = rand(screen_x)
		speck[i][2] = 0
	    --stuck
	    else
		speck[i][1] = rand(screen_x)
		speck[i][2] = 0
	    end if
	    
	    -- blank out previous position
	    pixel(BLACK, old_pos)
	    -- draw at new position
	    pixel(COLOUR, speck[i])
	end for
	while time()-throttle < FPS do
	end while
    end while
end procedure

-- program sequence
init()
fall()
quit()

