------------------------------------------------------------------------------
--HMR V0.1-- Hi-Res mouse support for WIN95-- G.Burke -- H.M.I. Software 6/97-
------------------------------{FreeWare}--------------graemejb@pronet.net.au--

include image.e
include machine.e

sequence pointer,scrblk,bitmask,bbitmask,
	oldmouse,blkos,p3,mp,rin,rout,
	dbstart,dbret,tt,bl,ll,rl,a,b,vc

object event
integer show_mouse,dbw,db_on


type point(sequence s)
    return length(s)=2  
end type

type gtpixl(sequence s)
    return length(s)=2 or length(s)=3 
end type

function checkevent(sequence e)
    
    if and_bits(2,event[1])=and_bits(2,e[1]) and and_bits(8,event[1])= 
	and_bits(8,e[1]) and event[2]=e[2] and event[3]=e[3] then
	
	return 0
    
    end if
    
    if event[1] != e[1] then
	if and_bits(2,event[1])>0 then
	    if and_bits(2,e[1])=0 then
		e[1]= or_bits(4,e[1])
	    end if
	end if
	if and_bits(8,event[1])>0 then
	    if and_bits(8,e[1])=0 then
		e[1]= or_bits(16,e[1])
	    end if
	end if
    end if 
    if event[2]!=e[2] or event[3]!=e[3] then
	e[1]=e[1]+1
    end if
    
    event=e
    
    return 1
    
end function

function tl(point a,point b)
    
    -- Find Top Left Corner
    for loop=1 to 2 do
	if a[loop]>b[loop] then
	    a[loop]=b[loop]
	end if
    end for
    
    return a

end function

function br(point a,point b)
    
    -- Find Bottom Right Corner
    for loop=1 to 2 do
	if a[loop]<b[loop] then
	    a[loop]=b[loop]
	end if
    end for

    return a

end function

global procedure HRM_limit(point min,point max)
    
    -- Limit Mouse to rectangle.
    rin = repeat(0,10)
    rout = rin
    rin[REG_AX] = 0 
    rout = dos_interrupt(#33,rin)

    if rout[REG_AX] != 0 then
	rin[REG_AX] = 7
	rin[REG_CX] = min[1]
	rin[REG_DX] = max[1] - 1
	rout = dos_interrupt(#33,rin)
	
	rin[REG_AX] = 8 
	rin[REG_CX] = min[2]
	rin[REG_DX] = max[2] - 1
	rout = dos_interrupt(#33,rin)
    else
	abort(1)
    end if
	
end procedure

procedure nozeros()
    
    sequence test
    test=(mp-1)>0
    mp=(mp-1)*test+1
    test=(oldmouse-1)>0
    oldmouse=(oldmouse-1)*test+1
    
end procedure

function si(sequence p1,sequence p2)

    -- friendly save_image()
    -- for co-ords < 1
    sequence tblk1,tblk2,p4,test
    p3=p1-1         
    p4=p3>0
    p3=p3*p4+1
    
    blkos=p3-p1
    test=(p3!=p1)
    
    if test[1] or test[2] then
	tblk1=save_image(p3,p2)
	tblk2=repeat(repeat({0},48),48)
	for loop=blkos[2]+1 to 48 do
	    tblk2[loop][blkos[1]+1..48]=tblk1[loop-blkos[2]][1..48-blkos[1]]
	end for
	return tblk2
    end if
    return save_image(p1,p2)

end function

procedure di (sequence p1,sequence p2)
    
    -- friendly display_image()
    sequence tmpblk,size,test
    test=(p1!=p3)
    if test[1] or test[2] then
	size=48-blkos
	tmpblk=repeat(repeat({0},size[1]),size[2])
	for loop=1 to size[2] do
	    tmpblk[loop][1..size[1]]=p2[loop+blkos[2]][blkos[1]+1..48]
	end for
	display_image(p3,tmpblk)
    else    
	display_image(p3,p2)
    end if
	
end procedure

global procedure HRM_init(object pal)
    
    sequence temp
    if sequence(pal) then
	if length(pal)=2 then
	    all_palette(pal[1])
	    pointer=pal[2]
	else 
	    if length(pal)=16 then
		pointer=pal
	    end if
	end if
    else    
	temp=read_bitmap("mouse.bmp")
	if pal=1 then
	    all_palette(temp[1])
	end if
	pointer=temp[2]
    end if
    scrblk=save_image({1,1},{16,16})
    bitmask= not pointer
    bbitmask=save_image({1,1},{48,48})*0+1
    for loop=17 to 32 do
	bbitmask[loop][17..32]=bitmask[loop-16][1..16]
    end for
    oldmouse={1,1}
    show_mouse=1
    vc=video_config()
    event={0,0,0}
    dbstart={0,0,{0,0}}
    dbret={0,{0,0},{0,0}}
    HRM_limit({0,0},{vc[VC_XPIXELS],vc[VC_YPIXELS]})
    db_on=-1

end procedure

global function HRMget_pixel(gtpixl pp)
	
    -- Friendly Get Pixel
    -- Sees Through Pointer
    integer p1,p2
    sequence out
    out={}
    if length(pp)=2 then
			
	if pp[1]>(oldmouse[1]-1) and pp[1]<(oldmouse[1]+16) 
	    and pp[2]>(oldmouse[2]-1) and pp[2]<(oldmouse[2]+16) then
	    
	    return scrblk[pp[2]-oldmouse[2]+1][pp[1]-oldmouse[1]+1]
	else
	    return machine_func(21,pp)
	end if
    
    else
	
	if pp[2]>oldmouse[2]-1 and pp[2]<oldmouse[2]+16 then
	    p1=pp[1]
	    p2=pp[1]+pp[3]-1
	    if p1<oldmouse[1] and p2>oldmouse[1]-1 then
		out=machine_func(21,{p1,pp[2],oldmouse[1]-p1})
		out=out&scrblk[pp[2]-oldmouse[2]+1][1..16]
		if p2>oldmouse[1]+15 then
		    out=out&machine_func
		    (21,{oldmouse[1]+16,pp[2],p2-oldmouse[1]-15})
		end if
		return out[1..pp[3]]
	    end if
	    if p1>oldmouse[1]-1 and p1<oldmouse[1]+16 then
		out =scrblk[pp[2]-oldmouse[2]+1][p1-oldmouse[1]+1..16]
		if p2>oldmouse[1]+15 then
		    out=out&machine_func
		    (21,{oldmouse[1]+16,pp[2],p2-oldmouse[1]-15})
		end if
		return out[1..pp[3]]
	    end if
	end if
	return machine_func(21,pp)
    end if
    
end function

procedure put_db()
    
    a=tl(dbstart[3],event[2..3])
    b=br(dbstart[3],event[2..3])
    dbw=b[1]-a[1]+1
    ll={} rl={}
    
    tt=HRMget_pixel({a[1],a[2],dbw})
    bl=HRMget_pixel({b[1]-dbw+1,b[2],dbw})
    
    
    for loop=a[2]+1 to b[2]-1 do
	
	    ll=append(ll,HRMget_pixel({a[1],loop}))
	    rl=append(rl,HRMget_pixel({b[1],loop}))
    
    end for
    
    
end procedure

procedure remove_db()
    integer pos
    
	pos=0
    for loop= a[1] to b[1] do
	pos=pos+1
	machine_proc(4,{tt[pos],{loop,a[2]}})
	machine_proc(4,{bl[pos],{loop,b[2]}})
    end for
    pos=0
    for loop= a[2]+1 to b[2]-1 do
	pos=pos+1
	machine_proc(4,{ll[pos],{a[1],loop}})
	machine_proc(4,{rl[pos],{b[1],loop}})
    end for
end procedure

procedure dbin()
    
    if dbstart[1] !=0 then
	remove_db()
	if and_bits(dbstart[2],event[1])>0 then
	    
	    dbret= {dbstart[1],
		    tl(dbstart[3],event[2..3]),
		    br(dbstart[3],event[2..3])}
	    dbstart[1]=0
	    if dbret[3][1]>dbret[2][1] or dbret[3][2]>dbret[2][2] then
		event[1]=event[1]+128
	    end if
	end if
	put_db()
    else
	if and_bits(event[1],10)>0 then
	    if and_bits(event[1],2)=2 then
		dbstart[1]=2
		dbstart[2]=4
	    else
		dbstart[1]=8
		dbstart[2]=16
	    end if
	    dbstart[3]={event[2],event[3]}
	    put_db()
	end if
    end if

end procedure


global function HRM()
    
    object e
    sequence dif,too,check,c2,bscrblk
    integer tps,sp
	    
    e={0,0,0}
    rin[REG_AX]=3
    rout=dos_interrupt(#33,rin)
    e[1]=and_bits(1,rout[REG_BX])*2
    e[1]=e[1]+and_bits(2,rout[REG_BX])*4
    e[2]=rout[REG_CX]
    e[3]=rout[REG_DX]
	    
    if checkevent(e) then
	
	if show_mouse !=0 then
	    
	    
	    if db_on+1 >0 then
		dbin()
	    end if
	    
	    mp={event[2],event[3]}
	    nozeros()
	    dif=oldmouse-mp
	    too=dif+17
	    c2=too<30
	    check=c2*(too>2)
	    
	    if check[1] and check[2] then
		
		-- Flicker Free Routine for Small Mouse Movements
		
		tps=too[1]+15
		-- Get Big screen Block
		bscrblk=si(mp-16,mp+31)
		
		-- Remove Previous Pointer from BSB
		for loop=too[2] to too[2]+15 do
		    
		    sp=loop-too[2]+1
		    bscrblk[loop][too[1]..tps]=scrblk[sp][1..16]
		    
		end for
		
		-- Save Screen Under New Pointer
		for loop=1 to 16 do
		    scrblk[loop][1..16]=bscrblk[loop+16][17..32]
		end for
		
		-- Punch Hole for Pointer
		bscrblk=bscrblk*bbitmask
		
		-- Merge Pointer
		for loop=17 to 32 do
		    bscrblk[loop][17..32]=
		    bscrblk[loop][17..32]+pointer[loop-16][1..16]
		end for
		-- Paste Image
		di(mp-16,bscrblk)
		oldmouse=mp
		nozeros()
	    
	    else
		
		--Standard Routine for Mouse Movements > 16
		
		display_image(oldmouse,scrblk)
		oldmouse={event[2],event[3]}
		nozeros()
		scrblk=si(oldmouse,oldmouse+15)
		di(oldmouse,scrblk*bitmask+pointer)
	    
	    end if
	    if dbstart[1]>0 then
		machine_proc(2,{db_on,0,
	{{a[1],a[2]},{b[1],a[2]},{b[1],b[2]},{a[1],b[2]},{a[1],a[2]}}})
		
	    end if
	end if
	
	return event
	
    end if
    
    return 0 
    
end function

global function HRMdrag_box(integer ds)

    --Turn Drag-Box Support on/off
    --Set Drag-Box Color
    --Return Drag-Box data
    if ds<0 and db_on>-1 and dbstart[1]>0 then
	remove_db()
	dbstart[1]=0
    end if
    
    if ds>vc[7] then
	ds=vc[7]
    end if
    
    db_on=ds
    
    return dbret

end function

global procedure HRMouse_pointer(integer sm)

    --turn pointer on/off (1/0)
    if sm=0 then
	
	remove_db()
	dbstart[1]=0
	display_image(oldmouse,scrblk)
	
    elsif show_mouse=0 then
	
	scrblk=save_image(oldmouse,oldmouse+15)  
	display_image(oldmouse,scrblk*bitmask+pointer)
    
    end if
    
    show_mouse=sm

end procedure
