;	Title:			IntelliBots System Includes
;	Created By:		ITI
;	Description:	predefined names and values
;	Version:		1.0
;	Last change:	3 August 95
;
;	WARNING!!		These are provided to help you with your programming.
;					These values are permanently set within the IntelliBots program.
;					Change these values at your own risk! Undefined behaviour may result.

; read/write port constants
ERROR					EQU	0						; current error status
RELATIVEX				EQU	1						; movement from initial position
RELATIVEY				EQU	2						; movement from initial position
INTPROCTIMER			EQU	3						; timer interrupt handler
INTPROCKEY				EQU	4						; keyboard interrupt handler
INTPROCSCAN				EQU	5						; scanned interrupt handler
INTPROCCOMM				EQU	6						; communitcation received interrupt handler
INTPROCDAMAGE			EQU	7						; damaged interrupt handler
INTPROCATTACK			EQU	8						; attacked interrupt handler
INTPROCERROR			EQU	9						; error interrupt handler
INTMASK					EQU	10						; interrupt mask (handled interrupts)
INTPENDING				EQU	11						; interrupts waiting execution
INTEXECUTING			EQU	12						; interrupts currently executing
MESSAGE					EQU	13						; message address for communication
SCANOBJECT				EQU	14						; scan code from last scan
SCANDISTANCE			EQU	15						; scan distance from last scan
SCANX					EQU	16						; relative distance to scanned object
SCANY					EQU	17						; relative distance to scanned object
SIDEATTACKED			EQU	18						; which side was attacked
SIDESCANNED				EQU	19						; which side was scanned
DAMAGINGOBJ				EQU	20						; scan code of last object which caused damage
LASTKEY					EQU	21						; last keystroke value in ASCII code

READONLYPORTMASK		EQU	$00008000				; mask to tell difference between r/w and r/o ports

; read only port constants
ARMORFRONT				EQU	0 | READONLYPORTMASK	; front armor capacity remaining
ARMORRIGHT				EQU	1 | READONLYPORTMASK	; right armor capacity remaining
ARMORBACK				EQU	2 | READONLYPORTMASK	; back armor capacity remaining
ARMORLEFT				EQU	3 | READONLYPORTMASK	; left armor capacity remaining
SHIELDFRONT				EQU	4 | READONLYPORTMASK	; front shield capacity remaining
SHIELDRIGHT				EQU	5 | READONLYPORTMASK	; right shield capacity remaining
SHIELDBACK				EQU	6 | READONLYPORTMASK	; back shield capacity remaining
SHIELDLEFT				EQU	7 | READONLYPORTMASK	; left shield capacity remaining
SHELLS					EQU	8 | READONLYPORTMASK	; number of cannon projectiles remaining
CHASSISDIR				EQU	9 | READONLYPORTMASK	; current direction chassis is facing (absolute)
TURRETDIR				EQU	10 | READONLYPORTMASK	; current direction turret is facing (absolute)
LASERTEMP				EQU	11 | READONLYPORTMASK	; current laser temperature
CANNONTEMP				EQU	12 | READONLYPORTMASK	; current cannon temperature
TICKS					EQU	13 | READONLYPORTMASK	; counts down
TIMER					EQU	14 | READONLYPORTMASK	; counts up
POWER					EQU	15 | READONLYPORTMASK	; power reserves remaining



; CoProcessor constants (COPR instruction)
; chassis commands
CHASSISTURN				EQU	$0000					; turn chassis relative
CHASSISTURNTO			EQU	CHASSISTURN + 1			; turn chassis absolute
CHASSISSCAN				EQU	CHASSISTURNTO + 1		; short range (chassis) scan
CHASSISMOVE				EQU	CHASSISSCAN + 1			; move

; turret commands
TURRETTURN				EQU	$0100					; turn turret relative
TURRETTURNTO			EQU	TURRETTURN + 1			; turn turret absolute
TURRETSCAN				EQU	TURRETTURNTO + 1		; long range (turret) scan

; offensive commands
OFFENSELASER			EQU	$0200					; fire laser
OFFENSECANNON			EQU	OFFENSELASER + 1		; launch a projectile
OFFENSEDESTRUCT			EQU	OFFENSECANNON + 1		; self-destruct

; defensive commands
DEFENSESHIELDFRONT		EQU	$0300					; raise front shield
DEFENSESHIELDRIGHT		EQU	DEFENSESHIELDFRONT + 1	; raise right shield
DEFENSESHIELDBACK		EQU	DEFENSESHIELDRIGHT + 1	; raise back shield
DEFENSESHIELDLEFT		EQU	DEFENSESHIELDBACK + 1	; raise left shield
DEFENSECLOAK			EQU	DEFENSESHIELDLEFT + 1	; cloak mode ON/OFF

;System commands (SYS instruction)
; general commands
COPRSTOP				EQU	$0000					; stop a coprocessor
COPRWAIT				EQU	COPRSTOP + 1			; wait on a coprocessor
COPRMODE				EQU	COPRWAIT + 1			; async mode ON/OFF
STATUSTEXT				EQU	COPRMODE + 1			; display a message
OBJECTSTATE				EQU	STATUSTEXT + 1			; Identify friend / foe / Alive / Dead
MESSAGESEND				EQU	OBJECTSTATE + 1			; send a message
COPRCURCMD				EQU	MESSAGESEND + 1			; currently executing coprocessor command

RANDOM					EQU	$0100					; random number
MISSIONINFO				EQU	$0200					; mission information system call
MISLOCALESIZE			EQU	$0000					; mission info map size request
MISOBJECTIVE			EQU	MISLOCALESIZE + 1		; mission info objective request

;boolean equates
FALSE					EQU 0
TRUE					EQU	1

;cloak mode
OFF						EQU	0
ON						EQU	1

;async mode
SYNC					EQU	OFF						; wait for co-processor command completion 
ASYNC					EQU	ON						; continue while co-processor executes

; identification results
ALIVE					EQU	-1						; robot is alive
DEAD					EQU	1						; robot is dead
NEUTRAL					EQU	0						; robot is not functioning

; **** MISC
; scan masks
SCANMASKLIGHTDAMAGE		EQU	$01						; $0001/1	will isolate the light damage bit
SCANMASKMEDIUMDAMAGE	EQU	$02						; $0002/2	will isolate the medium damage bit
SCANMASKHEAVYDAMAGE		EQU	SCANMASKLIGHTDAMAGE | SCANMASKMEDIUMDAMAGE	; $0003/3	will isolate the heavy damage bits
SCANMASKLTPOWERDAMAGE	EQU	$04						; $0004/4	will isolate the light power damage bit
SCANMASKMEDPOWERDAMAGE	EQU	$08						; $0008/8	will isolate the medium power damage bit
SCANMASKHVYPOWERDAMAGE	EQU	SCANMASKLTPOWERDAMAGE | SCANMASKMEDPOWERDAMAGE	; $000C/12	will isolate the heavy power damage bits
SCANMASKDAMAGE			EQU	SCANMASKHEAVYDAMAGE | SCANMASKHVYPOWERDAMAGE	; $000F/15	will isolate all damage bits
SCANMASKLOWSCAN			EQU	$10						; $0010/16	will isolate the low scan bit
SCANMASKHIGHSCAN		EQU	$20						; $0020/32	will isolate the high scan bit
SCANMASKSCAN			EQU	SCANMASKLOWSCAN | SCANMASKHIGHSCAN	; $0030/48	will isolate the scan bits
SCANMASKATTR			EQU	$00FF					; $00FF/127	will isolate the attributes
SCANMASKOBJECT			EQU	$8000					; $8000/32768	will isolate the object bit
SCANMASKID				EQU	$FF00					; $FF00/65280	will isolate the id

; scan code constants
EMPTY					EQU	$0000					; does not block scan
LOWCOVER				EQU	$0200 | SCANMASKLOWSCAN	; no damage hard to see
HIGHCOVER				EQU	$0300 | SCANMASKSCAN	; no damage hard to see
LIGHTNATURAL			EQU	$0400 | SCANMASKLIGHTDAMAGE | SCANMASKLOWSCAN	; light vegetation
MEDIUMNATURAL			EQU	$0600 | SCANMASKMEDIUMDAMAGE | SCANMASKSCAN	; medium vegetation
HEAVYNATURAL			EQU	$0800 | SCANMASKHEAVYDAMAGE | SCANMASKSCAN	; heavy vegetation
POWERNATURAL			EQU	$0A00 | SCANMASKLTPOWERDAMAGE | SCANMASKLOWSCAN	; no damage power sink
LIGHTOBSTR				EQU	$0500 | SCANMASKLIGHTDAMAGE | SCANMASKLOWSCAN	; constructed
MEDIUMOBSTR				EQU	$0700 | SCANMASKMEDIUMDAMAGE | SCANMASKSCAN	; constructed
HEAVYOBSTR				EQU	$0900 | SCANMASKHEAVYDAMAGE | SCANMASKSCAN	; constructed
POWEROBSTR				EQU	$0B00 | SCANMASKHEAVYDAMAGE | SCANMASKLTPOWERDAMAGE | SCANMASKSCAN	; constructed no damage power sink
BARRIER					EQU	$0100 | SCANMASKHEAVYDAMAGE | SCANMASKHVYPOWERDAMAGE | SCANMASKSCAN	; high damage power sink
HIGHGOAL				EQU	$9100 | SCANMASKSCAN
LOWGOAL					EQU	$9000 | SCANMASKLOWSCAN
MINE					EQU	$A000 | SCANMASKHEAVYDAMAGE | SCANMASKLOWSCAN
ENERGYSTATION			EQU	$A100 | SCANMASKSCAN
REPAIRSTATION			EQU	$A200 | SCANMASKSCAN
IBOT1					EQU	$8000 | SCANMASKHEAVYDAMAGE | SCANMASKMEDPOWERDAMAGE | SCANMASKSCAN
IBOT2					EQU	$8100 | SCANMASKHEAVYDAMAGE | SCANMASKMEDPOWERDAMAGE | SCANMASKSCAN
IBOT3					EQU	$8200 | SCANMASKHEAVYDAMAGE | SCANMASKMEDPOWERDAMAGE | SCANMASKSCAN
IBOT4					EQU	$8300 | SCANMASKHEAVYDAMAGE | SCANMASKMEDPOWERDAMAGE | SCANMASKSCAN
IBOTLAST				EQU IBOT1 | $0F00			; last possible IBot
UNKNOWN					EQU	-1

; interrupt level constants
INTMASKERROR			EQU	$0040
INTMASKATTACK			EQU	$0020
INTMASKDAMAGE			EQU	$0010
INTMASKCOMM				EQU	$0008
INTMASKSCAN				EQU	$0004
INTMASKKEY				EQU	$0002
INTMASKTIMER			EQU	$0001

; interrupt level bit constants
INTBITERROR				EQU	6
INTBITATTACK			EQU	5
INTBITDAMAGE			EQU	4
INTBITCOMM				EQU	3
INTBITSCAN				EQU	2
INTBITKEY				EQU	1
INTBITTIMER				EQU	0

; coprocessor constants
CHASSIS					EQU	$0000
TURRET					EQU	CHASSIS + 1
OFFENSE					EQU	TURRET + 1
DEFENSE					EQU	OFFENSE + 1

; robot plate constants
PLATEFRONT				EQU	0
PLATERIGHT				EQU	1
PLATEBACK				EQU	2
PLATELEFT				EQU	3

; weapon temperature constants
LASERMELTTEMP			EQU	75						; temperature at which laser will melt
CANNONMELTTEMP			EQU	125						; temperature at which cannon will melt
LASERMAXPOWER			EQU	50						; max power laser can fire
CANNONINC				EQU	110						; amount of heat generated with a cannon shot
DEFENSEMAX				EQU	800						; max power allocated to defense

; status register bit constants
SRBITSIGN				EQU	15						; Sign
SRBITZERO				EQU	14						; Zero
SRBITCARRY				EQU	13						; Carry
SRBITOFLOW				EQU	12						; Overflow
SRBITQMODE				EQU	7						; async mode on / off
SRBITCLOAK				EQU	6						; cloak on / off
SRBITATTACK				EQU	3						; Attacked
SRBITDAMAGE				EQU	2						; Damaged
SRBITCOMM				EQU	1						; Communication received
SRBITSCAN				EQU	0						; Scanned

; status register mask constants
SRMASKSIGN				EQU	$8000					; Sign
SRMASKZERO				EQU	$4000					; Zero
SRMASKCARRY				EQU	$2000					; Carry
SRMASKOFLOW				EQU	$1000					; Overflow
SRMASKQMODE				EQU	$0080					; async mode on / off
SRMASKCLOAK				EQU	$0040					; cloak on / off
SRMASKATTACK			EQU	$0008					; Attacked
SRMASKDAMAGE			EQU	$0004					; Damaged
SRMASKCOMM				EQU	$0002					; Communication received
SRMASKSCAN				EQU	$0001					; Scanned

; error constants
ERROPCODE				EQU 1						; executed an invalid opcode
ERRADDRESS				EQU	2						; used an invalid address
ERRPORT					EQU	3						; used an invalid port
ERRINTERRUPT			EQU	4						; error interrupt occurred but was improperly set-up
ERRREGISTER				EQU	5						; used an invalid register
ERROUTOFPOWER			EQU	6						; IBot power is gone
ERRSTACKOVERFLOW		EQU	7						; put too much data on stack
ERRSTACKUNDERFLOW		EQU	8						; took too much data off stack
ERRDIVZERO				EQU	9						; divide by zero
ERRINVALIDCOP			EQU	10						; invalid call to a coprocessor
ERRINVALIDSYS			EQU	11						; invalid call to system
ERRINVALIDGROUP			EQU	12						; invalid call to a coprocessor or system
