;******************************************************
;TITLE:        SEEKER.ASM
;CREATED BY:   Intelligent Technologies
;DESCRIPTION:  This program makes an IBot wander around and
;              then search for a target
;NOTES:        This program supports a more advanced hunt algorithm
;              so that if an aquired target moves an attempt is made
;              to relocate it
;Name             Date          Description
;---------------- ------------- -------------------
;ITI              July 22, 1995 created the program
;******************************************************

	.NAME	"Seeker"


;******************************************************
; Start
;
; DESC:   This is the starting point for the program
; IN:     nothing
; OUT:    nothing
; NOTES:  nothing
Start
	MOVE	#-1,R6				;initialize the turret direction storage
	CALL	Wander				;wander someplace else
	CALL	Hunt				;hunt for an enemy ibot
	JUMP	Start


;******************************************************
; Fire
;
; DESC:   Fire laser at enemy IBot
; IN:     nothing
; OUT:    nothing
; NOTES:  This routine assumes that the turret is already
;         pointing in the correct direction,  also this
;         routine destroys the contents of R0 and R1
Fire
	GETP	#LASERTEMP,R0		;get the current laser temperature
	JL		FireLaserDead		;-laser is burned out
	MOVE	#LASERMELTTEMP,R1	;get the burn out power
	SUB		R0,R1				;subtract the current temperature
	CMP		#25,R1				;is laser cool enough to fire
	JLE		FireExit			;-laser too hot to fire
	COPR	#OFFENSELASER,R1	;fire the laser
FireExit
	RTS
FireLaserDead
	LEA		LaserDeadStr,R0
	SYS		#STATUSTEXT,R0
	HALT
	

;******************************************************
; Hunt
;
; DESC:   Search for an enemy IBot
; IN:     nothing
; OUT:    nothing
; NOTES:  This routine scans in a complete circle searching for
;         a target, and destroys the contents of R0, R1, R5 and R6
Hunt
	MOVE	#360,R0				;init the max sweep
HuntLoop
	COPR	#TURRETSCAN,#0		;scan in current direction
	GETP	#SCANDISTANCE,R5	;get the distance to the scanned object
	GETP	#SCANOBJECT,R1		;get the object scanned
	JLE		HuntNext			;-nothing, do next
	CMP		#IBOT1,R1			;is the object an IBot?
	JL		HuntNotIBot			;-not an IBot
	CMP		#IBOT4,R1			;is the object an IBot?
	JLE		HuntFoundIbot		;-yes
HuntNotIBot
	MOVE	#5,R1				;set the standard sweep increment
	CMP		#8,R5				;was the terrain close
	JG		HuntTurn			;-not close enough to wory about
	MOVE	#15,R1				;set faster sweep increment
HuntTurn
	SUB		R1,R0				;decrement the total sweep
	JLE		HuntExit			;-done
	COPR	#TURRETTURN,R1		;turn the turret to new scan direction
	JUMP	HuntLoop			;-scan again
HuntNext
	MOVE	#5,R1				;set standard sweep increment
	JUMP	HuntTurn			;-turn the turret
HuntFoundIbot
	GETP	#TURRETDIR,R6		;get the turret direction
	CALL	Fire				;fire at the ibot
	CALL	Scan				;scan for it again
	JUMP	Hunt				;-begin a new hunt
HuntExit
	RTS


;******************************************************
; Move
;
; DESC:   Move the IBot
; IN:     R0 = absolute angle to turn to before moving
;         R1 = distance to move
; OUT:    nothing
; NOTES:  nothing
Move
	PUSH	R0					;save r0
	PUSH	R1					;save r1
	PUSH	R2					;save r2
	GETP	#CHASSISDIR,R2		;get the current chassis direction
	SUB		R2,R0				;calculate the amount to turn
	JE		MoveMove			;-don't need to turn, check distance to move
	COPR	#CHASSISTURN,R0		;turn the chassis
MoveMove
	SUB		#2,R1				;how far do we need to move
	JLE		MoveExit			;-don't need to move, exit
	COPR	#CHASSISMOVE,R1		;move the ibot
MoveExit
	POP		R2					;restore r2
	POP		R1					;restore r1
	POP		R0					;restore r0
	RTS


;******************************************************
; Scan
;
; DESC:   Scan for an enemy and move closer if necessary
; IN:     nothing
; OUT:    nothing
; NOTES:  This routine assumes that the turret is already
;         pointing in the correct direction,  also this
;         routine destroys the contents of R0, R1, R5 and R6
Scan
	COPR	#TURRETSCAN,#0		;scan for enemy ibot
	GETP	#SCANOBJECT,R0		;get the scan results
	JLE		ScanCheckExit		;-nothing
	MOVE	R0,R1				;save the scan result
	CMP		#IBOT1,R1			;is the object an IBot?
	JL		ScanCheckExit		;-not an IBot
	CMP		#IBOT4,R1			;is the object an IBot?
	JG		ScanCheckExit		;-yes
	GETP	#TURRETDIR,R6		;get the turret direction
	GETP	#SCANDISTANCE,R5	;get the distance to the enemy
ScanCheckFire
	CMP		#20,R5				;are we closer than 20
	JG		ScanMoveCloser		;-no, move closer
	CALL	Fire				;fire at the ibot
	JUMP	Scan				;-go scan again
ScanMoveCloser
	MOVE	R6,R0				;set the angle to turn to
	MOVE	R5,R1				;set the distance to move
	LSR		#1,R1				;calculate what half the distance would be
	CALL	Move				;move the ibot
	CALL	TurnTurret			;turn the turret
	JUMP	Scan				;-go scan again
ScanCheckExit
	CMP		#-1,R6
	JE		ScanExit
	CALL	Search
	JPL		ScanCheckFire
ScanExit
	RTS
	

;******************************************************
; Search
;
; DESC:   Search for enemy after it moves
; IN:     nothing
; OUT:    R5 = distance to scanned object/terrain
;         R6 = direction to scanned object/terrain
; NOTES:  This routine assumes that the turret is pointing
;         in the direction the enemy was last seen,  also this
;         routine destroys the contents of R0 and R1
Search
	MOVE	#18,R0				;initialize scan count
	COPR	#TURRETTURN,#-45	;turn the turret -45 degrees
	JUMP	SearchDoScan
SearchTryAgain
	DEC		R0					;decrement count and check if it is negative
	JL		SearchFailed		;-if count is negative, search failed
	COPR	#TURRETTURN,#5		;turn the turret 5 degrees
SearchDoScan
	COPR	#TURRETSCAN,#0		;scan
	GETP	#SCANOBJECT,R1		;get the scan result
	JLE		SearchTryAgain		;-if nothing, try again
	CMP		#IBOT1,R1			;is the object an IBot?
	JL		SearchTryAgain		;-not an IBot
	CMP		#IBOT4,R1			;is the object an IBot?
	JG		SearchTryAgain		;-yes
	GETP	#TURRETDIR,R6		;get the turret direction
	GETP	#SCANDISTANCE,R5	;get the scan distance
	RTS
SearchFailed
	MOVE	#-1,R6				;set the direction to not found
	RTS


;******************************************************
; TurnTurret
;
; DESC:   Turn the IBot turret
; IN:     R0 = absolute angle to turn the turret to
; OUT:    nothing
; NOTES:  nothing
TurnTurret
	PUSH	R0					;save r0
	PUSH	R2					;save r2
	GETP	#TURRETDIR,R2		;get the current turret direction
	SUB		R2,R0				;calculate the amount to turn
	JE		TurnTurretExit		;-don't need to turn, check distance to move
	COPR	#TURRETTURN,R2		;turn the chassis
TurnTurretExit
	POP		R2					;restore r2
	POP		R0					;restore r0
	RTS


;******************************************************
; Wander
;
; DESC:   Make the IBot wander
; IN:     nothing
; OUT:    nothing
; NOTES:  This routine destroys the contents of R0 and R1
Wander
	COPR	#TURRETSCAN,#0		;scan in the current turret direction
	GETP	#SCANOBJECT,R0		;get the object scanned
	JLE		WanderNothing		;-nothing, ok to move
	CMP		#IBOT1,R0			;is the object an IBot?
	JL		WanderExit			;-not an IBot
	CMP		#IBOT4,R0			;is the object an IBot?
	JG		WanderExit			;-yes
	GETP	#SCANDISTANCE,R0	;get the distance to the scanned object
	CMP		#10,R0				;is there room to move
	JLE		WanderNew			;-no room, check for a new direction
WanderNothing
	GETP	#TURRETDIR,R0		;get the turret direction
	MOVE	#20,R1				;set the distance
	CALL	Move				;move the ibot
WanderExit
	RTS
WanderNew
	COPR	#TURRETTURN,#10		;turn the turret
	JUMP	Wander				;-check the new direction


LaserDeadStr
	DSTR	"Laser burned out!"
