;******************************************************
;TITLE:        WANDERER.ASM"
;CREATED BY:   Intelligent Technologies
;DESCRIPTION:  This program makes an IBot wander around and avoid
;              any obstacles that would cause it damage
;NOTES:        This program supports a more advanced movement algorithm
;              so that it is able to move up next to objects without
;              hitting them
;Name             Date          Description
;---------------- ------------- -------------------
;ITI              July 22, 1995 created the program
;******************************************************


	.NAME	"Wanderer"
	
Start
	COPR	#CHASSISSCAN,#0		;do a chassis scan in the new direction
	GETP	#SCANDISTANCE,R1	;get the distance to the object scanned
	GETP	#SCANOBJECT,R0		;get the object scanned
	JE		TryToMove			;-if the scanned terrain is EMPTY then just move
	MOVE	R0,R2				;get the object scanned
	TSTB	#15,R2
	JNZ		HandleTerrain		;-terrain
	CMP		#IBOT4,R2			;is it a robot?
	JG		HandleNonRobot		;-not a robot
	CMP		#4,R1				;is the robot farther away than 4 squares?
	JG		ShootCannon			;-yes, try to shoot it with the cannon
	JUMP	ShootLaser			;-no, shoot it with the laser

HandleTerrain
	TEST	#$0006,R2			;does the terrain do medium or power damage
	JNE		HandleBadTerrain	;-yes

TryToMove
	CMP		#2,R1				;are we moving at all?
	JLE		TryToTurn			;-no, turn instead
	COPR	#CHASSISMOVE,R1		;move the robot
	JUMP	Start

TryToTurn
	MOVE	#0,BestDistance		;initialize the best distance
	MOVE	#-120,R4			;get the current chassis direction
TryNewDir
	ADD		#15,R4				;turn a little
	CMP		#120,R4				;are we done?
	JG		Turn				;-yes, use the best direction
	COPR	#CHASSISSCAN,R4		;scan in the new direction
	GETP	#SCANDISTANCE,R1	;get the distance to the object scanned
	CMP		R1,BestDistance		;is the new distance better than the best to date?
	JG		TryNewDir			;-no, try another one
	JL		UseDir				;-yes, use this one
	CMP		#-90,BestDirection	;is the best direction greater than -90 degrees
	JL		UseDir				;-yes, then use it
	CMP		#90,BestDirection	;is the best direction less than or equal to 90 degrees
	JLE		TryNewDir			;-yes, try another one
UseDir	
	MOVE	R1,BestDistance		;save the new distance
	MOVE	R4,BestDirection	;save the new direction
	JUMP	TryNewDir			;try another direction
Turn
	CMP		#0,BestDirection	;is the best direction straight ahead(are we stuck)?
	JNE		DoTurn				;-no, turn the chassis
	MOVE	#45,BestDirection	;set the turn to 45
DoTurn
	COPR	#chassisturn,BestDirection	;turn the chassis
	JUMP	Start				;goto the main loop
	
HandleBadTerrain
HandleNonRobot
	DEC		R1					;decrement the distance so that we do not hit the obstruction
	JUMP	TryToMove			;now move

ShootCannon
	GETP	#CANNONTEMP,R3		;get the cannon temp
	ADD		#CANNONINC,R3		;add in the temp per firing
	CMP		#CANNONMELTTEMP,R3	;will we melt the cannon if we fire?
	JGE		ShootLaser			;-yes, shoot the laser instead
	COPR	#OFFENSECANNON,R1	;shoot the cannon
	JUMP	Start				;goto the main loop

ShootLaser
	GETP	#LASERTEMP,R3		;get the laser temp
	MOVE	#LASERMELTTEMP,R4	;get the laser melt temp
	SUB		R3,R4				;calculate the difference
	CMP		#25,R4				;is it addequate for firing?
	JL		Start				;-no, goto the main loop
	COPR	#OFFENSELASER,R4	;fire the laser
	JUMP	Start				;goto the main loop

BestDistance
	DL	0
BestDirection
	DL	0
