--   Get some information about the computer from cmos ram
--   by Jacques Deschenes, Baie-Comeau, PQ. Canada

include machine.e

function Hex(integer i)
-- convert integer number to hexadecimal.
sequence HexDigit,HexStr
    HexDigit = "0123456789ABCDEF"
    HexStr = {}
    while i > 0 do
      HexStr=HexDigit[remainder(i,16)+1] & HexStr
      i = floor(i/16)
    end while
    if length(HexStr)=0  then
	return "#0"
    end if
    return '#' & HexStr
end function -- Hex()


sequence code

code = { -- binaray code to
#50,#53,        -- PUSH AX, PUSH BX
#BB,0,0,0,0,    -- MOV EBX, 0   -- poke here a pointer to result storage
#B0,#0,         -- MOV AL, 0    -- poke here register to read
#E6,#70,        -- OUT #70, AL   cmos register to be read
#E4,#71,        -- IN  AL, #71   read cmos data byte
#88,#03,        -- MOV [EBX], AL  store data byte at end of code segment
#5B,#58,#C3,    -- POP BX,  POP AX, RET  -- restore ax and bx and quit
#0}             -- DB ?  end of code where cmos byte read will be stored.

atom AsmFct
AsmFct = allocate(length(code))
poke(AsmFct,code)
poke(AsmFct+3,int_to_bytes(AsmFct+length(code)-1))

function ReadCmosRegister(integer Register)
    poke(AsmFct+8,Register)
    call(AsmFct)
    return  peek(AsmFct+length(code)-1)
end function -- ReadCmosRegister()

function HardDisk()
  integer C,D
  C = ReadCmosRegister(#19)
  D = ReadCmosRegister(#1A)
  return {C,D}
end function -- HardDisk()

function Floppies()
sequence FloppyType
integer FlopInfo
   FloppyType={"not installed","5.25\" 320KB","5.25\" 1.2MB","3.5\"720KB","3.5\" 1.44MB"}
   FlopInfo = ReadCmosRegister(#10)
   return {FloppyType[floor(FlopInfo/16)+1],
	    FloppyType[remainder(FlopInfo,16)+1]}
end function -- Floppies()

function GetConfig()
-- Read cmos register #14 to knowns configuration
-- it specify number of floppies, type of video adapter, coprocessor
-- return sequence {NbFloppies,Video, MathProc}
integer ConfigByte , NbFloppies,Video  sequence VideoAdapt
    VideoAdapt={"Unknown, possibly VGA","40x25 CGA",
		"80x25 CGA","MDA (MonoChrome)"}
    ConfigByte=ReadCmosRegister(#14)
    NbFloppies = floor(ConfigByte/64)+1
    ConfigByte = remainder(ConfigByte,64)
    Video = floor(ConfigByte/16)+1
    ConfigByte = floor(ConfigByte/2)
    return{NbFloppies,VideoAdapt[Video],remainder(ConfigByte,2)}
end function -- GetConfig()

clear_screen()
printf(1,"-------- INFORMATION READ FROM CMOS RAM -----------\n",{})
printf(1,"Memory\nbase memory size: %d Kbytes\n",{
       ReadCmosRegister(#15)+ReadCmosRegister(#16)*256})

printf(1,"Extended memory size: %d KBytes\n", {
       ReadCmosRegister(#30)+ReadCmosRegister(#31)*256})

sequence config
config = GetConfig()

printf(1,"\n%d floppies installed\n",config[1])
printf(1,"\nFloppies\nA: %s\nB:%s\n",Floppies())

printf(1,"\nHard disk type\nC:%d\nD:%d\n",HardDisk())

printf(1,"\nVideo adapter: %s\n",{config[2]})

if config[3] then
    printf(1,"\nMath co-processor installed.",{})
  else
    printf(1,"No math co-processor installed.",{})
end if
printf(1,"\n",{})

free(AsmFct)


